/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.profile.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.gmf.runtime.common.ui.preferences.CheckBoxFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.uml2.diagram.common.preferences.IconStylePreferencePage;
import org.eclipse.uml2.diagram.profile.part.Messages;
import org.eclipse.uml2.diagram.profile.part.UMLDiagramEditor;
import org.eclipse.uml2.diagram.profile.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.diagram.profile.providers.UMLElementTypes;

public class DiagramIconStylePreferencePage
extends IconStylePreferencePage {
    private static Map<String, Integer> ourConnectorLabels2Vids = new HashMap<String, Integer>();
    private final List<CheckBoxFieldEditor> myByVisualIdEditors = new ArrayList<CheckBoxFieldEditor>();
    private RadioGroupFieldEditor myModeEditor;
    private Composite myCheckBoxesPanel;
    private IWorkbench myWorkbench;

    static {
        ourConnectorLabels2Vids.put(Messages.DiagramIconStylePreferencePage_LinkLabelsFilter_ExtensionLabel_6001, 6001);
    }

    public static void initConnectorLabelDefaults(IPreferenceStore store) {
        for (Integer visualId : ourConnectorLabels2Vids.values()) {
            store.setDefault(DiagramIconStylePreferencePage.getConnectionLabelPreference((int)visualId), true);
        }
    }

    public DiagramIconStylePreferencePage() {
        this.setPreferenceStore(UMLDiagramEditorPlugin.getInstance().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
        super.init(workbench);
        this.myWorkbench = workbench;
    }

    public boolean performOk() {
        super.performOk();
        UMLElementTypes.refreshImageRegistry();
        this.refreshDiagramEditors();
        return true;
    }

    private void refreshDiagramEditors() {
        IEditorReference[] editors = this.myWorkbench.getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int i = 0;
        while (i < editors.length) {
            IEditorPart editor = editors[i].getEditor(false);
            if (editor != null && editor instanceof UMLDiagramEditor) {
                ((UMLDiagramEditor)editor).refresh();
            }
            ++i;
        }
    }

    protected void initHelp() {
    }

    protected void addFields(Composite parent) {
        super.addFields(parent);
        this.createShowHideIconsGroup(parent);
        this.createShowHideConnectorIconsGroup(parent);
    }

    protected CheckBoxFieldEditor addCheckBoxForVisualIds(Composite parent, String commonLabel, int ... visualIds) {
        StringBuffer propertyName = new StringBuffer("show.visual.id");
        int[] nArray = visualIds;
        int n = visualIds.length;
        int n2 = 0;
        while (n2 < n) {
            int nextVID = nArray[n2];
            propertyName.append('.').append(nextVID);
            ++n2;
        }
        CheckBoxFieldEditor result = new CheckBoxFieldEditor(propertyName.toString(), commonLabel, parent);
        this.addField((FieldEditor)result);
        this.myByVisualIdEditors.add(result);
        return result;
    }

    protected void initialize() {
        super.initialize();
        boolean stateShowSelected = "show.selected.visual.ids".equals(this.getPreferenceStore().getString("iconstyle.show-hide.mode"));
        this.enableVisualIdChoices(stateShowSelected);
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if ("field_editor_value".equals(event.getProperty())) {
            boolean nowConfigurable = "show.selected.visual.ids".equals(event.getNewValue());
            boolean wasConfigurable = "show.selected.visual.ids".equals(event.getOldValue());
            if (nowConfigurable || wasConfigurable) {
                this.enableVisualIdChoices(nowConfigurable);
            }
        }
    }

    private void enableVisualIdChoices(boolean enabled) {
        for (CheckBoxFieldEditor next : this.myByVisualIdEditors) {
            next.setEnabled(enabled, this.myCheckBoxesPanel);
        }
    }

    private Composite createShowHideIconsGroup(Composite parent) {
        Composite showHideIconsGroup = new Composite(parent, 0);
        showHideIconsGroup.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        showHideIconsGroup.setLayout((Layout)layout);
        String[][] choices = new String[][]{{"Hide All", "hide.all"}, {"Show All", "show.all"}, {"Show For Selected Elements Only", "show.selected.visual.ids"}};
        this.myModeEditor = new RadioGroupFieldEditor("iconstyle.show-hide.mode", "Metaclass Images", 1, choices, showHideIconsGroup, true);
        this.addField((FieldEditor)this.myModeEditor);
        Composite e = this.createExpansibleComposite(this.myModeEditor.getRadioBoxControl(showHideIconsGroup), "Elements");
        this.myCheckBoxesPanel = new Composite(e, 0);
        this.myCheckBoxesPanel.setLayout((Layout)new GridLayout());
        this.myCheckBoxesPanel.setLayoutData((Object)new GridData(768));
        this.addAllCheckBoxes(this.myCheckBoxesPanel);
        this.enableVisualIdChoices(false);
        return showHideIconsGroup;
    }

    private void addAllCheckBoxes(Composite parent) {
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_Comment, 5014);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_Constraint, 3008);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_ElementImport, 3009);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_Enumeration, 5005);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_EnumerationLiteral, 3005);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_Image, 3010);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_Profile, 5003, 5009);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_Property, 3001);
        this.addCheckBoxForVisualIds(parent, Messages.DiagramIconStylePreferencePage_label_for_Stereotype, 5001, 3003);
    }

    private Composite createShowHideConnectorIconsGroup(Composite parent) {
        IconStylePreferencePage.ShowHideConnectorLabelGroup builder = new IconStylePreferencePage.ShowHideConnectorLabelGroup((IconStylePreferencePage)this);
        return builder.createShowHideConnectorLabelGroup(parent, ourConnectorLabels2Vids);
    }
}

