/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.statemachine.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.diagram.statemachine.actions.CustomMessages;
import org.eclipse.uml2.diagram.statemachine.providers.UMLElementTypes;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.TransitionKind;
import org.eclipse.uml2.uml.Vertex;

public class NewInternalTransitionActionHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        DiagramDocumentEditor editor = (DiagramDocumentEditor)HandlerUtil.getActiveEditorChecked((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        List editParts = ((IStructuredSelection)selection).toList();
        TransactionalEditingDomain domain = editor.getEditingDomain();
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(domain, CustomMessages.NewInternalTransitionActionHandler_command_label);
        for (Object nextEditPart : editParts) {
            if (!(nextEditPart instanceof ShapeNodeEditPart)) continue;
            try {
                cc.add((IUndoableOperation)this.getCreateElementCommand((ShapeNodeEditPart)nextEditPart));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (cc.canExecute()) {
            editor.getDiagramEditDomain().getDiagramCommandStack().execute((Command)new ICommandProxy(cc.reduce()));
        }
        return null;
    }

    private ICommand getCreateElementCommand(ShapeNodeEditPart editPart) {
        CreateElementRequest createRequest = new CreateElementRequest(this.getTransuitionContainer(editPart), (IElementType)UMLElementTypes.Transition_3022);
        return new CreateInternalTransitionCommand(createRequest);
    }

    private EObject getTransuitionContainer(ShapeNodeEditPart editPart) throws IllegalArgumentException {
        EObject element = ((View)editPart.getModel()).getElement();
        if (!(element instanceof State)) {
            throw new IllegalArgumentException();
        }
        EList regions = ((State)element).getRegions();
        if (regions.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return (EObject)regions.get(0);
    }

    private static class CreateInternalTransitionCommand
    extends CreateElementCommand {
        public CreateInternalTransitionCommand(CreateElementRequest createRequest) {
            super(createRequest);
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            CommandResult result = super.doExecuteWithResult(monitor, info);
            Region region = (Region)((CreateElementRequest)this.getRequest()).getContainer();
            Transition transition = (Transition)result.getReturnValue();
            transition.setName(this.getTransitionName(region));
            transition.setKind(TransitionKind.INTERNAL_LITERAL);
            State state = region.getState();
            transition.setSource((Vertex)state);
            transition.setTarget((Vertex)state);
            return result;
        }

        private String getTransitionName(Region region) {
            if (!this.hasTransition(region, CustomMessages.NewInternalTransitionActionHandler_name_prefix)) {
                return CustomMessages.NewInternalTransitionActionHandler_name_prefix;
            }
            int i = 1;
            while (i <= 9) {
                String name = String.valueOf(CustomMessages.NewInternalTransitionActionHandler_name_prefix) + i;
                if (!this.hasTransition(region, name)) {
                    return name;
                }
                ++i;
            }
            return CustomMessages.NewInternalTransitionActionHandler_name_prefix;
        }

        private boolean hasTransition(Region region, String name) {
            EList transitions = region.getTransitions();
            Iterator transitionsIterator = transitions.iterator();
            while (transitionsIterator.hasNext()) {
                if (!name.equals(((Transition)transitionsIterator.next()).getName())) continue;
                return true;
            }
            return false;
        }
    }
}

