/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.draw2d.shadow;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.uml2.diagram.sequence.draw2d.shadow.ShadowCaster;
import org.eclipse.uml2.diagram.sequence.draw2d.shadow.ShadowPlate;
import org.eclipse.uml2.diagram.sequence.draw2d.shadow.ShadowStealth;
import org.eclipse.uml2.diagram.sequence.figures.InvisibleRectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShadowMaster {
    public static final int SHADOW_SIZE = 3;
    protected static final String SHADOW_COLOR_KEY = "ShadowColor";
    private static ColorRegistry ourColorRegistry;
    private List<IFigure> myClients;

    public void addClient(IFigure figure) {
        if (figure == null) {
            throw new NullPointerException();
        }
        if (this.myClients == null) {
            this.myClients = new ArrayList<IFigure>();
        }
        this.myClients.add(figure);
    }

    public void paintFigure(Graphics g) {
        this.paintFigures(this.myClients, g);
    }

    protected void paintFigures(List<?> figures, Graphics g) {
        if (figures == null || figures.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < figures.size()) {
            IFigure child = (IFigure)figures.get(i);
            if (child instanceof ShadowCaster) {
                ShadowCaster caster = (ShadowCaster)child;
                if (caster.isShadowVisible() && (!(caster instanceof ShadowPlate) || (child = ((ShadowPlate)caster).getChild()) != null)) {
                    this.paintShadow(caster.isSimpleShadow(), child, g);
                }
            } else {
                this.paintFigures(child.getChildren(), g);
            }
            ++i;
        }
    }

    protected void paintShadow(boolean simpleShadow, IFigure figure, Graphics g) {
        g.pushState();
        try {
            g.translate(3, 3);
            Color shadowColor = this.getShadowColor();
            g.setForegroundColor(shadowColor);
            g.setBackgroundColor(shadowColor);
            g.clipRect(new Rectangle(figure.getBounds()));
            if (figure instanceof InvisibleRectangle) {
                this.paintChildrenShadow(simpleShadow, figure, g);
            } else {
                if (figure instanceof Shape) {
                    ((Shape)figure).paintFigure(g);
                }
                if (!simpleShadow) {
                    this.paintChildrenShadow(false, figure, g);
                }
            }
            Border border = figure.getBorder();
            if (border != null) {
                border.paint(figure, g, IFigure.NO_INSETS);
            }
        }
        finally {
            g.popState();
        }
    }

    protected void paintChildrenShadow(boolean simpleShadow, IFigure figure, Graphics g) {
        Rectangle clip = Rectangle.SINGLETON;
        List children = figure.getChildren();
        int i = children.size() - 1;
        while (i >= 0) {
            block9: {
                Shape shape;
                IFigure child;
                block10: {
                    child = (IFigure)children.get(i);
                    if (child instanceof ShadowStealth) break block9;
                    if (!(child instanceof ShadowCaster)) break block10;
                    ShadowCaster caster = (ShadowCaster)child;
                    if (!caster.isShadowVisible() || caster instanceof ShadowPlate && (child = ((ShadowPlate)caster).getChild()) == null) break block9;
                    simpleShadow |= caster.isSimpleShadow();
                }
                if (child instanceof Shape && (shape = (Shape)child).isVisible() && shape.intersects(g.getClip(clip))) {
                    g.pushState();
                    try {
                        g.clipRect(new Rectangle(shape.getBounds()));
                        shape.paintFigure(g);
                        Border border = shape.getBorder();
                        if (border != null) {
                            border.paint((IFigure)shape, g, IFigure.NO_INSETS);
                        }
                    }
                    finally {
                        g.popState();
                    }
                }
                if (!simpleShadow) {
                    this.paintChildrenShadow(simpleShadow, child, g);
                }
            }
            --i;
        }
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension size = new Dimension();
        if (this.myClients == null) {
            return size;
        }
        int i = this.myClients.size() - 1;
        while (i >= 0) {
            IFigure client = this.myClients.get(i);
            size.union(client.getPreferredSize());
            --i;
        }
        size.width += 3;
        size.height += 3;
        return size;
    }

    private Color getShadowColor() {
        return ShadowMaster.getColorRegistry().get(SHADOW_COLOR_KEY);
    }

    private static ColorRegistry createColorRegistry() {
        ColorRegistry registry = new ColorRegistry();
        registry.put(SHADOW_COLOR_KEY, new RGB(153, 153, 153));
        return registry;
    }

    private static ColorRegistry getColorRegistry() {
        if (ourColorRegistry == null) {
            ourColorRegistry = ShadowMaster.createColorRegistry();
        }
        return ourColorRegistry;
    }
}

