/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.internal.layout.model;

import java.awt.Color;
import java.util.Iterator;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsNode;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.BracketMetaObject;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.JustReshapedState;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMBracketContainer;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMFrame;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMLifeLineBracket;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMMountingLink;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LmOwner;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.LifeLineElement;
import org.eclipse.uml2.diagram.sequence.internal.missed.ReverseListIterator;

public abstract class LMMountingRegion
extends LMLifeLineBracket {
    private LMMountingLink myMountingLink;

    LMMountingRegion(AbsNode gdeBracketNode, BracketMetaObject bracketMetaObject, LmOwner lmOwner) {
        super(gdeBracketNode, bracketMetaObject, lmOwner);
    }

    public boolean isLimitedHorizontally() {
        return false;
    }

    LMLifeLineBracket getCreationCandidate() {
        if (this.getChildBracketsList().isEmpty()) {
            return null;
        }
        Iterator it = this.getChildBracketsList().iterator();
        while (it.hasNext()) {
            LMLifeLineBracket next = (LMLifeLineBracket)it.next();
            LMLifeLineBracket result = next.getCreationCandidate();
            if (result == null) continue;
            return result;
        }
        return null;
    }

    LMLifeLineBracket getDestructionCandidate() {
        if (this.getChildBracketsList().isEmpty()) {
            return null;
        }
        ReverseListIterator it = new ReverseListIterator(this.getChildBracketsList().getListView());
        while (it.hasNext()) {
            LMLifeLineBracket nextBracket = (LMLifeLineBracket)it.next();
            LMLifeLineBracket lifelineBracket = nextBracket.getDestructionCandidate();
            if (lifelineBracket == null) continue;
            return lifelineBracket;
        }
        return null;
    }

    LMFrame getContainingFrame() {
        LMMountingLink mountingLink = this.getMountingLink();
        if (mountingLink == null) {
            return null;
        }
        return mountingLink.getFrame();
    }

    void setMountLink(LMMountingLink mountingLink) {
        if (this.myMountingLink != null && mountingLink != null) {
            throw new IllegalStateException("mounting link already set");
        }
        this.myMountingLink = mountingLink;
    }

    public LMMountingLink getMountingLink() {
        return this.myMountingLink;
    }

    public void setHorizontalPosition(int newPos) {
        this.getGdeNode().setX(newPos);
        if (this.myMountingLink != null) {
            this.myMountingLink.setXPosition(newPos + 10);
        }
    }

    abstract void setYAndHeightFromFrame(int var1, int var2, JustReshapedState var3);

    private LMFrame getLmFrame() {
        LMMountingLink mountingLink = this.getMountingLink();
        if (mountingLink == null) {
            return null;
        }
        return mountingLink.getFrame();
    }

    abstract MountingRegionLifelineElement getTopLifeLineElementForConstraint();

    abstract MountingRegionLifelineElement getBottomLifeLineElementForConstraint();

    protected boolean calculateIsBracketConsistent() {
        if (!super.calculateIsBracketConsistent()) {
            return false;
        }
        if (this.myMountingLink == null) {
            return false;
        }
        return this.myMountingLink.getFrame() != null;
    }

    Color setErrorDisplayColor(Color color) {
        Color oldColor = this.getGdeNode().getBackground();
        this.getGdeNode().setBackground(color);
        return oldColor;
    }

    class MountingRegionBottomPosition
    extends LMBracketContainer.BracketBottomPosition
    implements MountingRegionPosition {
        MountingRegionBottomPosition() {
        }

        public int getPositionValue() {
            LMFrame frame;
            if (!LMMountingRegion.this.getGdeNode().isUserResized() && (frame = LMMountingRegion.this.getLmFrame()) != null) {
                return frame.getBottomBorderPos();
            }
            return super.getPositionValue();
        }

        public void setPositionValue(int pos) {
            this.setPositionValue(pos, false);
        }

        public void setPositionValue(int pos, boolean doNotReshapeFrame) {
            super.setPositionValue(pos);
            if (!doNotReshapeFrame && LMMountingRegion.this.getMountingLink() != null) {
                LMMountingRegion.this.getMountingLink().setFrameBottomPosition(pos);
            }
        }
    }

    static interface MountingRegionLifelineElement
    extends LifeLineElement {
        public void setConstraintInvalid(boolean var1);
    }

    static interface MountingRegionPosition
    extends LifeLineElement.Position {
        public void setPositionValue(int var1, boolean var2);
    }

    class MountingRegionTopPosition
    extends LMBracketContainer.BracketTopPosition
    implements MountingRegionPosition {
        MountingRegionTopPosition() {
        }

        public int getPositionValue() {
            LMFrame frame;
            if (!LMMountingRegion.this.getGdeNode().isUserResized() && (frame = LMMountingRegion.this.getLmFrame()) != null) {
                int framePos = frame.getTopBorderPos();
                return this.framePosToRegionPos(framePos);
            }
            return super.getPositionValue();
        }

        public void setPositionValue(int pos) {
            this.setPositionValue(pos, false);
        }

        public void setPositionValue(int pos, boolean doNotReshapeFrame) {
            super.setPositionValue(pos);
            LMMountingRegion.this.getGdeNode().markUserResized();
            if (!doNotReshapeFrame && LMMountingRegion.this.getMountingLink() != null) {
                int framePos = this.regionPosToFramePos(pos);
                LMMountingRegion.this.getMountingLink().setFrameTopPosition(framePos);
            }
        }

        int regionPosToFramePos(int regionPos) {
            return regionPos;
        }

        int framePosToRegionPos(int framePos) {
            return framePos;
        }
    }
}

