/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eodm.examples.rdf;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.eodm.rdf.resource.RDFXMLResourceFactoryImpl;
import org.eclipse.eodm.rdfs.Namespace;
import org.eclipse.eodm.rdfs.Ontology;
import org.eclipse.eodm.rdfs.PlainLiteral;
import org.eclipse.eodm.rdfs.RDFProperty;
import org.eclipse.eodm.rdfs.RDFSClass;
import org.eclipse.eodm.rdfs.RDFSDatatype;
import org.eclipse.eodm.rdfs.RDFSFactory;
import org.eclipse.eodm.rdfs.RDFSResource;
import org.eclipse.eodm.rdfs.TypedLiteral;
import org.eclipse.eodm.rdfs.vocabulary.XSD;

public class CreateAndManipulateRDFExample {
    public static void main(String[] args) {
        RDFSFactory rdfsFactory = RDFSFactory.eINSTANCE;
        Ontology Schema = rdfsFactory.createOntology();
        Namespace ns = rdfsFactory.createNamespace(Schema, "test", "uri:test.org/#");
        Schema.setNamespace(ns);
        Namespace xsd = rdfsFactory.createNamespace(Schema, "xsd", "http://www.w3.org/2001/XMLSchema#");
        RDFSDatatype xsd_nonNegativeInteger = rdfsFactory.createRDFSDatatype(Schema, XSD.snonNegativeInteger, xsd);
        RDFSClass humanClass = rdfsFactory.createRDFSClass(Schema, "Human");
        PlainLiteral humanComment = rdfsFactory.createPlainLiteral();
        humanComment.setLexicalForm("Human Class represents the top class of Man and Woman.");
        humanClass.getRDFSComment().add((Object)humanComment);
        RDFSClass womanClass = rdfsFactory.createRDFSClass(Schema, "Woman");
        RDFSClass manClass = rdfsFactory.createRDFSClass(Schema, "Man");
        manClass.getRDFSSubClassOf().add((Object)humanClass);
        womanClass.getRDFSSubClassOf().add((Object)humanClass);
        RDFProperty hasWifeProperty = rdfsFactory.createRDFProperty(Schema, "hasWife");
        hasWifeProperty.getRDFSDomain().add((Object)manClass);
        hasWifeProperty.getRDFSRange().add((Object)womanClass);
        RDFProperty length = rdfsFactory.createRDFProperty(Schema, "length");
        length.getRDFSDomain().add((Object)humanClass);
        length.getRDFSRange().add((Object)xsd_nonNegativeInteger);
        RDFSResource aMan = rdfsFactory.createRDFSResource(Schema, "Man_1");
        aMan.getRDFType().add((Object)manClass);
        RDFSResource aWoman = rdfsFactory.createRDFSResource(Schema, "Woman_1");
        aWoman.getRDFType().add((Object)womanClass);
        aMan.addPropertyValue(hasWifeProperty, aWoman);
        TypedLiteral lengthValue = rdfsFactory.createTypedLiteral(Schema, "180", xsd_nonNegativeInteger);
        aMan.addPropertyValue(length, (RDFSResource)lengthValue);
        System.out.println("OK");
        try {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("rdf", new RDFXMLResourceFactoryImpl());
            URI fileURI = URI.createFileURI((String)new File("testcase/human.rdf").getAbsolutePath());
            Resource resource = resourceSet.createResource(fileURI);
            resource.getContents().add((Object)Schema);
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("ENCODING", "UTF-8");
            resource.save(options);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

