/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: PlainLiteralImpl.java,v 1.1 2007/03/18 08:10:12 lzhang Exp $
 */
package org.eclipse.eodm.rdf.rdfbase.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.eodm.rdf.rdfbase.PlainLiteral;
import org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Plain Literal</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.impl.PlainLiteralImpl#getLanguage <em>Language</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class PlainLiteralImpl extends RDFSLiteralImpl implements PlainLiteral {
	/**
	 * The default value of the '{@link #getLanguage() <em>Language</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLanguage()
	 * @generated
	 * @ordered
	 */
	protected static final String LANGUAGE_EDEFAULT = "";

	/**
	 * The cached value of the '{@link #getLanguage() <em>Language</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLanguage()
	 * @generated
	 * @ordered
	 */
	protected String language = LANGUAGE_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PlainLiteralImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return RDFBasePackage.eINSTANCE.getPlainLiteral();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLanguage() {
		return language;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLanguage(String newLanguage) {
		String oldLanguage = language;
		language = newLanguage;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RDFBasePackage.PLAIN_LITERAL__LANGUAGE, oldLanguage, language));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case RDFBasePackage.PLAIN_LITERAL__URI_REF:
					return ((InternalEList)getUriRef()).basicAdd(otherEnd, msgs);
				case RDFBasePackage.PLAIN_LITERAL__SUBJECT_STATEMENT:
					return ((InternalEList)getSubjectStatement()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case RDFBasePackage.PLAIN_LITERAL__RDF_SCOMMENT:
					return ((InternalEList)getRDFScomment()).basicRemove(otherEnd, msgs);
				case RDFBasePackage.PLAIN_LITERAL__RDF_SLABEL:
					return ((InternalEList)getRDFSlabel()).basicRemove(otherEnd, msgs);
				case RDFBasePackage.PLAIN_LITERAL__URI_REF:
					return ((InternalEList)getUriRef()).basicRemove(otherEnd, msgs);
				case RDFBasePackage.PLAIN_LITERAL__SUBJECT_STATEMENT:
					return ((InternalEList)getSubjectStatement()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RDFBasePackage.PLAIN_LITERAL__RDF_SIS_DEFINED_BY:
				return getRDFSisDefinedBy();
			case RDFBasePackage.PLAIN_LITERAL__RDF_SSEE_ALSO:
				return getRDFSseeAlso();
			case RDFBasePackage.PLAIN_LITERAL__RD_FTYPE:
				return getRDFtype();
			case RDFBasePackage.PLAIN_LITERAL__RDF_SMEMBER:
				return getRDFSmember();
			case RDFBasePackage.PLAIN_LITERAL__NODE_ID:
				return getNodeID();
			case RDFBasePackage.PLAIN_LITERAL__RDF_SCOMMENT:
				return getRDFScomment();
			case RDFBasePackage.PLAIN_LITERAL__RDF_SLABEL:
				return getRDFSlabel();
			case RDFBasePackage.PLAIN_LITERAL__URI_REF:
				return getUriRef();
			case RDFBasePackage.PLAIN_LITERAL__SUBJECT_STATEMENT:
				return getSubjectStatement();
			case RDFBasePackage.PLAIN_LITERAL__LEXICAL_FORM:
				return getLexicalForm();
			case RDFBasePackage.PLAIN_LITERAL__LANGUAGE:
				return getLanguage();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RDFBasePackage.PLAIN_LITERAL__RDF_SIS_DEFINED_BY:
				getRDFSisDefinedBy().clear();
				getRDFSisDefinedBy().addAll((Collection)newValue);
				return;
			case RDFBasePackage.PLAIN_LITERAL__RDF_SSEE_ALSO:
				getRDFSseeAlso().clear();
				getRDFSseeAlso().addAll((Collection)newValue);
				return;
			case RDFBasePackage.PLAIN_LITERAL__RD_FTYPE:
				getRDFtype().clear();
				getRDFtype().addAll((Collection)newValue);
				return;
			case RDFBasePackage.PLAIN_LITERAL__RDF_SMEMBER:
				getRDFSmember().clear();
				getRDFSmember().addAll((Collection)newValue);
				return;
			case RDFBasePackage.PLAIN_LITERAL__NODE_ID:
				setNodeID((String)newValue);
				return;
			case RDFBasePackage.PLAIN_LITERAL__RDF_SCOMMENT:
				getRDFScomment().clear();
				getRDFScomment().addAll((Collection)newValue);
				return;
			case RDFBasePackage.PLAIN_LITERAL__RDF_SLABEL:
				getRDFSlabel().clear();
				getRDFSlabel().addAll((Collection)newValue);
				return;
			case RDFBasePackage.PLAIN_LITERAL__URI_REF:
				getUriRef().clear();
				getUriRef().addAll((Collection)newValue);
				return;
			case RDFBasePackage.PLAIN_LITERAL__SUBJECT_STATEMENT:
				getSubjectStatement().clear();
				getSubjectStatement().addAll((Collection)newValue);
				return;
			case RDFBasePackage.PLAIN_LITERAL__LEXICAL_FORM:
				setLexicalForm((String)newValue);
				return;
			case RDFBasePackage.PLAIN_LITERAL__LANGUAGE:
				setLanguage((String)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RDFBasePackage.PLAIN_LITERAL__RDF_SIS_DEFINED_BY:
				getRDFSisDefinedBy().clear();
				return;
			case RDFBasePackage.PLAIN_LITERAL__RDF_SSEE_ALSO:
				getRDFSseeAlso().clear();
				return;
			case RDFBasePackage.PLAIN_LITERAL__RD_FTYPE:
				getRDFtype().clear();
				return;
			case RDFBasePackage.PLAIN_LITERAL__RDF_SMEMBER:
				getRDFSmember().clear();
				return;
			case RDFBasePackage.PLAIN_LITERAL__NODE_ID:
				setNodeID(NODE_ID_EDEFAULT);
				return;
			case RDFBasePackage.PLAIN_LITERAL__RDF_SCOMMENT:
				getRDFScomment().clear();
				return;
			case RDFBasePackage.PLAIN_LITERAL__RDF_SLABEL:
				getRDFSlabel().clear();
				return;
			case RDFBasePackage.PLAIN_LITERAL__URI_REF:
				getUriRef().clear();
				return;
			case RDFBasePackage.PLAIN_LITERAL__SUBJECT_STATEMENT:
				getSubjectStatement().clear();
				return;
			case RDFBasePackage.PLAIN_LITERAL__LEXICAL_FORM:
				setLexicalForm(LEXICAL_FORM_EDEFAULT);
				return;
			case RDFBasePackage.PLAIN_LITERAL__LANGUAGE:
				setLanguage(LANGUAGE_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RDFBasePackage.PLAIN_LITERAL__RDF_SIS_DEFINED_BY:
				return rdfSisDefinedBy != null && !rdfSisDefinedBy.isEmpty();
			case RDFBasePackage.PLAIN_LITERAL__RDF_SSEE_ALSO:
				return rdfSseeAlso != null && !rdfSseeAlso.isEmpty();
			case RDFBasePackage.PLAIN_LITERAL__RD_FTYPE:
				return rdFtype != null && !rdFtype.isEmpty();
			case RDFBasePackage.PLAIN_LITERAL__RDF_SMEMBER:
				return rdfSmember != null && !rdfSmember.isEmpty();
			case RDFBasePackage.PLAIN_LITERAL__NODE_ID:
				return NODE_ID_EDEFAULT == null ? nodeID != null : !NODE_ID_EDEFAULT.equals(nodeID);
			case RDFBasePackage.PLAIN_LITERAL__RDF_SCOMMENT:
				return rdfScomment != null && !rdfScomment.isEmpty();
			case RDFBasePackage.PLAIN_LITERAL__RDF_SLABEL:
				return rdfSlabel != null && !rdfSlabel.isEmpty();
			case RDFBasePackage.PLAIN_LITERAL__URI_REF:
				return uriRef != null && !uriRef.isEmpty();
			case RDFBasePackage.PLAIN_LITERAL__SUBJECT_STATEMENT:
				return subjectStatement != null && !subjectStatement.isEmpty();
			case RDFBasePackage.PLAIN_LITERAL__LEXICAL_FORM:
				return LEXICAL_FORM_EDEFAULT == null ? lexicalForm != null : !LEXICAL_FORM_EDEFAULT.equals(lexicalForm);
			case RDFBasePackage.PLAIN_LITERAL__LANGUAGE:
				return LANGUAGE_EDEFAULT == null ? language != null : !LANGUAGE_EDEFAULT.equals(language);
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (language: ");
		result.append(language);
		result.append(')');
		return result.toString();
	}

} //PlainLiteralImpl
