/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.gef;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.sequence.edit.parts.InteractionEditPart;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsDiagram;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsLink;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsLinkEnumeration;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsNode;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.gef.AbsElementGef;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.gef.AbsElementPropertyAccessU2T;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.gef.AbsLinkGef;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.gef.AbsNodeGef;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.gef.WeakValueHashMap;
import org.eclipse.uml2.uml.Interaction;

public class AbsDiagramGef
implements AbsDiagram {
    private final InteractionEditPart myInteractionNodeEditPart;
    private final DiagramGraphicalViewer myEditPartViewer;
    private final DiagramEditPart myRootModelPart;
    private final AbsElementFactory myFactory = new AbsElementFactory();
    private final ChangePositionWatcher myChangePositionWatcher = new ChangePositionWatcher();

    static {
        new AbsElementPropertyAccessU2T();
    }

    public AbsDiagramGef(InteractionEditPart interactionNodeEditPart) {
        this.myInteractionNodeEditPart = interactionNodeEditPart;
        EditPartViewer editPartViewer = interactionNodeEditPart.getViewer();
        if (!(editPartViewer instanceof DiagramGraphicalViewer)) {
            throw new IllegalArgumentException("editPartViewer is expected to be a DiagramGraphicalViewer");
        }
        this.myEditPartViewer = (DiagramGraphicalViewer)editPartViewer;
        this.myRootModelPart = (DiagramEditPart)this.myEditPartViewer.getContents();
    }

    public AbsNode getRootNode() {
        return this.myFactory.createAbsNode((GraphicalEditPart)this.myRootModelPart);
    }

    public AbsLinkEnumeration links() {
        LinkedList<ConnectionEditPart> links = new LinkedList<ConnectionEditPart>();
        for (Object nextEP : this.myEditPartViewer.getEditPartRegistry().values()) {
            if (!(nextEP instanceof ConnectionEditPart)) continue;
            links.add((ConnectionEditPart)nextEP);
        }
        final Iterator it = links.iterator();
        return new AbsLinkEnumeration(){

            public boolean hasMoreElements() {
                return it.hasNext();
            }

            public AbsLink nextGdeLink() {
                ConnectionEditPart nextLink = (ConnectionEditPart)it.next();
                return AbsDiagramGef.this.myFactory.createAbsLink(nextLink);
            }

            public Object nextElement() {
                return this.nextGdeLink();
            }
        };
    }

    public AbsElementFactory getAbsElementFactory() {
        return this.myFactory;
    }

    public ChangePositionWatcher getChangePositionWatcher() {
        return this.myChangePositionWatcher;
    }

    public Interaction getInteraction() {
        return (Interaction)this.myInteractionNodeEditPart.resolveSemanticElement();
    }

    public View getInteractionView() {
        return this.myInteractionNodeEditPart.getNotationView();
    }

    public AbsNode getInteractionAbsNode() {
        return this.getAbsElementFactory().createAbsNode((GraphicalEditPart)this.myInteractionNodeEditPart);
    }

    protected AbsNodeGef createAbsNodeImpl(GraphicalEditPart nodeEditPart) {
        return new AbsNodeGef(nodeEditPart, this, nodeEditPart == this.myInteractionNodeEditPart);
    }

    public class AbsElementFactory {
        private final WeakValueHashMap myInstances = new WeakValueHashMap();

        public AbsNodeGef createAbsNode(GraphicalEditPart nodeEditPart) {
            AbsNodeGef result = (AbsNodeGef)this.myInstances.get(nodeEditPart);
            if (result == null) {
                result = AbsDiagramGef.this.createAbsNodeImpl(nodeEditPart);
                this.myInstances.put(nodeEditPart, result);
            }
            return result;
        }

        public AbsLinkGef createAbsLink(ConnectionEditPart linkEditPart) {
            AbsLinkGef result = (AbsLinkGef)this.myInstances.get(linkEditPart);
            if (result == null) {
                result = new AbsLinkGef(linkEditPart, AbsDiagramGef.this);
                this.myInstances.put(linkEditPart, result);
            }
            return result;
        }

        public AbsElementGef createAbsElement(IGraphicalEditPart editPart) {
            AbsElementGef result = (AbsElementGef)this.myInstances.get(editPart);
            if (result == null) {
                if (editPart instanceof ShapeNodeEditPart) {
                    result = AbsDiagramGef.this.createAbsNodeImpl((GraphicalEditPart)((ShapeNodeEditPart)editPart));
                } else if (editPart instanceof ConnectionEditPart) {
                    result = new AbsLinkGef((ConnectionEditPart)editPart, AbsDiagramGef.this);
                } else {
                    throw new IllegalArgumentException();
                }
                this.myInstances.put(editPart, result);
            }
            return result;
        }
    }

    public static class ChangePositionWatcher {
        private ChangePositionListener myChangePositionListener = null;

        void linkPointsAreChanged(AbsLinkGef absLink) {
            if (this.myChangePositionListener == null) {
                throw new IllegalStateException("Change position listener isn't set");
            }
            this.myChangePositionListener.positionIsChanged(absLink, 0);
        }

        void nodeBoundsAreChanged(AbsNodeGef absNode, int coordCode) {
            if (this.myChangePositionListener == null) {
                throw new IllegalStateException("Change position listener isn't set");
            }
            this.myChangePositionListener.positionIsChanged(absNode, coordCode);
        }

        public void setListener(ChangePositionListener changePositionListener) {
            if (changePositionListener != null && this.myChangePositionListener != null) {
                throw new IllegalStateException("Listener is already set");
            }
            this.myChangePositionListener = changePositionListener;
        }

        public static interface ChangePositionListener {
            public static final int Y = 1;
            public static final int HEIGHT = 2;
            public static final int X = 3;
            public static final int WIDTH = 4;
            public static final int ALL = 5;

            public void positionIsChanged(AbsElementGef var1, int var2);
        }
    }
}

