/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.impl;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.internal.p2.metadata.OSGiVersion;
import org.eclipse.equinox.internal.p2.metadata.RequiredCapability;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.publisher.AdviceFileAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAction;
import org.eclipse.oomph.base.impl.ModelElementImpl;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.VersionSegment;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.resources.ResourcesUtil;
import org.eclipse.oomph.targlets.FeatureGenerator;
import org.eclipse.oomph.targlets.TargletPackage;
import org.eclipse.oomph.targlets.util.VersionGenerator;

public class FeatureGeneratorImpl
extends ModelElementImpl
implements FeatureGenerator {
    private static final IPath MANIFEST_PATH = new Path("feature.xml");

    protected FeatureGeneratorImpl() {
    }

    protected EClass eStaticClass() {
        return TargletPackage.Literals.FEATURE_GENERATOR;
    }

    @Override
    public void generateIUs(IProject project, final String qualifierReplacement, final Map<String, Version> iuVersions, final EList<IInstallableUnit> result) throws Exception {
        ResourcesUtil.runWithFile((IProject)project, (IPath)MANIFEST_PATH, (ResourcesUtil.RunnableWithFile)new ResourcesUtil.RunnableWithFile(){

            public void run(File projectFolder, File file) throws Exception {
                FeatureGeneratorAction action = new FeatureGeneratorAction();
                action.generateIUs(projectFolder, qualifierReplacement, iuVersions, (EList<IInstallableUnit>)result);
            }
        });
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 1: {
                try {
                    this.generateIUs((IProject)arguments.get(0), (String)arguments.get(1), (Map)arguments.get(2), (EList<IInstallableUnit>)((EList)arguments.get(3)));
                    return null;
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    private static final class FeatureGeneratorAction
    extends FeaturesAction {
        public FeatureGeneratorAction() {
            super(null);
            this.setPublisherInfo((IPublisherInfo)new PublisherInfo());
        }

        public void generateIUs(File projectFolder, String qualifierReplacement, final Map<String, Version> ius, EList<IInstallableUnit> result) throws Exception {
            Feature[] features = this.getFeatures(new File[]{projectFolder});
            if (features == null || features.length == 0) {
                return;
            }
            Feature feature = features[0];
            String version = feature.getVersion();
            feature.setVersion(VersionGenerator.replaceQualifier(version, qualifierReplacement));
            this.createAdviceFileAdvice(feature, this.info);
            feature.setEnvironment("", "", "", "");
            List childIUs = Collections.emptyList();
            InstallableUnit iu = (InstallableUnit)this.createGroupIU(feature, childIUs, this.info);
            List requirements = iu.getRequirements();
            String licenseFeature = feature.getLicenseFeature();
            String licenseFeatureVersion = feature.getLicenseFeatureVersion();
            boolean hasLicenseFeature = licenseFeature != null && licenseFeatureVersion != null;
            int size = requirements.size();
            IRequirement[] newRequirements = new IRequirement[size + (hasLicenseFeature ? 1 : 0)];
            if (hasLicenseFeature) {
                IRequirement requirement;
                VersionRange osgiRange;
                Version osgiVersion = OSGiVersion.create((String)licenseFeatureVersion);
                if (osgiVersion.equals(OSGiVersion.emptyVersion)) {
                    osgiRange = VersionRange.emptyRange;
                } else {
                    osgiRange = new VersionRange(osgiVersion, true, osgiVersion, true);
                    VersionRange adjustedRange = FeatureGeneratorAction.adjustQualifier(osgiRange);
                    if (adjustedRange != null) {
                        osgiRange = adjustedRange;
                    }
                }
                String namespace = "org.eclipse.equinox.p2.iu";
                String name = licenseFeature + ".feature.group";
                newRequirements[size] = requirement = MetadataFactory.createRequirement((String)namespace, (String)name, (VersionRange)osgiRange, null, (boolean)true, (boolean)false);
                iu.setProperty("org.eclipse.oomph.targlets.core.requiredLicenseFeatureID", name);
                iu.setProperty("org.eclipse.oomph.targlets.core.requiredLicenseFeatureVersionRange", osgiRange.toString());
            }
            if (qualifierReplacement != null) {
                int i = 0;
                while (i < size) {
                    Object requirement = (IRequirement)requirements.get(i);
                    if (requirement instanceof RequiredCapability && P2Util.isSimpleRequiredCapability((IRequirement)requirement)) {
                        RequiredCapability capability = (RequiredCapability)requirement;
                        final VersionRange originalRange = capability.getRange();
                        VersionRange adjustedRange = FeatureGeneratorAction.adjustQualifier(originalRange);
                        final String namespace = capability.getNamespace();
                        final String name = capability.getName();
                        final IMatchExpression filter = capability.getFilter();
                        final int min = capability.getMin();
                        final int max = capability.getMax();
                        final boolean greedy = capability.isGreedy();
                        requirement = adjustedRange != null ? MetadataFactory.createRequirement((String)namespace, (String)name, (VersionRange)adjustedRange, (IMatchExpression)filter, (int)min, (int)max, (boolean)greedy) : new IRequiredCapability(){
                            private IRequirement delegate;
                            private VersionRange versionRange;

                            private IRequirement getDelegate() {
                                if (this.delegate == null) {
                                    this.delegate = MetadataFactory.createRequirement((String)namespace, (String)name, (VersionRange)this.getRange(), (IMatchExpression)filter, (int)min, (int)max, (boolean)greedy);
                                }
                                return this.delegate;
                            }

                            public String getName() {
                                return name;
                            }

                            public String getNamespace() {
                                return namespace;
                            }

                            public VersionRange getRange() {
                                if (this.versionRange == null) {
                                    Version version = (Version)ius.get(name);
                                    this.versionRange = version != null ? P2Factory.eINSTANCE.createVersionRange(version, VersionSegment.MICRO) : originalRange;
                                }
                                return this.versionRange;
                            }

                            public int getMin() {
                                return this.getDelegate().getMin();
                            }

                            public int getMax() {
                                return this.getDelegate().getMax();
                            }

                            public IMatchExpression<IInstallableUnit> getFilter() {
                                return this.getDelegate().getFilter();
                            }

                            public IMatchExpression<IInstallableUnit> getMatches() {
                                return this.getDelegate().getMatches();
                            }

                            public boolean isMatch(IInstallableUnit iu) {
                                return this.getDelegate().isMatch(iu);
                            }

                            public boolean isGreedy() {
                                return this.getDelegate().isGreedy();
                            }

                            public String getDescription() {
                                return this.getDelegate().getDescription();
                            }

                            public String toString() {
                                if (this.delegate != null) {
                                    return this.delegate.toString();
                                }
                                return name + " " + String.valueOf(this.versionRange);
                            }
                        };
                    }
                    newRequirements[i] = requirement;
                    ++i;
                }
                iu.setRequiredCapabilities(newRequirements);
            }
            result.add((Object)iu);
            MetadataFactory.InstallableUnitDescription[] otherDescriptions = FeatureGeneratorAction.processAdditionalInstallableUnitsAdvice((IInstallableUnit)iu, (IPublisherInfo)this.info);
            if (otherDescriptions != null) {
                MetadataFactory.InstallableUnitDescription[] installableUnitDescriptionArray = otherDescriptions;
                int n = otherDescriptions.length;
                int n2 = 0;
                while (n2 < n) {
                    MetadataFactory.InstallableUnitDescription otherDescription = installableUnitDescriptionArray[n2];
                    IInstallableUnit otherIU = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)otherDescription);
                    result.add((Object)otherIU);
                    ++n2;
                }
            }
        }

        private void createAdviceFileAdvice(Feature feature, IPublisherInfo publisherInfo) {
            String groupId;
            AdviceFileAdvice advice;
            String location = feature.getLocation();
            if (location != null && (advice = new AdviceFileAdvice(groupId = FeatureGeneratorAction.getTransformedId(feature.getId(), false, true), Version.parseVersion((String)feature.getVersion()), (IPath)new Path(location), (IPath)new Path("p2.inf"))).containsAdvice()) {
                publisherInfo.addAdvice((IPublisherAdvice)advice);
            }
        }

        private static String getTransformedId(String original, boolean isPlugin, boolean isGroup) {
            return isPlugin ? original : original + (isGroup ? ".feature.group" : ".feature.jar");
        }

        private static VersionRange adjustQualifier(VersionRange range) {
            OSGiVersion osgiMinimum;
            Version minimum;
            if (!VersionRange.emptyRange.equals((Object)range) && (minimum = range.getMinimum()) instanceof OSGiVersion && (osgiMinimum = (OSGiVersion)minimum).equals((Object)range.getMaximum())) {
                minimum = OSGiVersion.createOSGi((int)osgiMinimum.getMajor(), (int)osgiMinimum.getMinor(), (int)osgiMinimum.getMicro());
                Version maximum = OSGiVersion.createOSGi((int)osgiMinimum.getMajor(), (int)osgiMinimum.getMinor(), (int)(osgiMinimum.getMicro() + 1));
                return new VersionRange(minimum, true, maximum, false);
            }
            return null;
        }
    }
}

