/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.OpaqueElementUtil;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledItem;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MTrimContribution;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.renderers.swt.HandledContributionItem;
import org.eclipse.e4.ui.workbench.renderers.swt.ToolBarManagerRenderer;
import org.eclipse.e4.ui.workbench.swt.factories.IRendererFactory;
import org.eclipse.jface.action.AbstractGroupMarker;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IContributionManagerOverrides;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.internal.provisional.action.ICoolBarManager2;
import org.eclipse.jface.internal.provisional.action.IToolBarContributionItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.menus.MenuHelper;
import org.eclipse.ui.menus.CommandContributionItem;

public class CoolBarToTrimManager
extends ContributionManager
implements ICoolBarManager2 {
    private static final String TOOLBAR_SEPARATOR = "toolbarSeparator";
    private static final String MAIN_TOOLBAR_ID = "org.eclipse.ui.main.toolbar";
    public static final String OBJECT = "coolbar.object";
    private static final String PREV_CHILD_VISIBLE = "prevChildVisible";
    private MTrimBar topTrim;
    private List<MTrimElement> workbenchTrimElements;
    private List<ToolBarContributionItemExtension> toolbarExtensions;
    private IRendererFactory rendererFactory;
    private ToolBarManagerRenderer renderer;
    private MApplication application;
    private MTrimmedWindow window;
    private IContributionManagerOverrides toolbarOverrides;
    private boolean trimBarsAdded;
    private EModelService modelService;

    public CoolBarToTrimManager(MApplication app, MTrimmedWindow window, List<MTrimElement> workbenchTrimElements, IRendererFactory rf) {
        this.application = app;
        this.window = window;
        this.rendererFactory = rf;
        this.workbenchTrimElements = workbenchTrimElements;
        this.toolbarExtensions = new ArrayList<ToolBarContributionItemExtension>();
        this.modelService = (EModelService)window.getContext().get(EModelService.class);
        this.topTrim = (MTrimBar)this.modelService.find(MAIN_TOOLBAR_ID, (MUIElement)window);
        if (this.topTrim == null) {
            this.topTrim = this.modelService.getTrim(window, SideValue.TOP);
            this.topTrim.setElementId(MAIN_TOOLBAR_ID);
        }
        this.topTrim.setToBeRendered(false);
        MToolBar mToolBar = (MToolBar)this.modelService.createModelElement(MToolBar.class);
        this.renderer = (ToolBarManagerRenderer)this.rendererFactory.getRenderer((MUIElement)mToolBar, null);
    }

    public void add(IAction action) {
        throw new UnsupportedOperationException();
    }

    public void add(IContributionItem item) {
        this.add(this.topTrim, -1, item);
    }

    private void add(MTrimBar trimBar, int idx, IContributionItem item) {
        MUIElement spacer;
        if (idx == -1 && (spacer = this.modelService.find("PerspectiveSpacer", (MUIElement)trimBar)) != null) {
            idx = trimBar.getChildren().indexOf(spacer);
        }
        if (item instanceof IToolBarContributionItem) {
            boolean tbFound;
            IToolBarContributionItem tbc = (IToolBarContributionItem)item;
            IToolBarManager mgr = tbc.getToolBarManager();
            if (!(mgr instanceof ToolBarManager)) {
                return;
            }
            ToolBarManager manager = (ToolBarManager)mgr;
            if (this.renderer.getToolBarModel(manager) != null) {
                return;
            }
            MToolBar toolBar = (MToolBar)this.modelService.find(item.getId(), (MUIElement)this.window);
            boolean bl = tbFound = toolBar != null;
            if (!tbFound) {
                toolBar = (MToolBar)this.modelService.createModelElement(MToolBar.class);
            } else {
                toolBar.getChildren().clear();
            }
            toolBar.setElementId(item.getId());
            toolBar.getTransientData().put(OBJECT, item);
            String toolbarLabel = CoolBarToTrimManager.getToolbarLabel(this.application, item.getId());
            if (toolbarLabel != null) {
                toolBar.getTransientData().put("Name", toolbarLabel);
            }
            this.renderer.linkModelToManager(toolBar, manager);
            toolBar.setToBeRendered(true);
            if (!tbFound) {
                if (idx < 0) {
                    trimBar.getChildren().add(toolBar);
                } else {
                    trimBar.getChildren().add(idx, toolBar);
                }
            }
            this.workbenchTrimElements.add((MTrimElement)toolBar);
            manager.setOverrides(this.toolbarOverrides);
        } else {
            if (item instanceof IContributionManager) {
                throw new IllegalStateException();
            }
            if (item instanceof AbstractGroupMarker) {
                boolean tbFound;
                if (item.getId() == null) {
                    return;
                }
                for (MTrimElement toolBar : this.topTrim.getChildren()) {
                    if (!item.getId().equals(toolBar.getElementId()) || !toolBar.getTags().contains(TOOLBAR_SEPARATOR)) continue;
                    return;
                }
                MToolBarSeparator separator = (MToolBarSeparator)this.modelService.createModelElement(MToolBarSeparator.class);
                separator.setToBeRendered(false);
                separator.setElementId(item.getId());
                List toolbars = this.modelService.findElements((MUIElement)this.window, item.getId(), MToolBar.class, null);
                MToolBar toolBar = toolbars.isEmpty() ? null : (MToolBar)toolbars.get(0);
                boolean bl = tbFound = toolBar != null;
                if (!tbFound) {
                    toolBar = (MToolBar)this.modelService.createModelElement(MToolBar.class);
                } else {
                    toolBar.getChildren().clear();
                }
                toolBar.getTransientData().put(OBJECT, item);
                toolBar.getTags().add(TOOLBAR_SEPARATOR);
                toolBar.setElementId(item.getId());
                toolBar.getChildren().add(separator);
                toolBar.setToBeRendered(false);
                if (!tbFound) {
                    if (idx < 0) {
                        this.topTrim.getChildren().add(toolBar);
                    } else {
                        this.topTrim.getChildren().add(idx, toolBar);
                    }
                }
                this.workbenchTrimElements.add((MTrimElement)toolBar);
            }
        }
    }

    public static String getToolbarLabel(MApplication application, MUIElement elt) {
        String name = CoolBarToTrimManager.getTransientName(elt);
        if (name != null) {
            return name;
        }
        String elementId = elt.getElementId();
        return CoolBarToTrimManager.getToolbarLabel(application, elementId);
    }

    private static String getToolbarLabel(MApplication application, String elementId) {
        if ("org.eclipse.ui.workbench.file".equalsIgnoreCase(elementId)) {
            return WorkbenchMessages.WorkbenchWindow_FileToolbar;
        }
        if ("org.eclipse.ui.workbench.edit".equalsIgnoreCase(elementId)) {
            return WorkbenchMessages.WorkbenchWindow_EditToolbar;
        }
        if ("org.eclipse.ui.workbench.navigate".equalsIgnoreCase(elementId)) {
            return WorkbenchMessages.WorkbenchWindow_NavigateToolbar;
        }
        if ("org.eclipse.ui.workbench.help".equalsIgnoreCase(elementId)) {
            return WorkbenchMessages.WorkbenchWindow_HelpToolbar;
        }
        List trimContributions = application.getTrimContributions();
        for (MTrimContribution mtb : trimContributions) {
            for (MTrimElement e : mtb.getChildren()) {
                String name;
                if (!e.getElementId().equals(elementId) || (name = CoolBarToTrimManager.getTransientName((MUIElement)e)) == null) continue;
                return name;
            }
        }
        return null;
    }

    static String getTransientName(MUIElement elt) {
        Object name = elt.getTransientData().get("Name");
        if (name instanceof String) {
            return (String)name;
        }
        return null;
    }

    public void add(IToolBarManager toolBarManager) {
        if (toolBarManager instanceof ToolBarManager) {
            this.add((IContributionItem)new ToolBarContributionItem(toolBarManager));
        }
    }

    public void appendToGroup(String groupName, IAction action) {
        throw new UnsupportedOperationException();
    }

    public void appendToGroup(String groupName, IContributionItem item) {
        List toolBars = this.modelService.findElements((MUIElement)this.window, groupName, MToolBar.class, null);
        if (toolBars.size() == 1) {
            MToolBar el = (MToolBar)toolBars.get(0);
            MTrimBar trimBar = this.getTrim((MTrimElement)el);
            int index = trimBar.getChildren().indexOf(el);
            index = index + 1 < trimBar.getChildren().size() ? index : -1;
            this.add(trimBar, index, item);
        }
        this.add(this.topTrim, -1, item);
    }

    public Control createControl2(Composite parent) {
        throw new UnsupportedOperationException();
    }

    public void dispose() {
        if (this.renderer == null) {
            return;
        }
        for (ToolBarContributionItemExtension ext : this.toolbarExtensions) {
            ToolBarManager manager = this.renderer.getManager(ext.tb);
            if (manager != null) {
                manager.dispose();
                manager.removeAll();
            }
            this.renderer.clearModelToManager(ext.tb, null);
            ext.dispose();
        }
        this.toolbarExtensions.clear();
        List toolbars = this.workbenchTrimElements.stream().filter(e -> e instanceof MToolBar).map(e -> (MToolBar)e).collect(Collectors.toList());
        for (MToolBar mToolBar : toolbars) {
            ToolBarManager manager = this.renderer.getManager(mToolBar);
            if (manager != null) {
                manager.dispose();
                manager.removeAll();
            }
            this.renderer.clearModelToManager(mToolBar, null);
        }
        ArrayList<MToolBarElement> toRemove = new ArrayList<MToolBarElement>();
        for (MTrimElement child : this.topTrim.getChildren()) {
            if (!(child instanceof MToolBar)) continue;
            MToolBar toolbar = (MToolBar)child;
            for (MToolBarElement element : toolbar.getChildren()) {
                if (!OpaqueElementUtil.isOpaqueToolItem((MUIElement)element)) continue;
                toRemove.add(element);
            }
            if (toRemove.isEmpty()) continue;
            toolbar.getChildren().removeAll(toRemove);
            toRemove.clear();
        }
        this.toolbarOverrides = null;
        this.renderer = null;
        this.rendererFactory = null;
    }

    public IContributionItem find(String id) {
        List toolbars = this.modelService.findElements((MUIElement)this.window, id, MToolBar.class, null);
        if (toolbars.isEmpty()) {
            return null;
        }
        MToolBar model = (MToolBar)toolbars.get(0);
        if (model.getTransientData().get(OBJECT) != null) {
            return (IContributionItem)model.getTransientData().get(OBJECT);
        }
        ToolBarManagerRenderer renderer = (ToolBarManagerRenderer)this.rendererFactory.getRenderer((MUIElement)model, null);
        ToolBarManager manager = renderer.getManager(model);
        if (manager != null) {
            ToolBarContributionItemExtension toolBarContributionItem = new ToolBarContributionItemExtension((IToolBarManager)manager, model);
            model.getTransientData().put(OBJECT, toolBarContributionItem);
            this.toolbarExtensions.add(toolBarContributionItem);
            return toolBarContributionItem;
        }
        if (model.getTags().contains(TOOLBAR_SEPARATOR)) {
            if (model.getTransientData().get(OBJECT) != null) {
                return (IContributionItem)model.getTransientData().get(OBJECT);
            }
            return new GroupMarker(model.getElementId());
        }
        return null;
    }

    public IMenuManager getContextMenuManager() {
        throw new UnsupportedOperationException();
    }

    public Control getControl2() {
        throw new UnsupportedOperationException();
    }

    public IContributionItem[] getItems() {
        ArrayList<Object> items = new ArrayList<Object>();
        List toolBars = this.modelService.findElements((MUIElement)this.window, null, MToolBar.class, null);
        for (MToolBar tb : toolBars) {
            if (tb.getTransientData().get(OBJECT) != null) {
                items.add((IContributionItem)tb.getTransientData().get(OBJECT));
                continue;
            }
            ToolBarManagerRenderer renderer = (ToolBarManagerRenderer)this.rendererFactory.getRenderer((MUIElement)tb, null);
            ToolBarManager manager = renderer.getManager(tb);
            if (manager != null) {
                ToolBarContributionItemExtension toolBarContributionItem = new ToolBarContributionItemExtension((IToolBarManager)manager, tb);
                tb.getTransientData().put(OBJECT, toolBarContributionItem);
                this.toolbarExtensions.add(toolBarContributionItem);
                items.add((Object)toolBarContributionItem);
                continue;
            }
            if (!tb.getTags().contains(TOOLBAR_SEPARATOR)) continue;
            if (tb.getTransientData().get(OBJECT) != null) {
                items.add((IContributionItem)tb.getTransientData().get(OBJECT));
            }
            items.add(new GroupMarker(tb.getElementId()));
        }
        return items.toArray(new IContributionItem[items.size()]);
    }

    public boolean getLockLayout() {
        return false;
    }

    public IContributionManagerOverrides getOverrides() {
        return this.toolbarOverrides;
    }

    public int getStyle() {
        return 0;
    }

    public void insertAfter(String id, IAction action) {
        throw new UnsupportedOperationException();
    }

    private MTrimBar getTrim(MTrimElement te) {
        if (te == null) {
            return null;
        }
        MElementContainer parentElement = te.getParent();
        return (MTrimBar)(parentElement instanceof MTrimBar ? parentElement : null);
    }

    private MToolBar getToolBar(String id) {
        List toolbars = this.modelService.findElements((MUIElement)this.window, id, MToolBar.class, null);
        if (toolbars.size() == 1) {
            return (MToolBar)toolbars.get(0);
        }
        return null;
    }

    public void insertAfter(String id, IContributionItem item) {
        MToolBar afterElement = this.getToolBar(id);
        if (afterElement == null || this.getTrim((MTrimElement)afterElement) == null) {
            return;
        }
        MTrimBar trimBar = this.getTrim((MTrimElement)afterElement);
        int index = trimBar.getChildren().indexOf(afterElement);
        index = index + 1 < trimBar.getChildren().size() ? index + 1 : -1;
        this.add(trimBar, index, item);
    }

    public void insertBefore(String id, IAction action) {
        throw new UnsupportedOperationException();
    }

    public void insertBefore(String id, IContributionItem item) {
        MToolBar beforeElement = this.getToolBar(id);
        if (beforeElement == null || this.getTrim((MTrimElement)beforeElement) == null) {
            return;
        }
        MTrimBar trimBar = this.getTrim((MTrimElement)beforeElement);
        int index = trimBar.getChildren().indexOf(beforeElement);
        this.add(trimBar, index, item);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isEmpty() {
        return this.topTrim.getChildren().isEmpty();
    }

    public void markDirty() {
    }

    public void prependToGroup(String groupName, IAction action) {
        throw new UnsupportedOperationException();
    }

    public void prependToGroup(String groupName, IContributionItem item) {
        MUIElement gnElement = this.modelService.find(groupName, (MUIElement)this.window);
        if (gnElement instanceof MToolBar) {
            MTrimBar trimBar = this.getTrim((MTrimElement)gnElement);
            int index = trimBar.getChildren().indexOf(gnElement);
            this.add(trimBar, index, item);
        }
        this.add(this.topTrim, -1, item);
    }

    public void refresh() {
    }

    public IContributionItem remove(IContributionItem item) {
        List children = this.modelService.findElements((MUIElement)this.window, null, MToolBar.class, null);
        int i = 0;
        while (i < children.size()) {
            MToolBar child = (MToolBar)children.get(i);
            Object obj = child.getTransientData().get(OBJECT);
            if (obj != null && obj.equals(item)) {
                IToolBarManager parent;
                if (child instanceof MToolBarElement) {
                    this.renderer.clearModelToContribution((MToolBarElement)child, item);
                }
                if (item instanceof IToolBarContributionItem && (parent = ((IToolBarContributionItem)item).getToolBarManager()) instanceof ToolBarManager) {
                    this.renderer.clearModelToManager(child, (ToolBarManager)parent);
                }
                this.workbenchTrimElements.remove(child);
                child.setToBeRendered(false);
                child.getParent().getChildren().remove(child);
                return (IContributionItem)obj;
            }
            if (item.getId() != null && item.getId().equals(child.getElementId())) {
                throw new IllegalStateException();
            }
            ++i;
        }
        return null;
    }

    public IContributionItem remove(String id) {
        throw new UnsupportedOperationException();
    }

    public void removeAll() {
        throw new UnsupportedOperationException();
    }

    public void resetItemOrder() {
        this.updateAll(true);
    }

    public void setContextMenuManager(IMenuManager menuManager) {
    }

    public void setItems(IContributionItem[] newItems) {
        throw new UnsupportedOperationException();
    }

    public void setLockLayout(boolean value) {
    }

    public void setOverrides(IContributionManagerOverrides newOverrides) {
        this.toolbarOverrides = newOverrides;
        this.topTrim.getTransientData().put(IContributionManagerOverrides.class.getName(), newOverrides);
    }

    public void update(boolean force) {
        List children = this.modelService.findElements((MUIElement)this.window, null, MToolBar.class, null);
        for (MToolBar el : children) {
            ToolBar toolbar;
            ToolBarManagerRenderer renderer = (ToolBarManagerRenderer)this.rendererFactory.getRenderer((MUIElement)el, null);
            ToolBarManager manager = renderer.getManager(el);
            if (manager == null) continue;
            boolean wasVisible = el.isVisible();
            boolean needUpdate = this.fill(el, (IContributionManager)manager);
            if (needUpdate || el.isVisible() != wasVisible) {
                manager.markDirty();
                manager.update(true);
            }
            if ((toolbar = manager.getControl()) == null || toolbar.isDisposed()) continue;
            toolbar.requestLayout();
        }
        if (!this.trimBarsAdded) {
            boolean hidden;
            boolean bl = hidden = !this.topTrim.isVisible();
            if (hidden) {
                this.topTrim.setVisible(true);
            }
            this.topTrim.setToBeRendered(true);
            if (hidden) {
                this.topTrim.setVisible(false);
            }
            this.trimBarsAdded = true;
        }
    }

    public void updateAll(boolean force) {
        List children = this.modelService.findElements((MUIElement)this.window, null, MToolBar.class, null);
        for (MToolBar mToolbar : children) {
            ToolBarManagerRenderer renderer;
            ToolBarManager manager;
            if (mToolbar == null || (manager = (renderer = (ToolBarManagerRenderer)this.rendererFactory.getRenderer((MUIElement)mToolbar, null)).getManager(mToolbar)) == null) continue;
            manager.update(true);
            ToolBar toolbar = manager.getControl();
            if (toolbar == null || toolbar.isDisposed()) continue;
            toolbar.requestLayout();
        }
    }

    private boolean fill(MToolBar container, IContributionManager manager) {
        boolean needUpdate = false;
        ToolBarManagerRenderer renderer = (ToolBarManagerRenderer)this.rendererFactory.getRenderer((MUIElement)container, null);
        IContributionItem[] items = manager.getItems();
        int index = 0;
        while (index < items.length) {
            IContributionItem item = items[index];
            if (item != null) {
                MToolBarElement toolBarElem = renderer.getToolElement(item);
                if (toolBarElem != null) {
                    if (container.isVisible()) {
                        needUpdate |= this.applyOverridenVisibility(toolBarElem, item, manager);
                    } else if (!item.isSeparator() && !item.isGroupMarker() && this.isChildVisible(item, manager)) {
                        needUpdate |= this.applyOverridenVisibility(toolBarElem, item, manager);
                        container.setVisible(true);
                    }
                } else if (item instanceof IToolBarContributionItem) {
                    IToolBarManager manager2 = ((IToolBarContributionItem)item).getToolBarManager();
                    needUpdate |= this.fill(container, (IContributionManager)manager2);
                } else if (!(item instanceof IMenuManager)) {
                    MToolItem toolItem;
                    if (item instanceof IContributionManager) {
                        needUpdate |= this.fill(container, (IContributionManager)item);
                    } else if (item instanceof CommandContributionItem) {
                        toolItem = MenuHelper.createToolItem(this.application, (CommandContributionItem)item);
                        if (toolItem != null) {
                            toolItem.setRenderer((Object)renderer);
                            HandledContributionItem ci = (HandledContributionItem)ContextInjectionFactory.make(HandledContributionItem.class, (IEclipseContext)this.window.getContext());
                            if (manager instanceof ContributionManager) {
                                ci.setId(toolItem.getElementId());
                                ci.setVisible(toolItem.isVisible());
                                ContributionManager cm = (ContributionManager)manager;
                                cm.insert(index, (IContributionItem)ci);
                                cm.remove(item);
                                item.dispose();
                            }
                            ci.setModel((MHandledItem)toolItem);
                            renderer.linkModelToContribution((MToolBarElement)toolItem, (IContributionItem)ci);
                            container.getChildren().add(toolItem);
                        }
                    } else {
                        toolItem = OpaqueElementUtil.createOpaqueToolItem();
                        toolItem.setElementId(item.getId());
                        OpaqueElementUtil.setOpaqueItem((MUIElement)toolItem, (Object)item);
                        if (item instanceof AbstractGroupMarker) {
                            toolItem.setVisible(item.isVisible());
                        }
                        renderer.linkModelToContribution((MToolBarElement)toolItem, item);
                        container.getChildren().add(toolItem);
                    }
                }
            }
            ++index;
        }
        return needUpdate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean applyOverridenVisibility(MToolBarElement modelItem, IContributionItem item, IContributionManager manager) {
        boolean needUpdate = false;
        Boolean overridenVisibility = this.getOverridenVisibility(item, manager);
        Boolean prevChildVisible = (Boolean)modelItem.getTransientData().get(PREV_CHILD_VISIBLE);
        if (overridenVisibility != null) {
            if (prevChildVisible != null) return needUpdate;
            boolean modelVisible = modelItem.isVisible();
            boolean itemVisible = item.isVisible();
            if (modelVisible != overridenVisibility || itemVisible != overridenVisibility) {
                needUpdate = true;
            }
            modelItem.getTransientData().put(PREV_CHILD_VISIBLE, itemVisible);
            modelItem.setVisible(overridenVisibility.booleanValue());
            return needUpdate;
        } else {
            if (prevChildVisible == null) return needUpdate;
            boolean oldVisible = modelItem.isVisible();
            if (oldVisible != prevChildVisible) {
                needUpdate = true;
            }
            modelItem.setVisible(prevChildVisible.booleanValue());
            modelItem.getTransientData().remove(PREV_CHILD_VISIBLE);
        }
        return needUpdate;
    }

    private Boolean getOverridenVisibility(IContributionItem item, IContributionManager manager) {
        IContributionManagerOverrides overrides = manager.getOverrides();
        return overrides == null ? null : overrides.getVisible(item);
    }

    private boolean isChildVisible(IContributionItem item, IContributionManager manager) {
        Boolean v = this.getOverridenVisibility(item, manager);
        return v == null ? item.isVisible() : v.booleanValue();
    }

    public MTrimBar getTopTrim() {
        return this.topTrim;
    }

    private static final class ToolBarContributionItemExtension
    extends ToolBarContributionItem {
        private final MToolBar tb;

        private ToolBarContributionItemExtension(IToolBarManager toolBarManager, MToolBar tb) {
            super(toolBarManager, tb.getElementId());
            this.tb = tb;
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            this.tb.setVisible(visible);
        }

        public void dispose() {
            this.tb.getTransientData().remove(CoolBarToTrimManager.OBJECT);
            super.dispose();
        }
    }
}

