/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.equinox.p2.core.UIServices;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.oomph.p2.core.CertificateConfirmer;
import org.eclipse.oomph.p2.internal.ui.P2ServiceUI;
import org.eclipse.oomph.setup.Index;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.SetupTaskPerformer;
import org.eclipse.oomph.setup.internal.core.util.ECFURIHandlerImpl;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.setup.internal.installer.ExtensionPage;
import org.eclipse.oomph.setup.internal.installer.NetworkConnectionsDialog;
import org.eclipse.oomph.setup.internal.installer.ProductPage;
import org.eclipse.oomph.setup.ui.UnsignedContentDialog;
import org.eclipse.oomph.setup.ui.wizards.ProjectPage;
import org.eclipse.oomph.setup.ui.wizards.SetupWizard;
import org.eclipse.oomph.util.Confirmer;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.swt.widgets.Shell;

public class Installer
extends SetupWizard {
    private final SetupWizard.SelectionMemento selectionMemento;
    public final UIServices uiServices;

    public Installer(SetupWizard.SelectionMemento theSelectionMemento) {
        this.selectionMemento = theSelectionMemento;
        this.setTrigger(Trigger.BOOTSTRAP);
        this.getResourceSet().getLoadOptions().put("OPTION_CACHE_HANDLING", ECFURIHandlerImpl.CacheHandling.CACHE_WITHOUT_ETAG_CHECKING);
        this.setSetupContext(SetupContext.createUserOnly((ResourceSet)this.getResourceSet()));
        this.setWindowTitle(PropertiesUtil.getProductName());
        this.uiServices = new P2ServiceUI(){

            protected Confirmer getUnsignedContentConfirmer() {
                return UnsignedContentDialog.createUnsignedContentConfirmer((User)Installer.this.getUser(), (boolean)false);
            }

            protected CertificateConfirmer getCertificateConfirmer() {
                return SetupCoreUtil.createCertificateConfirmer((User)Installer.this.getUser(), (boolean)false);
            }

            protected UIServices getDelegate() {
                return null;
            }
        };
    }

    public UIServices getUiServices() {
        return this.uiServices;
    }

    public SetupWizard.SelectionMemento getSelectionMemento() {
        return this.selectionMemento;
    }

    public String getHelpPath() {
        return "/org.eclipse.oomph.setup.doc/html/user/wizard/DocInstallWizard.html";
    }

    public void addPages() {
        this.addPage((IWizardPage)new ProductPage(this.selectionMemento));
        this.addPage((IWizardPage)new ProjectPage(this.selectionMemento));
        this.addPage((IWizardPage)new ExtensionPage());
        super.addPages();
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                Installer.this.loadIndex();
            }
        });
    }

    protected void indexLoaded(Index index) {
        super.indexLoaded(index);
        this.getCatalogManager().indexLoaded(index);
        IWizardPage currentPage = this.getCurrentPage();
        if (currentPage instanceof ProjectPage) {
            ((ProjectPage)currentPage).gotoPreviousPage();
        }
    }

    public void setPerformer(SetupTaskPerformer performer) {
        super.setPerformer(performer);
        if (performer != null) {
            performer.put(UIServices.class, (Object)this.getUiServices());
        }
    }

    public boolean handleMissingIndex(Shell shell) {
        int answer = new MessageDialog(shell, "Network Problem", null, "The catalog could not be loaded. Please ensure that you have network access and, if needed, have configured your network proxy.", 1, new String[]{"Retry", "Configure Network Proxy...", "Exit"}, 0).open();
        switch (answer) {
            case 1: {
                new NetworkConnectionsDialog(shell).open();
            }
            case 0: {
                ResourceSet resourceSet = this.getResourceSet();
                URI currentIndexLocation = resourceSet.getURIConverter().normalize(SetupContext.INDEX_SETUP_URI);
                ECFURIHandlerImpl.clearExpectedETags();
                this.reloadIndex(currentIndexLocation);
                return true;
            }
        }
        return false;
    }
}

