/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.eclipse.emf.common.ui.celleditor.ExtendedComboBoxCellEditor;
import org.eclipse.emf.common.ui.celleditor.ExtendedDialogCellEditor;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IPropertyEditorFactory;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.celleditor.FeatureEditorDialog;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.edit.ui.provider.InputDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class PropertyDescriptor
implements IPropertyDescriptor {
    protected Object object;
    protected IItemPropertyDescriptor itemPropertyDescriptor;
    protected static final EcorePackage ecorePackage = EcorePackage.eINSTANCE;

    public PropertyDescriptor(Object object, IItemPropertyDescriptor itemPropertyDescriptor) {
        this.object = object;
        this.itemPropertyDescriptor = itemPropertyDescriptor;
    }

    public Object getObject() {
        return this.object;
    }

    public IItemPropertyDescriptor getItemPropertyDescriptor() {
        return this.itemPropertyDescriptor;
    }

    public String getCategory() {
        return this.itemPropertyDescriptor.getCategory(this.object);
    }

    public String getDescription() {
        return this.itemPropertyDescriptor.getDescription(this.object);
    }

    public String getDisplayName() {
        return this.itemPropertyDescriptor.getDisplayName(this.object);
    }

    public String[] getFilterFlags() {
        return this.itemPropertyDescriptor.getFilterFlags(this.object);
    }

    public Object getHelpContextIds() {
        return this.itemPropertyDescriptor.getHelpContextIds(this.object);
    }

    public Object getFeature() {
        return this.itemPropertyDescriptor.getFeature(this.object);
    }

    public Object getId() {
        return this.itemPropertyDescriptor.getId(this.object);
    }

    public ILabelProvider getLabelProvider() {
        final IItemLabelProvider itemLabelProvider = this.itemPropertyDescriptor.getLabelProvider(this.object);
        return new LabelProvider(){

            public String getText(Object object) {
                return itemLabelProvider.getText(object);
            }

            public Image getImage(Object object) {
                return ExtendedImageRegistry.getInstance().getImage(itemLabelProvider.getImage(object));
            }
        };
    }

    protected ILabelProvider getEditLabelProvider() {
        return this.getLabelProvider();
    }

    public boolean isCompatibleWith(IPropertyDescriptor anotherProperty) {
        return false;
    }

    protected CellEditor createEDataTypeCellEditor(EDataType eDataType, IItemPropertyDescriptor.ValueHandler specializedValueHandler, Composite composite) {
        if (this.itemPropertyDescriptor.isMultiLine(this.object)) {
            EDataTypeValueHandler valueHandler = new EDataTypeValueHandler(eDataType, specializedValueHandler);
            return new MultiLineEDataTypeCellEditor(eDataType, valueHandler, EMFEditUIPlugin.INSTANCE.getString("_UI_FeatureEditorDialog_title", new Object[]{this.getDisplayName(), this.getEditLabelProvider().getText(this.object)}), composite);
        }
        return specializedValueHandler == null ? new EDataTypeCellEditor(eDataType, composite) : new EDataTypeCellEditor(eDataType, new EDataTypeValueHandler(eDataType, specializedValueHandler), composite);
    }

    protected CellEditor createEDataTypeCellEditor(EDataType eDataType, Composite composite) {
        return this.createEDataTypeCellEditor(eDataType, null, composite);
    }

    public CellEditor createPropertyEditor(Composite composite) {
        Object result = this.createPropertyEditorFromFactory(composite);
        if (result != null) {
            return result;
        }
        if (!this.itemPropertyDescriptor.canSetProperty(this.object)) {
            return null;
        }
        Object genericFeature = this.itemPropertyDescriptor.getFeature(this.object);
        if (genericFeature instanceof EReference[]) {
            result = new ExtendedComboBoxCellEditor(composite, new ArrayList(this.itemPropertyDescriptor.getChoiceOfValues(this.object)), this.getEditLabelProvider(), this.itemPropertyDescriptor.isSortChoices(this.object), 8, null, true);
        } else if (genericFeature instanceof EStructuralFeature) {
            EDataType eDataType;
            final EStructuralFeature feature = (EStructuralFeature)genericFeature;
            EClassifier eType = feature.getEType();
            final Collection choiceOfValues = this.itemPropertyDescriptor.getChoiceOfValues(this.object);
            if (choiceOfValues != null) {
                if (this.itemPropertyDescriptor.isMany(this.object)) {
                    boolean valid = true;
                    for (Object choice : choiceOfValues) {
                        if (eType.isInstance(choice)) continue;
                        valid = false;
                        break;
                    }
                    if (valid) {
                        final ILabelProvider editLabelProvider = this.getEditLabelProvider();
                        result = new ExtendedDialogCellEditor(composite, editLabelProvider){

                            protected Object openDialogBox(Control cellEditorWindow) {
                                FeatureEditorDialog dialog = new FeatureEditorDialog(cellEditorWindow.getShell(), editLabelProvider, PropertyDescriptor.this.object, feature.getEType(), (List)this.doGetValue(), PropertyDescriptor.this.getDisplayName(), new ArrayList(choiceOfValues), false, PropertyDescriptor.this.itemPropertyDescriptor.isSortChoices(PropertyDescriptor.this.object), feature.isUnique() || feature instanceof EReference, PropertyDescriptor.this.itemPropertyDescriptor instanceof IItemPropertyDescriptor.ValueHandlerProvider && ((IItemPropertyDescriptor.ValueHandlerProvider)PropertyDescriptor.this.itemPropertyDescriptor).isChoiceArbitrary(PropertyDescriptor.this.object) ? ((IItemPropertyDescriptor.ValueHandlerProvider)PropertyDescriptor.this.itemPropertyDescriptor).getValueHandler(PropertyDescriptor.this.object) : null);
                                dialog.open();
                                return dialog.getResult();
                            }
                        };
                    }
                }
                if (result == null) {
                    ArrayList values = new ArrayList(choiceOfValues);
                    result = this.itemPropertyDescriptor instanceof IItemPropertyDescriptor.ValueHandlerProvider && ((IItemPropertyDescriptor.ValueHandlerProvider)this.itemPropertyDescriptor).isChoiceArbitrary(this.object) ? new ExtendedComboBoxCellEditor(composite, values, this.getEditLabelProvider(), this.itemPropertyDescriptor.isSortChoices(this.object), 0, (ExtendedComboBoxCellEditor.ValueHandler)new EDataTypeValueHandler((EDataType)eType, ((IItemPropertyDescriptor.ValueHandlerProvider)this.itemPropertyDescriptor).getValueHandler(this.object)), false) : new ExtendedComboBoxCellEditor(composite, values, this.getEditLabelProvider(), this.itemPropertyDescriptor.isSortChoices(this.object), 8, null, true);
                }
            } else if (eType instanceof EDataType && (eDataType = (EDataType)eType).isSerializable()) {
                if (this.itemPropertyDescriptor.isMany(this.object)) {
                    final ILabelProvider editLabelProvider = this.getEditLabelProvider();
                    result = new ExtendedDialogCellEditor(composite, editLabelProvider){

                        protected Object openDialogBox(Control cellEditorWindow) {
                            FeatureEditorDialog dialog = new FeatureEditorDialog(cellEditorWindow.getShell(), editLabelProvider, PropertyDescriptor.this.object, feature.getEType(), (List)this.doGetValue(), PropertyDescriptor.this.getDisplayName(), null, PropertyDescriptor.this.itemPropertyDescriptor.isMultiLine(PropertyDescriptor.this.object), false, feature.isUnique(), PropertyDescriptor.this.itemPropertyDescriptor instanceof IItemPropertyDescriptor.ValueHandlerProvider ? ((IItemPropertyDescriptor.ValueHandlerProvider)PropertyDescriptor.this.itemPropertyDescriptor).getValueHandler(PropertyDescriptor.this.object) : null);
                            dialog.open();
                            return dialog.getResult();
                        }
                    };
                } else {
                    if (eDataType.getInstanceClass() == Boolean.class) {
                        return new CheckBoxCellEditor(composite, 0, true);
                    }
                    if (eDataType.getInstanceClass() == Boolean.TYPE) {
                        return new CheckBoxCellEditor(composite, 0, false);
                    }
                    result = this.itemPropertyDescriptor instanceof IItemPropertyDescriptor.ValueHandlerProvider ? this.createEDataTypeCellEditor(eDataType, ((IItemPropertyDescriptor.ValueHandlerProvider)this.itemPropertyDescriptor).getValueHandler(this.object), composite) : this.createEDataTypeCellEditor(eDataType, composite);
                }
            }
        }
        return result;
    }

    protected CellEditor createPropertyEditorFromFactory(Composite composite) {
        Object editor;
        IPropertyEditorFactory.Provider editorFactoryProvider;
        IPropertyEditorFactory editorFactory;
        if (this.itemPropertyDescriptor instanceof IPropertyEditorFactory.Provider && (editorFactory = IPropertyEditorFactory.Registry.INSTANCE.getPropertyEditorFactory((editorFactoryProvider = (IPropertyEditorFactory.Provider)this.itemPropertyDescriptor).getEditorFactory(this.object))) != null && (editor = editorFactory.createEditor(this.object, this.itemPropertyDescriptor, (Object)composite)) instanceof CellEditor) {
            return (CellEditor)editor;
        }
        return null;
    }

    public static class CheckBoxCellEditor
    extends CellEditor {
        private Button checkButton;
        private boolean isTriState;
        private Label label;

        public CheckBoxCellEditor(Composite parent, int style, boolean isTriState) {
            super(parent, style);
            this.isTriState = isTriState;
        }

        protected Control createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            RowLayout layout = new RowLayout();
            layout.marginTop = 1;
            layout.marginBottom = 0;
            layout.marginLeft = 5;
            layout.center = true;
            composite.setLayout((Layout)layout);
            this.checkButton = new Button(composite, 0x20 | this.getStyle());
            this.checkButton.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    CheckBoxCellEditor.this.focusLost();
                }
            });
            this.checkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CheckBoxCellEditor.this.changeState(false);
                }
            });
            this.checkButton.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 2) {
                        CheckBoxCellEditor.this.fireCancelEditor();
                    } else if (e.detail == 4) {
                        CheckBoxCellEditor.this.focusLost();
                    }
                }
            });
            this.label = new Label(composite, 0);
            MouseAdapter mouseListener = new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    CheckBoxCellEditor.this.changeState(true);
                }
            };
            this.label.addMouseListener((MouseListener)mouseListener);
            composite.addMouseListener((MouseListener)mouseListener);
            Color background = parent.getBackground();
            this.label.setBackground(background);
            composite.setBackground(background);
            return composite;
        }

        private void changeState(boolean toggle) {
            this.markDirty();
            if (this.isTriState) {
                if (this.checkButton.getGrayed()) {
                    this.checkButton.setGrayed(false);
                    this.checkButton.setSelection(false);
                } else if (this.checkButton.getSelection() == toggle) {
                    this.checkButton.setSelection(false);
                    this.checkButton.setGrayed(true);
                } else {
                    this.checkButton.setSelection(true);
                }
            } else if (toggle) {
                this.checkButton.setSelection(!this.checkButton.getSelection());
            }
            this.doSetValue(this.doGetValue());
        }

        protected Object doGetValue() {
            return this.checkButton.getGrayed() ? null : Boolean.valueOf(this.checkButton.getSelection());
        }

        protected void doSetValue(Object value) {
            this.checkButton.setSelection(Boolean.TRUE.equals(value));
            this.checkButton.setGrayed(value == null);
            this.label.setText(value == null ? "null" : (Boolean.TRUE.equals(value) ? "true" : "false"));
            this.label.setEnabled(value != null);
            this.label.getParent().layout();
        }

        protected void doSetFocus() {
            if (this.checkButton != null) {
                this.checkButton.setFocus();
            }
        }
    }

    public static class EDataTypeCellEditor
    extends TextCellEditor {
        protected EDataType eDataType;
        protected EDataTypeValueHandler valueHandler;
        protected boolean validateAsValue = true;

        public EDataTypeCellEditor(EDataType eDataType, Composite parent) {
            this(eDataType, new EDataTypeValueHandler(eDataType), parent);
        }

        public EDataTypeCellEditor(EDataType eDataType, EDataTypeValueHandler valueHandler, Composite parent) {
            super(parent);
            this.eDataType = eDataType;
            this.valueHandler = valueHandler;
            this.setValidator(valueHandler);
        }

        public Object doGetValue() {
            return this.valueHandler.toValue((String)super.doGetValue());
        }

        public void doSetValue(Object value) {
            value = this.valueHandler.toString(value);
            super.doSetValue(value);
        }

        protected void editOccured(ModifyEvent e) {
            this.validateAsValue = false;
            super.editOccured(e);
            this.validateAsValue = true;
        }

        protected boolean isCorrect(Object value) {
            if (this.validateAsValue) {
                value = this.valueHandler.toString(value);
            }
            return super.isCorrect(value);
        }
    }

    protected static class EDataTypeValueHandler
    implements ICellEditorValidator,
    IInputValidator,
    ExtendedComboBoxCellEditor.ValueHandler {
        protected EDataType eDataType;
        protected IItemPropertyDescriptor.ValueHandler valueHandler;

        public EDataTypeValueHandler(EDataType eDataType) {
            this(eDataType, (IItemPropertyDescriptor.ValueHandler)new ItemPropertyDescriptor.DataTypeValueHandler(eDataType));
        }

        public EDataTypeValueHandler(EDataType eDataType, IItemPropertyDescriptor.ValueHandler valueHandler) {
            this.eDataType = eDataType;
            this.valueHandler = valueHandler;
        }

        public String isValid(Object object) {
            return this.escape(this.valueHandler.isValid((String)object));
        }

        protected String escape(String message) {
            return message == null ? null : message.replaceAll("'", "''").replaceAll("\\{", "'{'");
        }

        public String isValid(String text) {
            return this.isValid((Object)text);
        }

        public Object toValue(String string) {
            return this.valueHandler.toValue(string);
        }

        public String toString(Object value) {
            String result = this.valueHandler.toString(value);
            return result == null ? "" : result;
        }
    }

    @Deprecated
    public static class FloatCellEditor
    extends TextCellEditor {
        public FloatCellEditor(Composite composite) {
            super(composite);
            this.setValidator(new ICellEditorValidator(){

                public String isValid(Object object) {
                    if (object instanceof Float) {
                        return null;
                    }
                    String string = (String)object;
                    try {
                        Float.parseFloat(string);
                        return null;
                    }
                    catch (NumberFormatException exception) {
                        return exception.getMessage();
                    }
                }
            });
        }

        public Object doGetValue() {
            return new Float(Float.parseFloat((String)super.doGetValue()));
        }

        public void doSetValue(Object value) {
            super.doSetValue((Object)value.toString());
        }
    }

    @Deprecated
    public static class IntegerCellEditor
    extends TextCellEditor {
        public IntegerCellEditor(Composite composite) {
            super(composite);
            this.setValidator(new ICellEditorValidator(){

                public String isValid(Object object) {
                    if (object instanceof Integer) {
                        return null;
                    }
                    String string = (String)object;
                    try {
                        Integer.parseInt(string);
                        return null;
                    }
                    catch (NumberFormatException exception) {
                        return exception.getMessage();
                    }
                }
            });
        }

        public Object doGetValue() {
            return Integer.parseInt((String)super.doGetValue());
        }

        public void doSetValue(Object value) {
            super.doSetValue((Object)value.toString());
        }
    }

    public static class MultiLineEDataTypeCellEditor
    extends EDataTypeCellEditor {
        private static final EDataTypeValueHandler NO_OP_VALUE_HANDLER = new EDataTypeValueHandler(EcorePackage.Literals.ESTRING);
        protected Text text;
        protected Button button;
        protected boolean doEscape;
        private String value;
        private String dialogTitle;
        private MouseListener mouseListener = new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                MultiLineEDataTypeCellEditor.this.showDialog();
            }

            public void mouseDoubleClick(MouseEvent e) {
                MultiLineEDataTypeCellEditor.this.showDialog();
            }
        };
        private VerifyListener verifyListener = new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = false;
                MultiLineEDataTypeCellEditor.this.showDialog();
            }
        };

        public MultiLineEDataTypeCellEditor(EDataType eDataType, EDataTypeValueHandler valueHandler, String dialogTitle, Composite parent) {
            super(eDataType, valueHandler, parent);
            this.dialogTitle = dialogTitle;
        }

        private void showDialog() {
            this.button.setFocus();
            this.button.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MultiLineEDataTypeCellEditor.this.button.notifyListeners(13, null);
                }
            });
        }

        public Object doGetValue() {
            String str;
            String string = str = this.value != null ? this.value : (String)super.doGetValue();
            if (this.doEscape) {
                str = this.unescape(str);
            }
            return str;
        }

        public void doSetValue(Object value) {
            this.text.removeMouseListener(this.mouseListener);
            this.text.removeVerifyListener(this.verifyListener);
            String literal = this.valueHandler.toString(value);
            if (literal != null) {
                char[] cArray = literal.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char c = cArray[n2];
                    if (Character.isISOControl(c)) {
                        this.doEscape = true;
                        this.button.setImage(ExtendedImageRegistry.INSTANCE.getImage(EMFEditUIPlugin.INSTANCE.getImage("full/ctool16/EncodedEllipses")));
                        literal = this.escape(literal);
                        break;
                    }
                    ++n2;
                }
            }
            EDataTypeValueHandler oldValueHandler = this.valueHandler;
            try {
                boolean isVeryLong;
                boolean bl = isVeryLong = literal.length() > 2000;
                if (isVeryLong) {
                    this.value = literal;
                    literal = literal.substring(0, 2000);
                } else {
                    this.value = null;
                }
                this.valueHandler = NO_OP_VALUE_HANDLER;
                super.doSetValue(literal);
                if (isVeryLong) {
                    this.text.addMouseListener(this.mouseListener);
                    this.text.addVerifyListener(this.verifyListener);
                }
            }
            finally {
                this.valueHandler = oldValueHandler;
            }
        }

        protected Control createControl(Composite parent) {
            GridLayout layout = new GridLayout(2, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.horizontalSpacing = 0;
            final Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)layout);
            composite.setFont(parent.getFont());
            composite.setBackground(parent.getBackground());
            this.text = (Text)super.createControl(composite);
            this.text.setLayoutData((Object)new GridData(4, 4, true, true));
            this.button = new Button(composite, 8);
            GridData layoutData = new GridData(4, 4, false, true);
            if (parent instanceof Tree) {
                layoutData.widthHint = ((Tree)parent).getItemHeight();
            } else if (parent instanceof Table) {
                layoutData.widthHint = ((Table)parent).getItemHeight();
            }
            this.button.setLayoutData((Object)layoutData);
            this.button.setImage(ExtendedImageRegistry.INSTANCE.getImage(EMFEditUIPlugin.INSTANCE.getImage("full/ctool16/Ellipses")));
            this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MultiLineInputDialog dialog;
                    boolean containsNull;
                    String stringValue = MultiLineEDataTypeCellEditor.this.valueHandler.toString(MultiLineEDataTypeCellEditor.this.getValue());
                    boolean bl = containsNull = stringValue.indexOf(0) != -1;
                    if (containsNull) {
                        stringValue = stringValue.replace('\u0000', '\n');
                    }
                    if ((dialog = new MultiLineInputDialog(composite.getShell(), MultiLineEDataTypeCellEditor.this.dialogTitle, EMFEditUIPlugin.INSTANCE.getString("_UI_MultiLineInputDialog_message"), stringValue, MultiLineEDataTypeCellEditor.this.valueHandler)).open() == 0) {
                        boolean newValidState;
                        Object newValue;
                        String value = dialog.getValue();
                        value = value.replace("\r\n", "\n");
                        if (containsNull) {
                            value = value.replace('\n', '\u0000');
                        }
                        if ((newValue = MultiLineEDataTypeCellEditor.this.valueHandler.toValue(value)) != null && (newValidState = MultiLineEDataTypeCellEditor.this.isCorrect(newValue))) {
                            MultiLineEDataTypeCellEditor.this.markDirty();
                            MultiLineEDataTypeCellEditor.this.doSetValue(newValue);
                            MultiLineEDataTypeCellEditor.this.fireApplyEditorValue();
                        }
                    } else {
                        MultiLineEDataTypeCellEditor.this.fireCancelEditor();
                    }
                }
            });
            this.button.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    if (e.character == '\u001b') {
                        MultiLineEDataTypeCellEditor.this.fireCancelEditor();
                    }
                }
            });
            return composite;
        }

        protected void focusLost() {
            if (this.isActivated()) {
                this.button.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        try {
                            if (MultiLineEDataTypeCellEditor.this.button.isFocusControl()) {
                                return;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            MultiLineEDataTypeCellEditor.this.fireApplyEditorValue();
                            MultiLineEDataTypeCellEditor.this.deactivate();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        }

        protected String escape(String literal) {
            if (literal == null) {
                return null;
            }
            int len = literal.length();
            StringBuilder builder = new StringBuilder(len);
            int i = 0;
            while (i < len) {
                char c = literal.charAt(i);
                if (c < ' ') {
                    switch (c) {
                        case '\r': {
                            builder.append('\\');
                            builder.append('r');
                            break;
                        }
                        case '\n': {
                            builder.append('\\');
                            builder.append('n');
                            break;
                        }
                        case '\t': {
                            builder.append('\\');
                            builder.append('t');
                            break;
                        }
                        case '\f': {
                            builder.append('\\');
                            builder.append('f');
                            break;
                        }
                        case '\b': {
                            builder.append('\\');
                            builder.append('b');
                            break;
                        }
                        default: {
                            if (c > '\u000f') {
                                builder.append("\\u00" + this.charToHex(c));
                                break;
                            }
                            builder.append("\\u000" + this.charToHex(c));
                            break;
                        }
                    }
                } else if (c == '\\') {
                    builder.append('\\');
                    builder.append('\\');
                } else {
                    builder.append(c);
                }
                ++i;
            }
            return builder.toString();
        }

        protected String unescape(String literal) {
            if (literal == null) {
                return null;
            }
            int len = literal.length();
            StringBuilder builder = new StringBuilder(len);
            StringBuilder unicodeBuilder = new StringBuilder(4);
            boolean unicode = false;
            boolean slash = false;
            int i = 0;
            while (i < len) {
                char c = literal.charAt(i);
                if (unicode) {
                    unicodeBuilder.append(c);
                    if (unicodeBuilder.length() == 4) {
                        try {
                            char value = this.hexToChar(unicodeBuilder.toString());
                            builder.append(value);
                            unicodeBuilder.setLength(0);
                            unicode = false;
                            slash = false;
                        }
                        catch (NumberFormatException ex) {
                            builder.append('\\');
                            builder.append('u');
                            builder.append((CharSequence)unicodeBuilder);
                        }
                    }
                } else if (slash) {
                    slash = false;
                    switch (c) {
                        case '\\': {
                            builder.append('\\');
                            break;
                        }
                        case 'r': {
                            builder.append('\r');
                            break;
                        }
                        case 'n': {
                            builder.append('\n');
                            break;
                        }
                        case 't': {
                            builder.append('\t');
                            break;
                        }
                        case 'f': {
                            builder.append('\f');
                            break;
                        }
                        case 'b': {
                            builder.append('\b');
                            break;
                        }
                        case 'u': {
                            unicode = true;
                            break;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': {
                            if (i + 2 < len && literal.charAt(i + 1) >= '0' && literal.charAt(i + 1) <= '7' && literal.charAt(i + 2) >= '0' && literal.charAt(i + 2) <= '7') {
                                builder.append((char)Integer.parseInt(literal.substring(i, i + 3), 8));
                                i += 2;
                                break;
                            }
                        }
                        default: {
                            builder.append(c);
                            break;
                        }
                    }
                } else if (c == '\\') {
                    slash = true;
                } else {
                    builder.append(c);
                }
                ++i;
            }
            if (slash) {
                builder.append('\\');
            }
            return builder.toString();
        }

        protected String charToHex(char ch) {
            return Integer.toHexString(ch).toUpperCase(Locale.ENGLISH);
        }

        protected char hexToChar(String s) {
            return (char)Integer.parseInt(s, 16);
        }
    }

    private static class MultiLineInputDialog
    extends InputDialog {
        public MultiLineInputDialog(Shell parentShell, String title, String message, String initialValue, IInputValidator validator) {
            super(parentShell, title, message, initialValue, validator);
            this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        }

        protected Text createText(Composite composite) {
            Text text = new Text(composite, 2818);
            GridData data = new GridData(1808);
            data.heightHint = 5 * text.getLineHeight();
            data.widthHint = this.convertHorizontalDLUsToPixels(200);
            text.setLayoutData((Object)data);
            return text;
        }
    }
}

