/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.core;

import java.io.File;
import org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.spi.IAgentServiceFactory;
import org.eclipse.oomph.p2.internal.core.LazyProfileRegistry;
import org.eclipse.oomph.p2.internal.core.Messages;
import org.eclipse.oomph.p2.internal.core.P2CorePlugin;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.osgi.util.NLS;

public class LazyProfileRegistryComponent
implements IAgentServiceFactory {
    public static final String PROP_LAZY_PROFILE_REGISTRY = "oomph.p2.lazy.profile.registry";

    public Object createService(IProvisioningAgent agent) {
        boolean isLazySupported;
        File directory;
        IAgentLocation location = (IAgentLocation)agent.getService(IAgentLocation.SERVICE_NAME);
        try {
            directory = LazyProfileRegistry.getDefaultRegistryDirectory((IAgentLocation)location);
        }
        catch (RuntimeException ex) {
            throw new RuntimeException(NLS.bind((String)Messages.LazyProfileRegistryComponent_ProblemCreatingDirecgtory_exception, (Object)location), ex);
        }
        SimpleProfileRegistry registry = null;
        boolean bl = isLazySupported = !"false".equals(PropertiesUtil.getProperty((String)PROP_LAZY_PROFILE_REGISTRY));
        if (isLazySupported) {
            try {
                registry = new LazyProfileRegistry(agent, directory, IOUtil.canWriteFolder((File)directory));
            }
            catch (Throwable ex) {
                P2CorePlugin.INSTANCE.log(ex);
            }
        }
        if (registry == null) {
            registry = new SimpleProfileRegistry(agent, directory);
        }
        registry.setEventBus((IProvisioningEventBus)agent.getService(IProvisioningEventBus.SERVICE_NAME));
        return registry;
    }
}

