/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.ui.storage.view;

import java.io.File;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.equinox.internal.security.ui.nls.SecUIMessages;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;

public class ExportDialog
extends TitleAreaDialog {
    private static final String HELP_ID = "org.eclipse.equinox.security.ui.ExportDialog";
    private static final ImageDescriptor dlgImageDescriptor = ImageDescriptor.createFromFile(ExportDialog.class, (String)"/icons/storage/export_secure_wiz.png");
    protected static final String[] exportExtensions = new String[]{".txt"};
    protected static final String EXPORT_FILE = "org.eclipse.equinox.security.ui.exportfile";
    protected IEclipsePreferences eclipseNode = ConfigurationScope.INSTANCE.getNode("org.eclipse.equinox.security.ui");
    protected Text fileText;
    protected Button okButton;
    protected String file;
    private Image dlgTitleImage = null;

    public ExportDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(SecUIMessages.generalTitle);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, HELP_ID);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, SecUIMessages.exportDialogOK, true);
        this.okButton.setEnabled(this.validFile());
        this.createButton(parent, 1, SecUIMessages.exportDialogCancel, false);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(SecUIMessages.exportDialogTitle);
        this.setMessage(SecUIMessages.exportDialogMsg, 2);
        this.dlgTitleImage = dlgImageDescriptor.createImage();
        this.setTitleImage(this.dlgTitleImage);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite compositeTop = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(compositeTop, 0);
        Label fileLabel = new Label(composite, 16384);
        fileLabel.setText(SecUIMessages.exportDialogFileLabel);
        GridData labelData = new GridData();
        labelData.horizontalSpan = 2;
        fileLabel.setLayoutData((Object)labelData);
        this.fileText = new Text(composite, 18432);
        String lastFileName = this.eclipseNode.get(EXPORT_FILE, null);
        if (lastFileName != null) {
            this.fileText.setText(lastFileName);
        }
        this.fileText.addModifyListener(event -> this.okButton.setEnabled(this.validFile()));
        Button browse = new Button(composite, 0);
        browse.setText(SecUIMessages.exportDialogBrowse);
        browse.setLayoutData((Object)new GridData(3, 2, false, false));
        browse.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                String result;
                FileDialog dialog = new FileDialog(ExportDialog.this.getShell());
                dialog.setText(SecUIMessages.fileSelectTitle);
                dialog.setFilterExtensions(exportExtensions);
                String tmp = ExportDialog.this.fileText.getText();
                if (tmp != null) {
                    dialog.setFileName(tmp);
                }
                if ((result = dialog.open()) != null) {
                    ExportDialog.this.fileText.setText(result);
                }
            }
        });
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayoutFactory.swtDefaults().generateLayout(composite);
        return composite;
    }

    protected boolean validFile() {
        File check;
        if (this.fileText == null) {
            return true;
        }
        String tmp = this.fileText.getText();
        boolean valid = tmp != null && tmp.length() != 0 ? ((check = new File(tmp)).exists() ? check.canWrite() : true) : false;
        if (valid) {
            this.setMessage(SecUIMessages.exportDialogMsg, 2);
        } else {
            this.setMessage(SecUIMessages.exportDialogInvalidMsg, 3);
        }
        return valid;
    }

    protected void okPressed() {
        this.file = this.fileText.getText();
        if (this.file != null && !this.file.equals(this.eclipseNode.get(EXPORT_FILE, null))) {
            this.eclipseNode.put(EXPORT_FILE, this.file);
            try {
                this.eclipseNode.flush();
            }
            catch (BackingStoreException backingStoreException) {}
        }
        super.okPressed();
    }

    public String getFileName() {
        return this.file;
    }
}

