/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.sync;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.oomph.setup.internal.sync.DataProvider;
import org.eclipse.oomph.setup.internal.sync.Messages;
import org.eclipse.oomph.setup.internal.sync.SetupSyncPlugin;
import org.eclipse.oomph.setup.internal.sync.SyncUtil;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.osgi.util.NLS;

public class Snapshot {
    public static final boolean DEFAULT_INCREMENTAL = true;
    private final DataProvider dataProvider;
    private final String info;
    private final File oldFile;
    private final File newFile;
    private final File tmpFile;

    public Snapshot(DataProvider dataProvider, File folder) {
        this(dataProvider, folder, true);
    }

    public Snapshot(DataProvider dataProvider, File folder, boolean incremental) {
        this.dataProvider = dataProvider;
        String prefix = dataProvider.getLocation().toString().toLowerCase();
        this.info = new File(folder, String.valueOf(prefix) + "-???.xml").toString();
        this.oldFile = incremental ? new File(folder, String.valueOf(prefix) + "-old.xml") : null;
        this.newFile = new File(folder, String.valueOf(prefix) + "-new.xml");
        this.tmpFile = new File(folder, String.valueOf(prefix) + "-tmp.xml");
    }

    public DataProvider getDataProvider() {
        return this.dataProvider;
    }

    public File getFolder() {
        return this.tmpFile.getParentFile();
    }

    public File getOldFile() {
        return this.oldFile;
    }

    public File getNewFile() {
        return this.newFile;
    }

    public void copyFilesTo(File target) {
        Snapshot.copyFileTo(target, this.oldFile);
        Snapshot.copyFileTo(target, this.newFile);
        File[] fileArray = this.dataProvider.getExtraFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            Snapshot.copyFileTo(target, file);
            ++n2;
        }
    }

    public void copyFilesFrom(File source) {
        Snapshot.copyFileFrom(source, this.oldFile);
        Snapshot.copyFileFrom(source, this.newFile);
        File[] fileArray = this.dataProvider.getExtraFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            Snapshot.copyFileFrom(source, file);
            ++n2;
        }
    }

    public WorkingCopy createWorkingCopy() throws IOException {
        try {
            this.dataProvider.retrieve(this.newFile);
        }
        catch (DataProvider.NotFoundException ex) {
            SyncUtil.deleteFile(this.newFile);
        }
        return new WorkingCopy(this);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.dataProvider + " --> " + this.info + "]";
    }

    private void doCommit(boolean updateDataProvider) throws IOException, DataProvider.NotCurrentException {
        if (!this.tmpFile.isFile()) {
            throw new FileNotFoundException(this.tmpFile.getAbsolutePath());
        }
        try {
            if (updateDataProvider) {
                this.dataProvider.update(this.tmpFile, this.newFile);
            }
            if (this.oldFile != null) {
                this.moveTmpFileTo(this.oldFile);
                IOUtil.copyFile((File)this.oldFile, (File)this.newFile);
            } else {
                this.moveTmpFileTo(this.newFile);
            }
        }
        catch (DataProvider.NotCurrentException ex) {
            this.moveTmpFileTo(this.newFile);
            throw ex;
        }
    }

    private void moveTmpFileTo(File target) throws IOException {
        SyncUtil.deleteFile(target);
        if (!this.tmpFile.renameTo(target)) {
            throw new IOException(NLS.bind((String)Messages.Snapshot_CouldNotRename_exception, (Object)this.tmpFile, (Object)target));
        }
    }

    private static void copyFileTo(File target, File file) {
        if (file != null && file.isFile()) {
            IOUtil.copyFile((File)file, (File)new File(target, file.getName()));
        }
    }

    private static void copyFileFrom(File source, File file) {
        File sourceFile;
        if (file != null && (sourceFile = new File(source, file.getName())).isFile()) {
            IOUtil.copyFile((File)sourceFile, (File)file);
        }
    }

    public static final class WorkingCopy {
        private final Snapshot snapshot;
        private boolean committed;
        private boolean disposed;

        private WorkingCopy(Snapshot snapshot) {
            this.snapshot = snapshot;
        }

        public Snapshot getSnapshot() {
            return this.snapshot;
        }

        public boolean isLocal() {
            return this.snapshot.getDataProvider().getLocation() == DataProvider.Location.LOCAL;
        }

        public File getTmpFile() {
            return this.snapshot.tmpFile;
        }

        public void commit(boolean updateDataProvider) throws IOException, DataProvider.NotCurrentException {
            if (!this.committed && !this.disposed) {
                this.committed = true;
                this.snapshot.doCommit(updateDataProvider);
            }
        }

        public void dispose() {
            if (!this.disposed) {
                this.disposed = true;
                try {
                    SyncUtil.deleteFile(this.snapshot.tmpFile);
                }
                catch (Throwable ex) {
                    SetupSyncPlugin.INSTANCE.log(ex);
                }
            }
        }
    }
}

