/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workspace.markers;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.ui.internal.workspace.markers.NameAttribute;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public final class Translation {
    private final Consumer<CoreException> reporter;
    private final NameAttribute nameAttribute;

    public Translation() {
        this(e -> Platform.getLog((Bundle)FrameworkUtil.getBundle(Translation.class)).log(e.getStatus()));
    }

    public Translation(Consumer<CoreException> reporter) {
        Objects.requireNonNull(reporter);
        this.reporter = reporter;
        this.nameAttribute = new NameAttribute();
    }

    public Optional<String> message(IMarker marker) {
        try {
            Object attribute = marker.getAttribute("message");
            if (attribute instanceof String) {
                String value = (String)attribute;
                return Optional.of(value);
            }
        }
        catch (CoreException e) {
            this.reporter.accept(e);
        }
        return Optional.empty();
    }

    public Optional<String> name(IMarker marker) {
        if (!marker.exists()) {
            return Optional.empty();
        }
        try {
            Object name = marker.getAttribute(this.nameAttribute.key());
            if (name != null) {
                return Optional.of(name.toString());
            }
        }
        catch (CoreException e) {
            this.reporter.accept(e);
        }
        return Optional.of(marker.getResource().getName());
    }
}

