/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class TabFolder
extends Composite {
    TabItem[] items;
    ImageList imageList;

    public TabFolder(Composite parent, int style) {
        super(parent, TabFolder.checkStyle(style));
    }

    static int checkStyle(int style) {
        style = TabFolder.checkBits(style, 128, 1024, 0, 0, 0, 0);
        return style & 0xFFFFFCFF;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    @Override
    long clientHandle() {
        int index = GTK.gtk_notebook_get_current_page(this.handle);
        if (index != -1 && this.items[index] != null) {
            return this.items[index].pageHandle;
        }
        return this.handle;
    }

    @Override
    Point computeSizeInPixels(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point size = super.computeSizeInPixels(wHint, hHint, changed);
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        boolean scrollable = GTK.gtk_notebook_get_scrollable(this.handle);
        GTK.gtk_notebook_set_scrollable(this.handle, false);
        Point notebookSize = this.computeNativeSize(this.handle, wHint, hHint, changed);
        GTK.gtk_notebook_set_scrollable(this.handle, scrollable);
        int[] initialGap = new int[1];
        notebookSize.x += initialGap[0] * 2;
        size.x = Math.max(notebookSize.x, size.x);
        size.y = Math.max(notebookSize.y, size.y);
        return size;
    }

    @Override
    Rectangle computeTrimInPixels(int x, int y, int width, int height) {
        this.checkWidget();
        this.forceResize();
        long clientHandle = this.clientHandle();
        GtkAllocation allocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(clientHandle, allocation);
        int clientX = allocation.x;
        int clientY = allocation.y;
        x -= clientX;
        y -= clientY;
        width += clientX + clientX;
        if ((this.style & 0x400) != 0) {
            int clientHeight = allocation.height;
            GTK.gtk_widget_get_allocation(this.handle, allocation);
            int parentHeight = allocation.height;
            height += parentHeight - clientHeight;
        } else {
            height += clientX + clientY;
        }
        return new Rectangle(x, y, width, height);
    }

    @Override
    Rectangle getClientAreaInPixels() {
        Rectangle clientRectangle = super.getClientAreaInPixels();
        clientRectangle.x = 0;
        clientRectangle.y = 0;
        return clientRectangle;
    }

    @Override
    void createHandle(int index) {
        this.state |= 8;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        this.handle = GTK.gtk_notebook_new();
        if (this.handle == 0L) {
            this.error(2);
        }
        if (GTK.GTK4) {
            OS.swt_fixed_add(this.fixedHandle, this.handle);
        } else {
            GTK3.gtk_widget_set_has_window(this.fixedHandle, true);
            GTK3.gtk_container_add(this.fixedHandle, this.handle);
        }
        GTK.gtk_notebook_set_show_tabs(this.handle, true);
        GTK.gtk_notebook_set_scrollable(this.handle, true);
        if ((this.style & 0x400) != 0) {
            GTK.gtk_notebook_set_tab_pos(this.handle, 3);
        }
    }

    @Override
    void createWidget(int index) {
        super.createWidget(index);
        this.items = new TabItem[4];
    }

    void createItem(TabItem item, int index) {
        long imageHandle;
        long labelHandle;
        long boxHandle;
        int itemCount = 0;
        if (GTK.GTK4) {
            itemCount = GTK.gtk_notebook_get_n_pages(this.handle);
        } else {
            long list = GTK3.gtk_container_get_children(this.handle);
            if (list != 0L) {
                itemCount = OS.g_list_length(list);
                OS.g_list_free(list);
            }
        }
        if (index < 0 || index > itemCount) {
            this.error(6);
        }
        if (itemCount == this.items.length) {
            TabItem[] newItems = new TabItem[this.items.length + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        if ((boxHandle = this.gtk_box_new(0, false, 0)) == 0L) {
            this.error(2);
        }
        if ((labelHandle = GTK.gtk_label_new_with_mnemonic(null)) == 0L) {
            this.error(2);
        }
        if ((imageHandle = GTK.gtk_image_new()) == 0L) {
            this.error(2);
        }
        if (GTK.GTK4) {
            GTK4.gtk_box_append(boxHandle, imageHandle);
            GTK4.gtk_box_append(boxHandle, labelHandle);
        } else {
            GTK3.gtk_container_add(boxHandle, imageHandle);
            GTK3.gtk_container_add(boxHandle, labelHandle);
        }
        long pageHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (pageHandle == 0L) {
            this.error(2);
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 49L);
        GTK.gtk_notebook_insert_page(this.handle, pageHandle, boxHandle, index);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 49L);
        if (GTK.GTK4) {
            GTK.gtk_widget_hide(imageHandle);
        } else {
            GTK.gtk_widget_show(boxHandle);
            GTK.gtk_widget_show(labelHandle);
            GTK.gtk_widget_show(pageHandle);
        }
        item.state |= 8;
        item.handle = boxHandle;
        item.labelHandle = labelHandle;
        item.imageHandle = imageHandle;
        item.pageHandle = pageHandle;
        System.arraycopy(this.items, index, this.items, index + 1, itemCount++ - index);
        this.items[index] = item;
        if ((this.state & 0x1000) != 0) {
            item.setForegroundGdkRGBA(item.handle, this.getForegroundGdkRGBA());
        }
        if ((this.state & 0x4000) != 0) {
            long fontDesc = this.getFontDescription();
            item.setFontDescription(fontDesc);
            OS.pango_font_description_free(fontDesc);
        }
        if (itemCount == 1) {
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 49L);
            GTK.gtk_notebook_set_current_page(this.handle, 0);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 49L);
            Event event = new Event();
            event.item = this.items[0];
            this.sendSelectionEvent(13, event, false);
        }
    }

    void destroyItem(TabItem item) {
        int newIndex;
        int index = 0;
        int itemCount = this.getItemCount();
        while (index < itemCount) {
            if (this.items[index] == item) break;
            ++index;
        }
        if (index == itemCount) {
            this.error(15);
        }
        int oldIndex = GTK.gtk_notebook_get_current_page(this.handle);
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 49L);
        GTK.gtk_notebook_remove_page(this.handle, index);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 49L);
        System.arraycopy(this.items, index + 1, this.items, index, --itemCount - index);
        this.items[itemCount] = null;
        if (index == oldIndex && (newIndex = GTK.gtk_notebook_get_current_page(this.handle)) != -1) {
            Control control = this.items[newIndex].getControl();
            if (control != null && !control.isDisposed()) {
                control.setBoundsInPixels(this.getClientAreaInPixels());
                control.setVisible(true);
            }
            Event event = new Event();
            event.item = this.items[newIndex];
            this.sendSelectionEvent(13, event, true);
        }
    }

    @Override
    long eventHandle() {
        return this.handle;
    }

    @Override
    Control[] _getChildren() {
        Control[] newChildren;
        Control[] directChildren = super._getChildren();
        int directCount = directChildren.length;
        int itemCount = this.items == null ? 0 : this.items.length;
        Control[] children = new Control[itemCount + directCount];
        int childrenCount = 0;
        int itemIndex = 0;
        while (itemIndex < itemCount) {
            TabItem tabItem = this.items[itemIndex];
            if (tabItem != null && !tabItem.isDisposed()) {
                long parentHandle = tabItem.pageHandle;
                if (GTK.GTK4) {
                    long child = GTK4.gtk_widget_get_first_child(parentHandle);
                    while (child != 0L) {
                        Widget childWidget = this.display.getWidget(child);
                        if (childWidget != null && childWidget instanceof Control && childWidget != this) {
                            children[childrenCount] = (Control)childWidget;
                            ++childrenCount;
                        }
                        child = GTK4.gtk_widget_get_next_sibling(child);
                    }
                } else {
                    long list = GTK3.gtk_container_get_children(parentHandle);
                    if (list != 0L) {
                        Widget widget;
                        long handle = OS.g_list_data(list);
                        if (handle != 0L && (widget = this.display.getWidget(handle)) != null && widget != this && widget instanceof Control) {
                            children[childrenCount++] = (Control)widget;
                        }
                        OS.g_list_free(list);
                    }
                }
            }
            ++itemIndex;
        }
        if (childrenCount == itemCount + directCount) {
            return children;
        }
        if (childrenCount == itemCount) {
            newChildren = children;
        } else {
            newChildren = new Control[childrenCount + directCount];
            System.arraycopy(children, 0, newChildren, 0, childrenCount);
        }
        System.arraycopy(directChildren, 0, newChildren, childrenCount, directCount);
        return newChildren;
    }

    public TabItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.getItemCount()) {
            this.error(6);
        }
        if (GTK.GTK4) {
            long child = GTK4.gtk_widget_get_first_child(this.handle);
            if (child == 0L) {
                this.error(8);
            }
        } else {
            long list = GTK3.gtk_container_get_children(this.handle);
            if (list == 0L) {
                this.error(8);
            }
            int itemCount = OS.g_list_length(list);
            OS.g_list_free(list);
            if (index < 0 || index >= itemCount) {
                this.error(8);
            }
        }
        return this.items[index];
    }

    public TabItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        int itemCount = this.getItemCount();
        int i = 0;
        while (i < itemCount) {
            TabItem item = this.items[i];
            Rectangle rect = item.getBounds();
            if (rect.contains(point)) {
                return item;
            }
            ++i;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        int itemCount = 0;
        if (GTK.GTK4) {
            itemCount = GTK.gtk_notebook_get_n_pages(this.handle);
        } else {
            long list = GTK3.gtk_container_get_children(this.handle);
            if (list == 0L) {
                return 0;
            }
            itemCount = OS.g_list_length(list);
            OS.g_list_free(list);
        }
        return itemCount;
    }

    public TabItem[] getItems() {
        this.checkWidget();
        int count = this.getItemCount();
        TabItem[] result = new TabItem[count];
        System.arraycopy(this.items, 0, result, 0, count);
        return result;
    }

    public TabItem[] getSelection() {
        this.checkWidget();
        int index = GTK.gtk_notebook_get_current_page(this.handle);
        if (index == -1) {
            return new TabItem[0];
        }
        return new TabItem[]{this.items[index]};
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return GTK.gtk_notebook_get_current_page(this.handle);
    }

    @Override
    long gtk_focus(long widget, long directionType) {
        return 0L;
    }

    @Override
    long gtk_switch_page(long notebook, long page, int page_num) {
        TabItem item = this.items[page_num];
        if (GTK.GTK4) {
            Control control = item.getControl();
            control.setBoundsInPixels(this.getClientAreaInPixels());
        } else {
            Control control;
            int index = GTK.gtk_notebook_get_current_page(this.handle);
            if (index != -1) {
                control = this.items[index].getControl();
                if (control != null && !control.isDisposed()) {
                    control.setVisible(false);
                }
            } else {
                return 0L;
            }
            control = item.getControl();
            if (control != null && !control.isDisposed()) {
                control.setBoundsInPixels(this.getClientAreaInPixels());
                control.setVisible(true);
            }
        }
        Event event = new Event();
        event.item = item;
        this.sendSelectionEvent(13, event, false);
        return 0L;
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.switch_page, this.display.getClosure(49), false);
    }

    public int indexOf(TabItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        int index = -1;
        int count = this.getItemCount();
        int i = 0;
        while (i < count) {
            if (this.items[i] == item) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    @Override
    Point minimumSize(int wHint, int hHint, boolean flushCache) {
        Control[] children = this._getChildren();
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            int index = 0;
            int count = this.getItemCount();
            while (index < count) {
                if (this.items[index].control == child) break;
                ++index;
            }
            if (index == count) {
                Rectangle rect = DPIUtil.autoScaleUp(child.getBounds());
                width = Math.max(width, rect.x + rect.width);
                height = Math.max(height, rect.y + rect.height);
            } else {
                Point size = DPIUtil.autoScaleUp(child.computeSize(DPIUtil.autoScaleDown(wHint), DPIUtil.autoScaleDown(hHint), flushCache));
                width = Math.max(width, size.x);
                height = Math.max(height, size.y);
            }
            ++i;
        }
        return new Point(width, height);
    }

    @Override
    boolean mnemonicHit(char key) {
        int itemCount = this.getItemCount();
        int i = 0;
        while (i < itemCount) {
            long labelHandle = this.items[i].labelHandle;
            if (labelHandle != 0L && this.mnemonicHit(labelHandle, key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    boolean mnemonicMatch(char key) {
        int itemCount = this.getItemCount();
        int i = 0;
        while (i < itemCount) {
            long labelHandle = this.items[i].labelHandle;
            if (labelHandle != 0L && this.mnemonicHit(labelHandle, key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    void releaseChildren(boolean destroy) {
        if (this.items != null) {
            int i = 0;
            while (i < this.items.length) {
                TabItem item = this.items[i];
                if (item != null && !item.isDisposed()) {
                    item.release(false);
                }
                ++i;
            }
            this.items = null;
        }
        super.releaseChildren(destroy);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
    }

    @Override
    void removeControl(Control control) {
        super.removeControl(control);
        int count = this.getItemCount();
        int i = 0;
        while (i < count) {
            TabItem item = this.items[i];
            if (item.control == control) {
                item.setControl(null);
            }
            ++i;
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    @Override
    void reskinChildren(int flags) {
        if (this.items != null) {
            int count = this.getItemCount();
            int i = 0;
            while (i < count) {
                TabItem item = this.items[i];
                if (item != null) {
                    item.reskin(flags);
                }
                ++i;
            }
        }
        super.reskinChildren(flags);
    }

    @Override
    void setBackgroundGdkRGBA(long context, long handle, GdkRGBA rgba) {
        String css;
        this.cssBackground = css = "notebook header {background-color: " + this.display.gtk_rgba_to_css_string(rgba) + ";}";
        String finalCss = this.display.gtk_css_create_css_color_string(this.cssBackground, this.cssForeground, 8);
        this.gtk_css_provider_load_from_css(context, finalCss);
    }

    @Override
    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        int index;
        int result = super.setBounds(x, y, width, height, move, resize);
        if ((result & 0x100) != 0 && (index = this.getSelectionIndex()) != -1) {
            TabItem item = this.items[index];
            Control control = item.control;
            if (control != null && !control.isDisposed()) {
                control.setBoundsInPixels(this.getClientAreaInPixels());
            }
        }
        return result;
    }

    @Override
    void setFontDescription(long font) {
        super.setFontDescription(font);
        TabItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i] != null) {
                items[i].setFontDescription(font);
            }
            ++i;
        }
    }

    @Override
    void setForegroundGdkRGBA(GdkRGBA rgba) {
        super.setForegroundGdkRGBA(rgba);
        TabItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i] != null) {
                items[i].setForegroundRGBA(rgba);
            }
            ++i;
        }
    }

    @Override
    void setOrientation(boolean create) {
        super.setOrientation(create);
        if (this.items != null) {
            int i = 0;
            while (i < this.items.length) {
                if (this.items[i] != null) {
                    this.items[i].setOrientation(create);
                }
                ++i;
            }
        }
    }

    public void setSelection(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.getItemCount()) {
            return;
        }
        this.setSelection(index, false);
    }

    void setSelection(int index, boolean notify) {
        if (index < 0) {
            return;
        }
        int oldIndex = GTK.gtk_notebook_get_current_page(this.handle);
        if (oldIndex == index) {
            return;
        }
        if (oldIndex != -1) {
            TabItem item = this.items[oldIndex];
            Control control = item.control;
            if (control != null && !control.isDisposed()) {
                control.setVisible(false);
            }
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 49L);
        GTK.gtk_notebook_set_current_page(this.handle, index);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 49L);
        int newIndex = GTK.gtk_notebook_get_current_page(this.handle);
        if (newIndex != -1) {
            TabItem item = this.items[newIndex];
            Control control = item.control;
            if (control != null && !control.isDisposed()) {
                control.setBoundsInPixels(this.getClientAreaInPixels());
                control.setVisible(true);
            }
            if (notify) {
                Event event = new Event();
                event.item = item;
                this.sendSelectionEvent(13, event, true);
            }
        }
    }

    public void setSelection(TabItem item) {
        if (item == null) {
            this.error(4);
        }
        this.setSelection(new TabItem[]{item});
    }

    public void setSelection(TabItem[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        if (items.length == 0) {
            this.setSelection(-1, false);
        } else {
            int i = items.length - 1;
            while (i >= 0) {
                int index = this.indexOf(items[i]);
                if (index != -1) {
                    this.setSelection(index, false);
                }
                --i;
            }
        }
    }

    @Override
    boolean traversePage(boolean next) {
        if (next) {
            GTK.gtk_notebook_next_page(this.handle);
        } else {
            GTK.gtk_notebook_prev_page(this.handle);
        }
        return true;
    }
}

