/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.internal.runtime.PlatformURLPluginConnection;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.internal.workbench.CommandLineOptionModelProcessor;
import org.eclipse.e4.ui.internal.workbench.E4XMIResourceFactory;
import org.eclipse.e4.ui.internal.workbench.ModelAssembler;
import org.eclipse.e4.ui.internal.workbench.URIHelper;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsPackageImpl;
import org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicPackageImpl;
import org.eclipse.e4.ui.model.application.impl.ApplicationPackageImpl;
import org.eclipse.e4.ui.model.application.ui.advanced.impl.AdvancedPackageImpl;
import org.eclipse.e4.ui.model.application.ui.impl.UiPackageImpl;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuPackageImpl;
import org.eclipse.e4.ui.workbench.IModelResourceHandler;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;

public class ResourceHandler
implements IModelResourceHandler {
    private ResourceSet resourceSet;
    private Resource resource;
    @Inject
    private Logger logger;
    @Inject
    private IEclipseContext context;
    @Inject
    @Named(value="initialWorkbenchModelURI")
    private URI applicationDefinitionInstance;
    @Inject
    @Optional
    @Named(value="instanceLocation")
    private Location instanceLocation;
    @Inject
    @Optional
    @Named(value="persistState")
    private boolean saveAndRestore;
    @Inject
    @Optional
    @Named(value="clearPersistedState")
    private boolean clearPersistedState;

    @Inject
    public ResourceHandler(@Named(value="persistState") boolean saveAndRestore, @Named(value="clearPersistedState") boolean clearPersistedState) {
        this.saveAndRestore = saveAndRestore;
        this.clearPersistedState = clearPersistedState;
    }

    @PostConstruct
    void init() {
        this.resourceSet = new ResourceSetImpl();
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new E4XMIResourceFactory());
        this.resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/ui/2010/UIModel/application", (Object)ApplicationPackageImpl.eINSTANCE);
        this.resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/ui/2010/UIModel/application/commands", (Object)CommandsPackageImpl.eINSTANCE);
        this.resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/ui/2010/UIModel/application/ui", (Object)UiPackageImpl.eINSTANCE);
        this.resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/ui/2010/UIModel/application/ui/menu", (Object)MenuPackageImpl.eINSTANCE);
        this.resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/ui/2010/UIModel/application/ui/basic", (Object)org.eclipse.e4.ui.model.application.ui.basic.impl.BasicPackageImpl.eINSTANCE);
        this.resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/ui/2010/UIModel/application/ui/advanced", (Object)AdvancedPackageImpl.eINSTANCE);
        this.resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/ui/2010/UIModel/application/descriptor/basic", (Object)BasicPackageImpl.eINSTANCE);
    }

    public boolean hasTopLevelWindows() {
        return this.hasTopLevelWindows(this.resource);
    }

    private boolean hasTopLevelWindows(Resource applicationResource) {
        if (applicationResource == null || applicationResource.getContents() == null) {
            return false;
        }
        MApplication application = (MApplication)applicationResource.getContents().get(0);
        return !application.getChildren().isEmpty();
    }

    @Override
    public Resource loadMostRecentModel() {
        boolean initialModel;
        File workbenchData = null;
        URI restoreLocation = null;
        if (this.saveAndRestore) {
            workbenchData = this.getWorkbenchSaveLocation();
            restoreLocation = URI.createFileURI((String)workbenchData.getAbsolutePath());
        }
        if (this.clearPersistedState && workbenchData != null && workbenchData.exists()) {
            workbenchData.delete();
        }
        long restoreLastModified = restoreLocation == null ? 0L : new File(restoreLocation.toFileString()).lastModified();
        boolean restore = restoreLastModified > 0L;
        this.resource = null;
        if (restore && this.saveAndRestore) {
            this.resource = this.loadResource(restoreLocation);
            if (!this.hasTopLevelWindows(this.resource)) {
                if (this.logger != null) {
                    this.logger.error((Throwable)new Exception(), "The persisted application model has no top-level window. Reinitializing with the default application model.");
                }
                this.resource = null;
            }
        }
        if (this.resource == null) {
            Resource applicationResource = this.loadResource(this.applicationDefinitionInstance);
            MApplication theApp = (MApplication)applicationResource.getContents().get(0);
            this.resource = this.createResourceWithApp(theApp);
            this.context.set("NO_SAVED_MODEL_FOUND", (Object)Boolean.TRUE);
            initialModel = true;
        } else {
            initialModel = false;
        }
        MApplication appElement = (MApplication)this.resource.getContents().get(0);
        this.context.set(MApplication.class, (Object)appElement);
        ModelAssembler mac = (ModelAssembler)this.context.get(ModelAssembler.class);
        if (mac != null) {
            ContextInjectionFactory.invoke((Object)mac, PostConstruct.class, (IEclipseContext)this.context);
            mac.processModel(initialModel);
        }
        if (!this.hasTopLevelWindows(this.resource) && this.logger != null) {
            this.logger.error((Throwable)new Exception(), "Loading the application model results in no top-level window.Continuing execution, but the missing window may cause other initialization failures.");
        }
        CommandLineOptionModelProcessor processor = (CommandLineOptionModelProcessor)ContextInjectionFactory.make(CommandLineOptionModelProcessor.class, (IEclipseContext)this.context);
        processor.process();
        return this.resource;
    }

    @Override
    public void save() throws IOException {
        if (this.saveAndRestore) {
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("E4_FILTER_PERSISTED_STATE", Boolean.TRUE);
            this.resource.save(options);
        }
    }

    @Override
    public Resource createResourceWithApp(MApplication theApp) {
        Resource res = this.createResource();
        res.getContents().add((Object)((EObject)theApp));
        return res;
    }

    private Resource createResource() {
        if (this.saveAndRestore) {
            URI saveLocation = URI.createFileURI((String)this.getWorkbenchSaveLocation().getAbsolutePath());
            return this.resourceSet.createResource(saveLocation);
        }
        return this.resourceSet.createResource(URI.createURI((String)"workbench.xmi"));
    }

    private File getWorkbenchSaveLocation() {
        return new File(this.getBaseLocation(), "workbench.xmi");
    }

    private File getBaseLocation() {
        File baseLocation;
        try {
            baseLocation = new File(URIUtil.toURI((URL)this.instanceLocation.getURL()));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        baseLocation = new File(baseLocation, ".metadata");
        baseLocation = new File(baseLocation, ".plugins");
        return new File(baseLocation, "org.eclipse.e4.workbench");
    }

    private Resource loadResource(URI uri) {
        Resource resource;
        try {
            resource = this.getResource(uri);
        }
        catch (Exception e) {
            this.logger.error((Throwable)e, "Unable to load resource " + String.valueOf(uri));
            return null;
        }
        String contributorURI = URIHelper.EMFtoPlatform(uri);
        if (contributorURI != null) {
            TreeIterator it = EcoreUtil.getAllContents((Collection)resource.getContents());
            while (it.hasNext()) {
                EObject o = (EObject)it.next();
                if (!(o instanceof MApplicationElement)) continue;
                ((MApplicationElement)o).setContributorURI(contributorURI);
            }
        }
        return resource;
    }

    private Resource getResource(URI uri) throws Exception {
        Resource resource;
        if (this.saveAndRestore) {
            resource = this.resourceSet.getResource(uri, true);
        } else {
            resource = this.resourceSet.createResource(uri);
            resource.load(new URL(uri.toString()).openStream(), this.resourceSet.getLoadOptions());
        }
        return resource;
    }

    protected long getLastApplicationModification() {
        long appLastModified = 0L;
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        Map attributes = resourceSetImpl.getURIConverter().getAttributes(this.applicationDefinitionInstance, Collections.singletonMap("requestedAttributes", Collections.singleton("timeStamp")));
        Object timestamp = attributes.get("timeStamp");
        if (timestamp instanceof Long) {
            appLastModified = (Long)timestamp;
        } else if (this.applicationDefinitionInstance.isPlatformPlugin()) {
            try {
                URL url = new URL(this.applicationDefinitionInstance.toString());
                Object[] obj = PlatformURLPluginConnection.parse((String)url.getFile().trim(), (URL)url);
                Bundle b = (Bundle)obj[0];
                URL resolved = b.getEntry((String)obj[1]);
                if (resolved == null) {
                    resolved = b.getResource((String)obj[1]);
                }
                if (resolved != null) {
                    URLConnection openConnection = resolved.openConnection();
                    appLastModified = openConnection.getLastModified();
                }
            }
            catch (Exception exception) {}
        }
        return appLastModified;
    }
}

