/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.osx;

import java.security.SecureRandom;
import javax.crypto.spec.PBEKeySpec;
import org.eclipse.equinox.internal.security.auth.AuthPlugin;
import org.eclipse.equinox.internal.security.osx.nls.OSXProviderMessages;
import org.eclipse.equinox.internal.security.storage.Base64;
import org.eclipse.equinox.security.storage.provider.IPreferencesContainer;
import org.eclipse.equinox.security.storage.provider.PasswordProvider;

public class OSXProvider
extends PasswordProvider {
    private static final String serviceName = "equinox.secure.storage";
    private String accountName = System.getProperty("user.name");

    static {
        System.loadLibrary("keystoreNative");
    }

    private native String getPassword(String var1, String var2) throws SecurityException;

    private native void setPassword(String var1, String var2, String var3) throws SecurityException;

    public PBEKeySpec getPassword(IPreferencesContainer container, int passwordType) {
        boolean passwordChange;
        if (this.accountName == null) {
            return null;
        }
        boolean newPassword = (passwordType & 1) != 0;
        boolean bl = passwordChange = (passwordType & 2) != 0;
        if (!newPassword && !passwordChange) {
            try {
                return new PBEKeySpec(this.getPassword(serviceName, this.accountName).toCharArray());
            }
            catch (SecurityException e) {
                AuthPlugin.getDefault().logError(OSXProviderMessages.getPasswordError, (Throwable)e);
                return null;
            }
        }
        try {
            byte[] rawPassword = new byte[64];
            SecureRandom random = new SecureRandom();
            random.setSeed(System.currentTimeMillis());
            random.nextBytes(rawPassword);
            String newPasswordString = Base64.encode((byte[])rawPassword);
            if (!newPassword && !passwordChange) {
                try {
                    return new PBEKeySpec(this.getPassword(serviceName, this.accountName).toCharArray());
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            this.setPassword(serviceName, this.accountName, newPasswordString);
            return new PBEKeySpec(newPasswordString.toCharArray());
        }
        catch (SecurityException e) {
            AuthPlugin.getDefault().logError(OSXProviderMessages.setPasswordError, (Throwable)e);
            return null;
        }
    }
}

