/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.storage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.equinox.internal.security.auth.AuthPlugin;
import org.eclipse.equinox.internal.security.auth.nls.SecAuthMessages;
import org.eclipse.equinox.internal.security.storage.PasswordProviderModuleExt;
import org.eclipse.equinox.internal.security.storage.SecurePreferencesMapper;
import org.eclipse.equinox.internal.security.storage.provider.IValidatingPasswordProvider;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.equinox.security.storage.provider.PasswordProvider;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class PasswordProviderSelector
implements IRegistryEventListener {
    private static final String EXTENSION_POINT = "org.eclipse.equinox.security.secureStorage";
    private static final String STORAGE_MODULE = "provider";
    private static final String MODULE_PRIORITY = "priority";
    private static final String MODULE_DESCRIPTION = "description";
    private static final String OBSOLETES_ID = "obsoletes";
    private static final String CLASS_NAME = "class";
    private static final String HINTS_NAME = "hint";
    private static final String HINT_VALUE = "value";
    private Map<String, PasswordProviderModuleExt> modules = new HashMap<String, PasswordProviderModuleExt>(5);
    private static PasswordProviderSelector instance = null;

    public static PasswordProviderSelector getInstance() {
        if (instance == null) {
            instance = new PasswordProviderSelector();
            IExtensionRegistry registry = RegistryFactory.getRegistry();
            if (registry != null) {
                registry.addListener((IRegistryEventListener)instance, EXTENSION_POINT);
            }
        }
        return instance;
    }

    public static void stop() {
        if (instance != null) {
            IExtensionRegistry registry = RegistryFactory.getRegistry();
            if (registry != null) {
                registry.removeListener((IRegistryEventListener)instance);
            }
            instance = null;
        }
    }

    private PasswordProviderSelector() {
    }

    public List<ExtStorageModule> findAvailableModules(String expectedID) {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint point = registry.getExtensionPoint(EXTENSION_POINT);
        IExtension[] extensions = point.getExtensions();
        ArrayList<ExtStorageModule> allAvailableModules = new ArrayList<ExtStorageModule>(extensions.length);
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            block13: {
                IConfigurationElement element;
                boolean isFound;
                String moduleID;
                IExtension extension;
                block14: {
                    IConfigurationElement[] elements;
                    extension = iExtensionArray[n2];
                    moduleID = extension.getUniqueIdentifier();
                    if (moduleID == null) break block13;
                    moduleID = moduleID.toLowerCase();
                    isFound = true;
                    if (expectedID != null && !expectedID.equals(moduleID)) {
                        isFound = false;
                    }
                    if ((elements = extension.getConfigurationElements()).length == 0) break block13;
                    element = elements[0];
                    if (STORAGE_MODULE.equals(element.getName())) break block14;
                    if (isFound) {
                        this.reportError(SecAuthMessages.unexpectedConfigElement, element.getName(), element, null);
                    }
                    break block13;
                }
                String obsoletes = element.getAttribute(OBSOLETES_ID);
                if (isFound || obsoletes != null && expectedID.equals(obsoletes)) {
                    String attribute = element.getAttribute(MODULE_PRIORITY);
                    int priority = -1;
                    if (attribute != null) {
                        priority = Integer.parseInt(attribute);
                        if (priority < 0) {
                            priority = 0;
                        }
                        if (priority > 10) {
                            priority = 10;
                        }
                    }
                    String name = extension.getLabel();
                    String description = element.getAttribute(MODULE_DESCRIPTION);
                    ArrayList<String> suppliedHints = null;
                    IConfigurationElement[] hints = element.getChildren(HINTS_NAME);
                    if (hints.length != 0) {
                        suppliedHints = new ArrayList<String>(hints.length);
                        IConfigurationElement[] iConfigurationElementArray = hints;
                        int n3 = hints.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IConfigurationElement h = iConfigurationElementArray[n4];
                            String hint = h.getAttribute(HINT_VALUE);
                            if (hint != null) {
                                suppliedHints.add(hint);
                            }
                            ++n4;
                        }
                    }
                    try {
                        Object clazz = element.createExecutableExtension(CLASS_NAME);
                        if (clazz instanceof IValidatingPasswordProvider && !((IValidatingPasswordProvider)clazz).isValid()) {
                        }
                    }
                    catch (CoreException e) {}
                    break block13;
                    allAvailableModules.add(new ExtStorageModule(moduleID, obsoletes, element, priority, name, description, suppliedHints));
                }
            }
            ++n2;
        }
        Collections.sort(allAvailableModules, (o1, o2) -> {
            int p1 = o1.priority;
            int p2 = o2.priority;
            return p2 - p1;
        });
        return allAvailableModules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PasswordProviderModuleExt findStorageModule(String expectedID) throws StorageException {
        if (expectedID != null) {
            expectedID = expectedID.toLowerCase();
        }
        Map<String, PasswordProviderModuleExt> map = this.modules;
        synchronized (map) {
            if (this.modules.containsKey(expectedID)) {
                return this.modules.get(expectedID);
            }
        }
        List<ExtStorageModule> allAvailableModules = this.findAvailableModules(expectedID);
        HashSet<String> disabledModules = this.getDisabledModules();
        for (ExtStorageModule module : allAvailableModules) {
            Object clazz;
            if (expectedID == null && disabledModules != null && disabledModules.contains(module.moduleID)) continue;
            try {
                clazz = module.element.createExecutableExtension(CLASS_NAME);
            }
            catch (CoreException e) {
                this.reportError(SecAuthMessages.instantiationFailed, module.element.getAttribute(CLASS_NAME), module.element, e);
                continue;
            }
            if (!(clazz instanceof PasswordProvider)) continue;
            PasswordProviderModuleExt result = new PasswordProviderModuleExt((PasswordProvider)clazz, module.moduleID, module.obsoleteID);
            Map<String, PasswordProviderModuleExt> map2 = this.modules;
            synchronized (map2) {
                if (expectedID == null) {
                    this.modules.put(null, result);
                }
                this.modules.put(module.moduleID, result);
            }
            return result;
        }
        String msg = expectedID == null ? SecAuthMessages.noSecureStorageModules : NLS.bind((String)SecAuthMessages.noSecureStorageModule, (Object)expectedID);
        throw new StorageException(1, msg);
    }

    private void reportError(String template, String arg, IConfigurationElement element, Throwable e) {
        String supplier = element.getContributor().getName();
        String message = NLS.bind((String)template, (Object)arg, (Object)supplier);
        AuthPlugin.getDefault().logError(message, e);
    }

    public void added(IExtension[] extensions) {
        this.clearCaches();
    }

    public void added(IExtensionPoint[] extensionPoints) {
        this.clearCaches();
    }

    public void removed(IExtension[] extensions) {
        this.clearCaches();
    }

    public void removed(IExtensionPoint[] extensionPoints) {
        this.clearCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCaches() {
        Map<String, PasswordProviderModuleExt> map = this.modules;
        synchronized (map) {
            this.modules.clear();
            SecurePreferencesMapper.clearPasswordCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLoggedIn() {
        Map<String, PasswordProviderModuleExt> map = this.modules;
        synchronized (map) {
            return this.modules.size() != 0;
        }
    }

    protected HashSet<String> getDisabledModules() {
        String[] disabledProviders;
        IScopeContext[] scopes = new IScopeContext[]{ConfigurationScope.INSTANCE, DefaultScope.INSTANCE};
        String defaultPreferenceValue = "";
        IPreferencesService preferencesService = this.getPreferencesService();
        String tmp = preferencesService.getString("org.eclipse.equinox.security", "org.eclipse.equinox.security.preferences.disabledProviders", defaultPreferenceValue, scopes);
        if (tmp == null || tmp.length() == 0) {
            return null;
        }
        HashSet<String> disabledModules = new HashSet<String>();
        String[] stringArray = disabledProviders = tmp.split(",");
        int n = disabledProviders.length;
        int n2 = 0;
        while (n2 < n) {
            String disabledProvider = stringArray[n2];
            disabledModules.add(disabledProvider);
            ++n2;
        }
        return disabledModules;
    }

    private IPreferencesService getPreferencesService() {
        BundleContext context = AuthPlugin.getDefault().getBundleContext();
        ServiceReference reference = context.getServiceReference(IPreferencesService.class);
        if (reference == null) {
            throw new IllegalStateException("Failed to find service: " + String.valueOf(IPreferencesService.class));
        }
        try {
            IPreferencesService iPreferencesService = (IPreferencesService)context.getService(reference);
            return iPreferencesService;
        }
        finally {
            context.ungetService(reference);
        }
    }

    public class ExtStorageModule {
        public String moduleID;
        public String obsoleteID;
        public IConfigurationElement element;
        public int priority;
        public String name;
        public String description;
        public List<String> hints;

        public ExtStorageModule(String id, String obsoleteID, IConfigurationElement element, int priority, String name, String description, List<String> hints) {
            this.element = element;
            this.moduleID = id;
            this.obsoleteID = obsoleteID;
            this.priority = priority;
            this.name = name;
            this.description = description;
            this.hints = hints;
        }
    }
}

