/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import org.eclipse.swt.widgets.Display;

public class ExceptionStash
implements AutoCloseable {
    Throwable storedThrowable;

    public void stash(Throwable throwable) {
        try {
            Display display = Display.getCurrent();
            if (display != null) {
                if (throwable instanceof RuntimeException) {
                    RuntimeException runtimeEx = (RuntimeException)throwable;
                    display.getRuntimeExceptionHandler().accept(runtimeEx);
                    return;
                }
                if (throwable instanceof Error) {
                    Error er = (Error)throwable;
                    display.getErrorHandler().accept(er);
                    return;
                }
            }
        }
        catch (Throwable ex) {
            throwable = ex;
        }
        if (this.storedThrowable != null) {
            this.storedThrowable.addSuppressed(throwable);
        } else {
            this.storedThrowable = throwable;
        }
    }

    @Override
    public void close() {
        if (this.storedThrowable == null) {
            return;
        }
        Throwable throwable = this.storedThrowable;
        this.storedThrowable = null;
        if (throwable instanceof RuntimeException) {
            RuntimeException runtimeEx = (RuntimeException)throwable;
            throw runtimeEx;
        }
        if (throwable instanceof Error) {
            Error er = (Error)throwable;
            throw er;
        }
    }
}

