/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.cairo.cairo_rectangle_int_t;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.OS;

public final class Region
extends Resource {
    public long handle;

    public Region() {
        this(null);
    }

    public Region(Device device) {
        super(device);
        this.handle = Cairo.cairo_region_create();
        if (this.handle == 0L) {
            SWT.error(2);
        }
        this.init();
    }

    Region(Device device, long handle) {
        super(device);
        this.handle = handle;
    }

    static long gdk_region_polygon(int[] pointArray, int npoints, int fill_rule) {
        long cairo;
        int minY;
        int minX;
        int maxX = minX = pointArray[0];
        int maxY = minY = pointArray[1];
        int count = npoints * 2;
        int i = 2;
        while (i < count) {
            int x = pointArray[i];
            int y = pointArray[i + 1];
            if (x < minX) {
                minX = x;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (y > maxY) {
                maxY = y;
            }
            i += 2;
        }
        long surface = Cairo.cairo_image_surface_create(0, maxX - minX, maxY - minY);
        if (surface == 0L) {
            SWT.error(2);
        }
        if ((cairo = Cairo.cairo_create(surface)) == 0L) {
            SWT.error(2);
        }
        Cairo.cairo_move_to(cairo, pointArray[0] - minX, pointArray[1] - minY);
        int i2 = 2;
        while (i2 < count) {
            Cairo.cairo_line_to(cairo, pointArray[i2] - minX, pointArray[i2 + 1] - minY);
            i2 += 2;
        }
        Cairo.cairo_close_path(cairo);
        Cairo.cairo_set_source_rgb(cairo, 1.0, 1.0, 1.0);
        int cairo_rule = 0;
        if (fill_rule == 0) {
            cairo_rule = 1;
        }
        Cairo.cairo_set_fill_rule(cairo, cairo_rule);
        Cairo.cairo_fill(cairo);
        Cairo.cairo_destroy(cairo);
        long polyRgn = GDK.gdk_cairo_region_create_from_surface(surface);
        Cairo.cairo_region_translate(polyRgn, minX, minY);
        Cairo.cairo_surface_destroy(surface);
        return polyRgn;
    }

    static void cairo_region_get_rectangles(long region, long[] rectangles, int[] n_rectangles) {
        int num = Cairo.cairo_region_num_rectangles(region);
        if (n_rectangles != null) {
            n_rectangles[0] = num;
        }
        rectangles[0] = OS.g_malloc(cairo_rectangle_int_t.sizeof * num);
        int n = 0;
        while (n < num) {
            Cairo.cairo_region_get_rectangle(region, n, rectangles[0] + (long)(n * cairo_rectangle_int_t.sizeof));
            ++n;
        }
    }

    public void add(int[] pointArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        this.addInPixels(DPIUtil.autoScaleUp(pointArray));
    }

    void addInPixels(int[] pointArray) {
        if (pointArray.length < 6) {
            return;
        }
        long polyRgn = Region.gdk_region_polygon(pointArray, pointArray.length / 2, 0);
        Cairo.cairo_region_union(this.handle, polyRgn);
        Cairo.cairo_region_destroy(polyRgn);
    }

    public void add(Rectangle rect) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        this.addInPixels(DPIUtil.autoScaleUp(rect));
    }

    void addInPixels(Rectangle rect) {
        this.addInPixels(rect.x, rect.y, rect.width, rect.height);
    }

    public void add(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (width < 0 || height < 0) {
            SWT.error(5);
        }
        this.add(new Rectangle(x, y, width, height));
    }

    void addInPixels(int x, int y, int width, int height) {
        cairo_rectangle_int_t rect = new cairo_rectangle_int_t();
        rect.x = x;
        rect.y = y;
        rect.width = width;
        rect.height = height;
        Cairo.cairo_region_union_rectangle(this.handle, rect);
    }

    public void add(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        Cairo.cairo_region_union(this.handle, region.handle);
    }

    public boolean contains(int x, int y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.contains(new Point(x, y));
    }

    boolean containsInPixels(int x, int y) {
        return Cairo.cairo_region_contains_point(this.handle, x, y);
    }

    public boolean contains(Point pt) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.containsInPixels(DPIUtil.autoScaleUp(pt));
    }

    boolean containsInPixels(Point pt) {
        if (pt == null) {
            SWT.error(4);
        }
        return this.containsInPixels(pt.x, pt.y);
    }

    @Override
    void destroy() {
        Cairo.cairo_region_destroy(this.handle);
        this.handle = 0L;
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return DPIUtil.autoScaleDown(this.getBoundsInPixels());
    }

    Rectangle getBoundsInPixels() {
        cairo_rectangle_int_t rect = new cairo_rectangle_int_t();
        Cairo.cairo_region_get_extents(this.handle, rect);
        return new Rectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public static Region gtk_new(Device device, long handle) {
        return new Region(device, handle);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void intersect(Rectangle rect) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        this.intersectInPixels(DPIUtil.autoScaleUp(rect));
    }

    void intersectInPixels(Rectangle rect) {
        this.intersectInPixels(rect.x, rect.y, rect.width, rect.height);
    }

    public void intersect(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (width < 0 || height < 0) {
            SWT.error(5);
        }
        this.intersect(new Rectangle(x, y, width, height));
    }

    void intersectInPixels(int x, int y, int width, int height) {
        cairo_rectangle_int_t rect = new cairo_rectangle_int_t();
        rect.x = x;
        rect.y = y;
        rect.width = width;
        rect.height = height;
        long rectRgn = Cairo.cairo_region_create_rectangle(rect);
        Cairo.cairo_region_intersect(this.handle, rectRgn);
        Cairo.cairo_region_destroy(rectRgn);
    }

    public void intersect(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        Cairo.cairo_region_intersect(this.handle, region.handle);
    }

    public boolean intersects(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.intersects(new Rectangle(x, y, width, height));
    }

    boolean intersectsInPixels(int x, int y, int width, int height) {
        cairo_rectangle_int_t rect = new cairo_rectangle_int_t();
        rect.x = x;
        rect.y = y;
        rect.width = width;
        rect.height = height;
        return Cairo.cairo_region_contains_rectangle(this.handle, rect) != 1L;
    }

    public boolean intersects(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.intersectsInPixels(DPIUtil.autoScaleUp(rect));
    }

    boolean intersectsInPixels(Rectangle rect) {
        return this.intersectsInPixels(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public boolean isDisposed() {
        return this.handle == 0L;
    }

    public boolean isEmpty() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return Cairo.cairo_region_is_empty(this.handle);
    }

    public void subtract(int[] pointArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        this.subtractInPixels(DPIUtil.autoScaleUp(pointArray));
    }

    void subtractInPixels(int[] pointArray) {
        if (pointArray.length < 6) {
            return;
        }
        long polyRgn = Region.gdk_region_polygon(pointArray, pointArray.length / 2, 0);
        Cairo.cairo_region_subtract(this.handle, polyRgn);
        Cairo.cairo_region_destroy(polyRgn);
    }

    public void subtract(Rectangle rect) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        this.subtractInPixels(DPIUtil.autoScaleUp(rect));
    }

    void subtractInPixels(Rectangle rect) {
        this.subtractInPixels(rect.x, rect.y, rect.width, rect.height);
    }

    public void subtract(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (width < 0 || height < 0) {
            SWT.error(5);
        }
        this.subtract(new Rectangle(x, y, width, height));
    }

    void subtractInPixels(int x, int y, int width, int height) {
        cairo_rectangle_int_t rect = new cairo_rectangle_int_t();
        rect.x = x;
        rect.y = y;
        rect.width = width;
        rect.height = height;
        long rectRgn = Cairo.cairo_region_create_rectangle(rect);
        Cairo.cairo_region_subtract(this.handle, rectRgn);
        Cairo.cairo_region_destroy(rectRgn);
    }

    public void subtract(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        Cairo.cairo_region_subtract(this.handle, region.handle);
    }

    public void translate(int x, int y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.translate(new Point(x, y));
    }

    void translateInPixels(int x, int y) {
        Cairo.cairo_region_translate(this.handle, x, y);
    }

    public void translate(Point pt) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pt == null) {
            SWT.error(4);
        }
        pt = DPIUtil.autoScaleUp(pt);
        this.translateInPixels(pt.x, pt.y);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Region {*DISPOSED*}";
        }
        return "Region {" + this.handle + "}";
    }
}

