/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding;

import java.util.Collections;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.internal.databinding.BindingStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class ListBinding<M, T>
extends Binding {
    private UpdateListStrategy<? super T, ? extends M> targetToModel;
    private UpdateListStrategy<? super M, ? extends T> modelToTarget;
    private IObservableValue<IStatus> validationStatusObservable;
    private IObservableList<T> target;
    private IObservableList<M> model;
    private boolean updatingTarget;
    private boolean updatingModel;
    private IListChangeListener<T> targetChangeListener = event -> {
        if (!this.updatingTarget) {
            this.doUpdate(this.model, event.diff, this.targetToModel, false, false);
        }
    };
    private IListChangeListener<M> modelChangeListener = event -> {
        if (!this.updatingModel) {
            this.doUpdate(this.target, event.diff, this.modelToTarget, false, false);
        }
    };

    public ListBinding(IObservableList<T> target, IObservableList<M> model, UpdateListStrategy<? super T, ? extends M> targetToModelStrategy, UpdateListStrategy<? super M, ? extends T> modelToTargetStrategy) {
        super((IObservable)target, (IObservable)model);
        this.target = target;
        this.model = model;
        this.targetToModel = targetToModelStrategy;
        this.modelToTarget = modelToTargetStrategy;
    }

    @Override
    public IObservableValue<IStatus> getValidationStatus() {
        return this.validationStatusObservable;
    }

    @Override
    protected void preInit() {
        ObservableTracker.setIgnore((boolean)true);
        try {
            this.validationStatusObservable = new WritableValue(this.context.getValidationRealm(), (Object)Status.OK_STATUS, IStatus.class);
        }
        finally {
            ObservableTracker.setIgnore((boolean)false);
        }
    }

    @Override
    protected void postInit() {
        if (this.modelToTarget.getUpdatePolicy() == UpdateListStrategy.POLICY_UPDATE) {
            ListBinding.execAfterDisposalCheck(this.model, () -> {
                this.model.addListChangeListener(this.modelChangeListener);
                this.updateModelToTarget();
            });
        } else {
            this.modelChangeListener = null;
        }
        if (this.targetToModel.getUpdatePolicy() == UpdateListStrategy.POLICY_UPDATE) {
            ListBinding.execAfterDisposalCheck(this.target, () -> {
                this.target.addListChangeListener(this.targetChangeListener);
                if (this.modelToTarget.getUpdatePolicy() == UpdateListStrategy.POLICY_NEVER) {
                    this.updateTargetToModel();
                } else {
                    this.validateTargetToModel();
                }
            });
        } else {
            this.targetChangeListener = null;
        }
    }

    @Override
    public void updateModelToTarget() {
        ListBinding.execAfterDisposalCheck(this.model, () -> {
            ListDiff diff = Diffs.computeListDiff(Collections.emptyList(), this.model);
            this.doUpdate(this.target, diff, this.modelToTarget, true, true);
        });
    }

    @Override
    public void updateTargetToModel() {
        ListBinding.execAfterDisposalCheck(this.target, () -> {
            ListDiff diff = Diffs.computeListDiff(Collections.emptyList(), this.target);
            this.doUpdate(this.model, diff, this.targetToModel, true, true);
        });
    }

    @Override
    public void validateModelToTarget() {
    }

    @Override
    public void validateTargetToModel() {
    }

    private <S, D1, D2 extends D1> void doUpdate(final IObservableList<D1> destination, ListDiff<? extends S> diff, final UpdateListStrategy<? super S, D2> updateListStrategy, boolean explicit, boolean clearDestination) {
        int policy = updateListStrategy.getUpdatePolicy();
        if (policy == UpdateListStrategy.POLICY_NEVER) {
            return;
        }
        if (policy == UpdateListStrategy.POLICY_ON_REQUEST && !explicit) {
            return;
        }
        if (!destination.getRealm().isCurrent()) {
            diff.getDifferences();
        }
        ListBinding.execAfterDisposalCheck(destination, () -> {
            block11: {
                if (destination == this.target) {
                    this.updatingTarget = true;
                } else {
                    this.updatingModel = true;
                }
                final BindingStatus multiStatus = BindingStatus.ok();
                try {
                    try {
                        if (clearDestination) {
                            destination.clear();
                        }
                        diff.accept(new ListDiffVisitor<S>(){
                            boolean useMoveAndReplace;
                            {
                                this.useMoveAndReplace = updateListStrategy2.useMoveAndReplace();
                            }

                            public void handleAdd(int index, S element) {
                                IStatus setterStatus = updateListStrategy.doAdd(destination, updateListStrategy.convert(element), index);
                                ListBinding.this.mergeStatus(multiStatus, setterStatus);
                            }

                            public void handleRemove(int index, S element) {
                                IStatus setterStatus = updateListStrategy.doRemove(destination, index);
                                ListBinding.this.mergeStatus(multiStatus, setterStatus);
                            }

                            public void handleMove(int oldIndex, int newIndex, S element) {
                                if (this.useMoveAndReplace) {
                                    IStatus setterStatus = updateListStrategy.doMove(destination, oldIndex, newIndex);
                                    ListBinding.this.mergeStatus(multiStatus, setterStatus);
                                } else {
                                    super.handleMove(oldIndex, newIndex, element);
                                }
                            }

                            public void handleReplace(int index, S oldElement, S newElement) {
                                if (this.useMoveAndReplace) {
                                    IStatus setterStatus = updateListStrategy.doReplace(destination, index, updateListStrategy.convert(newElement));
                                    ListBinding.this.mergeStatus(multiStatus, setterStatus);
                                } else {
                                    super.handleReplace(index, oldElement, newElement);
                                }
                            }
                        });
                    }
                    catch (Exception ex) {
                        String message = ex.getMessage() != null ? ex.getMessage() : "";
                        multiStatus.add((IStatus)new Status(4, "org.eclipse.core.databinding", 4, message, (Throwable)ex));
                        this.setValidationStatus((IStatus)multiStatus);
                        if (destination == this.target) {
                            this.updatingTarget = false;
                            break block11;
                        }
                        this.updatingModel = false;
                    }
                }
                finally {
                    this.setValidationStatus((IStatus)multiStatus);
                    if (destination == this.target) {
                        this.updatingTarget = false;
                    } else {
                        this.updatingModel = false;
                    }
                }
            }
        });
    }

    private void setValidationStatus(IStatus status) {
        this.validationStatusObservable.getRealm().exec(() -> this.validationStatusObservable.setValue((Object)status));
    }

    void mergeStatus(MultiStatus multiStatus, IStatus newStatus) {
        if (!newStatus.isOK()) {
            multiStatus.add(newStatus);
        }
    }

    @Override
    public void dispose() {
        if (this.targetChangeListener != null) {
            this.target.removeListChangeListener(this.targetChangeListener);
            this.targetChangeListener = null;
        }
        if (this.modelChangeListener != null) {
            this.model.removeListChangeListener(this.modelChangeListener);
            this.modelChangeListener = null;
        }
        super.dispose();
    }
}

