/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.filetransfer.events.socket;

import java.net.Socket;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.filetransfer.events.socket.ISocketEvent;
import org.eclipse.ecf.filetransfer.events.socket.ISocketEventSource;

public abstract class AbstractSocketEvent
implements ISocketEvent {
    private Socket factorySocket;
    private Socket wrappedSocket;
    private ISocketEventSource source;

    protected AbstractSocketEvent(ISocketEventSource source, Socket factorySocket, Socket wrappedSocket) {
        Assert.isNotNull((Object)source);
        Assert.isNotNull((Object)factorySocket);
        Assert.isNotNull((Object)wrappedSocket);
        this.source = source;
        this.factorySocket = factorySocket;
        this.wrappedSocket = wrappedSocket;
    }

    public ISocketEventSource getSource() {
        return this.source;
    }

    public Socket getFactorySocket() {
        return this.factorySocket;
    }

    public boolean isSameFactorySocket(ISocketEvent event) {
        AbstractSocketEvent other = (AbstractSocketEvent)event;
        return this.getFactorySocket() == other.getFactorySocket();
    }

    public Socket getSocket() {
        return this.wrappedSocket;
    }

    protected void setSocket(Socket socket) {
        this.wrappedSocket = socket;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getEventName() + "[");
        sb.append("source=");
        sb.append(this.source);
        sb.append(" socket=");
        sb.append(this.getSocket());
        sb.append(']');
        return sb.toString();
    }

    protected abstract String getEventName();
}

