/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.ui.wizard;

import java.util.ArrayList;
import org.eclipse.equinox.internal.security.ui.Activator;
import org.eclipse.equinox.internal.security.ui.SecurityUIMsg;
import org.eclipse.equinox.internal.security.ui.wizard.CertificateImportWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.service.security.TrustEngine;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class CertificateImportTrustEngineSelectPage
extends WizardPage
implements Listener {
    private Text aliasField;
    private Combo trustEngineCombo;
    private final ArrayList<TrustEngine> trustEngines = new ArrayList();

    protected CertificateImportTrustEngineSelectPage(String pageName) {
        super(pageName);
        this.setTitle(SecurityUIMsg.WIZARD_ENGINE_SELECT_TITLE);
        this.setDescription(SecurityUIMsg.WIZARD_ENGINE_SELECT_MSG);
    }

    public void createControl(Composite parent) {
        Composite certSelectComposite = new Composite(parent, 0);
        this.setControl((Control)certSelectComposite);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        certSelectComposite.setLayout((Layout)layout);
        certSelectComposite.setLayoutData((Object)new GridData(768));
        Label aliasLabel = new Label(certSelectComposite, 0);
        aliasLabel.setText(SecurityUIMsg.WIZARD_ALIAS_NAME_FIELD);
        this.aliasField = new Text(certSelectComposite, 0);
        this.aliasField.setLayoutData((Object)new GridData(512));
        Label targetEngineLabel = new Label(certSelectComposite, 0);
        targetEngineLabel.setText(SecurityUIMsg.WIZARD_TARGET_TRUST_ENGINE);
        this.trustEngineCombo = new Combo(certSelectComposite, 12);
        TrustEngine[] availableEngines = Activator.getTrustEngines();
        this.trustEngines.clear();
        TrustEngine[] trustEngineArray = availableEngines;
        int n = availableEngines.length;
        int n2 = 0;
        while (n2 < n) {
            TrustEngine availableEngine = trustEngineArray[n2];
            if (!availableEngine.isReadOnly()) {
                this.trustEngines.add(availableEngine);
                this.trustEngineCombo.add(availableEngine.getName());
            }
            ++n2;
        }
        if (this.trustEngineCombo.getItemCount() == 0) {
            this.setErrorMessage(SecurityUIMsg.WIZARD_ERROR_NO_WRITE_ENGINE);
        } else {
            this.trustEngineCombo.setVisibleItemCount(this.trustEngines.size());
        }
        this.addListeners();
    }

    private void addListeners() {
        this.aliasField.addListener(2, (Listener)this);
        this.trustEngineCombo.addListener(13, (Listener)this);
    }

    public void handleEvent(Event e) {
        if (e.widget == this.aliasField) {
            if (this.aliasField.getText().length() < 1) {
                this.setErrorMessage(SecurityUIMsg.WIZARD_ERROR_ALIAS_REQUIRED);
            } else {
                this.setErrorMessage(null);
                ((CertificateImportWizard)this.getWizard()).aliasName = this.aliasField.getText();
            }
        }
        if (e.widget == this.trustEngineCombo) {
            if (this.trustEngineCombo.getSelectionIndex() == -1) {
                this.setErrorMessage(SecurityUIMsg.WIZARD_ERROR_ENGINE_REQUIRED);
            } else {
                this.setErrorMessage(null);
                ((CertificateImportWizard)this.getWizard()).selectTrustEngine = this.trustEngines.get(this.trustEngineCombo.getSelectionIndex());
            }
        }
        this.getWizard().getContainer().updateButtons();
    }

    public boolean canFlipToNextPage() {
        return this.aliasField.getText().length() > 0 && this.trustEngineCombo.getSelectionIndex() != -1;
    }
}

