/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.HashMap;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.ide.undo.UpdateMarkersOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.Util;

public class MarkersPropertyPage
extends PropertyPage {
    private Text descriptionText;
    private IMarker marker;
    Combo priorityCombo;
    Button completedCheckbox;

    protected Control createContents(Composite parent) {
        IMarker element = (IMarker)Adapters.adapt((Object)this.getElement(), IMarker.class);
        IWorkspaceRoot resource = null;
        if (element != null) {
            this.marker = element;
            resource = this.marker.getResource();
        } else if (resource == null) {
            resource = ResourcesPlugin.getWorkspace().getRoot();
        }
        if (!Util.isEditable(this.marker)) {
            this.noDefaultAndApplyButton();
        }
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        this.initializeDialogUnits((Control)composite);
        this.createDescriptionArea(composite);
        if (element != null) {
            this.createSeperator(composite);
            this.createCreationTimeArea(composite);
        }
        this.createAttributesArea(composite);
        if (resource != null) {
            this.createSeperator(composite);
            this.createResourceArea(composite);
        }
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void createSeperator(Composite parent) {
        Label seperator = new Label(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        seperator.setLayoutData((Object)gridData);
    }

    private void createCreationTimeArea(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(MarkerMessages.propertiesDialog_creationTime_text);
        Text creationTime = new Text(parent, 12);
        creationTime.setText(Util.getCreationTime(this.marker));
    }

    private void createDescriptionArea(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(MarkerMessages.propertiesDialog_description_text);
        GridData labelGridData = new GridData(16384, 128, false, false);
        label.setLayoutData((Object)labelGridData);
        this.descriptionText = new Text(parent, 2626);
        labelGridData.verticalIndent = -this.descriptionText.computeTrim((int)0, (int)0, (int)0, (int)0).y;
        GridData gridData = new GridData(768);
        gridData.widthHint = this.convertHorizontalDLUsToPixels(250);
        gridData.heightHint = this.convertHeightInCharsToPixels(3);
        this.descriptionText.setLayoutData((Object)gridData);
        this.descriptionText.setText(Util.getProperty("message", this.marker));
        this.descriptionText.selectAll();
        this.descriptionText.setEditable(Util.isEditable(this.marker));
    }

    protected void createAttributesArea(Composite parent) {
        try {
            if (this.marker.isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
                this.createProblemAttributes(parent);
            }
            if (this.marker.isSubtypeOf("org.eclipse.core.resources.taskmarker")) {
                this.createTaskAttributes(parent);
            }
        }
        catch (CoreException e) {
            Policy.handle(e);
        }
    }

    private void createTaskAttributes(Composite parent) {
        this.createSeperator(parent);
        Label label = new Label(parent, 0);
        label.setText(MarkerMessages.propertiesDialog_priority);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.priorityCombo = new Combo(composite, 8);
        this.priorityCombo.setItems(new String[]{MarkerMessages.propertiesDialog_priorityLow, MarkerMessages.propertiesDialog_priorityNormal, MarkerMessages.propertiesDialog_priorityHigh});
        this.priorityCombo.select(this.marker.getAttribute("priority", 1));
        this.priorityCombo.setEnabled(Util.isEditable(this.marker));
        this.completedCheckbox = new Button(composite, 32);
        this.completedCheckbox.setText(MarkerMessages.propertiesDialog_completed);
        GridData gridData = new GridData();
        gridData.horizontalIndent = this.convertHorizontalDLUsToPixels(20);
        this.completedCheckbox.setLayoutData((Object)gridData);
        this.completedCheckbox.setEnabled(Util.isEditable(this.marker));
        try {
            Object done = this.marker.getAttribute("done");
            this.completedCheckbox.setSelection(done != null && done instanceof Boolean && (Boolean)done != false);
        }
        catch (CoreException e) {
            Policy.handle(e);
        }
    }

    private void createProblemAttributes(Composite parent) {
        this.createSeperator(parent);
        new Label(parent, 0).setText(MarkerMessages.propertiesDialog_severityLabel);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        Label severityImage = new Label(composite, 0);
        severityImage.setImage(Util.getImage(this.marker.getAttribute("severity", -1)));
        Text severityLabel = new Text(composite, 12);
        int severity = this.marker.getAttribute("severity", -1);
        if (severity == 2) {
            severityLabel.setText(MarkerMessages.propertiesDialog_errorLabel);
        } else if (severity == 1) {
            severityLabel.setText(MarkerMessages.propertiesDialog_warningLabel);
        } else if (severity == 0) {
            severityLabel.setText(MarkerMessages.propertiesDialog_infoLabel);
        } else {
            severityLabel.setText(MarkerMessages.propertiesDialog_noseverityLabel);
        }
    }

    private void createResourceArea(Composite parent) {
        Label resourceLabel = new Label(parent, 0);
        resourceLabel.setText(MarkerMessages.propertiesDialog_resource_text);
        Text resourceText = new Text(parent, 2124);
        GridData gridData = new GridData(768);
        resourceText.setLayoutData((Object)gridData);
        resourceText.setText(Util.getResourceName(this.marker));
        Label folderLabel = new Label(parent, 0);
        folderLabel.setText(MarkerMessages.propertiesDialog_folder_text);
        Text folderText = new Text(parent, 2124);
        gridData = new GridData(768);
        folderText.setLayoutData((Object)gridData);
        folderText.setText(Util.getContainerName(this.marker));
        Label locationLabel = new Label(parent, 0);
        locationLabel.setText(MarkerMessages.propertiesDialog_location_text);
        Text locationText = new Text(parent, 2124);
        gridData = new GridData(768);
        locationText.setLayoutData((Object)gridData);
        String line = Util.getProperty("lineNumber", this.marker);
        if (line.length() == 0) {
            String location = Util.getProperty("location", this.marker);
            if (location.length() == 0) {
                locationText.setText("");
            } else {
                locationText.setText(location);
            }
        } else {
            locationText.setText(NLS.bind((String)MarkerMessages.label_lineNumber, (Object)line));
        }
    }

    public boolean performOk() {
        if (this.marker == null || Util.isEditable(this.marker)) {
            this.saveChanges();
        }
        return super.performOk();
    }

    private void saveChanges() {
        HashMap<String, String> attrs;
        try {
            attrs = this.marker.getAttributes();
        }
        catch (CoreException e) {
            attrs = new HashMap<String, String>();
            Policy.handle(e);
        }
        attrs.put("message", this.descriptionText.getText());
        if (this.priorityCombo != null) {
            int priority = 1;
            int index = this.priorityCombo.getSelectionIndex();
            if (index == this.priorityCombo.indexOf(MarkerMessages.propertiesDialog_priorityHigh)) {
                priority = 2;
            } else if (index == this.priorityCombo.indexOf(MarkerMessages.propertiesDialog_priorityLow)) {
                priority = 0;
            }
            attrs.put("priority", (String)((Object)Integer.valueOf(priority)));
        }
        if (this.completedCheckbox != null) {
            attrs.put("done", (String)((Object)(this.completedCheckbox.getSelection() ? Boolean.TRUE : Boolean.FALSE)));
        }
        UpdateMarkersOperation op = new UpdateMarkersOperation(this.marker, attrs, NLS.bind((String)MarkerMessages.qualifiedMarkerCommand_title, (Object[])new Object[]{MarkerMessages.DialogMarkerProperties_Modify, Util.getResourceName(this.marker)}), true);
        try {
            PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)op, (IProgressMonitor)new NullProgressMonitor(), WorkspaceUndoUtil.getUIInfoAdapter(this.getShell()));
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CoreException) {
                StatusManager.getManager().handle(((CoreException)e.getCause()).getStatus(), 2);
            }
            StatusManager.getManager().handle(StatusUtil.newStatus(4, e.getLocalizedMessage(), (Throwable)e));
        }
    }
}

