/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.segmenter;

import com.ibm.icu.segmenter.Segmenter;
import com.ibm.icu.segmenter.Segments;
import com.ibm.icu.segmenter.SegmentsImpl;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.util.ULocale;
import java.util.Locale;

public class LocalizedSegmenter
implements Segmenter {
    private BreakIterator breakIterPrototype;

    @Override
    public Segments segment(CharSequence s) {
        return new SegmentsImpl(this.breakIterPrototype, s);
    }

    public static Builder builder() {
        return new Builder();
    }

    private LocalizedSegmenter(ULocale locale, SegmentationType segmentationType) {
        switch (segmentationType) {
            case LINE: {
                this.breakIterPrototype = BreakIterator.getLineInstance(locale);
                break;
            }
            case SENTENCE: {
                this.breakIterPrototype = BreakIterator.getSentenceInstance(locale);
                break;
            }
            case WORD: {
                this.breakIterPrototype = BreakIterator.getWordInstance(locale);
                break;
            }
            case GRAPHEME_CLUSTER: {
                this.breakIterPrototype = BreakIterator.getCharacterInstance(locale);
            }
        }
    }

    public static class Builder {
        private ULocale locale = ULocale.ROOT;
        private SegmentationType segmentationType = null;

        private Builder() {
        }

        public Builder setLocale(ULocale locale) {
            if (locale == null) {
                throw new IllegalArgumentException("locale cannot be set to null.");
            }
            this.locale = locale;
            return this;
        }

        public Builder setLocale(Locale locale) {
            if (locale == null) {
                throw new IllegalArgumentException("locale cannot be set to null.");
            }
            this.locale = ULocale.forLocale(locale);
            return this;
        }

        public Builder setSegmentationType(SegmentationType segmentationType) {
            if (segmentationType == null) {
                throw new IllegalArgumentException("segmentationType cannot be set to null.");
            }
            this.segmentationType = segmentationType;
            return this;
        }

        public Segmenter build() {
            if (this.segmentationType == null) {
                throw new IllegalArgumentException("segmentationType is null and must be set to a specific value.");
            }
            return new LocalizedSegmenter(this.locale, this.segmentationType);
        }
    }

    public static enum SegmentationType {
        GRAPHEME_CLUSTER,
        WORD,
        LINE,
        SENTENCE;

    }
}

