/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.navigator;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.commands.handlers.CopyElementHandler;
import org.eclipse.mylyn.reviews.r4e.ui.internal.commands.handlers.PasteElementHandler;
import org.eclipse.mylyn.reviews.r4e.ui.internal.filters.AnomaliesMyFilter;
import org.eclipse.mylyn.reviews.r4e.ui.internal.filters.AnomaliesOnlyFilter;
import org.eclipse.mylyn.reviews.r4e.ui.internal.filters.AssignParticipantFilter;
import org.eclipse.mylyn.reviews.r4e.ui.internal.filters.FocusFilter;
import org.eclipse.mylyn.reviews.r4e.ui.internal.filters.HideDeltasFilter;
import org.eclipse.mylyn.reviews.r4e.ui.internal.filters.HideRuleSetsFilter;
import org.eclipse.mylyn.reviews.r4e.ui.internal.filters.ReviewCompletedFilter;
import org.eclipse.mylyn.reviews.r4e.ui.internal.filters.ReviewParticipantFilter;
import org.eclipse.mylyn.reviews.r4e.ui.internal.filters.ReviewedElemsFilter;
import org.eclipse.mylyn.reviews.r4e.ui.internal.filters.ReviewsOnlyFilter;
import org.eclipse.mylyn.reviews.r4e.ui.internal.filters.TreeTableFilter;
import org.eclipse.mylyn.reviews.r4e.ui.internal.filters.UnassignParticipantFilter;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.navigator.ReviewNavigatorView;
import org.eclipse.mylyn.reviews.r4e.ui.internal.sorters.NavigatorElementComparator;
import org.eclipse.mylyn.reviews.r4e.ui.internal.sorters.ReviewTypeComparator;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;

public class ReviewNavigatorActionGroup
extends ActionGroup {
    private ReviewNavigatorView fView = null;
    private final ICommandService fCommandService;
    private final IHandlerService fHandlerService;
    private final ViewerComparator fAlphaReviewSorter;
    private final ViewerComparator fReviewTypeSorter;
    private final FocusFilter fFocusFilter;
    private final AnomaliesMyFilter fCurrentReviewFilter;
    private final ReviewsOnlyFilter fReviewsOnlyFilter;
    private final ReviewParticipantFilter fReviewsMyFilter;
    private final ReviewParticipantFilter fReviewsParticipantFilter;
    private final AssignParticipantFilter fAssignedMyFilter;
    private final AssignParticipantFilter fAssignedParticipantFilter;
    private final UnassignParticipantFilter fUnassignedFilter;
    private final ReviewCompletedFilter fReviewsCompletedFilter;
    private final AnomaliesOnlyFilter fAnomaliesFilter;
    private final ReviewedElemsFilter fReviewedElemsFilter;
    private final HideRuleSetsFilter fHideRuleSetsFilter;
    private final HideDeltasFilter fHideDeltasFilter;
    private final TreeTableFilter fTreeTableFilter;

    public ReviewNavigatorActionGroup(ReviewNavigatorView aView) {
        R4EUIPlugin.Ftracer.traceInfo("Create Action Group for view " + aView.getPartName());
        this.fView = aView;
        this.fCommandService = (ICommandService)this.fView.getSite().getWorkbenchWindow().getService(ICommandService.class);
        this.fHandlerService = (IHandlerService)this.fView.getSite().getWorkbenchWindow().getService(IHandlerService.class);
        this.fView.setEditorLinked((Boolean)this.fCommandService.getCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.LinkEditor").getState("org.eclipse.ui.commands.toggleState").getValue());
        this.fView.setPropertiesLinked((Boolean)this.fCommandService.getCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.LinkProperties").getState("org.eclipse.ui.commands.toggleState").getValue());
        this.fAlphaReviewSorter = new NavigatorElementComparator();
        this.fReviewTypeSorter = new ReviewTypeComparator();
        this.fFocusFilter = new FocusFilter();
        this.fCurrentReviewFilter = new AnomaliesMyFilter();
        this.fReviewsOnlyFilter = new ReviewsOnlyFilter();
        this.fReviewsMyFilter = new ReviewParticipantFilter();
        this.fReviewsParticipantFilter = new ReviewParticipantFilter();
        this.fAssignedMyFilter = new AssignParticipantFilter();
        this.fAssignedParticipantFilter = new AssignParticipantFilter();
        this.fUnassignedFilter = new UnassignParticipantFilter();
        this.fReviewsCompletedFilter = new ReviewCompletedFilter();
        this.fAnomaliesFilter = new AnomaliesOnlyFilter();
        this.fReviewedElemsFilter = new ReviewedElemsFilter();
        this.fHideRuleSetsFilter = new HideRuleSetsFilter();
        this.fHideDeltasFilter = new HideDeltasFilter();
        this.fTreeTableFilter = new TreeTableFilter();
        ReviewParticipantFilter filter = new ReviewParticipantFilter();
        filter.setParticipant(R4EUIModelController.getReviewer());
        this.fHandlerService.activateHandler(ActionFactory.COPY.getCommandId(), (IHandler)new CopyElementHandler());
        this.fHandlerService.activateHandler(ActionFactory.PASTE.getCommandId(), (IHandler)new PasteElementHandler());
    }

    public void resetAllFilterActions() throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        this.runReviewsOnlyFilterCommand(false);
        this.runReviewsMyFilterCommand(false);
        this.runReviewsParticipantFilterCommand("");
        this.runAssignedMyFilterCommand(false);
        this.runAssignedParticipantFilterCommand("");
        this.runUnassignedFilterCommand(false);
        this.runReviewsCompletedFilterCommand(false);
        this.runAnomaliesFilterCommand(false);
        this.runAnomaliesMyFilterCommand(false);
        this.runReviewElemsFilterCommand(false);
        this.runHideRuleSetsFilterCommand(false);
        this.runHideDeltasFilterCommand(false);
    }

    public void dialogOpenNotify() {
        IContributionItem[] items;
        IToolBarManager toolbar = this.fView.getViewSite().getActionBars().getToolBarManager();
        IContributionItem[] iContributionItemArray = items = toolbar.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof ActionContributionItem) {
                if (R4EUIModelController.isJobInProgress()) {
                    ((ActionContributionItem)item).getAction().setEnabled(false);
                } else {
                    ((ActionContributionItem)item).getAction().setEnabled(true);
                }
            }
            ++n2;
        }
    }

    public ViewerComparator getAlphaSorter() {
        return this.fAlphaReviewSorter;
    }

    public ViewerComparator getReviewTypeSorter() {
        return this.fReviewTypeSorter;
    }

    public ReviewCompletedFilter getReviewsCompletedFilter() {
        return this.fReviewsCompletedFilter;
    }

    private void resetReviewsCompletedFilterCommand() {
        this.fView.getTreeViewer().removeFilter((ViewerFilter)this.fReviewsCompletedFilter);
        this.fCommandService.getCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.ReviewsCompleted").getState("org.eclipse.ui.commands.toggleState").setValue((Object)false);
    }

    public void runReviewsCompletedFilterCommand(boolean aApply) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        this.resetReviewsCompletedFilterCommand();
        if (aApply && this.fCommandService.getCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.ReviewsCompleted").getHandler().isEnabled()) {
            this.fHandlerService.executeCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.ReviewsCompleted", null);
        }
    }

    public ReviewsOnlyFilter getReviewsOnlyFilter() {
        return this.fReviewsOnlyFilter;
    }

    private void resetReviewsOnlyFilterCommand() {
        this.fView.getTreeViewer().removeFilter((ViewerFilter)this.fReviewsOnlyFilter);
        this.fCommandService.getCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.ReviewsOnly").getState("org.eclipse.ui.commands.toggleState").setValue((Object)false);
    }

    public void runReviewsOnlyFilterCommand(boolean aApply) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        this.resetReviewsOnlyFilterCommand();
        if (aApply && this.fCommandService.getCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.ReviewsOnly").getHandler().isEnabled()) {
            this.fHandlerService.executeCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.ReviewsOnly", null);
        }
    }

    public AnomaliesMyFilter getCurrentReviewFilter() {
        return this.fCurrentReviewFilter;
    }

    public boolean isAnomaliesMyFilterSet() {
        return (Boolean)this.fCommandService.getCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.AnomaliesMy").getState("org.eclipse.ui.commands.toggleState").getValue();
    }

    private void resetAnomaliesMyFilterCommand() {
        this.fView.getTreeViewer().removeFilter((ViewerFilter)this.fCurrentReviewFilter);
        this.fCommandService.getCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.AnomaliesMy").getState("org.eclipse.ui.commands.toggleState").setValue((Object)false);
    }

    public void runAnomaliesMyFilterCommand(boolean aApply) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        this.resetAnomaliesMyFilterCommand();
        if (aApply && this.fCommandService.getCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.AnomaliesMy").getHandler().isEnabled()) {
            this.fHandlerService.executeCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.AnomaliesMy", null);
        }
    }

    public ReviewParticipantFilter getReviewsMyFilter() {
        return this.fReviewsMyFilter;
    }

    public boolean isMyReviewFilterSet() {
        return (Boolean)this.fCommandService.getCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.ReviewsMy").getState("org.eclipse.ui.commands.toggleState").getValue();
    }

    private void resetReviewsMyFilterCommand() {
        this.fView.getTreeViewer().removeFilter((ViewerFilter)this.fReviewsMyFilter);
        this.fCommandService.getCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.ReviewsMy").getState("org.eclipse.ui.commands.toggleState").setValue((Object)false);
    }

    public void runReviewsMyFilterCommand(boolean aApply) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        this.resetReviewsMyFilterCommand();
        if (aApply && this.fCommandService.getCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.ReviewsMy").getHandler().isEnabled()) {
            this.fHandlerService.executeCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.ReviewsMy", null);
        }
    }

    public String getReviewFilterParticipant() {
        return this.fReviewsParticipantFilter.getParticipant();
    }

    public ReviewParticipantFilter getReviewsParticipantFilter() {
        return this.fReviewsParticipantFilter;
    }

    public boolean isParticipantFilterSet() {
        return (Boolean)this.fCommandService.getCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.ReviewsParticipant").getState("org.eclipse.ui.commands.toggleState").getValue();
    }

    private void resetReviewsParticipantFilterCommand() {
        this.fView.getTreeViewer().removeFilter((ViewerFilter)this.fReviewsParticipantFilter);
        this.fCommandService.getCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.ReviewsParticipant").getState("org.eclipse.ui.commands.toggleState").setValue((Object)false);
    }

    public void runReviewsParticipantFilterCommand(String aParticipant) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        this.resetReviewsParticipantFilterCommand();
        if (this.fCommandService.getCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.ReviewsParticipant").getHandler().isEnabled()) {
            if (aParticipant == null || aParticipant.equals("")) {
                this.fReviewsParticipantFilter.setParticipant("");
                return;
            }
            this.fReviewsParticipantFilter.setParticipant(aParticipant);
            this.fHandlerService.executeCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.ReviewsParticipant", null);
        }
    }

    public AssignParticipantFilter getAssignedMyFilter() {
        return this.fAssignedMyFilter;
    }

    public boolean isAssignedMyFilterSet() {
        return (Boolean)this.fCommandService.getCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.AssignMy").getState("org.eclipse.ui.commands.toggleState").getValue();
    }

    private void resetAssignedMyFilterCommand() {
        this.fView.getTreeViewer().removeFilter((ViewerFilter)this.fAssignedMyFilter);
        this.fCommandService.getCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.AssignMy").getState("org.eclipse.ui.commands.toggleState").setValue((Object)false);
    }

    public void runAssignedMyFilterCommand(boolean aApply) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        this.resetAssignedMyFilterCommand();
        if (aApply && this.fCommandService.getCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.AssignMy").getHandler().isEnabled()) {
            this.fHandlerService.executeCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.AssignMy", null);
        }
    }

    public String getAssignedFilterParticipant() {
        return this.fAssignedParticipantFilter.getParticipant();
    }

    public AssignParticipantFilter getAssignedParticipantFilter() {
        return this.fAssignedParticipantFilter;
    }

    public boolean isAssignedParticipantFilterSet() {
        return (Boolean)this.fCommandService.getCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.AssignParticipants").getState("org.eclipse.ui.commands.toggleState").getValue();
    }

    private void resetAssignedParticipantFilterCommand() {
        this.fView.getTreeViewer().removeFilter((ViewerFilter)this.fAssignedParticipantFilter);
        this.fCommandService.getCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.AssignParticipants").getState("org.eclipse.ui.commands.toggleState").setValue((Object)false);
    }

    public void runAssignedParticipantFilterCommand(String aParticipant) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        this.resetAssignedParticipantFilterCommand();
        if (this.fCommandService.getCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.AssignParticipants").getHandler().isEnabled()) {
            if (aParticipant == null || aParticipant.equals("")) {
                this.fAssignedParticipantFilter.setParticipant("");
                return;
            }
            this.fAssignedParticipantFilter.setParticipant(aParticipant);
            this.fHandlerService.executeCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.AssignParticipants", null);
        }
    }

    public UnassignParticipantFilter getUnassignedFilter() {
        return this.fUnassignedFilter;
    }

    public boolean isUnassignedFilterSet() {
        return (Boolean)this.fCommandService.getCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.Unassign").getState("org.eclipse.ui.commands.toggleState").getValue();
    }

    private void resetUnassignedFilterCommand() {
        this.fView.getTreeViewer().removeFilter((ViewerFilter)this.fUnassignedFilter);
        this.fCommandService.getCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.Unassign").getState("org.eclipse.ui.commands.toggleState").setValue((Object)false);
    }

    public void runUnassignedFilterCommand(boolean aApply) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        this.resetUnassignedFilterCommand();
        if (aApply && this.fCommandService.getCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.Unassign").getHandler().isEnabled()) {
            this.fHandlerService.executeCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.Unassign", null);
        }
    }

    public AnomaliesOnlyFilter getAnomaliesFilter() {
        return this.fAnomaliesFilter;
    }

    private void resetAnomaliesFilterCommand() {
        this.fView.getTreeViewer().removeFilter((ViewerFilter)this.fAnomaliesFilter);
        this.fCommandService.getCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.Anomalies").getState("org.eclipse.ui.commands.toggleState").setValue((Object)false);
    }

    public void runAnomaliesFilterCommand(boolean aApply) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        this.resetAnomaliesFilterCommand();
        if (aApply && this.fCommandService.getCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.Anomalies").getHandler().isEnabled()) {
            this.fHandlerService.executeCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.Anomalies", null);
        }
    }

    public ReviewedElemsFilter getReviewedElemsFilter() {
        return this.fReviewedElemsFilter;
    }

    private void resetReviewedElemsFilterCommand() {
        this.fView.getTreeViewer().removeFilter((ViewerFilter)this.fReviewedElemsFilter);
        this.fCommandService.getCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.ReviewedElems").getState("org.eclipse.ui.commands.toggleState").setValue((Object)false);
    }

    public void runReviewElemsFilterCommand(boolean aApply) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        this.resetReviewedElemsFilterCommand();
        if (aApply && this.fCommandService.getCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.ReviewedElems").getHandler().isEnabled()) {
            this.fHandlerService.executeCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.ReviewedElems", null);
        }
    }

    public HideRuleSetsFilter getHideRuleSetsFilter() {
        return this.fHideRuleSetsFilter;
    }

    private void resetHideRuleSetsFilterCommand() {
        this.fView.getTreeViewer().removeFilter((ViewerFilter)this.fHideRuleSetsFilter);
        this.fCommandService.getCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.HideRuleSets").getState("org.eclipse.ui.commands.toggleState").setValue((Object)false);
    }

    public void runHideRuleSetsFilterCommand(boolean aApply) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        this.resetHideRuleSetsFilterCommand();
        if (aApply && this.fCommandService.getCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.HideRuleSets").getHandler().isEnabled()) {
            this.fHandlerService.executeCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.HideRuleSets", null);
        }
    }

    public HideDeltasFilter getHideDeltasFilter() {
        return this.fHideDeltasFilter;
    }

    public boolean isHideDeltasFilterSet() {
        return (Boolean)this.fCommandService.getCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.HideDeltas").getState("org.eclipse.ui.commands.toggleState").getValue();
    }

    private void resetHideDeltasFilterCommand() {
        this.fView.getTreeViewer().removeFilter((ViewerFilter)this.fHideDeltasFilter);
        this.fCommandService.getCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.HideDeltas").getState("org.eclipse.ui.commands.toggleState").setValue((Object)false);
    }

    public void runHideDeltasFilterCommand(boolean aApply) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        this.resetHideDeltasFilterCommand();
        if (aApply && this.fCommandService.getCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.HideDeltas").getHandler().isEnabled()) {
            this.fHandlerService.executeCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.HideDeltas", null);
        }
    }

    public FocusFilter getFocusFilter() {
        return this.fFocusFilter;
    }

    private void resetFocusFilterCommand() {
        this.fView.getTreeViewer().removeFilter((ViewerFilter)this.fFocusFilter);
        this.fCommandService.getCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.GoInto").getState("org.eclipse.ui.commands.toggleState").setValue((Object)false);
    }

    public void runFocusFilterCommand(boolean aApply) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        this.resetFocusFilterCommand();
        if (aApply) {
            this.fHandlerService.executeCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.GoInto", null);
        }
    }

    public TreeTableFilter getTreeTableFilter() {
        return this.fTreeTableFilter;
    }

    public void openElementCommand() throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        this.fHandlerService.executeCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.openElement", null);
    }

    public void changeDisplayCommand() throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        this.fHandlerService.executeCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.changeDisplay", null);
    }

    public void closeElementCommand() throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        this.fHandlerService.executeCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.closeElement", null);
    }

    public void addReviewItemCommand() throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        boolean commandActive = this.fCommandService.getCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.NewReviewItem").getHandler().isEnabled();
        IHandlerActivation activationToken = this.fHandlerService.activateHandler("org.eclipse.mylyn.reviews.r4e.ui.commands.NewReviewItem", this.fCommandService.getCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.NewReviewItem").getHandler());
        this.fHandlerService.executeCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.NewReviewItem", null);
        if (!commandActive) {
            this.fHandlerService.deactivateHandler(activationToken);
        }
    }
}

