/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.ldap.internal.preferences;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.mylyn.reviews.ldap.LdapPlugin;
import org.eclipse.mylyn.reviews.ldap.internal.preferences.PreferenceConstants;
import org.eclipse.mylyn.reviews.ldap.internal.util.R4EString;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class R4ELdapPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static IPreferenceStore FStore = LdapPlugin.getDefault().getPreferenceStore();
    private static final String FP_PORT_SEPARATOR = ":";
    private static final int PREFS_CONTAINER_DATA_SPAN = 1;
    private static final int PREFS_CONTAINER_DATA_NUM_COLUMNS = 4;
    private static final int R4E_GROUP_PREFS_SERVER_DATA_SPAN = 2;
    private static final int R4E_GROUP_PREFS_SECURITY_DATA_SPAN = 2;
    private static final int R4E_GROUP_MANDATORY_PREFS_FIELDS_DEF_DATA_NUM_COLUMNS = 4;
    private static final int R4E_GROUP_OPTIONAL_PREFS_FIELDS_DEF_DATA_NUM_COLUMNS = 2;
    private RadioGroupFieldEditor fLdapSelectBtn;
    private StringFieldEditor fHostFieldEditor;
    private StringFieldEditor fPortFieldEditor;
    private StringFieldEditor fBaseFieldEditor;
    private RadioGroupFieldEditor fAuthenficationBtn;
    private StringFieldEditor fUserNamedEditor;
    private StringFieldEditor fPasswordEditor;
    private StringFieldEditor fUserIdEditor;
    private StringFieldEditor fUserNameEditor;
    private StringFieldEditor fEmailEditor;
    private StringFieldEditor fTelephoneEditor;
    private StringFieldEditor fMobileEditor;
    private StringFieldEditor fEcnEditor;
    private StringFieldEditor fCieEditor;
    private StringFieldEditor fDeptEditor;
    private StringFieldEditor fOfficeEditor;
    private StringFieldEditor fRoomEditor;
    private StringFieldEditor fCityEditor;
    private StringFieldEditor fCountryEditor;
    private StringFieldEditor fDomainEditor;
    private StringFieldEditor fTitleEditor;
    private StringFieldEditor fStreetAddrEditor;
    private StringFieldEditor fPostalCodeEditor;

    public R4ELdapPreferencePage() {
        super(1);
        this.setPreferenceStore(FStore);
        this.setDescription("R4E LDAP Preferences");
    }

    protected void createFieldEditors() {
        LdapPlugin.FTracer.traceInfo("Build R4E LDPA Preference page");
        Composite prefsContainer = new Composite(this.getFieldEditorParent(), 0);
        GridData prefsContainerData = new GridData(4, 4, true, false);
        prefsContainerData.horizontalSpan = 1;
        prefsContainer.setLayoutData((Object)prefsContainerData);
        GridLayout prefsLayout = new GridLayout(4, false);
        prefsContainer.setLayout((Layout)prefsLayout);
        this.createServerInformation(prefsContainer);
        this.createSecurityInformation(prefsContainer);
        this.createFieldDefinitionInformation(prefsContainer);
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        this.fLdapSelectBtn.store();
        this.fAuthenficationBtn.store();
        return super.performOk();
    }

    public void performDefaults() {
        if (this.fLdapSelectBtn != null) {
            this.fLdapSelectBtn.setPreferenceStore(this.getPreferenceStore());
            this.fLdapSelectBtn.loadDefault();
        }
        if (this.fAuthenficationBtn != null) {
            this.fAuthenficationBtn.setPreferenceStore(this.getPreferenceStore());
            this.fAuthenficationBtn.loadDefault();
        }
        super.performDefaults();
    }

    private void createServerInformation(Composite aPrefsContainer) {
        Group r4ELdapHoostPrefsGroup = new Group(aPrefsContainer, 1);
        GridData r4eLdapHostPrefsGroupData = new GridData(4, 4, true, false);
        r4eLdapHostPrefsGroupData.horizontalSpan = 2;
        r4ELdapHoostPrefsGroup.setText(" Server Information");
        r4ELdapHoostPrefsGroup.setLayoutData((Object)r4eLdapHostPrefsGroupData);
        r4ELdapHoostPrefsGroup.setLayout((Layout)new GridLayout(2, false));
        Label r4ELdapPrefsSpacer = new Label((Composite)r4ELdapHoostPrefsGroup, 4);
        GridData r4EUserPrefsSpacerData = new GridData(4, 4, true, false);
        r4EUserPrefsSpacerData.horizontalSpan = 2;
        r4ELdapPrefsSpacer.setLayoutData((Object)r4EUserPrefsSpacerData);
        int numberRadio = 2;
        this.fLdapSelectBtn = new RadioGroupFieldEditor("serverType", "Type", numberRadio, PreferenceConstants.FP_SERVER_TYPE_VALUES, (Composite)r4ELdapHoostPrefsGroup, false);
        this.fLdapSelectBtn.setPreferenceStore(this.getPreferenceStore());
        this.fLdapSelectBtn.load();
        this.fHostFieldEditor = new StringFieldEditor("hostIdPreference", "Host: ", StringFieldEditor.UNLIMITED, (Composite)r4ELdapHoostPrefsGroup);
        this.fHostFieldEditor.getTextControl((Composite)r4ELdapHoostPrefsGroup).setToolTipText(R4EString.getFormattedString("defaultDescription", R4EString.getString("fhostTooltip")));
        this.addField((FieldEditor)this.fHostFieldEditor);
        this.fPortFieldEditor = new StringFieldEditor("portIdPreference", "Port:", StringFieldEditor.UNLIMITED, (Composite)r4ELdapHoostPrefsGroup);
        this.fPortFieldEditor.getTextControl((Composite)r4ELdapHoostPrefsGroup).setToolTipText(R4EString.getFormattedString("defaultDescription", R4EString.getString("fPortTooltip")));
        this.addField((FieldEditor)this.fPortFieldEditor);
        this.fBaseFieldEditor = new StringFieldEditor("baseIdPreference", "Base:      DN=", StringFieldEditor.UNLIMITED, (Composite)r4ELdapHoostPrefsGroup);
        this.fBaseFieldEditor.getTextControl((Composite)r4ELdapHoostPrefsGroup).setToolTipText(R4EString.getFormattedString("defaultDescription", R4EString.getString("fBaseTooltip")));
        this.addField((FieldEditor)this.fBaseFieldEditor);
    }

    private void createSecurityInformation(Composite aPrefsContainer) {
        final Group r4ESecurityPrefsGroup = new Group(aPrefsContainer, 1);
        GridData r4EGroupPrefsGroupData = new GridData(4, 4, true, false);
        r4EGroupPrefsGroupData.horizontalSpan = 2;
        r4ESecurityPrefsGroup.setText("Security ");
        r4ESecurityPrefsGroup.setLayoutData((Object)r4EGroupPrefsGroupData);
        r4ESecurityPrefsGroup.setLayout((Layout)new GridLayout(2, false));
        Label r4ESecurityGroupPrefsSpacer = new Label((Composite)r4ESecurityPrefsGroup, 4);
        int numberRadio = 3;
        this.fAuthenficationBtn = new RadioGroupFieldEditor("authentication", "Authentication", numberRadio, PreferenceConstants.FP_AUTHENTICATION_RADIO_VALUES, (Composite)r4ESecurityPrefsGroup, false);
        this.fAuthenficationBtn.setPreferenceStore(this.getPreferenceStore());
        this.fAuthenficationBtn.load();
        Label r4EFieldPrefsSpacer = new Label((Composite)r4ESecurityPrefsGroup, 4);
        GridData r4EFieldPrefsSpacerData = new GridData(4, 4, true, false);
        r4EFieldPrefsSpacerData.horizontalSpan = 2;
        r4EFieldPrefsSpacer.setLayoutData((Object)r4EFieldPrefsSpacerData);
        GridData r4EGroupPrefsSpacerData = new GridData(4, 4, true, false);
        r4EGroupPrefsSpacerData.horizontalSpan = 2;
        r4ESecurityGroupPrefsSpacer.setLayoutData((Object)r4EGroupPrefsSpacerData);
        this.fUserNamedEditor = new StringFieldEditor("userNamePreference", "User Name: ", StringFieldEditor.UNLIMITED, (Composite)r4ESecurityPrefsGroup);
        this.fUserNamedEditor.getTextControl((Composite)r4ESecurityPrefsGroup).setToolTipText(R4EString.getString("fUserNameTooltip"));
        this.addField((FieldEditor)this.fUserNamedEditor);
        this.fPasswordEditor = new StringFieldEditor("passwordIdPreference", "Password: ", StringFieldEditor.UNLIMITED, (Composite)r4ESecurityPrefsGroup);
        this.addField((FieldEditor)this.fPasswordEditor);
        this.fPasswordEditor.getTextControl((Composite)r4ESecurityPrefsGroup).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                R4ELdapPreferencePage.this.fPasswordEditor.getTextControl((Composite)r4ESecurityPrefsGroup).setEchoChar('*');
            }
        });
    }

    private void createFieldDefinitionInformation(Composite aPrefsContainer) {
        Group r4EFieldPrefsGroup = new Group(aPrefsContainer, 1);
        GridData r4EFieldPrefsGroupData = new GridData(4, 4, true, false);
        r4EFieldPrefsGroupData.horizontalSpan = 4;
        r4EFieldPrefsGroup.setText("LDAP field definition ");
        r4EFieldPrefsGroup.setLayoutData((Object)r4EFieldPrefsGroupData);
        r4EFieldPrefsGroup.setLayout((Layout)new GridLayout(4, false));
        Label r4EFieldPrefsSpacer = new Label((Composite)r4EFieldPrefsGroup, 4);
        GridData r4EFieldPrefsSpacerData = new GridData(4, 4, true, false);
        r4EFieldPrefsSpacerData.horizontalSpan = 4;
        r4EFieldPrefsSpacer.setLayoutData((Object)r4EFieldPrefsSpacerData);
        Group r4EFieldMandatoryPrefsGroup = new Group((Composite)r4EFieldPrefsGroup, 1);
        GridData r4EFieldMandatoryPrefsGroupData = new GridData(4, 4, true, false);
        r4EFieldMandatoryPrefsGroupData.horizontalSpan = 4;
        r4EFieldMandatoryPrefsGroup.setText("Mandatory ");
        r4EFieldMandatoryPrefsGroup.setLayoutData((Object)r4EFieldMandatoryPrefsGroupData);
        r4EFieldMandatoryPrefsGroup.setLayout((Layout)new GridLayout(4, false));
        this.fUserIdEditor = new StringFieldEditor("cn", "User Id:", StringFieldEditor.UNLIMITED, (Composite)r4EFieldMandatoryPrefsGroup);
        this.fUserIdEditor.setEmptyStringAllowed(false);
        this.fUserIdEditor.getTextControl((Composite)r4EFieldMandatoryPrefsGroup).setToolTipText(R4EString.getFormattedString("defaultDescription", "cn"));
        this.addField((FieldEditor)this.fUserIdEditor);
        this.fUserNameEditor = new StringFieldEditor("displayName", "Name:", StringFieldEditor.UNLIMITED, (Composite)r4EFieldMandatoryPrefsGroup);
        this.fUserNameEditor.setEmptyStringAllowed(false);
        this.fUserNameEditor.getTextControl((Composite)r4EFieldMandatoryPrefsGroup).setToolTipText(R4EString.getFormattedString("defaultDescription", "displayName"));
        this.addField((FieldEditor)this.fUserNameEditor);
        this.fEmailEditor = new StringFieldEditor("mail", "E-Mail", StringFieldEditor.UNLIMITED, (Composite)r4EFieldMandatoryPrefsGroup);
        this.fEmailEditor.setEmptyStringAllowed(false);
        this.fEmailEditor.getTextControl((Composite)r4EFieldMandatoryPrefsGroup).setToolTipText(R4EString.getFormattedString("defaultDescription", "mail"));
        this.addField((FieldEditor)this.fEmailEditor);
        Label r4EFieldPrefsSpacer2 = new Label((Composite)r4EFieldPrefsGroup, 4);
        GridData r4EFieldPrefsSpacer2Data = new GridData(4, 4, true, false);
        r4EFieldPrefsSpacer2Data.horizontalSpan = 4;
        r4EFieldPrefsSpacer2.setLayoutData((Object)r4EFieldPrefsSpacer2Data);
        Group r4EFieldOptionalPrefsGroup = new Group((Composite)r4EFieldPrefsGroup, 1);
        GridData r4EFieldOptionalPrefsGroupData = new GridData(4, 4, true, false);
        r4EFieldOptionalPrefsGroupData.horizontalSpan = 2;
        r4EFieldOptionalPrefsGroup.setText("Optional ");
        r4EFieldOptionalPrefsGroup.setLayoutData((Object)r4EFieldOptionalPrefsGroupData);
        r4EFieldOptionalPrefsGroup.setLayout((Layout)new GridLayout(2, false));
        this.fTelephoneEditor = new StringFieldEditor("telephoneNumber", "Telephone:", StringFieldEditor.UNLIMITED, (Composite)r4EFieldOptionalPrefsGroup);
        this.fTelephoneEditor.getTextControl((Composite)r4EFieldOptionalPrefsGroup).setToolTipText(R4EString.getFormattedString("defaultDescription", "telephoneNumber"));
        this.addField((FieldEditor)this.fTelephoneEditor);
        this.fMobileEditor = new StringFieldEditor("mobile", "Mobile:", StringFieldEditor.UNLIMITED, (Composite)r4EFieldOptionalPrefsGroup);
        this.fMobileEditor.getTextControl((Composite)r4EFieldOptionalPrefsGroup).setToolTipText(R4EString.getFormattedString("defaultDescription", "mobile"));
        this.addField((FieldEditor)this.fMobileEditor);
        this.fEcnEditor = new StringFieldEditor("otherTelephone", "Other Phone:", StringFieldEditor.UNLIMITED, (Composite)r4EFieldOptionalPrefsGroup);
        this.fEcnEditor.getTextControl((Composite)r4EFieldOptionalPrefsGroup).setToolTipText(R4EString.getFormattedString("defaultDescription", "otherTelephone"));
        this.addField((FieldEditor)this.fEcnEditor);
        this.fCieEditor = new StringFieldEditor("company", "Company", StringFieldEditor.UNLIMITED, (Composite)r4EFieldOptionalPrefsGroup);
        this.fCieEditor.getTextControl((Composite)r4EFieldOptionalPrefsGroup).setToolTipText(R4EString.getFormattedString("defaultDescription", "company"));
        this.addField((FieldEditor)this.fCieEditor);
        this.fDeptEditor = new StringFieldEditor("department", "Department", StringFieldEditor.UNLIMITED, (Composite)r4EFieldOptionalPrefsGroup);
        this.fDeptEditor.getTextControl((Composite)r4EFieldOptionalPrefsGroup).setToolTipText(R4EString.getFormattedString("defaultDescription", "department"));
        this.addField((FieldEditor)this.fDeptEditor);
        this.fDomainEditor = new StringFieldEditor("userPrincipalName", "Domain", StringFieldEditor.UNLIMITED, (Composite)r4EFieldOptionalPrefsGroup);
        this.fDomainEditor.getTextControl((Composite)r4EFieldOptionalPrefsGroup).setToolTipText(R4EString.getFormattedString("defaultDescription", "userPrincipalName"));
        this.addField((FieldEditor)this.fDomainEditor);
        this.fTitleEditor = new StringFieldEditor("title", "Title", StringFieldEditor.UNLIMITED, (Composite)r4EFieldOptionalPrefsGroup);
        this.fTitleEditor.getTextControl((Composite)r4EFieldOptionalPrefsGroup).setToolTipText(R4EString.getFormattedString("defaultDescription", "title"));
        this.addField((FieldEditor)this.fTitleEditor);
        Group r4EFieldOptionalPrefsGroup2 = new Group((Composite)r4EFieldPrefsGroup, 1);
        GridData r4EFieldOptionalPrefsGroupRightData2 = new GridData(4, 4, true, false);
        r4EFieldOptionalPrefsGroupRightData2.horizontalSpan = 2;
        r4EFieldOptionalPrefsGroup2.setText("Optional ");
        r4EFieldOptionalPrefsGroup2.setLayoutData((Object)r4EFieldOptionalPrefsGroupRightData2);
        r4EFieldOptionalPrefsGroup2.setLayout((Layout)new GridLayout(2, false));
        this.fOfficeEditor = new StringFieldEditor("physicalDeliveryOfficeName", "Office", StringFieldEditor.UNLIMITED, (Composite)r4EFieldOptionalPrefsGroup2);
        this.fOfficeEditor.getTextControl((Composite)r4EFieldOptionalPrefsGroup2).setToolTipText(R4EString.getFormattedString("defaultDescription", "physicalDeliveryOfficeName"));
        this.addField((FieldEditor)this.fOfficeEditor);
        this.fRoomEditor = new StringFieldEditor("extensionAttribute2", "Room", StringFieldEditor.UNLIMITED, (Composite)r4EFieldOptionalPrefsGroup2);
        this.fRoomEditor.getTextControl((Composite)r4EFieldOptionalPrefsGroup2).setToolTipText(R4EString.getFormattedString("defaultDescription", "extensionAttribute2"));
        this.addField((FieldEditor)this.fRoomEditor);
        this.fStreetAddrEditor = new StringFieldEditor("streetAddress", "Address", StringFieldEditor.UNLIMITED, (Composite)r4EFieldOptionalPrefsGroup2);
        this.fStreetAddrEditor.getTextControl((Composite)r4EFieldOptionalPrefsGroup2).setToolTipText(R4EString.getFormattedString("defaultDescription", "streetAddress"));
        this.addField((FieldEditor)this.fStreetAddrEditor);
        this.fCityEditor = new StringFieldEditor("l", "City", StringFieldEditor.UNLIMITED, (Composite)r4EFieldOptionalPrefsGroup2);
        this.fCityEditor.getTextControl((Composite)r4EFieldOptionalPrefsGroup2).setToolTipText(R4EString.getFormattedString("defaultDescription", "l"));
        this.addField((FieldEditor)this.fCityEditor);
        this.fCountryEditor = new StringFieldEditor("co", "Country", StringFieldEditor.UNLIMITED, (Composite)r4EFieldOptionalPrefsGroup2);
        this.fCountryEditor.getTextControl((Composite)r4EFieldOptionalPrefsGroup2).setToolTipText(R4EString.getFormattedString("defaultDescription", "co"));
        this.addField((FieldEditor)this.fCountryEditor);
        this.fPostalCodeEditor = new StringFieldEditor("postalCode", "Postal Code", StringFieldEditor.UNLIMITED, (Composite)r4EFieldOptionalPrefsGroup2);
        this.fPostalCodeEditor.getTextControl((Composite)r4EFieldOptionalPrefsGroup2).setToolTipText(R4EString.getFormattedString("defaultDescription", "postalCode"));
        this.addField((FieldEditor)this.fPostalCodeEditor);
    }

    public String getHostId() {
        return FStore.getString("hostIdPreference");
    }

    public String getPortId() {
        return FStore.getString("portIdPreference");
    }

    public String getBaseId() {
        return FStore.getString("baseIdPreference");
    }

    public String getServerType() {
        return FStore.getString("serverType");
    }

    public String getServerInfo() throws IOException {
        String host = this.getHostId();
        String port = this.getPortId();
        StringBuilder sb = new StringBuilder();
        sb.append(this.getServerType());
        sb.append(host);
        sb.append(FP_PORT_SEPARATOR);
        sb.append(port);
        if (host.equals("") || port.equals("")) {
            LdapPlugin.FTracer.traceWarning("Warning Host or port is empty");
            throw new IOException(String.valueOf(R4EString.getString("messageError1")) + R4EString.getString("noHostOrPort"));
        }
        return sb.toString();
    }

    public String getAuthentication() {
        return FStore.getString("authentication");
    }

    public String getUserName() {
        return FStore.getString("userNamePreference");
    }

    public String getPassword() {
        String encodedPwd = "";
        try {
            encodedPwd = this.encodePassword();
        }
        catch (UnsupportedEncodingException aE) {
            LdapPlugin.getDefault().logError(R4EString.getString("messageError2"), aE);
        }
        catch (NoSuchAlgorithmException aE) {
            LdapPlugin.getDefault().logError(R4EString.getString("messageError3"), aE);
        }
        return encodedPwd;
    }

    public String getFieldUserId() {
        return FStore.getString("cn");
    }

    public String getFieldUserName() {
        return FStore.getString("displayName");
    }

    public String getFieldEmail() {
        return FStore.getString("mail");
    }

    public String getFieldTelephone() {
        return FStore.getString("telephoneNumber");
    }

    public String getFieldMobile() {
        return FStore.getString("mobile");
    }

    public String getFieldECN() {
        return FStore.getString("otherTelephone");
    }

    public String getFieldCompany() {
        return FStore.getString("company");
    }

    public String getFieldDepartment() {
        return FStore.getString("department");
    }

    public String getFieldOfficeName() {
        return FStore.getString("physicalDeliveryOfficeName");
    }

    public String getFieldRoom() {
        return FStore.getString("extensionAttribute2");
    }

    public String getFieldCity() {
        return FStore.getString("l");
    }

    public String getFieldCountry() {
        return FStore.getString("co");
    }

    public String getFieldDomain() {
        return FStore.getString("userPrincipalName");
    }

    public String getFieldTitle() {
        return FStore.getString("title");
    }

    public String getFieldStreetAddress() {
        return FStore.getString("streetAddress");
    }

    public String getFieldPostalCode() {
        return FStore.getString("postalCode");
    }

    private String encodePassword() throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String storePwd = FStore.getString("passwordIdPreference");
        return storePwd;
    }

    public void setHostId(String aHost) {
        FStore.setValue("hostIdPreference", aHost);
    }

    public void setPortId(String aPort) {
        FStore.setValue("portIdPreference", aPort);
    }

    public void setBaseId(String aBase) {
        FStore.setValue("baseIdPreference", aBase);
    }

    public void setServerType(String aServerType) {
        FStore.setValue("serverType", aServerType);
    }

    public void setAuthentication(String aAuthentication) {
        FStore.setValue("authentication", aAuthentication);
    }

    public void setUserName(String aUserName) {
        FStore.setValue("userNamePreference", aUserName);
    }

    public void setPassword(String aPasswd) {
        FStore.setValue("passwordIdPreference", aPasswd);
    }

    public void main(String[] args) {
    }
}

