/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.rap.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.pde.ui.launcher.OSGiLauncherTabGroup;
import org.eclipse.rcptt.internal.launching.ext.UpdateVMArgs;
import org.eclipse.rcptt.internal.launching.rap.ui.Activator;
import org.eclipse.rcptt.internal.launching.rap.ui.RapAUTMainTab;

public class RcpttRapTabGroup
extends OSGiLauncherTabGroup {
    private static final String NEW_LINE = "\n";
    private static final String JETTY_LOG_LEVEL = "-Dorg.eclipse.equinox.http.jetty.log.stderr.threshold=info";

    public void createTabs(ILaunchConfigurationDialog dialog, String mode) {
        super.createTabs(dialog, mode);
        ILaunchConfigurationTab[] tabs = RcpttRapTabGroup.insertTab(this.getTabs(), 0, (ILaunchConfigurationTab)new RapAUTMainTab(this));
        tabs = RcpttRapTabGroup.removeTab(tabs, 1);
        this.setTabs(tabs);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        UpdateVMArgs.updateVMArgs((ILaunchConfigurationWorkingCopy)configuration);
        RcpttRapTabGroup.updateRapVmArgument(configuration);
        configuration.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", false);
        configuration.setAttribute("org.eclipse.debug.core.capture_output", false);
    }

    private static ILaunchConfigurationTab[] insertTab(ILaunchConfigurationTab[] tabs, int position, ILaunchConfigurationTab newTab) {
        ILaunchConfigurationTab[] result = new ILaunchConfigurationTab[tabs.length + 1];
        int offset = 0;
        int i = 0;
        while (i < result.length) {
            if (i == position) {
                result[i] = newTab;
                offset = -1;
            } else {
                result[i] = tabs[i + offset];
            }
            ++i;
        }
        return result;
    }

    private static ILaunchConfigurationTab[] removeTab(ILaunchConfigurationTab[] tabs, int position) {
        ILaunchConfigurationTab[] result = new ILaunchConfigurationTab[tabs.length - 1];
        int i = 0;
        while (i < tabs.length) {
            if (i < position) {
                result[i] = tabs[i];
            } else if (i > position) {
                result[i - 1] = tabs[i];
            } else {
                tabs[i].dispose();
            }
            ++i;
        }
        return result;
    }

    private static void updateRapVmArgument(ILaunchConfigurationWorkingCopy config) {
        String vmArguments = "";
        try {
            vmArguments = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "");
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
        vmArguments = RcpttRapTabGroup.appendJettyLogLevel(vmArguments);
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, vmArguments);
    }

    private static String appendJettyLogLevel(String vmArguments) {
        Object result = vmArguments;
        if (((String)result).length() > 0) {
            result = (String)result + NEW_LINE;
        }
        result = (String)result + JETTY_LOG_LEVEL;
        return result;
    }
}

