/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.ui.player;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rcptt.sherlock.core.SherlockTimerRunnable;
import org.eclipse.rcptt.tesla.core.Q7WaitUtils;
import org.eclipse.rcptt.tesla.core.TeslaLimits;
import org.eclipse.rcptt.tesla.core.context.ContextManagement;
import org.eclipse.rcptt.tesla.core.info.Q7WaitInfoRoot;
import org.eclipse.rcptt.tesla.core.protocol.ElementKind;
import org.eclipse.rcptt.tesla.core.protocol.GenericElementKind;
import org.eclipse.rcptt.tesla.core.protocol.UIColor;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;
import org.eclipse.rcptt.tesla.internal.core.TeslaExecutionFailedException;
import org.eclipse.rcptt.tesla.internal.ui.player.BrowserManager;
import org.eclipse.rcptt.tesla.internal.ui.player.ChildrenCollector;
import org.eclipse.rcptt.tesla.internal.ui.player.ISWTUIPlayerExtension;
import org.eclipse.rcptt.tesla.internal.ui.player.ItemUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.JFaceTextSupport;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerSelectionFilter;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerTextUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerWidgetUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerWrapUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTEvents;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTKeyboard;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTKeyboardLayout;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIColor;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.ScreenshotSupport;
import org.eclipse.rcptt.tesla.internal.ui.player.TeslaSWTAccess;
import org.eclipse.rcptt.tesla.internal.ui.player.UIJobCollector;
import org.eclipse.rcptt.tesla.internal.ui.player.WorkbenchUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.specific.GetWindowPlayer;
import org.eclipse.rcptt.tesla.internal.ui.player.viewers.TableViewerItem;
import org.eclipse.rcptt.tesla.internal.ui.player.viewers.Viewers;
import org.eclipse.rcptt.tesla.jface.TeslaCellEditorManager;
import org.eclipse.rcptt.tesla.swt.TeslaSWTMessages;
import org.eclipse.rcptt.tesla.swt.dialogs.SWTDialogManager;
import org.eclipse.rcptt.tesla.swt.events.ITimerExecHelper;
import org.eclipse.rcptt.tesla.swt.events.TeslaEventManager;
import org.eclipse.rcptt.tesla.swt.events.TeslaTimerExecManager;
import org.eclipse.rcptt.tesla.swt.workbench.EclipseWorkbenchProvider;
import org.eclipse.rcptt.tesla.ui.IViewerItem;
import org.eclipse.rcptt.util.ShellUtilsProvider;
import org.eclipse.rcptt.util.swt.Bounds;
import org.eclipse.rcptt.util.swt.Events;
import org.eclipse.rcptt.util.swt.TabCTabUtil;
import org.eclipse.rcptt.util.swt.TableTreeUtil;
import org.eclipse.rcptt.util.swt.Widgets;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CBanner;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.registry.EditorRegistry;

public final class SWTUIPlayer {
    private static final boolean DEBUG_PROCEED = "true".equals(Platform.getDebugOption((String)"org.eclipse.rcptt.tesla.swt/debug/proceed"));
    final Display display;
    private SWTUIElement[] ignoreWindows;
    private Shell[] ignoredShells;
    private final List<File> screenshotsDuringSession = null;
    private final SWTEvents events;
    private volatile Throwable error = null;
    private static SWTKeyboard keyboard = new SWTKeyboard();
    private final Map<ContextManagement.Context, List<Runnable>> runnables = new HashMap<ContextManagement.Context, List<Runnable>>();
    private static Map<Display, SWTUIPlayer> players = new HashMap<Display, SWTUIPlayer>();
    protected static Map<Class<?>, ElementKind> elementKinds = new LinkedHashMap();
    private final ITimerExecHelper timerListener;
    private static List<ISWTUIPlayerExtension> extensions = new ArrayList<ISWTUIPlayerExtension>();
    private ContextManagement.Context context;
    private final UIJobCollector collector;
    private final Map<Widget, Point> widgetToMouseForMenus = new HashMap<Widget, Point>();
    private static Set<WeakReference<Menu>> shownMenus;
    private static final Set<String> stableViews;
    private static final Point LEGACY_CLICK_POINT;
    public final ChildrenCollector children = new ChildrenCollector(this);
    public static final int COMBO_ITEM_NOT_FOUND = -1;
    private static long lastTimersSucess;
    private static long lastTimeSucessStep;
    public static volatile Boolean lastWorkbenchKeyboardPressResult;
    private static NotifyUINullRunnable notifyUINullRunnable;

    static {
        elementKinds.put(Shell.class, ElementKind.Window);
        elementKinds.put(CBanner.class, ElementKind.CBanner);
        elementKinds.put(ToolBar.class, ElementKind.Toolbar);
        elementKinds.put(CoolBar.class, ElementKind.CoolBar);
        elementKinds.put(Button.class, ElementKind.Button);
        elementKinds.put(ToolItem.class, ElementKind.Button);
        elementKinds.put(Label.class, ElementKind.Label);
        elementKinds.put(CLabel.class, ElementKind.Label);
        elementKinds.put(Group.class, ElementKind.Group);
        elementKinds.put(TabFolder.class, ElementKind.TabFolder);
        elementKinds.put(CTabFolder.class, ElementKind.TabFolder);
        elementKinds.put(Text.class, ElementKind.Text);
        elementKinds.put(StyledText.class, ElementKind.Text);
        elementKinds.put(Spinner.class, ElementKind.Text);
        elementKinds.put(Link.class, ElementKind.Link);
        elementKinds.put(Combo.class, ElementKind.Combo);
        elementKinds.put(CCombo.class, ElementKind.Combo);
        elementKinds.put(Tree.class, ElementKind.Tree);
        elementKinds.put(org.eclipse.swt.widgets.List.class, ElementKind.List);
        elementKinds.put(MenuItem.class, ElementKind.Menu);
        elementKinds.put(Menu.class, ElementKind.Menu);
        elementKinds.put(Table.class, ElementKind.Table);
        elementKinds.put(CTabItem.class, ElementKind.TabItem);
        elementKinds.put(TabItem.class, ElementKind.TabItem);
        elementKinds.put(IViewReference.class, ElementKind.View);
        elementKinds.put(IEditorReference.class, ElementKind.Editor);
        elementKinds.put(DateTime.class, ElementKind.DateTime);
        elementKinds.put(Slider.class, ElementKind.Slider);
        elementKinds.put(Link.class, ElementKind.Link);
        elementKinds.put(Shell.class, ElementKind.Window);
        elementKinds.put(TreeItem.class, ElementKind.Item);
        elementKinds.put(TableItem.class, ElementKind.Item);
        elementKinds.put(Canvas.class, ElementKind.Canvas);
        elementKinds.put(Browser.class, ElementKind.Browser);
        elementKinds.put(TreeColumn.class, ElementKind.ColumnHeader);
        elementKinds.put(TableColumn.class, ElementKind.ColumnHeader);
        shownMenus = new HashSet<WeakReference<Menu>>();
        stableViews = new HashSet<String>();
        stableViews.add("org.eclipse.ui.views.PropertySheet");
        stableViews.add("org.eclipse.ui.views.ProblemView");
        LEGACY_CLICK_POINT = new Point(0, 0);
        lastTimersSucess = 0L;
        lastTimeSucessStep = 0L;
    }

    public Throwable getError() {
        return this.error;
    }

    public Shell[] getIgnored() {
        return this.ignoredShells;
    }

    protected SWTUIPlayer(Display display, Shell ... ignoreWindows) {
        this.display = display;
        this.events = new SWTEvents(display);
        if (ignoreWindows != null) {
            this.ignoreWindows = new SWTUIElement[ignoreWindows.length];
            this.ignoredShells = ignoreWindows;
            int i = 0;
            Shell[] shellArray = ignoreWindows;
            int n = ignoreWindows.length;
            int n2 = 0;
            while (n2 < n) {
                Shell shell = shellArray[n2];
                this.ignoreWindows[i++] = this.wrap(shell);
                ++n2;
            }
        }
        this.collector = new UIJobCollector();
        Job.getJobManager().addJobChangeListener((IJobChangeListener)this.collector);
        this.timerListener = this.getTimerExecHelper();
        TeslaTimerExecManager.getManager().addEventListener(this.timerListener);
    }

    private ITimerExecHelper getTimerExecHelper() {
        return new ITimerExecHelper(){

            public boolean needNullify(Runnable run, int time) {
                String clName = null;
                clName = run instanceof SherlockTimerRunnable ? ((SherlockTimerRunnable)run).getRunnable().getClass().getName() : run.getClass().getName();
                if (!(clName.contains("org.eclipse.swt") || clName.contains("org.eclipse.gmf") || clName.contains("org.eclipse.jface") || clName.contains("org.eclipse.gef"))) {
                    if (clName.contains(Display.class.getName())) {
                        return false;
                    }
                    if (clName.startsWith("org.eclipse.nebula.widgets.oscilloscope.OscilloscopeDispatcher")) {
                        return false;
                    }
                    if (clName.startsWith("org.eclipse.tm.internal.terminal.textcanvas.PollingTextCanvasModel")) {
                        return false;
                    }
                    if (time < TeslaLimits.getTimerExecsWaitNullify()) {
                        ContextManagement.Context currentCtx = ContextManagement.makeContext((StackTraceElement[])Thread.currentThread().getStackTrace());
                        return !currentCtx.containsClass(clName);
                    }
                }
                return false;
            }
        };
    }

    private SWTUIPlayer(Display display) {
        this(display, null);
    }

    private static Class<?>[] one(Class<?> cl) {
        return new Class[]{cl};
    }

    public SWTUIElement select(PlayerSelectionFilter filter) {
        SWTUIElement result = null;
        for (ISWTUIPlayerExtension ext : SWTUIPlayer.getExtensions()) {
            result = ext.select(this, filter);
            if (result == null) continue;
            return result;
        }
        switch (filter.kind.kind) {
            case Unknown: {
                result = null;
                break;
            }
            case EclipseWindow: {
                result = this.selectEclipseWindow(filter.index);
                break;
            }
            case QuickAccess: {
                result = this.selectQuickAccess();
                break;
            }
            case Window: {
                result = new GetWindowPlayer(this, this.ignoreWindows).selectShell(filter);
                break;
            }
            case Menu: {
                result = this.selectMenu(filter);
                break;
            }
            case Button: {
                result = this.selectWidget(filter, Button.class, ToolItem.class);
                if (result != null) break;
                result = this.selectButton(filter);
                break;
            }
            case Group: {
                result = this.selectWidget(filter, Group.class);
                break;
            }
            case Text: {
                result = this.selectWidget(filter, Text.class, StyledText.class, Spinner.class);
                break;
            }
            case Combo: {
                result = this.selectWidget(filter, Combo.class, CCombo.class);
                break;
            }
            case Tree: {
                result = this.selectWidget(filter.withoutPattern(), false, Tree.class);
                break;
            }
            case Toolbar: {
                result = this.selectWidget(filter.withoutPattern(), false, ToolBar.class);
                break;
            }
            case CBanner: {
                result = this.selectWidget(filter.withoutPattern(), false, CBanner.class);
                break;
            }
            case CoolBar: {
                result = this.selectWidget(filter.withoutPattern(), false, CoolBar.class);
                break;
            }
            case Canvas: {
                result = this.selectWidget(filter.withoutPattern(), false, Canvas.class);
                break;
            }
            case List: {
                result = this.selectWidget(filter.withoutPattern(), false, org.eclipse.swt.widgets.List.class);
                break;
            }
            case Table: {
                result = this.selectWidget(filter.withoutPattern(), false, Table.class);
                break;
            }
            case Label: {
                result = this.selectWidget(filter, Label.class, CLabel.class);
                break;
            }
            case TabItem: {
                result = this.selectWidget(filter, CTabItem.class, TabItem.class);
                break;
            }
            case TabFolder: {
                result = this.selectWidget(filter, CTabFolder.class, TabFolder.class);
                break;
            }
            case View: {
                result = this.selectView(filter);
                break;
            }
            case Editor: {
                result = this.selectEditor(filter);
                break;
            }
            case Any: {
                result = this.selectWidget(filter.withoutKind(), new Class[0]);
                break;
            }
            case Item: {
                result = this.selectItem(filter);
                break;
            }
            case Browser: {
                result = this.selectWidget(filter.withoutPattern(), Browser.class);
                break;
            }
            case DateTime: {
                result = this.selectWidget(filter.withoutPattern(), DateTime.class);
                break;
            }
            case Slider: {
                result = this.selectWidget(filter.withoutPattern(), Slider.class);
                break;
            }
            case ColumnHeader: {
                result = this.selectColumnHeader(filter);
            }
        }
        if (result == null) {
            this.makeScreenShot();
        }
        return result;
    }

    private SWTUIElement selectColumnHeader(PlayerSelectionFilter f) {
        Widget unwrapped = PlayerWrapUtils.unwrapWidget(f.parent);
        if (!(unwrapped instanceof Tree) && !(unwrapped instanceof Table)) {
            return null;
        }
        return this.wrap(TableTreeUtil.findColumn((Widget)unwrapped, (String)f.pattern, (int)(f.index == null ? 0 : f.index)));
    }

    private SWTUIElement selectButton(PlayerSelectionFilter f) {
        String pattern = f.pattern;
        if (pattern != null && pattern.contains("(") && pattern.endsWith(")")) {
            int pos = pattern.indexOf(40);
            String prefix = pattern.substring(0, pos);
            String accel = pattern.substring(pos + 1, pattern.length() - 1);
            Object[] split = accel.split("\\+");
            Arrays.sort(split);
            if (split.length > 2) {
                SWTUIElement[] children = this.children.collectFor(f.parent, this.ignoreWindows, true, new Class[]{Button.class, ToolItem.class}, f.after);
                int cur = 0;
                SWTUIElement[] sWTUIElementArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    SWTUIElement widget = sWTUIElementArray[n2];
                    String text = PlayerTextUtils.getText(widget);
                    if (text != null && (text = PlayerTextUtils.removeAcceleratorFromText(text)) != null && text.contains("(") && text.endsWith(")")) {
                        int pos2 = text.indexOf(40);
                        String prefix2 = text.substring(0, pos2);
                        String accel2 = text.substring(pos2 + 1, text.length() - 1);
                        Object[] split2 = accel2.split("\\+");
                        Arrays.sort(split2);
                        if (prefix2.equals(prefix) && Arrays.equals(split2, split)) {
                            if (f.index != null && cur == f.index || f.index == null) {
                                return widget;
                            }
                            ++cur;
                        }
                    }
                    ++n2;
                }
            }
        }
        return null;
    }

    private SWTUIElement selectItem(PlayerSelectionFilter f) {
        Widget current;
        TreeItem[] items;
        TreeItem current2;
        Tree tree;
        SWTUIElement parent = f.parent;
        if (parent != null && PlayerWrapUtils.unwrapWidget(parent) instanceof Tree && f.path != null) {
            tree = (Tree)PlayerWrapUtils.unwrapWidget(parent);
            current2 = (TreeItem)Viewers.firstMatch(f.path, tree);
            if (current2 != null) {
                return this.wrap(current2);
            }
        } else if (parent != null && PlayerWrapUtils.unwrapWidget(parent) instanceof Tree && f.indexes != null && f.indexes.length == 2 && (items = SWTUIPlayer.getExpandedTreeItems(tree = (Tree)PlayerWrapUtils.unwrapWidget(parent))).length > f.indexes[1]) {
            return new ItemUIElement((Widget)items[f.indexes[1]], this, f.indexes[0]);
        }
        if (parent != null && PlayerWrapUtils.unwrapWidget(parent) instanceof Table && f.path != null && f.path.length > 0) {
            Table table = (Table)PlayerWrapUtils.unwrapWidget(parent);
            current2 = PlayerWrapUtils.unwrapWidget(parent);
            TableItem[] items2 = ((Table)current2).getItems();
            if (items2 == null) {
                return null;
            }
            IViewerItem[] viewerItems = Viewers.getViewerItems((Item[])items2);
            String[] stringArray = f.path;
            int n = f.path.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                TableItem[] tableItemArray = items2;
                int n3 = items2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String itemText;
                    TableItem item = tableItemArray[n4];
                    if (!item.isDisposed() && (itemText = SWTUIPlayer.toSelectionItem(Viewers.getTableItemText(new TableViewerItem(item), part, viewerItems))) != null && (itemText.equals(part) || PlayerTextUtils.safeMatches(itemText, part))) {
                        return this.wrap(item);
                    }
                    ++n4;
                }
                ++n2;
            }
        } else if (parent != null && PlayerWrapUtils.unwrapWidget(parent) instanceof Table && f.indexes != null && f.indexes.length == 2 && (items = ((Table)(current = PlayerWrapUtils.unwrapWidget(parent))).getItems()).length > f.indexes[1]) {
            return new ItemUIElement((Widget)items[f.indexes[1]], this, f.indexes[0]);
        }
        return null;
    }

    public static TreeItem[] getExpandedTreeItems(Tree tree) {
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        int i = 0;
        while (i < tree.getItemCount()) {
            TreeItem currentItem = tree.getItem(i);
            if (!currentItem.isDisposed()) {
                items.add(currentItem);
                if (currentItem.getExpanded()) {
                    items.addAll(SWTUIPlayer.getExpandedTreeItems(currentItem));
                }
            }
            ++i;
        }
        return items.toArray(new TreeItem[items.size()]);
    }

    private static List<TreeItem> getExpandedTreeItems(TreeItem item) {
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        int i = 0;
        while (i < item.getItemCount()) {
            TreeItem currentItem = item.getItem(i);
            items.add(currentItem);
            if (currentItem.getExpanded()) {
                items.addAll(SWTUIPlayer.getExpandedTreeItems(currentItem));
            }
            ++i;
        }
        return items;
    }

    private SWTUIElement selectQuickAccess() {
        Text quickAccess = EclipseWorkbenchProvider.getProvider().getQuickAccess();
        return quickAccess == null ? null : this.wrap(quickAccess);
    }

    private SWTUIElement selectEclipseWindow(Integer index) {
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        if (index == null) {
            return this.wrap(windows[0].getShell());
        }
        if (index < windows.length) {
            return this.wrap(windows[index].getShell());
        }
        return null;
    }

    public void makeScreenShot() {
    }

    public UIColor getSelectedColor(SWTUIElement uiElement) {
        ColorSelector colorSelector;
        Widget widget = PlayerWrapUtils.unwrapWidget(uiElement);
        if (widget instanceof Button && (colorSelector = TeslaSWTAccess.getColorSelector((Button)widget)) != null) {
            return new UIColor(colorSelector.getColorValue().red, colorSelector.getColorValue().green, colorSelector.getColorValue().blue);
        }
        return null;
    }

    public void setSelectedColor(SWTUIElement uiElement, UIColor color) {
        ColorSelector colorSelector;
        Widget widget = PlayerWrapUtils.unwrapWidget(uiElement);
        if (widget instanceof Button && (colorSelector = TeslaSWTAccess.getColorSelector((Button)widget)) != null) {
            colorSelector.setColorValue(new RGB(color.r, color.g, color.b));
        }
    }

    public SWTUIElement selectWidget(PlayerSelectionFilter filter, Class<?> ... classes) {
        return this.selectWidget(filter, true, classes);
    }

    public SWTUIElement selectWidget(PlayerSelectionFilter f, boolean checkText, Class<?> ... classes) {
        int n;
        int n2;
        SWTUIElement[] sWTUIElementArray;
        SWTUIElement[] children = this.children.collectFor(f.parent, this.ignoreWindows, true, classes, f.after);
        GenericElementKind kind = f.kind;
        if (kind != null) {
            ArrayList<SWTUIElement> filteredByKind = new ArrayList<SWTUIElement>();
            sWTUIElementArray = children;
            n2 = children.length;
            n = 0;
            while (n < n2) {
                SWTUIElement element = sWTUIElementArray[n];
                if (element.isSuitableForKind(kind)) {
                    filteredByKind.add(element);
                }
                ++n;
            }
            children = filteredByKind.toArray(new SWTUIElement[filteredByKind.size()]);
        }
        if (f.pattern == null) {
            int index;
            List<Class<?>> classesList;
            if (f.index == null && children.length > 0 && classes != null && (classesList = Arrays.asList(classes)).contains(Button.class)) {
                sWTUIElementArray = children;
                n2 = children.length;
                n = 0;
                while (n < n2) {
                    SWTUIElement swtuiElement = sWTUIElementArray[n];
                    String text = swtuiElement.getText();
                    if (text != null && text.trim().length() == 0) {
                        return swtuiElement;
                    }
                    ++n;
                }
            }
            int n3 = index = f.index == null ? 0 : f.index;
            if (children.length > index) {
                SWTUIElement child = children[index];
                if (kind != null && !kind.is(child.getKind())) {
                    child.overrideKind(kind);
                }
                return child;
            }
        }
        if (checkText) {
            int cur = 0;
            HashMap<SWTUIElement, String> wtMap = new HashMap<SWTUIElement, String>();
            if (f.pattern != null) {
                String text;
                SWTUIElement[] sWTUIElementArray2 = children;
                int n4 = children.length;
                n2 = 0;
                while (n2 < n4) {
                    SWTUIElement widget = sWTUIElementArray2[n2];
                    text = PlayerTextUtils.getText(widget);
                    if (text != null) {
                        text = PlayerTextUtils.removeAcceleratorFromText(text);
                        wtMap.put(widget, text);
                        if (text != null && text.equals(f.pattern)) {
                            if (f.index != null && cur == f.index || f.index == null) {
                                return widget;
                            }
                            if (kind == null || widget.getKind().is(kind)) {
                                ++cur;
                            }
                        }
                    }
                    ++n2;
                }
                cur = 0;
                sWTUIElementArray2 = children;
                n4 = children.length;
                n2 = 0;
                while (n2 < n4) {
                    SWTUIElement widget = sWTUIElementArray2[n2];
                    text = PlayerTextUtils.getText(widget);
                    if (text != null) {
                        text = PlayerTextUtils.removeAcceleratorFromText(text);
                        wtMap.put(widget, text);
                        if (text != null && PlayerTextUtils.safeMatches(text, f.pattern)) {
                            if (f.index != null && cur == f.index || f.index == null) {
                                return widget;
                            }
                            if (kind == null || widget.getKind().is(kind)) {
                                ++cur;
                            }
                        }
                    }
                    ++n2;
                }
            }
        }
        return null;
    }

    public SWTUIElement selectView(PlayerSelectionFilter f) {
        IViewReference iViewRef;
        String pattern = f.pattern;
        IViewReference[] views = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
        int currIdx = 0;
        IViewReference[] iViewReferenceArray = views;
        int n = views.length;
        int n2 = 0;
        while (n2 < n) {
            iViewRef = iViewReferenceArray[n2];
            try {
                String label = iViewRef.getPartName();
                String id = iViewRef.getId();
                if (label != null && (label.equals(pattern) || PlayerTextUtils.safeMatches(label, pattern)) || id != null && (id.equals(pattern) || PlayerTextUtils.safeMatches(id, pattern))) {
                    if (f.index == null || f.index.equals(currIdx)) {
                        return this.wrap(iViewRef);
                    }
                    ++currIdx;
                }
            }
            catch (Exception e) {
                TeslaCore.log((Throwable)e);
            }
            ++n2;
        }
        TeslaCore.log((String)("Can not find view by pattern \"" + pattern + "\". Activating views..."));
        currIdx = 0;
        iViewReferenceArray = views;
        n = views.length;
        n2 = 0;
        while (n2 < n) {
            iViewRef = iViewReferenceArray[n2];
            if (!stableViews.contains(iViewRef.getId())) {
                String title;
                IWorkbenchPart part = iViewRef.getPart(true);
                String string = title = part != null ? part.getTitle() : null;
                if (title != null && (title.equals(pattern) || PlayerTextUtils.safeMatches(title, pattern))) {
                    if (f.index == null || f.index.equals(currIdx)) {
                        return this.wrap(iViewRef);
                    }
                    ++currIdx;
                }
            }
            ++n2;
        }
        return null;
    }

    private static boolean matches(String value, String pattern) {
        return pattern == null || value != null && (value.equals(pattern) || PlayerTextUtils.safeMatches(value, pattern));
    }

    private static boolean matches(Integer value, Integer pattern) {
        return pattern == null || value != null && value.equals(pattern);
    }

    public SWTUIElement selectEditor(PlayerSelectionFilter f) {
        int n;
        String type;
        String title = f.pattern;
        if (title != null && title.length() == 0) {
            title = null;
        }
        if ((type = f.classPattern) != null && type.length() == 0) {
            type = null;
        }
        IEditorReference[] refs = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        if (f.index != null && f.index < 0) {
            return null;
        }
        if (title != null && type == null && f.index == null) {
            IEditorReference[] iEditorReferenceArray = refs;
            int n2 = refs.length;
            int n3 = 0;
            while (n3 < n2) {
                IEditorReference ref = iEditorReferenceArray[n3];
                if (SWTUIPlayer.matches(ref.getPartName(), title) || SWTUIPlayer.matches(ref.getId(), title)) {
                    return this.wrap(ref);
                }
                ++n3;
            }
            return null;
        }
        String id = null;
        if (type != null) {
            IEditorDescriptor[] iEditorDescriptorArray = ((EditorRegistry)PlatformUI.getWorkbench().getEditorRegistry()).getSortedEditorsFromPlugins();
            n = iEditorDescriptorArray.length;
            int n4 = 0;
            while (n4 < n) {
                IEditorDescriptor desc = iEditorDescriptorArray[n4];
                if (SWTUIPlayer.matches(desc.getLabel(), type)) {
                    id = desc.getId();
                }
                ++n4;
            }
        }
        int counter = 0;
        IEditorReference[] iEditorReferenceArray = refs;
        int n5 = refs.length;
        n = 0;
        while (n < n5) {
            IEditorReference ref = iEditorReferenceArray[n];
            if (SWTUIPlayer.matches(ref.getPartName(), title) && SWTUIPlayer.matches(ref.getId(), id) && SWTUIPlayer.matches(counter++, f.index)) {
                return this.wrap(ref);
            }
            ++n;
        }
        return null;
    }

    public void setTextOffset(final StyledText styledText, final int offset, final int line) {
        this.exec("Set text offset", new Runnable(){

            @Override
            public void run() {
                SWTUIPlayer.this.events.sendFocus((Widget)styledText);
                int actualOffset = offset;
                if (line != -1) {
                    actualOffset += styledText.getOffsetAtLine(line);
                }
                Point clickPoint = styledText.getLocationAtOffset(actualOffset);
                styledText.setCaretOffset(actualOffset);
                styledText.getAccessible().textCaretMoved(offset);
                SWTUIPlayer.this.events.sendEvent((Widget)styledText, 3, clickPoint, 1);
                SWTUIPlayer.this.events.sendEvent((Widget)styledText, 4, clickPoint, 1);
                styledText.setSelectionRange(actualOffset, 0);
            }
        });
    }

    public void click(SWTUIElement w) {
        this.click(w, false, false, false, 0);
    }

    public void click(final SWTUIElement w, final boolean isDefault, final boolean doubleClick, final boolean arrow, final int mask) {
        this.exec("click", new Runnable(){

            @Override
            public void run() {
                for (ISWTUIPlayerExtension ext : SWTUIPlayer.getExtensions()) {
                    if (!ext.canClick(w, isDefault, doubleClick, arrow)) continue;
                    ext.click(w, isDefault, doubleClick, arrow, mask);
                    return;
                }
                if (!PlayerWidgetUtils.canClick(w)) {
                    SWTUIPlayer.this.failClick(w);
                }
                IWorkbenchPage page = SWTUIPlayer.this.getTargetPage();
                switch (w.getKind().kind) {
                    case View: {
                        SWTUIPlayer.this.clickView(w, page);
                        break;
                    }
                    case Editor: {
                        SWTUIPlayer.this.clickEditor(w, page);
                        break;
                    }
                    case TabItem: {
                        SWTUIPlayer.this.clickTabItem(w, isDefault);
                        break;
                    }
                    case Link: {
                        SWTUIPlayer.this.clickLink(w, doubleClick, mask);
                        break;
                    }
                    case Item: {
                        SWTUIPlayer.this.clickTableTreeItem(w, doubleClick);
                        break;
                    }
                    case Label: {
                        SWTUIPlayer.this.clickLabel(w, mask);
                        break;
                    }
                    default: {
                        Button b;
                        Widget widget = PlayerWrapUtils.unwrapWidget(w);
                        if (widget.isDisposed()) break;
                        if (doubleClick) {
                            SWTUIPlayer.this.events.sendFocus(widget);
                            SWTUIPlayer.this.events.sendAll(widget, Events.createDoubleClick());
                            SWTUIPlayer.this.events.sendUnfocus(widget);
                            break;
                        }
                        if (widget instanceof MenuItem) {
                            SWTUIPlayer.this.clickMenuItem(w, isDefault, widget);
                            break;
                        }
                        boolean isButton = widget instanceof Button;
                        boolean isRadioButton = isButton && (widget.getStyle() & 0x10) != 0;
                        boolean isWin32 = Platform.getOS().equals("win32");
                        boolean isSelectionButton = isButton && ((Button)widget).getSelection();
                        SWTUIPlayer.this.events.sendFocus(widget);
                        if (!(!isRadioButton || isWin32 && isSelectionButton)) {
                            this.sendEventsToRadioButtons(widget);
                        }
                        if (isButton && (widget.getStyle() & 0x20) != 0) {
                            b.setSelection(!(b = (Button)widget).getSelection());
                        }
                        if (widget instanceof ToolItem && ((widget.getStyle() & 0x20) != 0 || (widget.getStyle() & 0x10) != 0)) {
                            b.setSelection(!(b = (ToolItem)widget).getSelection());
                        }
                        Point clickPoint = SWTUIPlayer.getClickPoint(w);
                        SWTUIPlayer.this.events.sendEvent(w, 6, mask);
                        SWTUIPlayer.this.events.sendEvent(w, 32, mask);
                        SWTUIPlayer.this.events.sendEvent(w, 3, clickPoint, 1, mask);
                        if (Widgets.isToggleButton((Widget)widget)) {
                            ((Button)widget).setSelection(!((Button)widget).getSelection());
                        }
                        if (!isRadioButton || !isWin32 || isSelectionButton) {
                            Event event = SWTUIPlayer.this.events.createEvent(w);
                            if (arrow) {
                                event.detail = 4;
                            }
                            event.type = isDefault ? 14 : 13;
                            event.stateMask = mask;
                            SWTUIPlayer.this.events.sendEvent(w, event);
                        }
                        SWTUIPlayer.this.events.sendEvent(w, 4, clickPoint, 1, mask);
                        SWTUIPlayer.this.events.sendEvent(w, 7);
                        SWTUIPlayer.this.events.sendUnfocus(widget);
                    }
                }
            }

            private void sendEventsToRadioButtons(Widget widget) {
                Button button = (Button)widget;
                this.sendEventPreviousSelected(button);
                button.setSelection(true);
            }

            private void sendEventPreviousSelected(Button button) {
                SWTUIElement[] siblings = null;
                int parentStyle = button.getParent().getStyle();
                if ((parentStyle & 0x400000) == 0) {
                    siblings = SWTUIPlayer.this.children.collectFor(SWTUIPlayer.this.wrap(button.getParent()), new SWTUIElement[]{w}, false, Button.class);
                }
                if (siblings == null) {
                    return;
                }
                SWTUIElement[] sWTUIElementArray = siblings;
                int n = siblings.length;
                int n2 = 0;
                while (n2 < n) {
                    void element = sWTUIElementArray[n2];
                    Button previousButton = (Button)PlayerWrapUtils.unwrap((SWTUIElement)element);
                    if ((previousButton.getStyle() & 0x10) != 0 && previousButton.getSelection()) {
                        previousButton.setSelection(false);
                        SWTUIPlayer.this.events.sendEvent((SWTUIElement)element, 13);
                        return;
                    }
                    ++n2;
                }
            }
        });
    }

    private static Point getMiddleClickPoint(Control w) {
        Point size = w.getSize();
        return new Point(size.x / 2, size.y / 2);
    }

    private static Point getClickPoint(SWTUIElement element) {
        Widget widget = PlayerWrapUtils.unwrapWidget(element);
        switch (element.getKind().kind) {
            case Tree: {
                Tree tree = (Tree)widget;
                TreeItem[] selection = tree.getSelection();
                if (selection.length < 1) {
                    return LEGACY_CLICK_POINT;
                }
                TreeItem item = selection[0];
                Point point = Viewers.getSafeToClickPoint(item);
                if (point == Viewers.UNSAFE_CLICK_POINT) {
                    return LEGACY_CLICK_POINT;
                }
                return point;
            }
        }
        if (widget instanceof Control) {
            return SWTUIPlayer.getMiddleClickPoint((Control)widget);
        }
        return LEGACY_CLICK_POINT;
    }

    private void clickMenuItem(SWTUIElement w, boolean isDefault, Widget widget) {
        MenuItem menuItem = (MenuItem)widget;
        this.hidePopupMenus(menuItem);
        if ((menuItem.getStyle() & 0x10) != 0) {
            Menu parentMenu = menuItem.getParent();
            if (parentMenu != null && !parentMenu.isDisposed() && (parentMenu.getStyle() & 0x400000) == 0) {
                int index = 0;
                MenuItem[] items = parentMenu.getItems();
                while (index < items.length && items[index] != menuItem) {
                    ++index;
                }
                int lowBound = index - 1;
                while (lowBound >= 0 && (items[lowBound].getStyle() & 0x10) != 0 && !items[lowBound].isDisposed()) {
                    items[lowBound].setSelection(false);
                    --lowBound;
                }
                int upperBound = index + 1;
                while (upperBound < items.length && (items[upperBound].getStyle() & 0x10) != 0 && !items[upperBound].isDisposed()) {
                    items[upperBound].setSelection(false);
                    ++upperBound;
                }
            }
            if (!menuItem.isDisposed()) {
                menuItem.setSelection(true);
                this.events.sendEvent((Widget)menuItem, 13);
            }
        } else {
            boolean newSelection = menuItem.getSelection();
            if ((menuItem.getStyle() & 0x20) != 0) {
                newSelection = !menuItem.getSelection();
                menuItem.setSelection(newSelection);
            }
            this.events.sendEvent(w, isDefault ? 14 : 13);
            if (!menuItem.isDisposed()) {
                menuItem.setSelection(newSelection);
            }
        }
        if (menuItem.isDisposed()) {
            return;
        }
        Menu parent = menuItem.getParent();
        while (parent != null) {
            if (parent.isDisposed()) {
                return;
            }
            this.events.sendEvent((Widget)parent, 23);
            if (parent.isDisposed()) {
                return;
            }
            parent = parent.getParentMenu();
        }
    }

    private void hidePopupMenus(MenuItem menuItem) {
        Menu parent = menuItem.getParent();
        while (parent != null) {
            List popupMenus = TeslaEventManager.getManager().getPopupMenus();
            for (WeakReference weakReference : popupMenus) {
                Menu reffered = (Menu)weakReference.get();
                if (!parent.equals(reffered)) continue;
                popupMenus.remove(weakReference);
                break;
            }
            parent = parent.getParentMenu();
        }
    }

    private void failClick(SWTUIElement w) {
        this.setBackgroundColor(w, 3);
        this.makeScreenShot();
        throw new RuntimeException(NLS.bind((String)TeslaSWTMessages.SWTUIPlayer_CannotClickOnDisabledControl, (Object)w.toString()));
    }

    private IWorkbenchPage getTargetPage() {
        IWorkbenchWindow window;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page == null && (page = (window = PlatformUI.getWorkbench().getWorkbenchWindows()[0]).getActivePage()) == null) {
            page = window.getPages()[0];
        }
        return page;
    }

    private void clickView(SWTUIElement w, IWorkbenchPage page) {
        IViewReference view = (IViewReference)((WorkbenchUIElement)w).reference;
        IWorkbenchPart part = view.getPart(true);
        if (part == null) {
            return;
        }
        page.activate(part);
        IWorkbenchPart activePart = page.getActivePart();
        if (!part.equals(activePart)) {
            throw new RuntimeException(NLS.bind((String)TeslaSWTMessages.SWTUIPlayer_WorkbenchPartNotActivated, (Object)w.toString()));
        }
    }

    private void clickLink(SWTUIElement w, boolean doubleClick, int mask) {
        Widget widget = PlayerWrapUtils.unwrapWidget(w);
        if (widget.isDisposed()) {
            return;
        }
        if (doubleClick) {
            this.events.sendFocus(widget);
            this.events.sendAll(widget, Events.createDoubleClick());
            this.events.sendUnfocus(widget);
        } else {
            this.events.sendAll(widget, new Event[]{Events.createMouseDown((int)1, (int)1, (int)mask, (int)0, (int)0), Events.createSelection((boolean)false, (int)mask), Events.createMouseUp()});
        }
    }

    private void clickEditor(SWTUIElement w, IWorkbenchPage page) {
        IEditorReference editor = (IEditorReference)((WorkbenchUIElement)w).reference;
        IWorkbenchPart editorPart = editor.getPart(true);
        page.bringToTop(editorPart);
        page.activate(editorPart);
    }

    private void clickTabItem(SWTUIElement w, boolean isDefault) {
        Item rawItem = (Item)PlayerWrapUtils.unwrapWidget(w);
        Composite tabParent = TabCTabUtil.getParent((Item)rawItem);
        TabCTabUtil.setSelection((Composite)tabParent, (Item)rawItem);
        Point pos = Bounds.centerAbs((Rectangle)TabCTabUtil.getBounds((Item)rawItem));
        this.events.sendAll((Widget)tabParent, (Widget)rawItem, new Event[]{Events.createMouseDown((Point)pos), Events.createSelection((boolean)isDefault, (int)0), Events.createMouseUp((Point)pos)});
    }

    private void clickLabel(SWTUIElement w, int stateMask) {
        Widget widget = w.unwrap();
        this.events.sendFocus(widget);
        Event[] eventArray = Events.createClick((int)1, (int)stateMask, (int)Bounds.centerRel((Rectangle)w.getBounds()).x, (int)Bounds.centerRel((Rectangle)w.getBounds()).y);
        int n = eventArray.length;
        int n2 = 0;
        while (n2 < n) {
            Event event = eventArray[n2];
            this.events.sendEvent(w, event);
            ++n2;
        }
        this.events.sendUnfocus(widget);
    }

    private void clickTableTreeItem(SWTUIElement w, final boolean doubleClick) {
        int column = w instanceof ItemUIElement ? ((ItemUIElement)w).getColumn() : -1;
        Widget item = (Widget)PlayerWrapUtils.unwrap(w);
        final Widget itemParent = TableTreeUtil.getParent((Widget)item);
        Viewers.selectItem(w, false);
        final Point itemCenter = Bounds.centerAbs((Rectangle)(column >= 0 ? TableTreeUtil.getItemBounds((Widget)item, (int)column) : TableTreeUtil.getItemBounds((Widget)item)));
        w.getPlayer().exec("click cell", new Runnable(){

            @Override
            public void run() {
                if (doubleClick) {
                    SWTUIPlayer.this.getEvents().sendFocus(itemParent);
                    SWTUIPlayer.this.getEvents().sendAll(itemParent, Events.createDoubleClick((Point)itemCenter));
                    SWTUIPlayer.this.getEvents().sendUnfocus(itemParent);
                } else {
                    SWTUIPlayer.this.getEvents().sendEvent(itemParent, Events.createMouseDown((Point)itemCenter));
                    SWTUIPlayer.this.getEvents().sendEvent(itemParent, Events.createMouseUp((Point)itemCenter));
                }
            }
        });
    }

    private static void checkCell(Item item, int column, boolean state) {
        TeslaCellEditorManager.getInstance().setNextCellEditorActivateEventType(4);
        if (item instanceof TreeItem) {
            Tree tree = ((TreeItem)item).getParent();
            TreeViewer v = (TreeViewer)TeslaSWTAccess.getViewer((Control)tree);
            if (v == null) {
                throw new RuntimeException("No tree viewer.");
            }
            if (column < 0 || column >= tree.getColumnCount()) {
                throw new RuntimeException("Invalid tree column index.");
            }
            TreeColumn c = tree.getColumn(column);
            Object data = c.getData("org.eclipse.jface.columnViewer");
            if (!(data instanceof ViewerColumn)) {
                throw new RuntimeException("No tree column viewer.");
            }
            ViewerColumn cv = (ViewerColumn)data;
            EditingSupport es = TeslaSWTAccess.getField(EditingSupport.class, cv, "editingSupport");
            if (es == null) {
                throw new RuntimeException("No editing support for tree column viewer.");
            }
            Object value = TeslaSWTAccess.callMethod(EditingSupport.class, (Object)es, "getValue", new Class[]{Object.class}, item.getData());
            if (!(value instanceof Boolean)) {
                throw new RuntimeException("Does not look like a checkbox tree column.");
            }
            if ((Boolean)value == state) {
                return;
            }
            v.editElement(item.getData(), column);
        } else if (item instanceof TableItem) {
            Table table = ((TableItem)item).getParent();
            TableViewer v = (TableViewer)TeslaSWTAccess.getViewer((Control)table);
            if (v == null) {
                throw new RuntimeException("No table viewer.");
            }
            if (column < 0 || column >= table.getColumnCount()) {
                throw new RuntimeException("Invalid table column index.");
            }
            TableColumn c = table.getColumn(column);
            Object data = c.getData("org.eclipse.jface.columnViewer");
            if (!(data instanceof ViewerColumn)) {
                throw new RuntimeException("No table column viewer.");
            }
            ViewerColumn cv = (ViewerColumn)data;
            EditingSupport es = TeslaSWTAccess.getField(EditingSupport.class, cv, "editingSupport");
            if (es == null) {
                throw new RuntimeException("No editing support for table column viewer.");
            }
            Object value = TeslaSWTAccess.callMethod(EditingSupport.class, (Object)es, "getValue", new Class[]{Object.class}, item.getData());
            if (!(value instanceof Boolean)) {
                throw new RuntimeException("Does not look like a checkbox table column.");
            }
            if ((Boolean)value == state) {
                return;
            }
            v.editElement(item.getData(), column);
        }
    }

    public void check(SWTUIElement w, boolean state) {
        Widget widget = PlayerWrapUtils.unwrapWidget(w);
        if (!widget.isDisposed()) {
            if (w instanceof ItemUIElement && widget instanceof Item) {
                SWTUIPlayer.checkCell((Item)widget, ((ItemUIElement)w).getColumn(), state);
            } else if ((widget.getStyle() & 0x20) != 0) {
                if (widget instanceof Button) {
                    if (((Button)widget).getSelection() != state) {
                        this.click(w);
                    }
                } else if (widget instanceof MenuItem) {
                    if (((MenuItem)widget).getSelection() != state) {
                        this.click(w);
                    }
                } else if (widget instanceof ToolItem && ((ToolItem)widget).getSelection() != state) {
                    this.click(w);
                }
            }
        }
    }

    public SWTUIElement wrap(Object s) {
        for (ISWTUIPlayerExtension ext : SWTUIPlayer.getExtensions()) {
            SWTUIElement result = ext.wrap(s, this);
            if (result == null) continue;
            return result;
        }
        if (s instanceof SWTUIElement) {
            return (SWTUIElement)s;
        }
        if (s instanceof IWorkbenchPart) {
            IWorkbenchWindow[] windows;
            IWorkbenchPart part = (IWorkbenchPart)s;
            IWorkbenchPartSite site = part.getSite();
            if (site != null) {
                IWorkbenchPage[] pages;
                IWorkbenchPartReference reference;
                IWorkbenchWindow window = site.getWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                if (page != null && (reference = page.getReference(part)) != null) {
                    return new WorkbenchUIElement(reference, this);
                }
                IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
                int n = pages.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchPage wp = iWorkbenchPageArray[n2];
                    IWorkbenchPartReference ref = wp.getReference(part);
                    if (ref != null) {
                        return new WorkbenchUIElement(ref, this);
                    }
                    ++n2;
                }
            }
            IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            int n = windows.length;
            int n3 = 0;
            while (n3 < n) {
                IWorkbenchPage[] pages;
                IWorkbenchWindow win = iWorkbenchWindowArray[n3];
                IWorkbenchPage[] iWorkbenchPageArray = pages = win.getPages();
                int n4 = pages.length;
                int n5 = 0;
                while (n5 < n4) {
                    IWorkbenchPage wp = iWorkbenchPageArray[n5];
                    IWorkbenchPartReference reference = wp.getReference(part);
                    if (reference != null) {
                        return new WorkbenchUIElement(reference, this);
                    }
                    ++n5;
                }
                ++n3;
            }
        }
        if (s instanceof IWorkbenchPartReference) {
            return new WorkbenchUIElement((IWorkbenchPartReference)s, this);
        }
        if (s instanceof Widget) {
            return new SWTUIElement((Widget)s, this);
        }
        return null;
    }

    Point getMousePos(Widget c) {
        Point xy = new Point(0, 0);
        Point point = this.widgetToMouseForMenus.get(c);
        if (point != null) {
            xy.x = point.x;
            xy.y = point.y;
        } else if (c instanceof TabFolder) {
            TabItem[] items = ((TabFolder)c).getSelection();
            if (items.length > 0) {
                Rectangle bounds = items[0].getBounds();
                return new Point(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
            }
        } else if (c instanceof CTabFolder) {
            CTabItem selection = ((CTabFolder)c).getSelection();
            if (selection != null) {
                Rectangle bounds = selection.getBounds();
                xy.x = bounds.x + bounds.width / 2;
                xy.y = bounds.y + bounds.height / 2;
                return new Point(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
            }
        } else if (c instanceof Table) {
            if (((Table)c).getItemCount() == 0) {
                Rectangle bounds = ((Table)c).getBounds();
                return new Point(bounds.width / 2, 9 * (bounds.height / 10));
            }
        } else if (c instanceof Tree && ((Tree)c).getItemCount() == 0) {
            Rectangle bounds = ((Tree)c).getBounds();
            return new Point(bounds.width / 2, 9 * (bounds.height / 10));
        }
        return xy;
    }

    public UIColor getSystemColor(int color) {
        return new SWTUIColor(this.display.getSystemColor(color));
    }

    public SWTUIElement selectMenu(PlayerSelectionFilter f) {
        SWTUIElement currentParent;
        block9: {
            block8: {
                if (f.path == null) {
                    return null;
                }
                currentParent = f.parent;
                if (!currentParent.getKind().is(ElementKind.Item)) break block8;
                Widget unwrapped = PlayerWrapUtils.unwrapWidget(currentParent);
                if (!(unwrapped instanceof TreeItem) && !(unwrapped instanceof TableItem)) break block9;
                currentParent = this.getParentElement(currentParent);
                break block9;
            }
            if (currentParent.getKind().is(ElementKind.Button)) {
                SWTUIElement[] children;
                while ((children = this.children.collectFor(currentParent, this.ignoreWindows, false, SWTUIPlayer.one(MenuItem.class), f.after)).length <= 0) {
                    if ((currentParent = this.getParentElement(currentParent)) != null) continue;
                    currentParent = f.parent;
                    break;
                }
            }
        }
        List<String> parts = Arrays.asList(f.path);
        int i = 0;
        int count = parts.size();
        while (i < count) {
            boolean isLast;
            String part = parts.get(i);
            SWTUIElement[] children = this.children.collectFor(currentParent, this.ignoreWindows, false, SWTUIPlayer.one(MenuItem.class), f.after);
            List<SWTUIElement> menuItems = this.findMenuItems(children, part, !(isLast = i == count - 1));
            if (menuItems.isEmpty()) {
                return null;
            }
            if (isLast && f.index != null) {
                if (f.index < 0 || f.index >= menuItems.size()) {
                    return null;
                }
                currentParent = menuItems.get(f.index);
            } else {
                currentParent = menuItems.get(0);
            }
            ++i;
        }
        return currentParent;
    }

    private List<SWTUIElement> findMenuItems(SWTUIElement[] items, String name, boolean returnFirstElement) {
        ArrayList<SWTUIElement> result = new ArrayList<SWTUIElement>();
        SWTUIElement[] sWTUIElementArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            SWTUIElement uiElement = sWTUIElementArray[n2];
            String elementName = PlayerTextUtils.getText(uiElement);
            if (elementName != null && (elementName = PlayerTextUtils.getMenuText(elementName)) != null && (elementName.equals(name) || PlayerTextUtils.safeMatches(elementName, name))) {
                result.add(uiElement);
                if (returnFirstElement) {
                    return result;
                }
            }
            ++n2;
        }
        return result;
    }

    public UIColor getBackgroundColor(SWTUIElement uiElement) {
        Widget widget = PlayerWrapUtils.unwrapWidget(uiElement);
        if (widget instanceof Control) {
            return new SWTUIColor(((Control)widget).getBackground());
        }
        return null;
    }

    public int countItems(SWTUIElement element, String[] selection) {
        Object widget = PlayerWrapUtils.unwrap(element);
        if (widget instanceof Tree) {
            return Viewers.countTreeItemChildren(element, selection);
        }
        if (widget instanceof Table) {
            return ((Table)widget).getItemCount();
        }
        if (widget instanceof org.eclipse.swt.widgets.List) {
            return ((org.eclipse.swt.widgets.List)widget).getItemCount();
        }
        if (widget instanceof TabFolder) {
            return ((TabFolder)widget).getItemCount();
        }
        if (widget instanceof CTabFolder) {
            return ((CTabFolder)widget).getItemCount();
        }
        return 0;
    }

    public void setBackgroundColor(SWTUIElement uiElement, int color) {
        this.setBackgroundColor(uiElement, new SWTUIColor(this.display.getSystemColor(color)));
    }

    public void setBackgroundColor(SWTUIElement uiElement, final UIColor color) {
        final Widget widget = PlayerWrapUtils.unwrapWidget(uiElement);
        if (widget instanceof Control && !widget.isDisposed()) {
            this.exec("setBackground", new Runnable(){

                @Override
                public void run() {
                    if (!widget.isDisposed()) {
                        ((Control)widget).setBackground(((SWTUIColor)color).getColor());
                    }
                }
            });
        }
    }

    public void setDateTime(final SWTUIElement uiElement, final int year, final int month, final int day, final int hours, final int minutes, final int second) {
        final Widget widget = PlayerWrapUtils.unwrapWidget(uiElement);
        this.exec("setDateTime", new Runnable(){

            @Override
            public void run() {
                if (widget.isDisposed()) {
                    return;
                }
                if (widget instanceof DateTime) {
                    DateTime dt = (DateTime)widget;
                    SWTUIPlayer.this.events.sendFocus(widget);
                    dt.setDate(year, month - 1, day);
                    dt.setTime(hours, minutes, second);
                    SWTUIPlayer.this.events.sendEvent(uiElement, 13);
                    SWTUIPlayer.this.events.sendUnfocus(widget);
                }
            }
        });
    }

    public void setText(SWTUIElement uiElement, String text) {
        this.setText(uiElement, text, false);
    }

    public static int findComboItem(String[] items, String item, boolean select) {
        int i = 0;
        while (i < items.length) {
            if (items[i].equals(item)) {
                return i;
            }
            ++i;
        }
        if (!select) {
            return -1;
        }
        i = 0;
        while (i < items.length) {
            if (PlayerTextUtils.safeMatches(items[i], item)) {
                return i;
            }
            ++i;
        }
        item = item.toLowerCase();
        String[] lowerItems = new String[items.length];
        int i2 = 0;
        while (i2 < items.length) {
            lowerItems[i2] = items[i2].toLowerCase();
            ++i2;
        }
        i2 = 0;
        while (i2 < items.length) {
            if (lowerItems[i2].equals(item)) {
                return i2;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < items.length) {
            if (PlayerTextUtils.safeMatches(lowerItems[i2], item)) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public void setText(final SWTUIElement uiElement, final String text, final boolean select) {
        final Widget widget = PlayerWrapUtils.unwrapWidget(uiElement);
        this.exec("setText", new Runnable(){

            @Override
            public void run() {
                int itemIndex;
                Combo combo;
                if (widget.isDisposed()) {
                    return;
                }
                if (widget instanceof Text) {
                    Text textElement = (Text)widget;
                    SWTUIPlayer.this.events.sendFocus(widget);
                    textElement.setText(text);
                    SWTUIPlayer.this.events.sendEvent(uiElement, 25);
                    SWTUIPlayer.this.events.sendEvent(uiElement, 24);
                    SWTUIPlayer.this.events.sendUnfocus(widget);
                }
                if (widget instanceof Spinner) {
                    SWTUIPlayer.this.events.sendFocus(widget);
                    int Val = (int)(Double.parseDouble(text) * Math.pow(10.0, ((Spinner)widget).getDigits()));
                    ((Spinner)widget).setSelection(Val);
                    SWTUIPlayer.this.events.sendEvent(uiElement, 24);
                    SWTUIPlayer.this.events.sendUnfocus(widget);
                }
                if (widget instanceof Slider) {
                    SWTUIPlayer.this.events.sendFocus(widget);
                    int Val = Integer.parseInt(text);
                    ((Slider)widget).setSelection(Val);
                    SWTUIPlayer.this.events.sendEvent(uiElement, 24);
                    SWTUIPlayer.this.events.sendEvent(uiElement, 13);
                    SWTUIPlayer.this.events.sendUnfocus(widget);
                }
                if (widget instanceof StyledText) {
                    SWTUIPlayer.this.events.sendFocus(widget);
                    ((StyledText)widget).setText(text);
                    if (widget instanceof StyledText) {
                        StyledText tt = (StyledText)widget;
                        int offset = tt.getCaretOffset();
                        String allText = tt.getText();
                        tt.setText(allText);
                        tt.setCaretOffset(offset);
                    }
                    SWTUIPlayer.this.events.sendUnfocus(widget);
                }
                if (widget instanceof Combo) {
                    combo = (Combo)widget;
                    SWTUIPlayer.this.events.sendFocus(widget);
                    itemIndex = SWTUIPlayer.findComboItem(combo.getItems(), text, select);
                    if (!select) {
                        combo.setText(text);
                    }
                    if (itemIndex != -1) {
                        combo.select(itemIndex);
                    }
                    SWTUIPlayer.this.events.sendEvent(uiElement, 24);
                    SWTUIPlayer.this.events.sendEvent(uiElement, 13);
                    SWTUIPlayer.this.events.sendUnfocus(widget);
                }
                if (widget instanceof CCombo) {
                    combo = (CCombo)widget;
                    SWTUIPlayer.this.events.sendFocus(widget);
                    itemIndex = SWTUIPlayer.findComboItem(combo.getItems(), text, select);
                    if (!select) {
                        combo.setText(text);
                    }
                    if (itemIndex != -1) {
                        combo.select(itemIndex);
                    }
                    SWTUIPlayer.this.events.sendEvent(uiElement, 24);
                    SWTUIPlayer.this.events.sendEvent(uiElement, 13);
                    SWTUIPlayer.this.events.sendUnfocus(widget);
                }
                if (widget instanceof Browser) {
                    Browser browser = (Browser)widget;
                    SWTUIPlayer.this.events.sendFocus(widget);
                    browser.setText(text);
                    SWTUIPlayer.this.events.sendEvent(uiElement, 25);
                    SWTUIPlayer.this.events.sendEvent(uiElement, 24);
                    SWTUIPlayer.this.events.sendUnfocus(widget);
                }
            }
        });
    }

    protected boolean checkContainsControl(Control control, Combo combo) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show(SWTUIElement uiElement, int x, int y) {
        Menu menu = (Menu)uiElement.unwrap();
        Point pos = new Point(x, y);
        if (pos.x == -1 && pos.y == -1) {
            pos = this.getMousePos((Widget)menu);
        }
        if ((menu.getStyle() & 2) == 0) {
            Set<WeakReference<Menu>> set = shownMenus;
            synchronized (set) {
                shownMenus.add(new WeakReference<Menu>(menu));
            }
        }
        this.events.sendEvent(uiElement, 22, pos.x, pos.y, 0);
    }

    public boolean isDisposed(SWTUIElement uiElement) {
        Widget widget = PlayerWrapUtils.unwrapWidget(uiElement);
        return widget == null || widget.isDisposed();
    }

    protected static void checkIntegrity(Class<?>[] classes) {
        int i = 0;
        while (i < classes.length) {
            int j = i + 1;
            while (j < classes.length) {
                Class<?> ci = classes[i];
                Class<?> cj = classes[j];
                if (ci.isAssignableFrom(cj)) {
                    System.out.println(String.format("Achtung! %s should be after %s", ci.getName(), cj.getName()));
                }
                ++j;
            }
            ++i;
        }
    }

    public static Class<?> getSearchableClass(Object widget) {
        ElementKind kind = elementKinds.get(widget.getClass());
        if (kind == null) {
            for (ISWTUIPlayerExtension iSWTUIPlayerExtension : SWTUIPlayer.getExtensions()) {
                Class<?> searchableClass = iSWTUIPlayerExtension.getSearchableClass(widget);
                if (searchableClass == null) continue;
                return searchableClass;
            }
            for (Map.Entry entry : elementKinds.entrySet()) {
                Class key = (Class)entry.getKey();
                if (!key.isInstance(widget)) continue;
                return key;
            }
        }
        return widget.getClass();
    }

    public static GenericElementKind getKind(Object w) {
        if (w == null) {
            return GenericElementKind.Unknown;
        }
        for (ISWTUIPlayerExtension extension : SWTUIPlayer.getExtensions()) {
            GenericElementKind kind = extension.getKind(w);
            if (kind == null) continue;
            return kind;
        }
        ElementKind kind = elementKinds.get(w.getClass());
        if (kind == null) {
            for (Map.Entry<Class<?>, ElementKind> entry : elementKinds.entrySet()) {
                Class<?> key = entry.getKey();
                if (!key.isInstance(w)) continue;
                return new GenericElementKind(entry.getValue());
            }
        }
        if (kind != null) {
            return new GenericElementKind(kind);
        }
        return GenericElementKind.Unknown;
    }

    public void close(final SWTUIElement uiElement) {
        this.exec("close", new Runnable(){

            @Override
            public void run() {
                if (uiElement instanceof WorkbenchUIElement) {
                    IWorkbenchPartReference reference = ((WorkbenchUIElement)uiElement).getReference();
                    if (reference == null) {
                        return;
                    }
                    IWorkbenchPart part = reference.getPart(false);
                    if (part != null) {
                        IWorkbenchPage page = part.getSite().getPage();
                        if (part instanceof IEditorPart) {
                            page.closeEditor((IEditorPart)part, true);
                        } else if (part instanceof IViewPart) {
                            IViewPart vp = (IViewPart)part;
                            page.hideView(vp);
                        }
                    }
                } else {
                    Widget widget = PlayerWrapUtils.unwrapWidget(uiElement);
                    if (widget instanceof CTabItem) {
                        CTabItem item = (CTabItem)widget;
                        Rectangle rect = TeslaSWTAccess.getCTabItemCloseRect(item);
                        if (rect != null && rect.width > 0 && rect.height > 0) {
                            SWTUIPlayer.this.events.sendEvent((Widget)item.getParent(), 3, rect.x + 1, rect.y + 1, 1);
                            SWTUIPlayer.this.events.sendEvent((Widget)item.getParent(), 4, rect.x + 1, rect.y + 1, 1);
                        }
                    } else if (widget instanceof Shell) {
                        SWTUIPlayer.this.getEvents().sendEvent(widget, 27);
                        ((Shell)widget).close();
                    } else {
                        Event e = SWTUIPlayer.this.events.sendEvent(uiElement, 21);
                        if (e != null && e.doit && widget != null && !widget.isDisposed()) {
                            widget.dispose();
                        }
                    }
                }
            }
        });
    }

    public List<File> getScreenshots() {
        if (this.screenshotsDuringSession != null) {
            return new ArrayList<File>(this.screenshotsDuringSession);
        }
        return new ArrayList<File>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exec(String msg, Runnable runnable) {
        Exception e = new Exception();
        StackTraceElement stackTraceElement = e.getStackTrace()[1];
        String errorMethod = stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + ":" + stackTraceElement.getLineNumber();
        ContextManagement.Context currentContext = this.context;
        ExecRunnable myr = new ExecRunnable(msg, currentContext, runnable, errorMethod);
        if (this.context != null) {
            Map<ContextManagement.Context, List<Runnable>> map = this.runnables;
            synchronized (map) {
                List<Runnable> runs = this.runnables.get(this.context);
                if (runs == null) {
                    runs = new ArrayList<Runnable>();
                    this.runnables.put(this.context, runs);
                }
                runs.add(myr);
            }
        }
        this.display.asyncExec((Runnable)myr);
        this.display.wake();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canProceed(ContextManagement.Context context, Q7WaitInfoRoot info) {
        if (!this.display.equals(Display.getCurrent())) {
            SWTUIPlayer.debugProceed("Wrong display");
            return false;
        }
        if (SWTUIPlayer.hasTimers(this.display, info)) {
            SWTUIPlayer.debugProceed("Timers active");
            return false;
        }
        if (!TeslaEventManager.getManager().isNoWaitForJob() && SWTUIPlayer.hasRunnables(this.display)) {
            SWTUIPlayer.debugProceed("Display has runnables");
            return false;
        }
        if (!BrowserManager.getInstance().isExecutionAllowed(info)) {
            SWTUIPlayer.debugProceed("Browser active");
            return false;
        }
        Map<ContextManagement.Context, List<Runnable>> map = this.runnables;
        synchronized (map) {
            this.context = context;
            List<Runnable> runs = this.runnables.get(context);
            if (runs != null && !runs.isEmpty()) {
                SWTUIPlayer.debugProceed("Previous tsk is still pending");
                return false;
            }
            if (!TeslaEventManager.getManager().isNoWaitForJob() && !this.collector.isEmpty(context, info)) {
                SWTUIPlayer.debugProceed("There are active jobs");
                return false;
            }
        }
        SWTUIPlayer.debugProceed("Can proceed");
        return true;
    }

    public static boolean hasRunnables(Display display) {
        Synchronizer synchronizer = display.getSynchronizer();
        return TeslaSWTAccess.getRunnables(synchronizer) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasTimers(Display display, Q7WaitInfoRoot infoRoot) {
        Q7WaitInfoRoot timers = TeslaSWTAccess.getTimers(display);
        List map = TeslaTimerExecManager.getManager().getTimers();
        ArrayList<TeslaTimerExecManager.TimerInfo> waitFor = new ArrayList<TeslaTimerExecManager.TimerInfo>();
        Q7WaitInfoRoot q7WaitInfoRoot = timers;
        int n = ((Runnable[])q7WaitInfoRoot).length;
        int n2 = 0;
        while (n2 < n) {
            Runnable runnable = q7WaitInfoRoot[n2];
            if (runnable instanceof SherlockTimerRunnable) {
                runnable = ((SherlockTimerRunnable)runnable).getRunnable();
            }
            TeslaTimerExecManager.TimerInfo current = null;
            for (TeslaTimerExecManager.TimerInfo t : map) {
                if (!t.hasRunnable(runnable)) continue;
                current = t;
                break;
            }
            if (current != null) {
                Class<?> cl = runnable.getClass();
                String clName = cl.getName();
                if (clName.startsWith("org.eclipse.core.internal.databinding.observable.DelayedObservableValue")) {
                    waitFor.add(current);
                    break;
                }
                if (clName.contains("org.eclipse.jface")) {
                    waitFor.add(current);
                    break;
                }
                if (!SWTUIPlayer.isTimerIgnored(clName) && TeslaLimits.getTimerExecsWait() > 0) {
                    boolean add = false;
                    for (TeslaTimerExecManager.TimerInfo info : map) {
                        if (!info.hasRunnable(runnable) || info.time >= (long)TeslaLimits.getTimerExecsWait()) continue;
                        if (System.currentTimeMillis() - info.firstSheduleTime > (long)TeslaLimits.getTimerExecsSkip() && info.resheduleCounter > 0L) {
                            SWTUIPlayer.printTimers(map);
                            continue;
                        }
                        add = true;
                        break;
                    }
                    if (add) {
                        waitFor.add(current);
                    }
                }
            }
            ++n2;
        }
        if (waitFor.size() > 0 && lastTimersSucess != 0L && System.currentTimeMillis() - lastTimersSucess > (long)TeslaLimits.getTimerExecsTotalWaitTime()) {
            if (lastTimeSucessStep == 0L) {
                lastTimeSucessStep = System.currentTimeMillis();
                SWTUIPlayer.printTimers(waitFor);
                return false;
            }
            if (System.currentTimeMillis() - lastTimeSucessStep > (long)TeslaLimits.getTimerExecsTotalWaitTimeStep()) {
                lastTimeSucessStep = System.currentTimeMillis();
                SWTUIPlayer.printTimers(waitFor);
                return false;
            }
        }
        if (waitFor.size() > 0) {
            for (TeslaTimerExecManager.TimerInfo timerInfo : waitFor) {
                String timerClassName = timerInfo.getRunnable().getClass().getName();
                q7WaitInfoRoot = infoRoot;
                synchronized (q7WaitInfoRoot) {
                    if (timerInfo.execQualifier != null) {
                        infoRoot.getInnerClassMap().put((Object)timerClassName, (Object)timerInfo.execQualifier);
                    }
                }
                Q7WaitUtils.updateInfo((String)"timer", (String)timerClassName, (Q7WaitInfoRoot)infoRoot);
            }
            return true;
        }
        lastTimersSucess = System.currentTimeMillis();
        lastTimeSucessStep = 0L;
        return false;
    }

    public static boolean isTimerIgnored(String clName) {
        return TeslaTimerExecManager.isTimerIgnored((String)clName);
    }

    private static void printTimers(List<TeslaTimerExecManager.TimerInfo> map) {
    }

    public static String toSelectionItem(String toPattern) {
        if (toPattern != null) {
            toPattern = toPattern.replaceAll("\\+", "\\\\+");
            toPattern = toPattern.replaceAll("\\(", "\\\\(");
            toPattern = toPattern.replaceAll("\\)", "\\\\)");
            toPattern = toPattern.replaceAll("\\[", "\\\\[");
            toPattern = toPattern.replaceAll("\\]", "\\\\]");
            toPattern = toPattern.replaceAll("\\*", "\\\\*");
        }
        return toPattern;
    }

    public static String buildPathFragment(String text, int index) {
        return String.format("%s%%%d%%", SWTUIPlayer.toSelectionItem(text).replaceAll("/", "\\\\/"), index);
    }

    public static String buildPathFragment(String text) {
        return SWTUIPlayer.toSelectionItem(text).replaceAll("/", "\\\\/");
    }

    public void setIgnores(Shell ... ignoreWindows) {
        if (ignoreWindows != null) {
            this.ignoreWindows = new SWTUIElement[ignoreWindows.length];
            this.ignoredShells = ignoreWindows;
            int i = 0;
            Shell[] shellArray = ignoreWindows;
            int n = ignoreWindows.length;
            int n2 = 0;
            while (n2 < n) {
                Shell shell = shellArray[n2];
                this.ignoreWindows[i++] = this.wrap(shell);
                ++n2;
            }
        }
    }

    public void typeText(final SWTUIElement element, final String text, final int mask, final boolean fromDisplay) {
        this.exec("typeText", new Runnable(){

            @Override
            public void run() {
                switch (element.getKind().kind) {
                    // Empty switch
                }
                Widget widget = PlayerWrapUtils.unwrapWidget(element);
                if (widget instanceof Control) {
                    Control ctrl = (Control)widget;
                    if (fromDisplay) {
                        try {
                            ShellUtilsProvider.getShellUtils().forceActive((Object)ctrl.getShell());
                        }
                        catch (CoreException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    SWTUIPlayer.this.events.sendFocus(widget);
                    if (ctrl instanceof CCombo) {
                        CCombo combo = (CCombo)widget;
                        Text tW = SWTUIPlayer.this.getCComboText(combo);
                        SWTUIPlayer.this.events.sendFocus((Widget)tW);
                        tW.insert(text);
                        SWTUIPlayer.this.events.sendEvent(SWTUIPlayer.this.wrap(tW), 24);
                        SWTUIPlayer.this.events.sendEvent(SWTUIPlayer.this.wrap(tW), 27);
                    } else if (ctrl instanceof Text) {
                        Text tW = (Text)ctrl;
                        SWTUIPlayer.this.events.sendFocus((Widget)tW);
                        tW.insert(text);
                        SWTUIPlayer.this.type(element, 0, 131072, false, '\u0000', 1);
                        SWTUIPlayer.this.events.sendEvent(SWTUIPlayer.this.wrap(tW), 24);
                        SWTUIPlayer.this.events.sendEvent(SWTUIPlayer.this.wrap(tW), 27);
                    } else {
                        this.sendKeysToWidget(text, mask, fromDisplay, widget);
                        SWTUIPlayer.this.events.sendEvent(SWTUIPlayer.this.wrap(widget), 27);
                    }
                }
            }

            private void sendKeysToWidget(String text2, int mask2, boolean fromDisplay2, Widget widget) {
                SWTUIElement element2 = SWTUIPlayer.this.wrap(widget);
                if (!widget.isDisposed()) {
                    char[] cArray = text2.toCharArray();
                    int n = cArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char ch = cArray[n2];
                        SWTUIPlayer.this.updateStyledTextPos(widget);
                        List<KeyStroke> keys = keyboard.splitToKeys(KeyStroke.getInstance((int)mask2, (int)0));
                        if (fromDisplay2) {
                            keys.add(SWTKeyboardLayout.getKeyboardLayout().keyStrokeFor(ch));
                        } else if (Character.isUpperCase(ch)) {
                            ch = Character.toLowerCase(ch);
                            keys.add(KeyStroke.getInstance((int)131072, (int)ch));
                        } else {
                            keys.add(KeyStroke.getInstance((int)ch));
                        }
                        keyboard.typeKeys(widget, fromDisplay2, keys.toArray(new KeyStroke[0]));
                        if (widget instanceof Text || widget instanceof Combo || widget instanceof CCombo) {
                            String textValue = PlayerTextUtils.getRawText(element2);
                            Event ee = SWTUIPlayer.this.events.createEvent(element2);
                            ee.start = 0;
                            ee.end = textValue.length();
                            ee.text = textValue;
                            ee.type = 25;
                            SWTUIPlayer.this.events.sendEvent(element2, ee);
                            SWTUIPlayer.this.events.sendEvent(element2, 24);
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    public void traverse(final SWTUIElement element, final int code, char character, final int times) {
        this.exec("traverse", new Runnable(){

            @Override
            public void run() {
                Widget widget = PlayerWrapUtils.unwrapWidget(element);
                if (!(widget instanceof Control)) {
                    return;
                }
                int i = 0;
                while (i < times) {
                    Object control = (Control)widget;
                    boolean traverseResult = false;
                    boolean isShellProcessed = false;
                    while (!traverseResult && !isShellProcessed && control != null) {
                        if (!control.isDisposed()) {
                            Event ee = new Event();
                            if (code == 16) {
                                ee.keyCode = 9;
                                ee.stateMask = 0;
                            } else if (code == 8) {
                                ee.keyCode = 9;
                                ee.stateMask = 131072;
                            }
                            ee.widget = control;
                            ee.time = (int)System.currentTimeMillis();
                            ee.doit = true;
                            ee.detail = code;
                            try {
                                traverseResult = control.traverse(code, ee);
                            }
                            catch (Exception e) {
                                try {
                                    Method method = Control.class.getDeclaredMethod("traverse", Event.class);
                                    method.setAccessible(true);
                                    method.invoke(control, ee);
                                }
                                catch (Exception e1) {
                                    traverseResult = control.traverse(code);
                                }
                            }
                        }
                        isShellProcessed = control instanceof Shell;
                        control = !control.isDisposed() ? control.getParent() : null;
                    }
                    ++i;
                }
            }
        });
    }

    public void type(final SWTUIElement element, final int code, final int mask, final boolean fromDisplay, final char character, final int times) {
        this.exec("type", new Runnable(){

            @Override
            public void run() {
                switch (element.getKind().kind) {
                    // Empty switch
                }
                Widget widget = PlayerWrapUtils.unwrapWidget(element);
                if (widget instanceof Control) {
                    if (fromDisplay) {
                        try {
                            ShellUtilsProvider.getShellUtils().forceActive((Object)((Control)widget).getShell());
                        }
                        catch (CoreException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    SWTUIPlayer.this.events.sendFocus(widget);
                    lastWorkbenchKeyboardPressResult = null;
                    boolean doModify = false;
                    if (widget instanceof CCombo) {
                        CCombo combo = (CCombo)widget;
                        Text text = SWTUIPlayer.this.getCComboText(combo);
                        int i = 0;
                        while (i < times) {
                            this.sendKeyEvent(code, mask, fromDisplay, character, (Widget)text);
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while (i < times) {
                            this.sendKeyEvent(code, mask, fromDisplay, character, widget);
                            doModify |= lastWorkbenchKeyboardPressResult != null && lastWorkbenchKeyboardPressResult == false;
                            ++i;
                        }
                    }
                    if (widget instanceof Text) {
                        if (doModify) {
                            SWTUIPlayer.this.events.sendEvent(element, 24);
                        }
                        if (code == 13 && mask == 0) {
                            SWTUIPlayer.this.events.sendEvent(element, 14);
                        }
                    }
                }
            }

            private void sendKeyEvent(int code2, int mask2, boolean fromDisplay2, char character2, Widget widget) {
                if (widget.isDisposed()) {
                    return;
                }
                if (fromDisplay2) {
                    KeyStroke[] keys = new KeyStroke[]{KeyStroke.getInstance((int)mask2, (int)code2)};
                    keyboard.typeKeys(widget, fromDisplay2, keys);
                } else {
                    Event createEvent = keyboard.createEvent(code2, mask2, character2);
                    createEvent.widget = widget;
                    SWTUIPlayer.this.updateStyledTextPos(widget);
                    SWTUIPlayer.this.events.sendEventRaw(1, createEvent);
                    if (widget.isDisposed()) {
                        return;
                    }
                    SWTUIPlayer.this.events.sendEventRaw(2, createEvent);
                }
            }
        });
    }

    public void typeAction(SWTUIElement element, final String actionId) {
        this.exec("typeAction", new Runnable(){

            @Override
            public void run() {
                IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                try {
                    handlerService.executeCommand(actionId, null);
                }
                catch (Exception e) {
                    TeslaCore.log((Throwable)e);
                }
            }
        });
    }

    protected Text getCComboText(CCombo combo) {
        return TeslaSWTAccess.getCComboText(combo);
    }

    public void clickAndWait(SWTUIElement w) {
        this.click(w);
    }

    private void shutdown() {
        Job.getJobManager().removeJobChangeListener((IJobChangeListener)this.collector);
        BrowserManager.getInstance().clear();
        TeslaTimerExecManager.getManager().removeEventListener(this.timerListener);
    }

    public void waitFinish() {
    }

    public void save(final SWTUIElement w) {
        this.exec("save", new Runnable(){

            @Override
            public void run() {
                IEditorReference editor;
                IEditorPart editorPart;
                if (w.getKind().kind == ElementKind.Editor && (editorPart = (editor = (IEditorReference)((WorkbenchUIElement)w).reference).getEditor(false)) != null) {
                    editorPart.doSave((IProgressMonitor)new NullProgressMonitor());
                }
            }
        });
    }

    public boolean isDirty(SWTUIElement w) {
        if (w.getKind().kind == ElementKind.Editor) {
            IEditorReference editor = (IEditorReference)((WorkbenchUIElement)w).reference;
            return editor.isDirty();
        }
        return false;
    }

    private static Widget parentFromExtension(Widget current) {
        for (ISWTUIPlayerExtension ext : SWTUIPlayer.getExtensions()) {
            Widget result = ext.getIndirectParent(current);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static List<Widget> collectParents(Widget widget, Map<Control, SWTUIElement> references, Widget ... stopAt) {
        ArrayList<Widget> parents = new ArrayList<Widget>();
        if (widget == null || widget.isDisposed()) {
            return parents;
        }
        Object current = widget;
        Widget prev = null;
        while (current != null) {
            int n;
            Menu parentMenu;
            prev = current;
            Widget indirectParent = SWTUIPlayer.parentFromExtension(current);
            current = indirectParent != null ? indirectParent : (current instanceof Control ? (current instanceof ToolBar ? (references != null && references.containsKey(current) ? references.get(current).unwrap() : ((Control)current).getParent()) : ((Control)current).getParent()) : (current instanceof TreeItem ? ((TreeItem)current).getParent() : (current instanceof TableItem ? ((TableItem)current).getParent() : (current instanceof MenuItem ? ((MenuItem)current).getParent() : (current instanceof ToolItem ? ((ToolItem)current).getParent() : (current instanceof Menu ? ((parentMenu = ((Menu)current).getParentMenu()) == null ? ((Menu)current).getParent() : parentMenu) : (current instanceof ScrollBar ? ((ScrollBar)current).getParent() : (current instanceof ToolTip ? ((ToolTip)current).getParent() : null))))))));
            if (current == null) continue;
            if (current instanceof CoolBar) {
                CoolItem[] items;
                CoolBar bar = (CoolBar)current;
                CoolItem[] coolItemArray = items = bar.getItems();
                int n2 = items.length;
                n = 0;
                while (n < n2) {
                    Control control;
                    CoolItem coolItem = coolItemArray[n];
                    if (coolItem != null && (control = coolItem.getControl()) != null && control.equals(prev)) {
                        parents.add((Widget)coolItem);
                    }
                    ++n;
                }
            }
            if (stopAt != null) {
                boolean breakRequired = false;
                Widget[] widgetArray = stopAt;
                n = stopAt.length;
                int n3 = 0;
                while (n3 < n) {
                    Widget w = widgetArray[n3];
                    if (w.equals(current)) {
                        breakRequired = true;
                        break;
                    }
                    ++n3;
                }
                if (breakRequired) break;
            }
            parents.add((Widget)current);
        }
        return parents;
    }

    public String getSelectedTabItem(SWTUIElement swtuiElement) {
        TabFolder tf;
        TabItem[] selection;
        Widget w = PlayerWrapUtils.unwrapWidget(swtuiElement);
        if (w instanceof CTabFolder) {
            CTabFolder tf2 = (CTabFolder)w;
            CTabItem item = tf2.getSelection();
            return item.getText();
        }
        if (w instanceof TabFolder && (selection = (tf = (TabFolder)w).getSelection()).length > 0) {
            return selection[0].getText();
        }
        return null;
    }

    public static boolean isVisible(SWTUIElement swtuiElement) {
        Widget widget = PlayerWrapUtils.unwrapWidget(swtuiElement);
        if (widget instanceof Control) {
            return ((Control)widget).isVisible();
        }
        return true;
    }

    public static SWTUIElement getShell(SWTUIElement element) {
        for (ISWTUIPlayerExtension ext : SWTUIPlayer.getExtensions()) {
            SWTUIElement result = ext.getShell(element);
            if (result == null) continue;
            return result;
        }
        Widget widget = PlayerWrapUtils.unwrapWidget(element);
        if (widget == null || widget.isDisposed()) {
            return null;
        }
        SWTUIPlayer player = element.getPlayer();
        if (widget instanceof Control) {
            return player.wrap(((Control)widget).getShell());
        }
        if (widget instanceof MenuItem) {
            return player.wrap(((MenuItem)widget).getParent().getShell());
        }
        if (widget instanceof ToolItem) {
            return player.wrap(((ToolItem)widget).getParent().getShell());
        }
        if (widget instanceof TreeItem) {
            return player.wrap(((TreeItem)widget).getParent().getShell());
        }
        if (widget instanceof TableItem) {
            return player.wrap(((TableItem)widget).getParent().getShell());
        }
        if (widget instanceof CTabItem) {
            return player.wrap(((CTabItem)widget).getParent().getShell());
        }
        if (widget instanceof CoolItem) {
            return player.wrap(((CoolItem)widget).getParent().getShell());
        }
        if (widget instanceof TabItem) {
            return player.wrap(((TabItem)widget).getParent().getShell());
        }
        if (widget instanceof TreeColumn) {
            return player.wrap(((TreeColumn)widget).getParent().getShell());
        }
        if (widget instanceof TableColumn) {
            return player.wrap(((TableColumn)widget).getParent().getShell());
        }
        if (widget instanceof Item) {
            return player.wrap(((Item)widget).getDisplay().getActiveShell());
        }
        if (widget instanceof ScrollBar) {
            return player.wrap(((ScrollBar)widget).getParent().getShell());
        }
        return null;
    }

    public void addMouseWidgetInfo(final Widget canvas, int x, int y) {
        TeslaEventManager.getManager().setLastWidget(canvas, x, y);
        this.widgetToMouseForMenus.put(canvas, new Point(x, y));
        canvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SWTUIPlayer.this.widgetToMouseForMenus.remove(canvas);
                try {
                    canvas.removeDisposeListener((DisposeListener)this);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    public SWTEvents getEvents() {
        return this.events;
    }

    public List<SWTUIElement> getParentsList(SWTUIElement swtuiElement) {
        Map<Control, SWTUIElement> references = EclipseWorkbenchProvider.getProvider().getWorkbenchReference(this);
        List<Widget> parents = SWTUIPlayer.collectParents(PlayerWrapUtils.unwrapWidget(swtuiElement), references, new Widget[0]);
        ArrayList<SWTUIElement> elements = new ArrayList<SWTUIElement>();
        for (Widget widget : parents) {
            GenericElementKind kind;
            SWTUIElement e = null;
            e = references.containsKey(widget) ? references.get(widget) : this.wrap(widget);
            if (e == null || (kind = e.getKind()).is(ElementKind.Any) || kind.is(ElementKind.Unknown) || kind.is(ElementKind.Toolbar) || kind.is(ElementKind.CoolBar) || kind.is(ElementKind.CBanner) || kind.is(ElementKind.TabFolder) || kind.is(ElementKind.Canvas) || kind.is(ElementKind.Combo) || !SWTUIPlayer.isVisible(e)) continue;
            elements.add(e);
        }
        return elements;
    }

    public UIJobCollector getCollector() {
        return this.collector;
    }

    public SWTUIElement getParentElement(SWTUIElement uiElement) {
        List<SWTUIElement> parentsList = this.getParentsList(uiElement);
        if (parentsList.size() > 0) {
            return parentsList.get(0);
        }
        return null;
    }

    public BrowserManager getBrowserManager() {
        return BrowserManager.getInstance();
    }

    private void updateStyledTextPos(Widget widget) {
        if (widget instanceof StyledText) {
            StyledText t = (StyledText)widget;
            int topPixel = t.getTopPixel();
            Viewer viewer = TeslaSWTAccess.getViewer((Control)t);
            if (viewer != null) {
                JFaceTextSupport.setLastPixels(viewer, topPixel);
            }
        }
    }

    public static byte[] captureControlImage(Control ctrl, Rectangle subImageBounds) {
        Image image = SWTUIPlayer.captureControlImageRaw(ctrl, subImageBounds);
        ImageData data = image.getImageData();
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{data};
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        loader.save((OutputStream)stream, 5);
        image.dispose();
        return stream.toByteArray();
    }

    public static Image captureControlImageRaw(Control ctrl, Rectangle subImageBounds) {
        Image image;
        ctrl.getShell().setActive();
        if (ctrl instanceof Label && (image = ((Label)ctrl).getImage()) != null) {
            return new Image(image.getDevice(), image, 0);
        }
        GC gc = new GC((Drawable)ctrl);
        Rectangle bounds = ctrl.getBounds();
        Image image2 = null;
        if (!bounds.equals((Object)subImageBounds)) {
            image2 = new Image((Device)ctrl.getDisplay(), subImageBounds.width, subImageBounds.height);
            gc.copyArea(image2, subImageBounds.x, subImageBounds.y);
            gc.dispose();
        } else {
            image2 = new Image((Device)ctrl.getDisplay(), bounds.width, bounds.height);
            gc.copyArea(image2, 0, 0);
            ScreenshotSupport.saveImage(image2.getImageData(), "");
            gc.dispose();
        }
        return image2;
    }

    public static Image copyImagePart(Image img, Rectangle subImageBounds) {
        GC gc = new GC((Drawable)img);
        Rectangle bounds = img.getBounds();
        Image image = null;
        if (!bounds.equals((Object)subImageBounds)) {
            image = new Image(img.getDevice(), subImageBounds.width, subImageBounds.height);
            gc.copyArea(image, subImageBounds.x, subImageBounds.y);
            gc.dispose();
        } else {
            gc.dispose();
            image = img;
        }
        ScreenshotSupport.saveImage(image.getImageData(), "copy_img");
        return image;
    }

    public static byte[] captureControlImage(Image img) {
        ImageData data = img.getImageData();
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{data};
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        loader.save((OutputStream)stream, 5);
        img.dispose();
        return stream.toByteArray();
    }

    public static Image prepateImageForOCR(byte[] image, int x, int y, int width, int height) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        Image img = new Image((Device)display, (InputStream)new ByteArrayInputStream(image));
        ScreenshotSupport.saveImage(img.getImageData(), "ocr");
        Image scaled = SWTUIPlayer.prepareImageForOCR(x, y, width, height, img);
        ScreenshotSupport.saveImage(scaled.getImageData(), "ocr_scaled");
        img.dispose();
        return scaled;
    }

    public static Image prepareImageForOCR(int x, int y, int width, int height, Image img) {
        int mult = 2;
        Image scaled = new Image(img.getDevice(), width * mult, height * mult);
        GC gc = new GC((Drawable)scaled);
        gc.drawImage(img, x, y, width, height, 0, 0, width * mult, height * mult);
        ScreenshotSupport.saveImage(scaled.getImageData(), "ocr_part");
        gc.dispose();
        return scaled;
    }

    public static void disableMessageDialogs() {
        SWTDialogManager.setCancelMessageBoxesDisplay((boolean)true);
    }

    public static void enableMessageDialogs() {
        SWTDialogManager.setCancelMessageBoxesDisplay((boolean)false);
    }

    public static synchronized SWTUIPlayer getPlayer(Display display) {
        SWTUIPlayer p = players.get(display);
        if (p == null) {
            p = new SWTUIPlayer(display);
            players.put(display, p);
        }
        return p;
    }

    public static synchronized SWTUIPlayer getPlayer() {
        return SWTUIPlayer.getPlayer(PlatformUI.getWorkbench().getDisplay());
    }

    public static synchronized void shutdown(SWTUIPlayer internalPlayer) {
        if (internalPlayer != null) {
            players.remove(internalPlayer.getDisplay());
            internalPlayer.shutdown();
        }
    }

    public Display getDisplay() {
        return this.display;
    }

    public void minimize(SWTUIElement uiElement) {
        final Widget widget = PlayerWrapUtils.unwrapWidget(uiElement);
        this.exec("minimize", new Runnable(){

            @Override
            public void run() {
                SWTUIPlayer.this.processTabFolderButton(widget, 0);
            }
        });
    }

    public void maximize(SWTUIElement uiElement) {
        final Widget widget = PlayerWrapUtils.unwrapWidget(uiElement);
        this.exec("maximize", new Runnable(){

            @Override
            public void run() {
                if (widget instanceof Shell) {
                    ((Shell)widget).setMaximized(true);
                    try {
                        ShellUtilsProvider.getShellUtils().forceActive((Object)((Shell)widget));
                    }
                    catch (CoreException e) {
                        throw new RuntimeException(e);
                    }
                }
                SWTUIPlayer.this.processTabFolderButton(widget, 1);
            }
        });
    }

    public void restore(SWTUIElement uiElement) {
        final Widget widget = PlayerWrapUtils.unwrapWidget(uiElement);
        this.exec("restore", new Runnable(){

            @Override
            public void run() {
                SWTUIPlayer.this.processTabFolderButton(widget, 2);
            }
        });
    }

    private void processTabFolderButton(Widget widget, int buttonId) {
        EclipseWorkbenchProvider.getProvider().processTabFolderButton(widget, buttonId);
    }

    public void showTabList(SWTUIElement uiElement) {
        final Widget widget = PlayerWrapUtils.unwrapWidget(uiElement);
        this.exec("showTabList", new Runnable(){

            @Override
            public void run() {
                SWTUIPlayer.this.processTabShowList(widget);
            }
        });
    }

    private void processTabShowList(Widget widget) {
        EclipseWorkbenchProvider.getProvider().processTabShowList(widget);
    }

    public void setPerspective(final String perspectiveId) {
        this.exec("setPerspective", new Runnable(){

            @Override
            public void run() {
                IPerspectiveDescriptor persectiveDescriptor = PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(perspectiveId);
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().setPerspective(persectiveDescriptor);
            }
        });
    }

    public void wakeup() {
        SWTUIPlayer.notifyUI(this.getDisplay());
    }

    public static void notifyUI(Display display) {
        display.wake();
        display.asyncExec((Runnable)notifyUINullRunnable);
    }

    public static synchronized void addExtension(ISWTUIPlayerExtension extension) {
        extensions.add(extension);
    }

    public static synchronized void removeExtension(ISWTUIPlayerExtension extension) {
        extensions.remove(extension);
    }

    public static synchronized List<ISWTUIPlayerExtension> getExtensions() {
        return new ArrayList<ISWTUIPlayerExtension>(extensions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cleanMenus(Q7WaitInfoRoot info) {
        boolean[] result = new boolean[1];
        Display curDisplay = PlatformUI.getWorkbench().getDisplay();
        if (curDisplay == null || curDisplay.isDisposed()) {
            return false;
        }
        final ArrayList<Menu> menusToProceed = new ArrayList<Menu>();
        Set<WeakReference<Menu>> set = shownMenus;
        synchronized (set) {
            for (WeakReference<Menu> weakReference : shownMenus) {
                Menu menu = (Menu)weakReference.get();
                if (menu == null) continue;
                menusToProceed.add(menu);
            }
            shownMenus.clear();
        }
        if (!menusToProceed.isEmpty()) {
            Q7WaitUtils.updateInfo((String)"menu", (String)"hide", (Q7WaitInfoRoot)info);
            curDisplay.syncExec(new Runnable(){

                @Override
                public void run() {
                    for (Menu menu : menusToProceed) {
                        while (menu != null && !menu.isDisposed()) {
                            SWTUIPlayer.this.events.sendEvent((Widget)menu, 23);
                            menu = menu.getParentMenu();
                        }
                    }
                }
            });
        }
        set = shownMenus;
        synchronized (set) {
            result[0] = !shownMenus.isEmpty();
        }
        return result[0];
    }

    public void clean() {
        this.getCollector().clean();
        this.getBrowserManager().clear();
        this.cleanMenus(null);
        this.error = null;
    }

    public boolean isCollectable(SWTUIElement element, Class<?>[] classes) {
        if (element == null) {
            return false;
        }
        if (classes == null) {
            return true;
        }
        for (ISWTUIPlayerExtension extension : SWTUIPlayer.getExtensions()) {
            if (!extension.isCollectable(element, classes)) continue;
            return true;
        }
        return false;
    }

    private static void debugProceed(String message) {
        if (DEBUG_PROCEED) {
            System.out.println("SWTUIPlayer: " + message);
            System.out.flush();
        }
    }

    public final class ExecRunnable
    implements Runnable {
        private final ContextManagement.Context currentContext;
        private final Runnable runnable;
        private final String errorMethod;
        private String msg;

        private ExecRunnable(String msg, ContextManagement.Context currentContext, Runnable runnable, String errorMethod) {
            this.msg = msg;
            this.currentContext = currentContext;
            this.runnable = runnable;
            this.errorMethod = errorMethod;
        }

        public String toString() {
            return this.errorMethod;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block18: {
                SWTUIPlayer.this.collector.enable();
                try {
                    try {
                        this.runnable.run();
                        SWTUIPlayer.this.display.wake();
                    }
                    catch (Throwable t) {
                        if (SWTUIPlayer.this.error != null) {
                            SWTUIPlayer.this.error = t;
                        }
                        TeslaCore.log((Throwable)new TeslaExecutionFailedException(this.errorMethod, t));
                        Map<ContextManagement.Context, List<Runnable>> map = SWTUIPlayer.this.runnables;
                        synchronized (map) {
                            if (this.currentContext != null) {
                                List<Runnable> runs = SWTUIPlayer.this.runnables.get(this.currentContext);
                                runs.remove(this);
                            }
                            break block18;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Map<ContextManagement.Context, List<Runnable>> map = SWTUIPlayer.this.runnables;
                    synchronized (map) {
                        if (this.currentContext != null) {
                            List<Runnable> runs = SWTUIPlayer.this.runnables.get(this.currentContext);
                            runs.remove(this);
                        }
                    }
                    throw throwable;
                }
                Map<ContextManagement.Context, List<Runnable>> map = SWTUIPlayer.this.runnables;
                synchronized (map) {
                    if (this.currentContext != null) {
                        List<Runnable> runs = SWTUIPlayer.this.runnables.get(this.currentContext);
                        runs.remove(this);
                    }
                }
            }
        }
    }

    private static class NotifyUINullRunnable
    implements Runnable {
        private NotifyUINullRunnable() {
        }

        @Override
        public void run() {
        }
    }
}

