/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.bnd;

import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.core.ClasspathContainerState;
import org.eclipse.pde.internal.core.PDECore;

public class BndResourceChangeListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            final HashSet<IProject> updateProjects = new HashSet<IProject>();
            try {
                delta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        IResource resource = delta.getResource();
                        if (resource instanceof IFile) {
                            IFile instr;
                            Object sessionProperty;
                            IFile file = (IFile)resource;
                            IProject project = file.getProject();
                            Object object = sessionProperty = project.isOpen() ? project.getSessionProperty(PDECore.BND_CLASSPATH_INSTRUCTION_FILE) : null;
                            if (sessionProperty instanceof IFile && (instr = (IFile)sessionProperty).equals((Object)file)) {
                                updateProjects.add(file.getProject());
                            }
                        }
                        return true;
                    }
                });
                ClasspathContainerState.requestClasspathUpdate(updateProjects);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }
}

