/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions;

import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;

public class NotExpression
extends Expression {
    private static final int HASH_INITIAL = NotExpression.class.getName().hashCode();
    private final Expression fExpression;

    public NotExpression(Expression expression) {
        Assert.isNotNull((Object)expression);
        this.fExpression = expression;
    }

    @Override
    public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
        return this.fExpression.evaluate(context).not();
    }

    @Override
    public void collectExpressionInfo(ExpressionInfo info) {
        this.fExpression.collectExpressionInfo(info);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object object) {
        void that;
        if (!(object instanceof NotExpression)) {
            return false;
        }
        NotExpression notExpression = (NotExpression)object;
        return this.fExpression.equals(that.fExpression);
    }

    @Override
    protected int computeHashCode() {
        return HASH_INITIAL * 89 + this.fExpression.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append(" [expression=");
        builder.append(this.fExpression);
        builder.append("]");
        return builder.toString();
    }
}

