/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.Objects;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.internal.corext.dom.ASTSemanticMatcher;

public final class ASTMatcherSameVariablesAndMethods
extends ASTSemanticMatcher {
    public boolean match(SimpleName node, Object other) {
        return super.match(node, other) && this.sameReference(node, (SimpleName)other);
    }

    private boolean sameReference(SimpleName node1, SimpleName node2) {
        IBinding declaration1 = this.getDeclaration(node1);
        IBinding declaration2 = this.getDeclaration(node2);
        return declaration1 != null && Objects.equals(declaration1, declaration2);
    }

    private IBinding getDeclaration(SimpleName node) {
        IBinding ast = node.resolveBinding();
        if (ast != null) {
            switch (ast.getKind()) {
                case 3: {
                    return ((IVariableBinding)ast).getVariableDeclaration();
                }
                case 4: {
                    return ((IMethodBinding)ast).getMethodDeclaration();
                }
            }
        }
        return ast;
    }
}

