/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.algebra;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.common.order.AvailableStatementOrder;
import org.eclipse.rdf4j.federated.algebra.QueryRef;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.query.algebra.AbstractQueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Var;

public abstract class NTuple
extends AbstractQueryModelNode
implements TupleExpr,
QueryRef {
    private static final long serialVersionUID = -4899531533519154174L;
    protected final List<TupleExpr> args;
    protected final QueryInfo queryInfo;

    public NTuple(List<TupleExpr> args, QueryInfo queryInfo) {
        this.queryInfo = queryInfo;
        this.args = args;
        for (TupleExpr expr : args) {
            expr.setParentNode(this);
        }
    }

    public TupleExpr getArg(int i) {
        return this.args.get(i);
    }

    public List<TupleExpr> getArgs() {
        return this.args;
    }

    public int getNumberOfArguments() {
        return this.args.size();
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        for (TupleExpr expr : this.args) {
            expr.visit(visitor);
        }
    }

    @Override
    public NTuple clone() {
        return (NTuple)super.clone();
    }

    @Override
    public Set<String> getAssuredBindingNames() {
        LinkedHashSet<String> res = new LinkedHashSet<String>(16);
        for (TupleExpr e : this.args) {
            res.addAll(e.getAssuredBindingNames());
        }
        return res;
    }

    @Override
    public Set<String> getBindingNames() {
        LinkedHashSet<String> res = new LinkedHashSet<String>(16);
        for (TupleExpr e : this.args) {
            res.addAll(e.getBindingNames());
        }
        return res;
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        int index = this.args.indexOf(current);
        if (index < 0) {
            throw new IllegalArgumentException("Node is not a child node: " + current);
        }
        this.args.set(index, (TupleExpr)replacement);
        replacement.setParentNode(this);
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meetOther(this);
    }

    @Override
    public QueryInfo getQueryInfo() {
        return this.queryInfo;
    }

    @Override
    public Set<Var> getSupportedOrders(AvailableStatementOrder tripleSource) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public void setOrder(Var var) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public Var getOrder() {
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

