/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.RioConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RioConfig
implements Serializable {
    private static final long serialVersionUID = 2714L;
    protected final ConcurrentMap<RioSetting<Object>, Object> settings = new ConcurrentHashMap<RioSetting<Object>, Object>();
    protected final ConcurrentMap<RioSetting<Object>, Object> systemPropertyCache = new ConcurrentHashMap<RioSetting<Object>, Object>();
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public <T> T get(RioSetting<T> setting) {
        String stringRepresentation;
        Object result = this.settings.get(setting);
        if (result == null) {
            result = this.systemPropertyCache.get(setting);
        }
        if (result == null && (stringRepresentation = System.getProperty(setting.getKey())) != null) {
            try {
                T typesafeSystemProperty = setting.convert(stringRepresentation);
                this.systemPropertyCache.put(setting, typesafeSystemProperty);
                return typesafeSystemProperty;
            }
            catch (RioConfigurationException e) {
                this.log.trace(e.getMessage(), (Throwable)e);
            }
        }
        if (result == null) {
            return setting.getDefaultValue();
        }
        return (T)result;
    }

    public <T> RioConfig set(RioSetting<T> setting, T value) {
        if (value == null) {
            this.settings.remove(setting);
        } else {
            Object putIfAbsent = this.settings.putIfAbsent(setting, value);
            if (putIfAbsent != null) {
                this.settings.put(setting, value);
            }
        }
        return this;
    }

    public <T> boolean isSet(RioSetting<T> setting) {
        return this.settings.containsKey(setting) || this.systemPropertyCache.containsKey(setting) || this.hasSystemPropertyOverride(setting);
    }

    private boolean hasSystemPropertyOverride(RioSetting<?> setting) {
        return Objects.nonNull(System.getProperty(setting.getKey()));
    }

    public RioConfig useDefaults() {
        this.settings.clear();
        this.systemPropertyCache.clear();
        return this;
    }

    public Map<RioSetting<Object>, Object> getSettings() {
        return Collections.unmodifiableMap(new HashMap<RioSetting<Object>, Object>(this.settings));
    }
}

