/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.factory.map.primitive.ImmutableShortByteMapFactory;
import org.eclipse.collections.api.map.primitive.ImmutableShortByteMap;
import org.eclipse.collections.api.map.primitive.ShortByteMap;
import org.eclipse.collections.impl.factory.primitive.ShortByteMaps;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableShortByteEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableShortByteHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableShortByteSingletonMap;

public enum ImmutableShortByteMapFactoryImpl implements ImmutableShortByteMapFactory
{
    INSTANCE;


    public ImmutableShortByteMap empty() {
        return ImmutableShortByteEmptyMap.INSTANCE;
    }

    public ImmutableShortByteMap of() {
        return this.empty();
    }

    public ImmutableShortByteMap with() {
        return this.empty();
    }

    public ImmutableShortByteMap of(short key, byte value) {
        return this.with(key, value);
    }

    public ImmutableShortByteMap with(short key, byte value) {
        return new ImmutableShortByteSingletonMap(key, value);
    }

    public ImmutableShortByteMap ofAll(ShortByteMap map) {
        return this.withAll(map);
    }

    public ImmutableShortByteMap withAll(ShortByteMap map) {
        if (map instanceof ImmutableShortByteMap) {
            return (ImmutableShortByteMap)map;
        }
        if (map.isEmpty()) {
            return this.with();
        }
        if (map.size() == 1) {
            short key = map.keysView().shortIterator().next();
            return new ImmutableShortByteSingletonMap(key, map.get(key));
        }
        return new ImmutableShortByteHashMap(map);
    }

    public <T> ImmutableShortByteMap from(Iterable<T> iterable, ShortFunction<? super T> keyFunction, ByteFunction<? super T> valueFunction) {
        return ShortByteMaps.mutable.from(iterable, keyFunction, valueFunction).toImmutable();
    }
}

