/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.ui.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.ui.util.AbstractResourceActionHandler;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.ui.commands.ConvertTargetDialog;
import org.eclipse.cdt.managedbuilder.internal.ui.commands.Messages;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class ConvertTargetHandler
extends AbstractResourceActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
        IStructuredSelection selection = ConvertTargetHandler.getSelection((ExecutionEvent)event);
        if (selection.size() != 1) {
            return null;
        }
        Object obj = selection.getFirstElement();
        if (!(obj instanceof IProject)) {
            return null;
        }
        IProject project = (IProject)obj;
        if (ConvertTargetHandler.hasTargetConverters(project)) {
            ConvertTargetHandler.handleConvertTargetAction(project, shell);
        } else {
            MessageDialog.openError((Shell)shell, (String)Messages.ConvertTargetHandler_No_Converter, (String)NLS.bind((String)Messages.ProjectConvert_noConverterErrorDialog_message, (Object[])new String[]{project.getName()}));
        }
        return null;
    }

    public static boolean hasTargetConverters(IProject project) {
        return ManagedBuildManager.hasTargetConversionElements((IBuildObject)ConvertTargetHandler.getProjectType(project)) || ManagedBuildManager.hasAnyTargetConversionElements(ConvertTargetHandler.getProjectToolchains(project));
    }

    private static IProjectType getProjectType(IProject project) {
        IManagedProject managedProject;
        IProjectType projectType = null;
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        if (info != null && (managedProject = info.getManagedProject()) != null) {
            projectType = managedProject.getProjectType();
        }
        return projectType;
    }

    private static List<IBuildObject> getProjectToolchains(IProject project) {
        ArrayList<IBuildObject> projectToolchains = new ArrayList<IBuildObject>();
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        if (info != null) {
            IConfiguration[] configs;
            IConfiguration[] iConfigurationArray = configs = info.getManagedProject().getConfigurations();
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfiguration config = iConfigurationArray[n2];
                IToolChain toolchain = config.getToolChain();
                if (toolchain != null) {
                    projectToolchains.add((IBuildObject)toolchain);
                }
                ++n2;
            }
        }
        return projectToolchains;
    }

    private static void handleConvertTargetAction(IProject project, Shell shell) {
        String title = NLS.bind((String)Messages.ProjectConvert_title, (Object)project.getName());
        ConvertTargetDialog dialog = new ConvertTargetDialog(shell, project, title);
        if (dialog.open() != 0) {
            return;
        }
        if (!ConvertTargetDialog.isConversionSuccessful()) {
            MessageDialog.openError((Shell)shell, (String)Messages.ProjectConvert_conversionErrordialog_title, (String)NLS.bind((String)Messages.ProjectConvert_conversionErrordialog_message, (Object)project.getName()));
        }
    }
}

