/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ptp.debug.core.model.IRunToLine;
import org.eclipse.ptp.internal.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ptp.internal.debug.ui.messages.Messages;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class RunToLineAdapter
implements IRunToLineTarget {
    /*
     * Enabled aggressive block sorting
     */
    public void runToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) throws CoreException {
        String errorMessage = null;
        if (!(part instanceof ITextEditor)) {
            errorMessage = Messages.RunToLineAdapter_2;
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        ITextEditor textEditor = (ITextEditor)part;
        IEditorInput input = textEditor.getEditorInput();
        if (input == null) {
            errorMessage = Messages.RunToLineAdapter_0;
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)input);
        if (document == null) {
            errorMessage = Messages.RunToLineAdapter_1;
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        final String fileName = this.getFileName(input);
        ITextSelection textSelection = (ITextSelection)selection;
        final int lineNumber = textSelection.getStartLine() + 1;
        if (!(target instanceof IAdaptable)) return;
        final IRunToLine runToLine = (IRunToLine)((IAdaptable)target).getAdapter(IRunToLine.class);
        if (runToLine == null) return;
        if (!runToLine.canRunToLine(fileName, lineNumber)) return;
        Runnable r = new Runnable(){

            public void run() {
                try {
                    runToLine.runToLine(fileName, lineNumber, DebugUITools.getPreferenceStore().getBoolean("org.eclipse.debug.ui.skip_breakpoints_during_run_to_line"));
                }
                catch (DebugException e) {
                    RunToLineAdapter.this.failed(e);
                }
            }
        };
        this.runInBackground(r);
    }

    public boolean canRunToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) {
        if (target instanceof IAdaptable && part instanceof IEditorPart) {
            String fileName;
            IRunToLine runToLine = (IRunToLine)((IAdaptable)target).getAdapter(IRunToLine.class);
            if (runToLine == null) {
                return false;
            }
            IEditorPart editorPart = (IEditorPart)part;
            IEditorInput input = editorPart.getEditorInput();
            if (input == null) {
                return false;
            }
            if (!(editorPart instanceof ITextEditor)) {
                return false;
            }
            ITextEditor textEditor = (ITextEditor)editorPart;
            IDocument document = textEditor.getDocumentProvider().getDocument((Object)input);
            if (document == null) {
                return false;
            }
            try {
                fileName = this.getFileName(input);
            }
            catch (CoreException e) {
                return false;
            }
            ITextSelection textSelection = (ITextSelection)selection;
            int lineNumber = textSelection.getStartLine() + 1;
            return runToLine.canRunToLine(fileName, lineNumber);
        }
        return false;
    }

    private String getFileName(IEditorInput input) throws CoreException {
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile().getName();
        }
        if (input instanceof IStorageEditorInput) {
            return ((IStorageEditorInput)input).getStorage().getName();
        }
        return null;
    }

    private void runInBackground(Runnable r) {
        DebugPlugin.getDefault().asyncExec(r);
    }

    protected void failed(Throwable e) {
        MultiStatus ms = new MultiStatus(PTPDebugUIPlugin.getUniqueIdentifier(), 10002, Messages.RunToLineAdapter_3, null);
        ms.add((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 10002, e.getMessage(), e));
        IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler((IStatus)ms);
        if (handler != null) {
            try {
                handler.handleStatus((IStatus)ms, (Object)this);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }
}

