/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.DnsConfig;

final class ImmutableDnsConfig
implements DnsConfig {
    @Nullable
    private final List<String> nameServers;
    @Nullable
    private final List<String> search;
    @Nullable
    private final List<String> options;

    private ImmutableDnsConfig(@Nullable List<String> nameServers, @Nullable List<String> search, @Nullable List<String> options) {
        this.nameServers = nameServers;
        this.search = search;
        this.options = options;
    }

    @Override
    @JsonProperty(value="Nameservers")
    @Nullable
    public List<String> nameServers() {
        return this.nameServers;
    }

    @Override
    @JsonProperty(value="Search")
    @Nullable
    public List<String> search() {
        return this.search;
    }

    @Override
    @JsonProperty(value="Options")
    @Nullable
    public List<String> options() {
        return this.options;
    }

    public final ImmutableDnsConfig withNameServers(String ... elements) {
        if (elements == null) {
            return new ImmutableDnsConfig(null, this.search, this.options);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableDnsConfig.createUnmodifiableList(false, ImmutableDnsConfig.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableDnsConfig(newValue, this.search, this.options);
    }

    public final ImmutableDnsConfig withNameServers(@Nullable Iterable<String> elements) {
        if (this.nameServers == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableDnsConfig.createUnmodifiableList(false, ImmutableDnsConfig.createSafeList(elements, true, false));
        return new ImmutableDnsConfig(newValue, this.search, this.options);
    }

    public final ImmutableDnsConfig withSearch(String ... elements) {
        if (elements == null) {
            return new ImmutableDnsConfig(this.nameServers, null, this.options);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableDnsConfig.createUnmodifiableList(false, ImmutableDnsConfig.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableDnsConfig(this.nameServers, newValue, this.options);
    }

    public final ImmutableDnsConfig withSearch(@Nullable Iterable<String> elements) {
        if (this.search == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableDnsConfig.createUnmodifiableList(false, ImmutableDnsConfig.createSafeList(elements, true, false));
        return new ImmutableDnsConfig(this.nameServers, newValue, this.options);
    }

    public final ImmutableDnsConfig withOptions(String ... elements) {
        if (elements == null) {
            return new ImmutableDnsConfig(this.nameServers, this.search, null);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableDnsConfig.createUnmodifiableList(false, ImmutableDnsConfig.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableDnsConfig(this.nameServers, this.search, newValue);
    }

    public final ImmutableDnsConfig withOptions(@Nullable Iterable<String> elements) {
        if (this.options == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableDnsConfig.createUnmodifiableList(false, ImmutableDnsConfig.createSafeList(elements, true, false));
        return new ImmutableDnsConfig(this.nameServers, this.search, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDnsConfig && this.equalTo(0, (ImmutableDnsConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableDnsConfig another) {
        return Objects.equals(this.nameServers, another.nameServers) && Objects.equals(this.search, another.search) && Objects.equals(this.options, another.options);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.nameServers);
        h += (h << 5) + Objects.hashCode(this.search);
        h += (h << 5) + Objects.hashCode(this.options);
        return h;
    }

    public String toString() {
        return "DnsConfig{nameServers=" + this.nameServers + ", search=" + this.search + ", options=" + this.options + "}";
    }

    public static ImmutableDnsConfig copyOf(DnsConfig instance) {
        if (instance instanceof ImmutableDnsConfig) {
            return (ImmutableDnsConfig)instance;
        }
        return ImmutableDnsConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    static final class Builder
    implements DnsConfig.Builder {
        private List<String> nameServers = null;
        private List<String> search = null;
        private List<String> options = null;

        private Builder() {
        }

        public final Builder from(DnsConfig instance) {
            List<String> optionsValue;
            List<String> searchValue;
            Objects.requireNonNull(instance, "instance");
            List<String> nameServersValue = instance.nameServers();
            if (nameServersValue != null) {
                this.addAllNameServers(nameServersValue);
            }
            if ((searchValue = instance.search()) != null) {
                this.addAllSearch(searchValue);
            }
            if ((optionsValue = instance.options()) != null) {
                this.addAllOptions(optionsValue);
            }
            return this;
        }

        public final Builder nameServer(String element) {
            if (this.nameServers == null) {
                this.nameServers = new ArrayList<String>();
            }
            this.nameServers.add(Objects.requireNonNull(element, "nameServers element"));
            return this;
        }

        @Override
        public final Builder nameServers(String ... elements) {
            if (this.nameServers == null) {
                this.nameServers = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nameServers.add(Objects.requireNonNull(element, "nameServers element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Nameservers")
        public final Builder nameServers(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.nameServers = null;
                return this;
            }
            this.nameServers = new ArrayList<String>();
            return this.addAllNameServers(elements);
        }

        public final Builder addAllNameServers(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nameServers element");
            if (this.nameServers == null) {
                this.nameServers = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nameServers.add(Objects.requireNonNull(element, "nameServers element"));
            }
            return this;
        }

        public final Builder search(String element) {
            if (this.search == null) {
                this.search = new ArrayList<String>();
            }
            this.search.add(Objects.requireNonNull(element, "search element"));
            return this;
        }

        @Override
        public final Builder search(String ... elements) {
            if (this.search == null) {
                this.search = new ArrayList<String>();
            }
            for (String element : elements) {
                this.search.add(Objects.requireNonNull(element, "search element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Search")
        public final Builder search(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.search = null;
                return this;
            }
            this.search = new ArrayList<String>();
            return this.addAllSearch(elements);
        }

        public final Builder addAllSearch(Iterable<String> elements) {
            Objects.requireNonNull(elements, "search element");
            if (this.search == null) {
                this.search = new ArrayList<String>();
            }
            for (String element : elements) {
                this.search.add(Objects.requireNonNull(element, "search element"));
            }
            return this;
        }

        public final Builder option(String element) {
            if (this.options == null) {
                this.options = new ArrayList<String>();
            }
            this.options.add(Objects.requireNonNull(element, "options element"));
            return this;
        }

        @Override
        public final Builder options(String ... elements) {
            if (this.options == null) {
                this.options = new ArrayList<String>();
            }
            for (String element : elements) {
                this.options.add(Objects.requireNonNull(element, "options element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Options")
        public final Builder options(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.options = null;
                return this;
            }
            this.options = new ArrayList<String>();
            return this.addAllOptions(elements);
        }

        public final Builder addAllOptions(Iterable<String> elements) {
            Objects.requireNonNull(elements, "options element");
            if (this.options == null) {
                this.options = new ArrayList<String>();
            }
            for (String element : elements) {
                this.options.add(Objects.requireNonNull(element, "options element"));
            }
            return this;
        }

        @Override
        public ImmutableDnsConfig build() {
            return new ImmutableDnsConfig(this.nameServers == null ? null : ImmutableDnsConfig.createUnmodifiableList(true, this.nameServers), this.search == null ? null : ImmutableDnsConfig.createUnmodifiableList(true, this.search), this.options == null ? null : ImmutableDnsConfig.createUnmodifiableList(true, this.options));
        }
    }
}

