/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.mandas.docker.client.messages.swarm.RemoteManager;

final class ImmutableRemoteManager
implements RemoteManager {
    private final String addr;
    private final String nodeId;

    private ImmutableRemoteManager(String addr, String nodeId) {
        this.addr = addr;
        this.nodeId = nodeId;
    }

    @Override
    @JsonProperty(value="Addr")
    public String addr() {
        return this.addr;
    }

    @Override
    @JsonProperty(value="NodeID")
    public String nodeId() {
        return this.nodeId;
    }

    public final ImmutableRemoteManager withAddr(String value) {
        String newValue = Objects.requireNonNull(value, "addr");
        if (this.addr.equals(newValue)) {
            return this;
        }
        return new ImmutableRemoteManager(newValue, this.nodeId);
    }

    public final ImmutableRemoteManager withNodeId(String value) {
        String newValue = Objects.requireNonNull(value, "nodeId");
        if (this.nodeId.equals(newValue)) {
            return this;
        }
        return new ImmutableRemoteManager(this.addr, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRemoteManager && this.equalTo(0, (ImmutableRemoteManager)another);
    }

    private boolean equalTo(int synthetic, ImmutableRemoteManager another) {
        return this.addr.equals(another.addr) && this.nodeId.equals(another.nodeId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.addr.hashCode();
        h += (h << 5) + this.nodeId.hashCode();
        return h;
    }

    public String toString() {
        return "RemoteManager{addr=" + this.addr + ", nodeId=" + this.nodeId + "}";
    }

    public static ImmutableRemoteManager copyOf(RemoteManager instance) {
        if (instance instanceof ImmutableRemoteManager) {
            return (ImmutableRemoteManager)instance;
        }
        return ImmutableRemoteManager.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private static final long INIT_BIT_ADDR = 1L;
        private static final long INIT_BIT_NODE_ID = 2L;
        private long initBits = 3L;
        private String addr;
        private String nodeId;

        private Builder() {
        }

        public final Builder from(RemoteManager instance) {
            Objects.requireNonNull(instance, "instance");
            this.addr(instance.addr());
            this.nodeId(instance.nodeId());
            return this;
        }

        @JsonProperty(value="Addr")
        public final Builder addr(String addr) {
            this.addr = Objects.requireNonNull(addr, "addr");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="NodeID")
        public final Builder nodeId(String nodeId) {
            this.nodeId = Objects.requireNonNull(nodeId, "nodeId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableRemoteManager build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRemoteManager(this.addr, this.nodeId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("addr");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("nodeId");
            }
            return "Cannot build RemoteManager, some of required attributes are not set " + attributes;
        }
    }
}

