/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.composition.discoverer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.discovery.core.annotations.Parameter;
import org.eclipse.modisco.java.ASTNode;
import org.eclipse.modisco.java.AbstractTypeDeclaration;
import org.eclipse.modisco.java.Archive;
import org.eclipse.modisco.java.CompilationUnit;
import org.eclipse.modisco.java.Model;
import org.eclipse.modisco.java.Package;
import org.eclipse.modisco.java.composition.discoverer.Activator;
import org.eclipse.modisco.java.composition.discoverer.Messages;
import org.eclipse.modisco.java.composition.discoverer.listeners.JavaCompositionSourceVisitListener;
import org.eclipse.modisco.java.composition.javaapplication.Java2Directory;
import org.eclipse.modisco.java.composition.javaapplication.Java2File;
import org.eclipse.modisco.java.composition.javaapplication.JavaApplication;
import org.eclipse.modisco.java.composition.javaapplication.JavaJar2File;
import org.eclipse.modisco.java.composition.javaapplication.JavaNodeSourceRegion;
import org.eclipse.modisco.java.composition.javaapplication.JavaapplicationFactory;
import org.eclipse.modisco.java.discoverer.AbstractDiscoverJavaModelFromProject;
import org.eclipse.modisco.java.discoverer.ElementsToAnalyze;
import org.eclipse.modisco.java.internal.util.JavaUtil;
import org.eclipse.modisco.kdm.source.extension.discovery.AbstractComposedKDMSourceDiscoverer2;
import org.eclipse.modisco.kdm.source.extension.discovery.SourceVisitListener;
import org.eclipse.modisco.omg.kdm.kdm.KDMModel;
import org.eclipse.modisco.omg.kdm.kdm.Segment;
import org.eclipse.modisco.omg.kdm.source.AbstractInventoryElement;
import org.eclipse.modisco.omg.kdm.source.BinaryFile;
import org.eclipse.modisco.omg.kdm.source.InventoryContainer;
import org.eclipse.modisco.omg.kdm.source.InventoryModel;
import org.eclipse.modisco.omg.kdm.source.SourceFile;
import org.eclipse.modisco.omg.kdm.source.util.KDMSourceUtils;

public abstract class AbstractDiscoverKDMSourceAndJavaModel<T>
extends AbstractComposedKDMSourceDiscoverer2<T> {
    private static final String JAVA = "Java";
    private Resource javaModelResource = null;
    private Resource package2DirectoryResource = null;
    private Resource javaAppModelResource = null;
    private Map<Java2Directory, Resource> directoryToResourceFragmentMap = null;
    private Map<CompilationUnit, List<JavaNodeSourceRegion>> cuToRegionsMap = null;
    private Model javaModel = null;
    private Segment kdmModel = null;
    private JavaApplication javaApplication = null;
    private InventoryContainer container = null;
    private IProject fProject = null;
    private ElementsToAnalyze fElementsToAnalyze;
    private boolean fLogJavaAnalysisWarnings = false;
    private boolean fDeepAnalysis = true;
    private boolean fIncrementalMode;
    private String includedElementsRegEx;
    private String excludedElementsRegEx;

    @Parameter(name="ELEMENTS_TO_ANALYZE", description="The Java projects or packages that will be analyzed.")
    public void setElementsToAnalyze(ElementsToAnalyze elementsToAnalyze) {
        this.fElementsToAnalyze = elementsToAnalyze;
    }

    protected ElementsToAnalyze getElementsToAnalyze() {
        return this.fElementsToAnalyze;
    }

    @Parameter(name="LOG_JAVA_ANALYSIS_WARNINGS", description="Whether to log warnings from java analysis.")
    public void setLogJavaAnalysisWarnings(boolean logJavaAnalysisWarnings) {
        this.fLogJavaAnalysisWarnings = logJavaAnalysisWarnings;
    }

    protected boolean isLogJavaAnalysisWarnings() {
        return this.fLogJavaAnalysisWarnings;
    }

    @Parameter(name="DEEP_ANALYSIS", description="If true, analyze method bodies. If false, only analyze fields and method signatures.")
    public void setDeepAnalysis(boolean deepAnalysis) {
        this.fDeepAnalysis = deepAnalysis;
    }

    protected boolean isDeepAnalysis() {
        return this.fDeepAnalysis;
    }

    @Parameter(name="INCREMENTAL_MODE", description="Optimize memory use by analyzing incrementally (more time expensive).")
    public void setIncrementalMode(boolean incrementalMode) {
        this.fIncrementalMode = incrementalMode;
    }

    protected boolean isIncrementalMode() {
        return this.fIncrementalMode;
    }

    @Parameter(name="INCLUDED_ELEMENTS_REGEX", description="A regular expression on qualified names for elements (types & packages) to be included during analysis")
    public void setIncludedElementsRegEx(String includedElementsRegEx) {
        this.includedElementsRegEx = includedElementsRegEx;
    }

    protected String getIncludedElementsRegEx() {
        return this.includedElementsRegEx;
    }

    @Parameter(name="EXCLUDED_ELEMENTS_REGEX", description="A regular expression on qualified names for elements (types & packages) to be excluded during analysis")
    public void setExcludedElementsRegEx(String excludedElementsRegEx) {
        this.excludedElementsRegEx = excludedElementsRegEx;
    }

    protected String getExcludedElementsRegEx() {
        return this.excludedElementsRegEx;
    }

    protected boolean isSerializeKDMResource() {
        return this.isTargetSerializationChosen();
    }

    protected URI getKDMResourceTargetURI() {
        return this.deriveTargetURI(null, null, "_kdm.xmi");
    }

    protected void initializeCompositeModel(T source, IProgressMonitor monitor) {
        if (Activator.getDefault().isDebugging()) {
            System.out.println("--- Starting DiscoverKDMSourceAndJavaModel.initializeCompositeModel ---");
        }
        this.javaApplication = JavaapplicationFactory.eINSTANCE.createJavaApplication();
        this.setKdmSourceModelResource(null);
        this.javaModel = null;
        this.kdmModel = null;
        this.cuToRegionsMap = null;
        this.container = null;
        this.fProject = this.getProject(source);
        String projectName = this.fProject.getProject().getName();
        this.setDefaultTargetURI(URI.createPlatformResourceURI((String)(String.valueOf(projectName) + "/" + projectName + "_java2kdm.xmi"), (boolean)true));
        this.javaAppModelResource = this.getResourceSet().createResource(this.deriveTargetURI(null, null, "_java2kdm.xmi"));
        this.package2DirectoryResource = this.getResourceSet().createResource(this.deriveTargetURI("java2kdmFragments", "Package2Directory", "_java2kdm.xmi"));
        this.javaAppModelResource.getContents().add((Object)this.javaApplication);
    }

    protected abstract IProject getProject(T var1);

    protected void discoverOtherLeafModels(T source, IProgressMonitor monitor) {
        if (Activator.getDefault().isDebugging()) {
            System.out.println("--- Starting DiscoverKDMSourceAndJavaModel.discoverOtherLeafModels ---");
        }
        try {
            this.discoverJavaModel(source, monitor);
        }
        catch (InterruptedException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
    }

    protected void finishBuildingModel(T source, IProgressMonitor monitor) {
        if (Activator.getDefault().isDebugging()) {
            System.out.println("--- Starting DiscoverKDMSourceAndJavaModel.completeModelsBuild ---");
        }
        if (this.javaModelResource != null) {
            this.directoryToResourceFragmentMap = null;
            this.weaveModel();
            this.weaveCompilationUnit();
            this.weaveArchiveFile();
            if (this.isTargetSerializationChosen()) {
                try {
                    this.saveAllResources(monitor);
                }
                catch (IOException e) {
                    MoDiscoLogger.logError((String)e.getMessage(), (Plugin)Activator.getDefault());
                }
            }
            if (this.javaAppModelResource != null) {
                this.setTargetModel(this.javaAppModelResource);
            } else if (Activator.getDefault().isDebugging()) {
                System.out.println("--- Starting JavaAppModelResource = null ---");
            }
        } else {
            if (Activator.getDefault().isDebugging()) {
                System.out.println("--- Starting JavaModelResource = null ---");
            }
            this.javaApplication = null;
            this.javaAppModelResource = null;
        }
        this.doFinally(monitor);
    }

    protected void doFinally(IProgressMonitor monitor) {
        monitor.done();
        this.setKdmSourceModelResource(null);
        this.javaModel = null;
        this.kdmModel = null;
        this.cuToRegionsMap = null;
        this.container = null;
    }

    void discoverJavaModel(T source, IProgressMonitor monitor) throws InterruptedException {
        this.cuToRegionsMap = new HashMap<CompilationUnit, List<JavaNodeSourceRegion>>();
        this.javaModelResource = null;
        monitor.subTask(Messages.DiscoverKDMSourceAndJavaModel_10);
        AbstractDiscoverJavaModelFromProject<T> javaDiscoverer = this.initJavaDiscoverer();
        javaDiscoverer.setDeepAnalysis(this.isDeepAnalysis());
        javaDiscoverer.setElementsToAnalyze(this.getElementsToAnalyze());
        javaDiscoverer.setIncludedElementsRegEx(this.getIncludedElementsRegEx());
        javaDiscoverer.setExcludedElementsRegEx(this.getExcludedElementsRegEx());
        javaDiscoverer.setIncrementalMode(this.isIncrementalMode());
        javaDiscoverer.setLogJavaAnalysisWarnings(this.isLogJavaAnalysisWarnings());
        javaDiscoverer.setSerializeTarget(this.isTargetSerializationChosen());
        javaDiscoverer.setTargetURI(this.deriveTargetURI(null, null, "_java.xmi"));
        javaDiscoverer.addSourceVisitListener(this.initSourceVisitListener());
        try {
            javaDiscoverer.discoverElement(source, monitor);
            this.javaModelResource = javaDiscoverer.getTargetModel();
        }
        catch (Exception e) {
            MoDiscoLogger.logError((Throwable)e, (String)"error discovering Java model", (Plugin)Activator.getDefault());
        }
        if (this.javaModelResource != null) {
            this.getResourceSet().getResources().add((Object)this.javaModelResource);
            if (this.javaModelResource.getURI() == null || this.javaModelResource.getURI().toString().trim().length() == 0) {
                this.javaModelResource.setURI(javaDiscoverer.getDefaultTargetURI());
            }
        } else {
            monitor.setCanceled(true);
        }
    }

    private URI deriveTargetURI(String directory, String filename, String suffix) {
        String baseName = filename;
        URI mainURI = this.getTargetURI();
        if (mainURI == null || mainURI.toString().trim().length() == 0) {
            mainURI = this.getDefaultTargetURI();
        }
        String lastSegment = mainURI.lastSegment();
        if (baseName == null) {
            baseName = lastSegment.endsWith("_java2kdm.xmi") ? lastSegment.substring(0, lastSegment.length() - "_java2kdm.xmi".length()) : (lastSegment.endsWith(".xmi") ? lastSegment.substring(0, lastSegment.length() - ".xmi".length()) : lastSegment);
        }
        mainURI = mainURI.trimSegments(1);
        if (directory != null) {
            mainURI = mainURI.appendSegment(directory);
        }
        return mainURI.appendSegment(String.valueOf(baseName) + suffix);
    }

    protected abstract AbstractDiscoverJavaModelFromProject<T> initJavaDiscoverer();

    protected SourceVisitListener initSourceVisitListener() {
        return new JavaCompositionSourceVisitListener(this.cuToRegionsMap);
    }

    void weaveModel() {
        this.javaApplication.setJavaModel(this.getJavaModel());
        this.javaApplication.setDeploymentModel((InventoryModel)this.getKdmModel().getModel().get(0));
    }

    private InventoryContainer getKDMProjectForWeaving() {
        block4: {
            try {
                if (this.container != null) break block4;
                InventoryModel invent = null;
                for (KDMModel kdmModelTmp : this.getKdmModel().getModel()) {
                    if (!(kdmModelTmp instanceof InventoryModel)) continue;
                    invent = (InventoryModel)kdmModelTmp;
                    break;
                }
                if (invent == null) break block4;
                for (AbstractInventoryElement absInvenElt : invent.getInventoryElement()) {
                    if (!(absInvenElt instanceof InventoryContainer)) continue;
                    this.container = (InventoryContainer)absInvenElt;
                    break;
                }
            }
            catch (NullPointerException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
        return this.container;
    }

    void weaveArchiveFile() {
        ArrayList listBinaryFiles = new ArrayList();
        listBinaryFiles.addAll(KDMSourceUtils.getBinaryFilesFromInventoryModel((InventoryContainer)this.getKDMProjectForWeaving(), null, (boolean)true));
        for (Archive archive : this.getJavaModel().getArchives()) {
            for (BinaryFile binaryFile : listBinaryFiles) {
                if (!binaryFile.getPath().equalsIgnoreCase(archive.getOriginalFilePath())) continue;
                JavaJar2File javaJar2File = JavaapplicationFactory.eINSTANCE.createJavaJar2File();
                javaJar2File.setJavaArchive(archive);
                javaJar2File.setFile(binaryFile);
                this.javaApplication.getJar2FileChildren().add((Object)javaJar2File);
            }
        }
    }

    void weaveCompilationUnit() {
        ArrayList<CompilationUnit> compilationUnitList = new ArrayList<CompilationUnit>();
        for (CompilationUnit cu : this.getJavaModel().getCompilationUnits()) {
            compilationUnitList.add(cu);
        }
        ArrayList<String> filteredFileName = new ArrayList<String>();
        filteredFileName.add("bin");
        ArrayList sourceFileList = new ArrayList();
        sourceFileList.addAll(KDMSourceUtils.getSourceFileFromInventoryModel((InventoryContainer)this.getKDMProjectForWeaving(), filteredFileName, (boolean)true));
        block1: for (CompilationUnit compilationUnit : compilationUnitList) {
            Package pck = AbstractDiscoverKDMSourceAndJavaModel.getPackageFromCU(compilationUnit);
            Java2Directory java2Directory = this.getJava2DirectoryFromPackage(pck);
            if (java2Directory == null) {
                java2Directory = this.manageJava2DirectoryCreation(compilationUnit, pck);
            }
            for (SourceFile sourceFile : sourceFileList) {
                if (!new File(sourceFile.getPath()).equals(new File(compilationUnit.getOriginalFilePath()))) continue;
                Java2File java2File = JavaapplicationFactory.eINSTANCE.createJava2File();
                java2File.setFile(sourceFile);
                sourceFile.setLanguage(JAVA);
                java2File.setUnit((EObject)compilationUnit);
                if (this.cuToRegionsMap.get(compilationUnit) != null) {
                    java2File.getChildren().addAll(this.getAndSortChildren(compilationUnit));
                }
                if (this.getMapJava2DirectoryResource().containsKey(java2Directory)) {
                    this.getMapJava2DirectoryResource().get(java2Directory).getContents().add((Object)java2File);
                } else {
                    String qualifiedName = JavaUtil.getQualifiedName((ASTNode)java2Directory.getJavaPackage());
                    Resource resource = this.getResourceSet().createResource(this.deriveTargetURI("java2kdmFragments", qualifiedName, "_java2kdm.xmi"));
                    resource.getContents().add((Object)java2File);
                    this.getMapJava2DirectoryResource().put(java2Directory, resource);
                }
                java2Directory.getJava2FileChildren().add((Object)java2File);
                continue block1;
            }
        }
    }

    private List<JavaNodeSourceRegion> getAndSortChildren(CompilationUnit compilationUnit) {
        List<JavaNodeSourceRegion> toBeSortedJavaNodeList = this.cuToRegionsMap.get(compilationUnit);
        Comparator<JavaNodeSourceRegion> c = new Comparator<JavaNodeSourceRegion>(){

            @Override
            public int compare(JavaNodeSourceRegion o1, JavaNodeSourceRegion o2) {
                return o1.getStartPosition().compareTo(o2.getStartPosition());
            }
        };
        Collections.sort(toBeSortedJavaNodeList, c);
        return toBeSortedJavaNodeList;
    }

    private Java2Directory getJava2DirectoryFromPackage(Package pck) {
        Java2Directory java2Directory = null;
        if (pck != null) {
            for (EObject object : this.package2DirectoryResource.getContents()) {
                if (!((Java2Directory)object).getJavaPackage().equals(pck)) continue;
                java2Directory = (Java2Directory)object;
                break;
            }
        } else {
            MoDiscoLogger.logWarning((String)"No Package Found", (Plugin)Activator.getDefault());
        }
        return java2Directory;
    }

    private static Package getPackageFromCU(CompilationUnit compilationUnit) {
        Package pck = null;
        for (AbstractTypeDeclaration atd : compilationUnit.getTypes()) {
            pck = atd.getPackage();
            if (pck == null) continue;
            return pck;
        }
        return pck;
    }

    private Java2Directory manageJava2DirectoryCreation(CompilationUnit compilationUnit, Package pck) {
        Java2Directory java2Directory = JavaapplicationFactory.eINSTANCE.createJava2Directory();
        java2Directory.setJavaPackage(pck);
        String directoryPath = compilationUnit.getOriginalFilePath().substring(0, compilationUnit.getOriginalFilePath().lastIndexOf(File.separator));
        java2Directory.getDirectory().add((Object)KDMSourceUtils.getDirectoryByPath((String)directoryPath, (InventoryContainer)this.getKDMProjectForWeaving()));
        this.package2DirectoryResource.getContents().add((Object)java2Directory);
        this.javaApplication.getJava2DirectoryChildren().add((Object)java2Directory);
        return java2Directory;
    }

    protected void saveAllResources(IProgressMonitor monitor) throws IOException {
        monitor.subTask(Messages.DiscoverKDMSourceAndJavaModel_7);
        AbstractDiscoverKDMSourceAndJavaModel.saveResource((Resource)this.getJavaAppModelResource());
        monitor.subTask(Messages.DiscoverKDMSourceAndJavaModel_8);
        AbstractDiscoverKDMSourceAndJavaModel.saveResource((Resource)this.getPackage2DirectoryResource());
        monitor.subTask(Messages.DiscoverKDMSourceAndJavaModel_9);
        for (Resource resource : this.getMapJava2DirectoryResource().values()) {
            AbstractDiscoverKDMSourceAndJavaModel.saveResource((Resource)resource);
        }
    }

    public Model getJavaModel() {
        if (this.javaModel == null) {
            if (this.getJavaModelResource() != null) {
                this.javaModel = (Model)this.getJavaModelResource().getContents().get(0);
            } else {
                throw new IllegalStateException("java model resource should not be null");
            }
        }
        return this.javaModel;
    }

    public Segment getKdmModel() {
        if (this.kdmModel == null) {
            if (this.getKdmSourceModelResource() != null) {
                this.kdmModel = (Segment)this.getKdmSourceModelResource().getContents().get(0);
            } else {
                throw new IllegalStateException("kdm model resource should not be null");
            }
        }
        return this.kdmModel;
    }

    private Map<Java2Directory, Resource> getMapJava2DirectoryResource() {
        if (this.directoryToResourceFragmentMap == null) {
            this.directoryToResourceFragmentMap = new HashMap<Java2Directory, Resource>();
        }
        return this.directoryToResourceFragmentMap;
    }

    public Resource getKdmSourceModelResource() {
        return super.getKdmSourceModelResource();
    }

    public Resource getPackage2DirectoryResource() {
        return this.package2DirectoryResource;
    }

    public Resource getJavaAppModelResource() {
        return this.javaAppModelResource;
    }

    public Map<CompilationUnit, List<JavaNodeSourceRegion>> getCuToRegionsMap() {
        return this.cuToRegionsMap;
    }

    public Resource getJavaModelResource() {
        return this.javaModelResource;
    }

    protected void saveTargetModel() throws IOException {
    }
}

