/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.tests.reqif10.serialization.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xml.namespace.XMLNamespacePackage;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.ReqIF10Package;
import org.eclipse.rmf.reqif10.datatypes.DatatypesPackage;
import org.eclipse.rmf.reqif10.serialization.ReqIF10ResourceFactoryImpl;
import org.eclipse.rmf.reqif10.serialization.ReqIF10ResourceImpl;
import org.eclipse.rmf.reqif10.xhtml.XhtmlPackage;
import org.eclipse.rmf.serialization.XMLPersistenceMappingResourceImpl;
import org.eclipse.rmf.serialization.XMLPersistenceMappingResourceSetImpl;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public abstract class AbstractTestCase {
    protected static final String WORKING_DIRECTORY = "work";
    protected static Map<String, Object> backupRegistry = null;
    protected static XMLPersistenceMappingResourceSetImpl loadXMLPersistenceMappingResourceSet = null;
    protected static XMLPersistenceMappingResourceSetImpl saveXMLPersistenceMappingResourceSet = null;
    static final DateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
    static final DateFormat timeFormat = new SimpleDateFormat("HHmm");

    @BeforeClass
    public static void setupOnce() throws Exception {
        backupRegistry = new HashMap<String, Object>();
        backupRegistry.putAll((Map<String, Object>)EPackage.Registry.INSTANCE);
        EPackage.Registry.INSTANCE.clear();
        EPackage.Registry.INSTANCE.put((Object)"http://www.omg.org/spec/ReqIF/20110401/reqif.xsd", (Object)ReqIF10Package.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.w3.org/1999/xhtml", (Object)XhtmlPackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.w3.org/1999/xhtml/datatypes/", (Object)DatatypesPackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.w3.org/XML/1998/namespace", (Object)XMLNamespacePackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/emf/2002/Ecore", (Object)EcorePackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/emf/2003/XMLType", (Object)XMLTypePackage.eINSTANCE);
        loadXMLPersistenceMappingResourceSet = new XMLPersistenceMappingResourceSetImpl();
        loadXMLPersistenceMappingResourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("reqif", new ReqIF10ResourceFactoryImpl());
        saveXMLPersistenceMappingResourceSet = new XMLPersistenceMappingResourceSetImpl();
        saveXMLPersistenceMappingResourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("reqif", new ReqIF10ResourceFactoryImpl());
    }

    @AfterClass
    public static void tearDownOnce() throws Exception {
        if (backupRegistry != null) {
            EPackage.Registry.INSTANCE.clear();
            EPackage.Registry.INSTANCE.putAll(backupRegistry);
        }
    }

    protected static String getWorkingDirectoryFileName() {
        return WORKING_DIRECTORY;
    }

    protected static String getWorkingFileName(String fileName) {
        return "work/" + fileName;
    }

    protected void validateAgainstSchema(String filename) throws Exception {
        Source[] schemaDocuments = new StreamSource[]{new StreamSource("../org.eclipse.rmf.reqif10/schema/reqif.xsd")};
        StreamSource instanceDocument = new StreamSource(filename);
        LSResourceResolver resolver = new LSResourceResolver(){

            @Override
            public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
                FileInputStream inputStream;
                int slashIndex;
                Object schemaFileName = systemId != null ? (-1 == (slashIndex = systemId.lastIndexOf("/")) ? systemId : (slashIndex == systemId.length() + 1 ? null : systemId.substring(slashIndex))) : null;
                try {
                    inputStream = new FileInputStream("../org.eclipse.rmf.reqif10/schema/" + (String)schemaFileName);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return null;
                }
                return new Input(publicId, systemId, inputStream);
            }
        };
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        sf.setResourceResolver(resolver);
        Schema s = sf.newSchema(schemaDocuments);
        Validator v = s.newValidator();
        v.validate(instanceDocument);
    }

    protected static void saveReqIFFile(EObject reqif, String fileName) throws IOException {
        XMLPersistenceMappingResourceSetImpl resourceSet = AbstractTestCase.getXMLPersistenceMappingResourceSet();
        AbstractTestCase.saveReqIFFile(reqif, fileName, (ResourceSet)resourceSet);
    }

    protected static void saveReqIFFile(EObject reqif, String fileName, ResourceSet resourceSet) throws IOException {
        URI emfURI = AbstractTestCase.createEMFURI(fileName);
        Resource resource = resourceSet.createResource(emfURI);
        AbstractTestCase.populateIdMap((ReqIF10ResourceImpl)resource, reqif);
        resource.getContents().add((Object)reqif);
        resource.save(AbstractTestCase.getSaveOptions());
    }

    private static void populateIdMap(ReqIF10ResourceImpl resource, EObject reqif) {
        TreeIterator all = EcoreUtil.getAllContents((EObject)reqif, (boolean)true);
        while (all.hasNext()) {
            Object id;
            EObject eObject;
            EAttribute idAttribute;
            Object obj = all.next();
            if (!(obj instanceof EObject) || (idAttribute = (eObject = (EObject)obj).eClass().getEIDAttribute()) == null || !((id = eObject.eGet((EStructuralFeature)idAttribute)) instanceof String)) continue;
            resource.getEObjectToIDMap().put(eObject, (String)id);
            resource.getIDToEObjectMap().put((String)id, eObject);
        }
    }

    protected static ReqIF loadReqIFFile(String fileName) throws IOException {
        XMLPersistenceMappingResourceSetImpl resourceSet = AbstractTestCase.getXMLPersistenceMappingResourceSet();
        return AbstractTestCase.loadReqIFFile(fileName, false, (ResourceSet)resourceSet);
    }

    protected static ReqIF loadReqIFFile(String fileName, ResourceSet resourceSet) throws IOException {
        return AbstractTestCase.loadReqIFFile(fileName, false, resourceSet);
    }

    protected static XMLPersistenceMappingResourceSetImpl getXMLPersistenceMappingResourceSet() {
        XMLPersistenceMappingResourceSetImpl xmlPersistenceMappingResourceSet = new XMLPersistenceMappingResourceSetImpl();
        xmlPersistenceMappingResourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("reqif", new ReqIF10ResourceFactoryImpl());
        return xmlPersistenceMappingResourceSet;
    }

    protected static ReqIF loadReqIFFile(String fileName, boolean validateOnLoad, ResourceSet resourceSet) throws IOException {
        return (ReqIF)AbstractTestCase.loadFile(fileName, validateOnLoad, resourceSet);
    }

    protected static EObject loadFile(String fileName, boolean validateOnLoad, ResourceSet resourceSet) throws IOException {
        URI emfURI = AbstractTestCase.createEMFURI(fileName);
        XMLPersistenceMappingResourceImpl resource = (XMLPersistenceMappingResourceImpl)resourceSet.createResource(emfURI);
        if (validateOnLoad) {
            resource.enableSchemaValidation = true;
            resource.initDefaultOptions();
            resource.enableSchemaValidation = false;
        }
        resource.load(null);
        EList rootObjects = resource.getContents();
        if (rootObjects.isEmpty()) {
            return null;
        }
        return (EObject)rootObjects.get(0);
    }

    protected static URI createEMFURI(String fileName) {
        return URI.createURI((String)fileName, (boolean)true);
    }

    protected static String getReferenceDataFileName(String testCaseId, boolean isArchive) {
        return AbstractTestCase.getFileName(testCaseId, 0, 10, "Reference", isArchive);
    }

    protected static String getFirstExportFileName(String testCaseId, boolean isArchive) {
        return AbstractTestCase.getFileName(testCaseId, 1, 21, "EclipseRMF", isArchive);
    }

    private static String getFileName(String testCaseId, int numberOfExports, int testStep, String tool, boolean isArchive) {
        Date now = new Date();
        String dateString = dateFormat.format(now);
        String timeString = timeFormat.format(now);
        String creatorName = System.getProperty("user.name");
        if (creatorName == null || "".equals(creatorName)) {
            creatorName = "RMFUser";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(testCaseId);
        stringBuffer.append("_");
        stringBuffer.append("E");
        stringBuffer.append(String.format("%04d", numberOfExports));
        stringBuffer.append("_");
        stringBuffer.append("S");
        stringBuffer.append(String.format("%02d", testStep));
        stringBuffer.append("_");
        stringBuffer.append(tool);
        stringBuffer.append("_");
        stringBuffer.append(dateString);
        stringBuffer.append("_");
        stringBuffer.append(timeString);
        stringBuffer.append("_");
        stringBuffer.append(creatorName);
        stringBuffer.append(".");
        if (isArchive) {
            stringBuffer.append("reqifz");
        } else {
            stringBuffer.append("reqif");
        }
        return stringBuffer.toString();
    }

    public static List<ReqIF> loadReqIFFromZip(String zipSourceFileName, ResourceSetImpl resourceSet) throws IOException, URISyntaxException {
        ZipFile zipSourceFile = new ZipFile(zipSourceFileName);
        ArrayList<ReqIF> reqIFs = new ArrayList<ReqIF>();
        Enumeration<? extends ZipEntry> zipFileEntries = zipSourceFile.entries();
        while (zipFileEntries.hasMoreElements()) {
            ZipEntry entry = zipFileEntries.nextElement();
            if (entry.isDirectory() || !entry.getName().endsWith(".reqif")) continue;
            File zipFile = new File(zipSourceFileName);
            String absoluteZipFilePath = zipFile.getAbsolutePath();
            URI uri = URI.createURI((String)("archive:file:" + absoluteZipFilePath + "!/" + entry.getName()));
            Resource resource = resourceSet.createResource(uri);
            resource.load(null);
            EList rootObjects = resource.getContents();
            if (rootObjects.size() <= 0) continue;
            reqIFs.add((ReqIF)rootObjects.get(0));
        }
        zipSourceFile.close();
        return reqIFs;
    }

    public static void saveReqIFsToZip(List<ReqIF> reqIFs, String zipFileName, ResourceSetImpl resourceSet) throws IOException {
        int lastSlashIndex;
        for (ReqIF reqIF : reqIFs) {
            XMLPersistenceMappingResourceImpl resource = new XMLPersistenceMappingResourceImpl();
            resource.getContents().add((Object)reqIF);
            resourceSet.getResources().add((Object)resource);
        }
        int lastDotIndex = zipFileName.lastIndexOf(".");
        String entryName = zipFileName;
        if (lastDotIndex > 0) {
            entryName = zipFileName.substring(0, lastDotIndex);
        }
        if ((lastSlashIndex = entryName.lastIndexOf("/")) > 0) {
            entryName = entryName.substring(lastSlashIndex + 1);
        }
        FileOutputStream fileOutputStream = new FileOutputStream(zipFileName);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream));
        int i = 0;
        while (i < resourceSet.getResources().size()) {
            Resource resource = (Resource)resourceSet.getResources().get(i);
            ZipEntry zipEntry = new ZipEntry(String.valueOf(entryName) + "_" + i + ".reqif");
            zipOutputStream.putNextEntry(zipEntry);
            resource.save((OutputStream)zipOutputStream, AbstractTestCase.getSaveOptions());
            ++i;
        }
        zipOutputStream.close();
    }

    protected static Map<Object, Object> getSaveOptions() {
        HashMap<Object, Object> options = new HashMap<Object, Object>();
        options.put("namespace to prefix map", AbstractTestCase.getNamespaceToPrefixMap());
        return options;
    }

    protected static Map<String, String> getNamespaceToPrefixMap() {
        HashMap<String, String> namespaceToPrefixMap = new HashMap<String, String>();
        namespaceToPrefixMap.put("http://www.omg.org/spec/ReqIF/20110401/reqif.xsd", "");
        return namespaceToPrefixMap;
    }

    public class Input
    implements LSInput {
        private String publicId;
        private String systemId;
        private BufferedInputStream inputStream;

        @Override
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public void setPublicId(String publicId) {
            this.publicId = publicId;
        }

        @Override
        public String getBaseURI() {
            return null;
        }

        @Override
        public InputStream getByteStream() {
            return null;
        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public Reader getCharacterStream() {
            return null;
        }

        @Override
        public String getEncoding() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getStringData() {
            BufferedInputStream bufferedInputStream = this.inputStream;
            synchronized (bufferedInputStream) {
                try {
                    byte[] input = new byte[this.inputStream.available()];
                    this.inputStream.read(input);
                    String contents = new String(input);
                    return contents;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.out.println("Exception " + e);
                    return null;
                }
            }
        }

        @Override
        public void setBaseURI(String baseURI) {
        }

        @Override
        public void setByteStream(InputStream byteStream) {
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
        }

        @Override
        public void setEncoding(String encoding) {
        }

        @Override
        public void setStringData(String stringData) {
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }

        @Override
        public void setSystemId(String systemId) {
            this.systemId = systemId;
        }

        public BufferedInputStream getInputStream() {
            return this.inputStream;
        }

        public void setInputStream(BufferedInputStream inputStream) {
            this.inputStream = inputStream;
        }

        public Input(String publicId, String sysId, InputStream input) {
            this.publicId = publicId;
            this.systemId = sysId;
            this.inputStream = new BufferedInputStream(input);
        }
    }
}

