/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.tests.serialization.util;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.sphinx.emf.serialization.XMLPersistenceMappingResourceSetImpl;
import org.junit.Assert;
import org.junit.Before;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTestCase {
    @Before
    public void setUp() throws Exception {
    }

    protected EObject loadInputFile(String inputFileName, ResourceFactoryImpl resourceFactory, Map<?, ?> options) throws Exception {
        URI emfURI = URI.createURI((String)("resources/input/" + inputFileName), (boolean)true);
        XMLResource resource = (XMLResource)resourceFactory.createResource(emfURI);
        resource.load(options);
        XMLPersistenceMappingResourceSetImpl resourceSet = new XMLPersistenceMappingResourceSetImpl();
        resourceSet.getResources().add((Object)resource);
        Assert.assertSame((Object)0, (Object)resource.getErrors().size());
        return (EObject)resource.getContents().get(0);
    }

    protected String loadFileAsString(InputStream inputStream) throws Exception {
        inputStream = new BufferedInputStream(inputStream);
        try {
            int bufferLength;
            byte[] buffer = new byte[1024];
            StringBuilder content = new StringBuilder();
            while ((bufferLength = inputStream.read(buffer)) > -1) {
                content.append(new String(buffer, 0, bufferLength));
            }
            String string = content.toString();
            return string;
        }
        finally {
            inputStream.close();
        }
    }

    protected String loadWorkingFileAsString(String fileName) throws Exception {
        URI emfURI = URI.createURI((String)("working-dir/" + fileName), (boolean)true);
        return this.loadFileAsString(URIConverter.INSTANCE.createInputStream(emfURI));
    }

    protected String loadInputFileAsString(String fileName) throws Exception {
        URI emfURI = URI.createURI((String)("resources/input" + fileName), (boolean)true);
        return this.loadFileAsString(URIConverter.INSTANCE.createInputStream(emfURI));
    }

    protected void saveWorkingFile(String fileName, EObject modelRoot, ResourceFactoryImpl resourceFactory, Map<?, ?> options) throws Exception {
        URI emfURI = URI.createURI((String)("working-dir/" + fileName), (boolean)true);
        XMLResource resource = (XMLResource)resourceFactory.createResource(emfURI);
        resource.getContents().add((Object)modelRoot);
        resource.save(options);
        Assert.assertSame((Object)0, (Object)resource.getErrors().size());
    }
}

