/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.logging;

import java.util.Locale;
import org.slf4j.event.Level;

public enum JettyLevel {
    ALL(Level.TRACE.toInt() - 10),
    TRACE(Level.TRACE),
    DEBUG(Level.DEBUG),
    INFO(Level.INFO),
    WARN(Level.WARN),
    ERROR(Level.ERROR),
    OFF(Level.ERROR.toInt() + 1);

    private final Level level;
    private final int levelInt;

    private JettyLevel(Level level) {
        this.level = level;
        this.levelInt = level.toInt();
    }

    private JettyLevel(int i) {
        this.level = null;
        this.levelInt = i;
    }

    public static JettyLevel fromLevel(Level slf4jLevel) {
        for (JettyLevel level : JettyLevel.values()) {
            if (slf4jLevel.toInt() != level.levelInt) continue;
            return level;
        }
        return OFF;
    }

    public int toInt() {
        return this.levelInt;
    }

    public Level toLevel() {
        return this.level;
    }

    public boolean includes(JettyLevel testLevel) {
        return this.levelInt <= testLevel.levelInt;
    }

    public String toString() {
        return this.name();
    }

    public static JettyLevel intToLevel(int levelInt) {
        for (JettyLevel level : JettyLevel.values()) {
            if (levelInt > level.levelInt) continue;
            return level;
        }
        return OFF;
    }

    public static JettyLevel strToLevel(String levelStr) {
        if (levelStr == null) {
            return null;
        }
        String levelName = levelStr.trim().toUpperCase(Locale.ENGLISH);
        for (JettyLevel level : JettyLevel.values()) {
            if (!level.name().equals(levelName)) continue;
            return level;
        }
        return null;
    }
}

