/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.rap.rwt.internal.textsize.TextSizeUtil;
import org.eclipse.rap.rwt.theme.BoxDimensions;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.widgets.ILinkAdapter;
import org.eclipse.swt.internal.widgets.linkkit.LinkLCA;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TypedListener;

public class Link
extends Control {
    private String text = "";
    private String displayText = "";
    private Point[] offsets;
    private String[] ids;
    private int[] mnemonics;
    private transient ILinkAdapter linkAdapter;

    public Link(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    void initState() {
        this.addState(256);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        if (!string.equals(this.text)) {
            this.displayText = this.parse(string);
            this.text = string;
        }
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if (this.displayText.length() > 0) {
            String string = Link.escapeAmpersand(this.displayText);
            Point extent = TextSizeUtil.textExtent(this.getFont(), string, wHint);
            width = extent.x;
            height = extent.y;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        BoxDimensions border = this.getBorder();
        BoxDimensions padding = this.getPadding();
        return new Point(width += border.left + border.right + padding.left + padding.right, height += border.top + border.bottom + padding.top + padding.bottom);
    }

    private static String escapeAmpersand(String string) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < string.length()) {
            if (string.charAt(i) == '&') {
                result.append("&&");
            } else {
                result.append(string.charAt(i));
            }
            ++i;
        }
        return result.toString();
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == ILinkAdapter.class) {
            if (this.linkAdapter == null) {
                this.linkAdapter = new ILinkAdapter(){

                    @Override
                    public String getDisplayText() {
                        return Link.this.displayText;
                    }

                    @Override
                    public Point[] getOffsets() {
                        return Link.this.offsets;
                    }

                    @Override
                    public String[] getIds() {
                        return Link.this.ids;
                    }
                };
            }
            return (T)this.linkAdapter;
        }
        if (adapter == WidgetLCA.class) {
            return (T)LinkLCA.INSTANCE;
        }
        return super.getAdapter(adapter);
    }

    @Override
    boolean isTabGroup() {
        return true;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    String parse(String string) {
        int length = string.length();
        this.offsets = new Point[length / 4];
        this.ids = new String[length / 4];
        this.mnemonics = new int[length / 4 + 1];
        StringBuffer result = new StringBuffer();
        char[] buffer = new char[length];
        string.getChars(0, string.length(), buffer, 0);
        int index = 0;
        int state = 0;
        int linkIndex = 0;
        int start = 0;
        int tagStart = 0;
        int linkStart = 0;
        int endtagStart = 0;
        int refStart = 0;
        while (index < length) {
            char c = Character.toLowerCase(buffer[index]);
            block0 : switch (state) {
                case 0: {
                    if (c != '<') break;
                    tagStart = index;
                    ++state;
                    break;
                }
                case 1: {
                    if (c != 'a') break;
                    ++state;
                    break;
                }
                case 2: {
                    switch (c) {
                        case 'h': {
                            state = 7;
                            break block0;
                        }
                        case '>': {
                            linkStart = index + 1;
                            ++state;
                            break block0;
                        }
                    }
                    if (Character.isWhitespace(c)) break;
                    state = 13;
                    break;
                }
                case 3: {
                    if (c != '<') break;
                    endtagStart = index;
                    ++state;
                    break;
                }
                case 4: {
                    state = c == '/' ? state + 1 : 3;
                    break;
                }
                case 5: {
                    state = c == 'a' ? state + 1 : 3;
                    break;
                }
                case 6: {
                    if (c == '>') {
                        this.mnemonics[linkIndex] = this.parseMnemonics(buffer, start, tagStart, result);
                        int offset = result.length();
                        this.parseMnemonics(buffer, linkStart, endtagStart, result);
                        this.offsets[linkIndex] = new Point(offset, result.length() - 1);
                        if (this.ids[linkIndex] == null) {
                            this.ids[linkIndex] = new String(buffer, linkStart, endtagStart - linkStart);
                        }
                        ++linkIndex;
                        endtagStart = refStart = index + 1;
                        linkStart = refStart;
                        tagStart = refStart;
                        start = refStart;
                        state = 0;
                        break;
                    }
                    state = 3;
                    break;
                }
                case 7: {
                    state = c == 'r' ? state + 1 : 0;
                    break;
                }
                case 8: {
                    state = c == 'e' ? state + 1 : 0;
                    break;
                }
                case 9: {
                    state = c == 'f' ? state + 1 : 0;
                    break;
                }
                case 10: {
                    state = c == '=' ? state + 1 : 0;
                    break;
                }
                case 11: {
                    if (c == '\"') {
                        ++state;
                        refStart = index + 1;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 12: {
                    if (c != '\"') break;
                    this.ids[linkIndex] = new String(buffer, refStart, index - refStart);
                    state = 2;
                    break;
                }
                case 13: {
                    if (Character.isWhitespace(c)) {
                        state = 0;
                        break;
                    }
                    if (c != '=') break;
                    ++state;
                    break;
                }
                case 14: {
                    state = c == '\"' ? state + 1 : 0;
                    break;
                }
                case 15: {
                    if (c != '\"') break;
                    state = 2;
                    break;
                }
                default: {
                    state = 0;
                }
            }
            ++index;
        }
        if (start < length) {
            int tmp = this.parseMnemonics(buffer, start, tagStart, result);
            int mnemonic = this.parseMnemonics(buffer, Math.max(tagStart, linkStart), length, result);
            if (mnemonic == -1) {
                mnemonic = tmp;
            }
            this.mnemonics[linkIndex] = mnemonic;
        } else {
            this.mnemonics[linkIndex] = -1;
        }
        if (this.offsets.length != linkIndex) {
            Point[] newOffsets = new Point[linkIndex];
            System.arraycopy(this.offsets, 0, newOffsets, 0, linkIndex);
            this.offsets = newOffsets;
            String[] newIDs = new String[linkIndex];
            System.arraycopy(this.ids, 0, newIDs, 0, linkIndex);
            this.ids = newIDs;
            int[] newMnemonics = new int[linkIndex + 1];
            System.arraycopy(this.mnemonics, 0, newMnemonics, 0, linkIndex + 1);
            this.mnemonics = newMnemonics;
        }
        return result.toString();
    }

    int parseMnemonics(char[] buffer, int start, int end, StringBuffer result) {
        int mnemonic = -1;
        int index = start;
        while (index < end) {
            if (buffer[index] == '&') {
                if (index + 1 < end && buffer[index + 1] == '&') {
                    result.append(buffer[index]);
                    ++index;
                } else {
                    mnemonic = result.length();
                }
            } else {
                result.append(buffer[index]);
            }
            ++index;
        }
        return mnemonic;
    }
}

