/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.internal;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritePendingException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.ComplianceViolation;
import org.eclipse.jetty.http.HostPortHttpField;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.Trailers;
import org.eclipse.jetty.http.UriCompliance;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.server.AbstractMetaDataConnection;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.ConnectionMetaData;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpStream;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.TunnelSupport;
import org.eclipse.jetty.server.internal.HttpChannelState;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.HostPort;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnection
extends AbstractMetaDataConnection
implements Runnable,
Connection.UpgradeFrom,
Connection.UpgradeTo,
Connection.Tunnel,
ConnectionMetaData {
    private static final Logger LOG = LoggerFactory.getLogger(HttpConnection.class);
    private static final HttpField PREAMBLE_UPGRADE_H2C = new HttpField(HttpHeader.UPGRADE, "h2c");
    private static final ThreadLocal<HttpConnection> __currentConnection = new ThreadLocal();
    private static final AtomicLong __connectionIdGenerator = new AtomicLong();
    private final Callback _fillableCallback = new FillableCallback();
    private final TunnelSupport _tunnelSupport = new TunnelSupportOverHTTP1();
    private final AtomicLong _streamIdGenerator = new AtomicLong();
    private final long _id;
    private final HttpChannel _httpChannel;
    private final RequestHandler _requestHandler;
    private final HttpParser _parser;
    private final HttpGenerator _generator;
    private final ByteBufferPool _bufferPool;
    private final AtomicReference<HttpStreamOverHTTP1> _stream = new AtomicReference();
    private final Attributes.Lazy _attributes = new Attributes.Lazy();
    private final DemandContentCallback _demandContentCallback = new DemandContentCallback();
    private final SendCallback _sendCallback = new SendCallback();
    private final AtomicBoolean _handling = new AtomicBoolean(false);
    private final HttpFields.Mutable _headerBuilder = HttpFields.build();
    private final int _minBufferSpace;
    private volatile RetainableByteBuffer _requestBuffer;
    private HttpFields.Mutable _trailers;
    private Runnable _onRequest;
    private final AtomicLong _requests = new AtomicLong();
    private final AtomicLong _responses = new AtomicLong();
    private final AtomicLong _bytesIn = new AtomicLong();
    private final AtomicLong _bytesOut = new AtomicLong();

    public static HttpConnection getCurrentConnection() {
        return __currentConnection.get();
    }

    protected static HttpConnection setCurrentConnection(HttpConnection connection) {
        HttpConnection last = __currentConnection.get();
        __currentConnection.set(connection);
        return last;
    }

    public HttpConnection(HttpConfiguration configuration, Connector connector, EndPoint endPoint) {
        super(connector, configuration, endPoint);
        this._id = __connectionIdGenerator.getAndIncrement();
        this._bufferPool = connector.getByteBufferPool();
        this._generator = this.newHttpGenerator();
        this._httpChannel = this.newHttpChannel(connector.getServer(), configuration);
        this._requestHandler = this.newRequestHandler();
        this._parser = this.newHttpParser(configuration.getHttpCompliance());
        int n = this._minBufferSpace = configuration.getMinInputBufferSpace() < 0 ? Math.min(1500, configuration.getInputBufferSize()) : configuration.getMinInputBufferSpace();
        if (LOG.isDebugEnabled()) {
            LOG.debug("New HTTP Connection {}", (Object)this);
        }
    }

    protected HttpGenerator newHttpGenerator() {
        return new HttpGenerator();
    }

    protected HttpParser newHttpParser(HttpCompliance compliance) {
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)this._requestHandler, this.getHttpConfiguration().getRequestHeaderSize(), compliance);
        parser.setHeaderCacheSize(this.getHttpConfiguration().getHeaderCacheSize());
        parser.setHeaderCacheCaseSensitive(this.getHttpConfiguration().isHeaderCacheCaseSensitive());
        return parser;
    }

    protected HttpChannel newHttpChannel(Server server, HttpConfiguration configuration) {
        return new HttpChannelState(this);
    }

    protected HttpStreamOverHTTP1 newHttpStream(String method, String uri, HttpVersion version) {
        return new HttpStreamOverHTTP1(method, uri, version);
    }

    protected RequestHandler newRequestHandler() {
        return new RequestHandler();
    }

    public Server getServer() {
        return this.getConnector().getServer();
    }

    public HttpChannel getHttpChannel() {
        return this._httpChannel;
    }

    public HttpParser getParser() {
        return this._parser;
    }

    public HttpGenerator getGenerator() {
        return this._generator;
    }

    @Override
    public String getId() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getRemoteSocketAddress()).append('@');
        try {
            TypeUtil.toHex((int)this.hashCode(), (Appendable)builder);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        builder.append('#').append(this._id);
        return builder.toString();
    }

    @Override
    public HttpVersion getHttpVersion() {
        HttpStreamOverHTTP1 stream = this._stream.get();
        return stream != null ? stream._version : HttpVersion.HTTP_1_1;
    }

    @Override
    public String getProtocol() {
        return this.getHttpVersion().asString();
    }

    @Override
    public boolean isPersistent() {
        return this._generator.isPersistent(this.getHttpVersion());
    }

    public Object removeAttribute(String name) {
        return this._attributes.removeAttribute(name);
    }

    public Object setAttribute(String name, Object attribute) {
        return this._attributes.setAttribute(name, attribute);
    }

    public Object getAttribute(String name) {
        return this._attributes.getAttribute(name);
    }

    public Set<String> getAttributeNameSet() {
        return this._attributes.getAttributeNameSet();
    }

    public void clearAttributes() {
        this._attributes.clearAttributes();
    }

    public long getMessagesIn() {
        return this._requests.get();
    }

    public long getMessagesOut() {
        return this._responses.get();
    }

    public boolean isUseInputDirectByteBuffers() {
        return this.getHttpConfiguration().isUseInputDirectByteBuffers();
    }

    @Deprecated(forRemoval=true, since="12.1.0")
    public void setUseInputDirectByteBuffers(boolean useInputDirectByteBuffers) {
        this.getHttpConfiguration().setUseInputDirectByteBuffers(useInputDirectByteBuffers);
    }

    public boolean isUseOutputDirectByteBuffers() {
        return this.getHttpConfiguration().isUseOutputDirectByteBuffers();
    }

    @Deprecated(forRemoval=true, since="12.1.0")
    public void setUseOutputDirectByteBuffers(boolean useOutputDirectByteBuffers) {
        this.getHttpConfiguration().setUseOutputDirectByteBuffers(useOutputDirectByteBuffers);
    }

    public ByteBuffer onUpgradeFrom() {
        if (this.isRequestBufferEmpty()) {
            return null;
        }
        ByteBuffer unconsumed = ByteBuffer.allocateDirect(this._requestBuffer.remaining());
        unconsumed.put(this._requestBuffer.getByteBuffer());
        unconsumed.flip();
        return unconsumed;
    }

    public void onUpgradeTo(ByteBuffer buffer) {
        this.ensureRequestBuffer();
        BufferUtil.append((ByteBuffer)this._requestBuffer.getByteBuffer(), (ByteBuffer)buffer);
    }

    public void startTunnel() {
        this.getParser().startTunnel();
        this.getGenerator().startTunnel();
    }

    void releaseRequestBuffer() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("releasing request buffer {} {}", (Object)this._requestBuffer, (Object)this);
        }
        RetainableByteBuffer buffer = this._requestBuffer;
        this._requestBuffer = null;
        if (buffer != null) {
            buffer.release();
        }
    }

    private void ensureRequestBuffer() {
        if (this._requestBuffer == null) {
            this._requestBuffer = this._bufferPool.acquire(this.getInputBufferSize(), this.isUseInputDirectByteBuffers());
            if (LOG.isDebugEnabled()) {
                LOG.debug("request buffer acquired {} {}", (Object)this._requestBuffer, (Object)this);
            }
        }
    }

    public boolean isRequestBufferEmpty() {
        return this._requestBuffer == null || !this._requestBuffer.hasRemaining();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFillable() {
        HttpConnection last;
        block34: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("onFillable enter {} {} {}", new Object[]{this._httpChannel, this._requestBuffer, this});
            }
            last = HttpConnection.setCurrentConnection(this);
            try {
                this.ensureRequestBuffer();
                while (true) {
                    int filled;
                    if (this.isRequestBufferEmpty()) {
                        filled = this.fillRequestBuffer(true);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("onFillable filled {} {} {} {}", new Object[]{filled, this._httpChannel, this._requestBuffer, this});
                        }
                        if (filled < 0 && this.getEndPoint().isOutputShutdown()) {
                            this.close();
                        }
                    } else {
                        filled = 0;
                    }
                    boolean handle = this.parseRequestBuffer();
                    if (this.getEndPoint().getConnection() != this) {
                        this.releaseRequestBuffer();
                        break block34;
                    }
                    if (handle) {
                        Request request = this._httpChannel.getRequest();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("HANDLE {} {}", (Object)request, (Object)this);
                        }
                        if (this.isRequestBufferEmpty() && !this._parser.hasContent()) {
                            this.parseRequestBuffer();
                            if (this._parser.isComplete()) {
                                this.releaseRequestBuffer();
                            }
                        }
                        this._handling.set(true);
                        Runnable onRequest = this._onRequest;
                        this._onRequest = null;
                        onRequest.run();
                        if (this._handling.compareAndSet(true, false)) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("request !complete {} {} {}", new Object[]{request, this._requestBuffer, this});
                            }
                        } else if (this.getEndPoint().getConnection() != this) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("upgraded {} -> {}", (Object)this, (Object)this.getEndPoint().getConnection());
                            }
                            if (this._requestBuffer != null) {
                                this.releaseRequestBuffer();
                            }
                        } else {
                            if (this._requestBuffer != null) continue;
                            this.fillInterested(this._fillableCallback);
                        }
                        break block34;
                    }
                    if (filled == 0) {
                        assert (this.isRequestBufferEmpty());
                        this.releaseRequestBuffer();
                        this.fillInterested(this._fillableCallback);
                        break block34;
                    }
                    if (filled < 0) {
                        assert (this.isRequestBufferEmpty());
                        this.releaseRequestBuffer();
                        this.getEndPoint().shutdownOutput();
                        break block34;
                    }
                    if (this._requestHandler._failure != null) break;
                }
                this.releaseRequestBuffer();
            }
            catch (Throwable x) {
                try {
                    try {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("caught exception {} {}", new Object[]{this, this._httpChannel, x});
                        }
                        if (this._requestBuffer != null) {
                            this.releaseRequestBuffer();
                        }
                    }
                    finally {
                        this.getEndPoint().close(x);
                    }
                }
                catch (Throwable throwable) {
                    HttpConnection.setCurrentConnection(last);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("onFillable exit {} {} {}", new Object[]{this._httpChannel, this._requestBuffer, this});
                    }
                    throw throwable;
                }
                HttpConnection.setCurrentConnection(last);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("onFillable exit {} {} {}", new Object[]{this._httpChannel, this._requestBuffer, this});
                }
            }
        }
        HttpConnection.setCurrentConnection(last);
        if (LOG.isDebugEnabled()) {
            LOG.debug("onFillable exit {} {} {}", new Object[]{this._httpChannel, this._requestBuffer, this});
        }
    }

    void parseAndFillForContent() {
        this.ensureRequestBuffer();
        while (this._parser.inContentState() && !this.parseRequestBuffer() && this._parser.inContentState()) {
            int filled;
            assert (!this._requestBuffer.hasRemaining());
            boolean compact = true;
            if (this._requestBuffer.isRetained()) {
                ByteBuffer backing = this._requestBuffer.getByteBuffer();
                if (this._minBufferSpace > 0 && BufferUtil.space((ByteBuffer)backing) >= this._minBufferSpace) {
                    compact = false;
                } else {
                    this.releaseRequestBuffer();
                    this.ensureRequestBuffer();
                }
            }
            if ((filled = this.fillRequestBuffer(compact)) > 0) continue;
            if (filled < 0 || !this._requestBuffer.isRetained()) {
                this.releaseRequestBuffer();
            }
            if (filled >= 0) break;
            this._parser.parseNext(BufferUtil.EMPTY_BUFFER);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int fillRequestBuffer(boolean compact) {
        int padding = 0;
        ByteBuffer requestBuffer = this._requestBuffer.getByteBuffer();
        try {
            int filled;
            if (!compact) {
                padding = requestBuffer.limit();
                requestBuffer.position(0);
            }
            if ((filled = this.getEndPoint().fill(requestBuffer)) == 0) {
                filled = this.getEndPoint().fill(requestBuffer);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("filled {} {} {}", new Object[]{filled, this._requestBuffer, this});
            }
            if (filled > 0) {
                this._bytesIn.addAndGet(filled);
            } else if (filled < 0) {
                this._parser.atEOF();
            }
            int n = filled;
            return n;
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unable to fill from endpoint {}", (Object)this.getEndPoint(), (Object)x);
            }
            this._parser.atEOF();
            int n = -1;
            return n;
        }
        finally {
            if (!compact && padding > 0) {
                requestBuffer.position(padding);
            }
        }
    }

    private boolean parseRequestBuffer() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("parse {} {}", (Object)this._requestBuffer, (Object)this);
        }
        if (this._parser.isTerminated()) {
            throw new UncheckedIOException(new IOException("Parser is terminated"));
        }
        boolean handle = this._parser.parseNext(this._requestBuffer.getByteBuffer());
        if (LOG.isDebugEnabled()) {
            LOG.debug("parsed {} {} {} {}", new Object[]{handle, this._parser, this._requestBuffer, this});
        }
        return handle;
    }

    private boolean upgrade(HttpStreamOverHTTP1 stream) {
        if (stream.upgrade()) {
            this._httpChannel.recycle();
            this._parser.close();
            this._generator.reset();
            return true;
        }
        return false;
    }

    public void onFillInterestedFailed(Throwable cause) {
        this._parser.close();
        super.onFillInterestedFailed(cause);
    }

    public boolean onIdleExpired(TimeoutException timeout) {
        HttpChannel.IdleTimeoutTask task = this._httpChannel.onIdleTimeout(timeout);
        boolean handlingRequest = task.handlingRequest();
        if (handlingRequest) {
            ThreadPool.executeImmediately((Executor)this.getExecutor(), (Runnable)task.action());
        }
        return !handlingRequest;
    }

    public void close() {
        try {
            Runnable task = this._httpChannel.onClose();
            if (task != null) {
                task.run();
            }
        }
        finally {
            super.close();
        }
    }

    public void onOpen() {
        super.onOpen();
        if (this.isRequestBufferEmpty()) {
            this.fillInterested(this._fillableCallback);
        } else {
            this.getExecutor().execute(this);
        }
    }

    @Override
    public void run() {
        this.onFillable();
    }

    public void asyncReadFillInterested() {
        this.tryFillInterested(this._demandContentCallback);
    }

    public long getBytesIn() {
        return this._bytesIn.get();
    }

    public long getBytesOut() {
        return this._bytesOut.get();
    }

    public String toConnectionString() {
        return String.format("%s@%x[p=%s,g=%s]=>%s", TypeUtil.toShortName(this.getClass()), this.hashCode(), this._parser, this._generator, this._httpChannel);
    }

    private class FillableCallback
    implements Callback {
        private final Invocable.InvocationType _invocationType;

        private FillableCallback() {
            this._invocationType = HttpConnection.this.getServer().getInvocationType();
        }

        public void succeeded() {
            HttpConnection.this.onFillable();
        }

        public void failed(Throwable x) {
            HttpConnection.this.onFillInterestedFailed(x);
        }

        public Invocable.InvocationType getInvocationType() {
            return this._invocationType;
        }
    }

    private class TunnelSupportOverHTTP1
    implements TunnelSupport {
        private TunnelSupportOverHTTP1() {
        }

        @Override
        public String getProtocol() {
            return null;
        }

        @Override
        public EndPoint getEndPoint() {
            return HttpConnection.this.getEndPoint();
        }
    }

    private class DemandContentCallback
    implements Callback {
        private DemandContentCallback() {
        }

        public void succeeded() {
            Runnable task = HttpConnection.this._httpChannel.onContentAvailable();
            if (LOG.isDebugEnabled()) {
                LOG.debug("demand succeeded {}", (Object)task);
            }
            if (task != null) {
                task.run();
            }
        }

        public void failed(Throwable x) {
            Runnable task = HttpConnection.this._httpChannel.onFailure(x);
            if (LOG.isDebugEnabled()) {
                LOG.debug("demand failed {}", (Object)task, (Object)x);
            }
            ThreadPool.executeImmediately((Executor)HttpConnection.this.getConnector().getExecutor(), (Runnable)task);
        }

        public Invocable.InvocationType getInvocationType() {
            return Invocable.getInvocationType((Object)HttpConnection.this._httpChannel);
        }
    }

    private class SendCallback
    extends IteratingCallback {
        private MetaData.Response _info;
        private boolean _head;
        private ByteBuffer _content;
        private boolean _lastContent;
        private Callback _callback;
        private RetainableByteBuffer _header;
        private RetainableByteBuffer _chunk;
        private boolean _shutdownOut;

        private SendCallback() {
            super(true);
        }

        public Callback cancel(Throwable cause) {
            CancelSendException cancelSendException = new CancelSendException(cause);
            if (!this.abort(cancelSendException)) {
                return Callback.NOOP;
            }
            Callback senderCallback = HttpConnection.this.getEndPoint().cancelWrite(cause);
            if (senderCallback == null) {
                cancelSendException.complete();
            } else {
                senderCallback.failed(cause);
            }
            return cancelSendException.join();
        }

        protected void onAborted(Throwable cause) {
            if (cause instanceof CancelSendException) {
                CancelSendException cancelSend = (CancelSendException)cause;
                cancelSend.setCallback(this.takeCallbackAndReset());
            }
        }

        protected void onCompleted(Throwable causeOrNull) {
            if (causeOrNull instanceof CancelSendException) {
                CancelSendException cancelSendException = (CancelSendException)causeOrNull;
                cancelSendException.complete();
            }
            super.onCompleted(causeOrNull);
        }

        public Invocable.InvocationType getInvocationType() {
            return this._callback.getInvocationType();
        }

        private boolean reset(MetaData.Request request, MetaData.Response response, ByteBuffer content, boolean last, Callback callback) {
            if (this.reset()) {
                this._info = response;
                this._head = request != null && HttpMethod.HEAD.is(request.getMethod());
                this._content = content;
                this._lastContent = last;
                this._callback = callback;
                this._header = null;
                if (HttpConnection.this.getConnector().isShutdown()) {
                    HttpConnection.this._generator.setPersistent(false);
                }
                return true;
            }
            if (this.isClosed()) {
                callback.failed((Throwable)new EofException());
            } else {
                callback.failed((Throwable)new WritePendingException());
            }
            return false;
        }

        public IteratingCallback.Action process() throws Exception {
            HttpGenerator.Result result;
            if (this._callback == null) {
                throw new IllegalStateException();
            }
            int responseHeadersSize = HttpConnection.this.getHttpConfiguration().getResponseHeaderSize();
            int maxResponseHeadersSize = HttpConnection.this.getHttpConfiguration().getMaxResponseHeaderSize();
            boolean useDirectByteBuffers = HttpConnection.this.isUseOutputDirectByteBuffers();
            block20: while (true) {
                ByteBuffer headerByteBuffer = this._header == null ? null : this._header.getByteBuffer();
                ByteBuffer chunkByteBuffer = this._chunk == null ? null : this._chunk.getByteBuffer();
                result = HttpConnection.this._generator.generateResponse(this._info, this._head, headerByteBuffer, chunkByteBuffer, this._content, this._lastContent);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("generate: {} for {} ({},{},{})@{}", new Object[]{result, this, BufferUtil.toSummaryString((ByteBuffer)headerByteBuffer), BufferUtil.toSummaryString((ByteBuffer)this._content), this._lastContent, HttpConnection.this._generator.getState()});
                }
                switch (result) {
                    case NEED_INFO: {
                        throw new EofException("request lifecycle violation");
                    }
                    case NEED_HEADER: {
                        int maxHeaderBytes = maxResponseHeadersSize;
                        if (maxHeaderBytes < 0) {
                            maxHeaderBytes = HttpConnection.this.getHttpConfiguration().getResponseHeaderSize();
                        }
                        HttpConnection.this._generator.setMaxHeaderBytes(maxHeaderBytes);
                        this._header = HttpConnection.this._bufferPool.acquire(responseHeadersSize, useDirectByteBuffers);
                        continue block20;
                    }
                    case HEADER_OVERFLOW: {
                        if (maxResponseHeadersSize > 0 && maxResponseHeadersSize > responseHeadersSize) {
                            HttpConnection.this._generator.reset();
                            this._header.release();
                            this._header = HttpConnection.this._bufferPool.acquire(maxResponseHeadersSize, useDirectByteBuffers);
                            responseHeadersSize = maxResponseHeadersSize;
                            continue block20;
                        }
                        throw new HttpException.RuntimeException(500, "Response Header Fields Too Large");
                    }
                    case NEED_CHUNK: {
                        this._chunk = HttpConnection.this._bufferPool.acquire(12, useDirectByteBuffers);
                        continue block20;
                    }
                    case NEED_CHUNK_TRAILER: {
                        this.releaseChunk();
                        this._chunk = HttpConnection.this._bufferPool.acquire(responseHeadersSize, useDirectByteBuffers);
                        continue block20;
                    }
                    case FLUSH: {
                        if (this._head || HttpConnection.this._generator.isNoContent()) {
                            if (this._chunk != null) {
                                BufferUtil.clear((ByteBuffer)chunkByteBuffer);
                            }
                            BufferUtil.clear((ByteBuffer)this._content);
                        }
                        int gatherWrite = 0;
                        long bytes = 0L;
                        if (BufferUtil.hasContent((ByteBuffer)headerByteBuffer)) {
                            gatherWrite += 4;
                            bytes += (long)this._header.remaining();
                        }
                        if (BufferUtil.hasContent((ByteBuffer)chunkByteBuffer)) {
                            gatherWrite += 2;
                            bytes += (long)this._chunk.remaining();
                        }
                        if (BufferUtil.hasContent((ByteBuffer)this._content)) {
                            ++gatherWrite;
                            bytes += (long)this._content.remaining();
                        }
                        HttpConnection.this._bytesOut.addAndGet(bytes);
                        switch (gatherWrite) {
                            case 7: {
                                HttpConnection.this.getEndPoint().write((Callback)this, new ByteBuffer[]{headerByteBuffer, chunkByteBuffer, this._content});
                                break;
                            }
                            case 6: {
                                HttpConnection.this.getEndPoint().write((Callback)this, new ByteBuffer[]{headerByteBuffer, chunkByteBuffer});
                                break;
                            }
                            case 5: {
                                HttpConnection.this.getEndPoint().write((Callback)this, new ByteBuffer[]{headerByteBuffer, this._content});
                                break;
                            }
                            case 4: {
                                HttpConnection.this.getEndPoint().write((Callback)this, new ByteBuffer[]{headerByteBuffer});
                                break;
                            }
                            case 3: {
                                HttpConnection.this.getEndPoint().write((Callback)this, new ByteBuffer[]{chunkByteBuffer, this._content});
                                break;
                            }
                            case 2: {
                                HttpConnection.this.getEndPoint().write((Callback)this, new ByteBuffer[]{chunkByteBuffer});
                                break;
                            }
                            case 1: {
                                HttpConnection.this.getEndPoint().write((Callback)this, new ByteBuffer[]{this._content});
                                break;
                            }
                            default: {
                                this.succeeded();
                            }
                        }
                        return IteratingCallback.Action.SCHEDULED;
                    }
                    case SHUTDOWN_OUT: {
                        this._shutdownOut = true;
                        continue block20;
                    }
                    case DONE: {
                        if (HttpConnection.this.getConnector().isShutdown() && HttpConnection.this._generator.isEnd() && HttpConnection.this._generator.isPersistent()) {
                            this._shutdownOut = true;
                        }
                        return IteratingCallback.Action.SUCCEEDED;
                    }
                    case CONTINUE: {
                        continue block20;
                    }
                }
                break;
            }
            throw new IllegalStateException("generateResponse=" + String.valueOf(result));
        }

        private Callback takeCallbackAndReset() {
            Callback callback = this._callback;
            this._callback = null;
            this._info = null;
            this._content = null;
            return callback;
        }

        private void release() {
            if (this._callback != null) {
                throw new IllegalStateException("callback not invoked");
            }
            this.releaseHeader();
            this.releaseChunk();
        }

        private void releaseHeader() {
            if (this._header != null) {
                this._header.release();
            }
            this._header = null;
        }

        private void releaseChunk() {
            if (this._chunk != null) {
                this._chunk.release();
            }
            this._chunk = null;
        }

        protected void onCompleteSuccess() {
            if (this._shutdownOut && !(HttpConnection.this._httpChannel.getRequest().getAttribute(HttpStream.UPGRADE_CONNECTION_ATTRIBUTE) instanceof Connection)) {
                HttpConnection.this.getEndPoint().shutdownOutput();
            }
            Callback callback = this.takeCallbackAndReset();
            this.release();
            if (callback != null) {
                callback.succeeded();
            }
        }

        public void onFailure(Throwable x) {
            Callback callback = this.takeCallbackAndReset();
            if (callback != null) {
                callback.failed(x);
            }
        }

        protected void onCompleteFailure(Throwable cause) {
            this.release();
        }

        public String toString() {
            return String.format("%s[i=%s,cb=%s]", super.toString(), this._info, this._callback);
        }

        private static class CancelSendException
        extends IOException {
            private final CountDownLatch _complete = new CountDownLatch(2);
            private Callback _callback;

            public CancelSendException(Throwable cause) {
                super(cause);
            }

            public void complete() {
                this._complete.countDown();
            }

            public Callback join() {
                try {
                    this._complete.await();
                }
                catch (InterruptedException x) {
                    Throwable cause = this.getCause();
                    if (cause == null) {
                        throw new RuntimeException(x);
                    }
                    ExceptionUtil.addSuppressedIfNotAssociated((Throwable)cause, (Throwable)x);
                    throw ExceptionUtil.asRuntimeException((Throwable)cause);
                }
                return this._callback;
            }

            public void setCallback(Callback callback) {
                this._callback = callback;
                this._complete.countDown();
            }
        }
    }

    protected class RequestHandler
    implements HttpParser.RequestHandler {
        private Throwable _failure;

        protected RequestHandler() {
        }

        public void messageBegin() {
            HttpConnection.this._httpChannel.initialize();
        }

        public void startRequest(String method, String uri, HttpVersion version) {
            HttpStreamOverHTTP1 stream = HttpConnection.this.newHttpStream(method, uri, version);
            if (!HttpConnection.this._stream.compareAndSet(null, stream)) {
                throw new IllegalStateException("Stream pending");
            }
            HttpConnection.this._headerBuilder.clear();
            HttpConnection.this._httpChannel.setHttpStream(stream);
        }

        public void parsedHeader(HttpField field) {
            HttpConnection.this._stream.get().parsedHeader(field);
        }

        public boolean headerComplete() {
            HttpConnection.this._onRequest = HttpConnection.this._stream.get().headerComplete();
            return true;
        }

        public boolean content(ByteBuffer buffer) {
            HttpStreamOverHTTP1 stream = HttpConnection.this._stream.get();
            if (stream == null || stream._chunk != null || HttpConnection.this._requestBuffer == null) {
                throw new IllegalStateException();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("content {}/{} for {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)buffer), HttpConnection.this._requestBuffer, HttpConnection.this});
            }
            HttpConnection.this._requestBuffer.retain();
            stream._chunk = Content.Chunk.asChunk((ByteBuffer)buffer, (boolean)false, (Retainable)HttpConnection.this._requestBuffer);
            return true;
        }

        public boolean contentComplete() {
            return false;
        }

        public void onViolation(ComplianceViolation.Event event) {
            HttpConnection.this.getHttpChannel().getComplianceViolationListener().onComplianceViolation(event);
        }

        public void parsedTrailer(HttpField field) {
            if (HttpConnection.this._trailers == null) {
                HttpConnection.this._trailers = HttpFields.build();
            }
            HttpConnection.this._trailers.add(field);
        }

        public boolean messageComplete() {
            HttpStreamOverHTTP1 stream = HttpConnection.this._stream.get();
            if (stream._chunk != null) {
                throw new IllegalStateException();
            }
            stream._chunk = HttpConnection.this._trailers != null ? new Trailers(HttpConnection.this._trailers.asImmutable()) : Content.Chunk.EOF;
            HttpConnection.this.getHttpChannel().getComplianceViolationListener().onRequestBegin((Attributes)HttpConnection.this.getHttpChannel().getRequest());
            return false;
        }

        public void badMessage(HttpException failure) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("badMessage {} {}", (Object)HttpConnection.this, (Object)failure);
            }
            this._failure = (Throwable)failure;
            HttpConnection.this._generator.setPersistent(false);
            HttpStreamOverHTTP1 stream = HttpConnection.this._stream.get();
            if (stream == null) {
                stream = HttpConnection.this.newHttpStream("BAD", "/badMessage", HttpVersion.HTTP_1_0);
                HttpConnection.this._stream.set(stream);
                HttpConnection.this._httpChannel.setHttpStream(stream);
            }
            if (HttpConnection.this._httpChannel.getRequest() == null) {
                HttpConnection.this._httpChannel.onRequest(new MetaData.Request(HttpConnection.this._parser.getBeginNanoTime(), stream._method, (HttpURI)stream._uri, stream._version, HttpFields.EMPTY));
            }
            ThreadPool.executeImmediately((Executor)HttpConnection.this.getServer().getThreadPool(), (Runnable)HttpConnection.this._httpChannel.onFailure(this._failure));
        }

        public void earlyEOF() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("early EOF {}", (Object)HttpConnection.this);
            }
            HttpConnection.this._generator.setPersistent(false);
            HttpStreamOverHTTP1 stream = HttpConnection.this._stream.get();
            if (stream != null) {
                HttpEofException bad = new HttpEofException();
                Content.Chunk chunk = stream._chunk;
                if (Content.Chunk.isFailure((Content.Chunk)chunk)) {
                    if (chunk.isLast()) {
                        chunk.getFailure().addSuppressed((Throwable)((Object)bad));
                    } else {
                        bad.addSuppressed(chunk.getFailure());
                        stream._chunk = Content.Chunk.from((Throwable)((Object)bad));
                    }
                } else {
                    if (chunk != null) {
                        chunk.release();
                    }
                    stream._chunk = Content.Chunk.from((Throwable)((Object)bad));
                }
            }
        }
    }

    protected class HttpStreamOverHTTP1
    implements HttpStream {
        private final long _id;
        private final String _method;
        private final HttpURI.Mutable _uri;
        private final HttpVersion _version;
        private long _contentLength = -1L;
        private HostPortHttpField _hostField;
        private MetaData.Request _request;
        private HttpField _upgrade = null;
        private Content.Chunk _chunk;
        private boolean _connectionClose = false;
        private boolean _connectionKeepAlive = false;
        private boolean _connectionUpgrade = false;
        private boolean _unknownExpectation = false;
        private boolean _expects100Continue = false;
        private List<String> _complianceViolations;

        protected HttpStreamOverHTTP1(String method, String uri, HttpVersion version) {
            this._id = HttpConnection.this._streamIdGenerator.getAndIncrement();
            this._method = method;
            this._uri = uri == null ? null : HttpURI.build((String)method, (String)uri);
            this._version = Objects.requireNonNull(version);
            if (this._uri != null && StringUtil.isEmpty((String)this._uri.getPath()) && this._uri.getScheme() != null && this._uri.hasAuthority()) {
                this._uri.path("/");
            }
        }

        @Override
        public Throwable consumeAvailable() {
            Throwable result = HttpStream.consumeAvailable(this, HttpConnection.this.getHttpConfiguration());
            if (result != null) {
                HttpConnection.this._generator.setPersistent(false);
                if (this._chunk != null) {
                    this._chunk.release();
                }
                this._chunk = Content.Chunk.from((Throwable)result, (boolean)true);
            }
            return result;
        }

        public void parsedHeader(HttpField field) {
            HttpHeader header = field.getHeader();
            String value = field.getValue();
            if (header != null) {
                switch (header) {
                    case CONNECTION: {
                        this._connectionClose |= field.contains(HttpHeaderValue.CLOSE.asString());
                        if (HttpVersion.HTTP_1_0.equals((Object)this._version)) {
                            this._connectionKeepAlive |= field.contains(HttpHeader.KEEP_ALIVE.asString());
                        }
                        this._connectionUpgrade |= field.contains(HttpHeaderValue.UPGRADE.asString());
                        break;
                    }
                    case HOST: {
                        if (value == null) {
                            value = "";
                        }
                        if (field instanceof HostPortHttpField) {
                            this._hostField = (HostPortHttpField)field;
                            break;
                        }
                        this._hostField = new HostPortHttpField(value);
                        field = this._hostField;
                        break;
                    }
                    case EXPECT: {
                        if (HttpHeaderValue.parseCsvIndex((String)value, t -> {
                            if (t == HttpHeaderValue.CONTINUE) {
                                this._expects100Continue = true;
                                return true;
                            }
                            return false;
                        }, s -> false)) break;
                        this._unknownExpectation = true;
                        this._expects100Continue = false;
                        break;
                    }
                    case UPGRADE: {
                        this._upgrade = field;
                        break;
                    }
                    case CONTENT_LENGTH: {
                        this._contentLength = field.getLongValue();
                        break;
                    }
                }
            }
            HttpConnection.this._headerBuilder.add(field);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Runnable headerComplete() {
            boolean persistent;
            UriCompliance compliance;
            String badMessage;
            if (this._uri.hasViolations() && (badMessage = UriCompliance.checkUriCompliance((UriCompliance)(compliance = HttpConnection.this.getHttpConfiguration().getUriCompliance()), (HttpURI)this._uri, (ComplianceViolation.Listener)HttpConnection.this.getHttpChannel().getComplianceViolationListener())) != null) {
                throw new BadMessageException(badMessage);
            }
            if (this._hostField != null) {
                if (this._uri.isAbsolute()) {
                    if (!this._hostField.getValue().equals(this._uri.getAuthority())) {
                        HttpCompliance httpCompliance = HttpConnection.this.getHttpConfiguration().getHttpCompliance();
                        if (!httpCompliance.allows((ComplianceViolation)HttpCompliance.Violation.MISMATCHED_AUTHORITY)) throw new BadMessageException("Authority!=Host");
                        HttpConnection.this.getHttpChannel().getComplianceViolationListener().onComplianceViolation(new ComplianceViolation.Event((ComplianceViolation.Mode)httpCompliance, (ComplianceViolation)HttpCompliance.Violation.MISMATCHED_AUTHORITY, this._uri.asString()));
                    }
                } else if (StringUtil.isBlank((String)this._hostField.getHostPort().getHost())) {
                    throw new BadMessageException("Blank Host");
                }
            }
            if (!this._uri.isAbsolute()) {
                this._uri.scheme(HttpConnection.this.getEndPoint() instanceof SslConnection.SslEndPoint ? HttpScheme.HTTPS : HttpScheme.HTTP);
            }
            if (this._uri.getAuthority() == null && !HttpMethod.CONNECT.is(this._method)) {
                HostPort hostPort = this._hostField == null ? HttpConnection.this.getServerAuthority() : this._hostField.getHostPort();
                int port = hostPort.getPort();
                if (port == URIUtil.getDefaultPortForScheme((String)this._uri.getScheme())) {
                    port = -1;
                }
                this._uri.authority(hostPort.getHost(), port);
            }
            if (this._uri.getPath() == null) {
                this._uri.path("/");
            }
            this._request = new MetaData.Request(HttpConnection.this._parser.getBeginNanoTime(), this._method, (HttpURI)this._uri.asImmutable(), this._version, (HttpFields)HttpConnection.this._headerBuilder, this._contentLength){

                public boolean is100ContinueExpected() {
                    return HttpStreamOverHTTP1.this._expects100Continue;
                }
            };
            Runnable handle = HttpConnection.this._httpChannel.onRequest(this._request);
            HttpConnection.this._requests.incrementAndGet();
            Request request = HttpConnection.this._httpChannel.getRequest();
            HttpConnection.this.getHttpChannel().getComplianceViolationListener().onRequestBegin((Attributes)request);
            if (this._complianceViolations != null && !this._complianceViolations.isEmpty()) {
                HttpConnection.this._httpChannel.getRequest().setAttribute("org.eclipse.jetty.http.compliance.violations", this._complianceViolations);
                this._complianceViolations = null;
            }
            switch (this._request.getHttpVersion()) {
                case HTTP_0_9: {
                    persistent = false;
                    break;
                }
                case HTTP_1_0: {
                    persistent = HttpConnection.this.getHttpConfiguration().isPersistentConnectionsEnabled() && this._connectionKeepAlive && !this._connectionClose || HttpMethod.CONNECT.is(this._method);
                    HttpConnection.this._generator.setPersistent(persistent);
                    if (persistent) break;
                    this._connectionKeepAlive = false;
                    break;
                }
                case HTTP_1_1: {
                    if (this._unknownExpectation) {
                        throw new BadMessageException(417);
                    }
                    persistent = HttpConnection.this.getHttpConfiguration().isPersistentConnectionsEnabled() && !this._connectionClose || HttpMethod.CONNECT.is(this._method);
                    HttpConnection.this._generator.setPersistent(persistent);
                    if (this._upgrade == null || !HttpConnection.this.upgrade(HttpConnection.this._stream.get())) break;
                    return null;
                }
                case HTTP_2: {
                    this._upgrade = PREAMBLE_UPGRADE_H2C;
                    if (HttpMethod.PRI.is(this._method) && "*".equals(this._uri.getPath()) && HttpConnection.this._headerBuilder.size() == 0 && HttpConnection.this.upgrade(HttpConnection.this._stream.get())) {
                        return null;
                    }
                    HttpConnection.this._parser.close();
                    throw new BadMessageException(426, "Upgrade Required");
                }
                default: {
                    throw new IllegalStateException("unsupported version " + String.valueOf(this._version));
                }
            }
            if (persistent) return handle;
            HttpConnection.this._generator.setPersistent(false);
            return handle;
        }

        @Override
        public String getId() {
            return Long.toString(this._id);
        }

        @Override
        public Content.Chunk read() {
            if (this._chunk == null) {
                if (HttpConnection.this._parser.isTerminated()) {
                    this._chunk = Content.Chunk.EOF;
                } else {
                    HttpConnection.this.parseAndFillForContent();
                }
            }
            Content.Chunk content = this._chunk;
            this._chunk = Content.Chunk.next((Content.Chunk)content);
            if (content != null && this._expects100Continue && content.hasRemaining()) {
                this._expects100Continue = false;
            }
            return content;
        }

        @Override
        public void demand() {
            if (this._chunk != null) {
                this.invokeDemandCallback();
                return;
            }
            HttpConnection.this.parseAndFillForContent();
            if (this._chunk != null) {
                this.invokeDemandCallback();
                return;
            }
            HttpConnection.this.asyncReadFillInterested();
        }

        private void invokeDemandCallback() {
            Runnable onContentAvailable = HttpConnection.this._httpChannel.onContentAvailable();
            if (onContentAvailable != null) {
                onContentAvailable.run();
            }
        }

        @Override
        public void prepareResponse(HttpFields.Mutable headers) {
            if (this._connectionKeepAlive && this._version == HttpVersion.HTTP_1_0 && !headers.contains(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE.asString())) {
                headers.add(HttpFields.CONNECTION_KEEPALIVE);
            }
        }

        @Override
        public void send(MetaData.Request request, MetaData.Response response, boolean last, ByteBuffer content, Callback callback) {
            if (response == null) {
                if (!last && BufferUtil.isEmpty((ByteBuffer)content)) {
                    callback.succeeded();
                    return;
                }
            } else {
                if (HttpConnection.this._generator.isCommitted()) {
                    callback.failed((Throwable)new IllegalStateException("Committed"));
                    return;
                }
                HttpConnection.this._responses.incrementAndGet();
                if (this._expects100Continue) {
                    if (response.getStatus() == 100) {
                        this._expects100Continue = false;
                    } else {
                        HttpConnection.this._generator.setPersistent(false);
                    }
                }
            }
            if (HttpConnection.this._sendCallback.reset(this._request, response, content, last, callback)) {
                HttpConnection.this._sendCallback.iterate();
            }
        }

        @Override
        public Runnable cancelSend(Throwable cause, Callback appCallback) {
            return () -> Callback.combine((Callback)HttpConnection.this._sendCallback.cancel(cause), (Callback)appCallback).failed(cause);
        }

        @Override
        public long getIdleTimeout() {
            return HttpConnection.this.getEndPoint().getIdleTimeout();
        }

        @Override
        public void setIdleTimeout(long idleTimeoutMs) {
            HttpConnection.this.getEndPoint().setIdleTimeout(idleTimeoutMs);
        }

        @Override
        public boolean isCommitted() {
            return HttpConnection.this._stream.get() != this || HttpConnection.this._generator.isCommitted();
        }

        private boolean upgrade() {
            boolean isPriorKnowledgeH2C;
            if (LOG.isDebugEnabled()) {
                LOG.debug("upgrade {} {}", (Object)this, (Object)this._upgrade);
            }
            if (!this._connectionUpgrade && this._upgrade == null) {
                return false;
            }
            boolean bl = isPriorKnowledgeH2C = this._upgrade == PREAMBLE_UPGRADE_H2C;
            if (!isPriorKnowledgeH2C && !this._connectionUpgrade) {
                throw new BadMessageException(400);
            }
            ConnectionFactory.Upgrading factory = HttpConnection.this.getConnector().getConnectionFactories().stream().filter(f -> f instanceof ConnectionFactory.Upgrading).map(ConnectionFactory.Upgrading.class::cast).filter(f -> f.getProtocols().contains(this._upgrade.getValue())).findAny().orElse(null);
            if (factory == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No factory for {} in {}", (Object)this._upgrade, (Object)HttpConnection.this.getConnector());
                }
                return false;
            }
            HttpFields.Mutable response101 = HttpFields.build();
            Connection upgradeConnection = factory.upgradeConnection(HttpConnection.this.getConnector(), HttpConnection.this.getEndPoint(), this._request, response101);
            if (upgradeConnection == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Upgrade ignored for {} by {}", (Object)this._upgrade, (Object)factory);
                }
                return false;
            }
            if (!isPriorKnowledgeH2C) {
                this.send(this._request, new MetaData.Response(101, null, HttpVersion.HTTP_1_1, (HttpFields)response101, 0L), false, null, Callback.NOOP);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Upgrading from {} to {}", (Object)HttpConnection.this.getEndPoint().getConnection(), (Object)upgradeConnection);
            }
            HttpConnection.this.getEndPoint().upgrade(upgradeConnection);
            return true;
        }

        @Override
        public TunnelSupport getTunnelSupport() {
            return HttpConnection.this._tunnelSupport;
        }

        public void succeeded() {
            HttpStreamOverHTTP1 stream = HttpConnection.this._stream.getAndSet(null);
            if (stream == null) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("succeeded {}", (Object)HttpConnection.this);
            }
            if (HttpConnection.this.isFillInterested()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("abort due to pending read {} {} ", (Object)this, (Object)HttpConnection.this.getEndPoint());
                }
                this.abort(new IOException("Pending read in onCompleted"));
                HttpConnection.this._httpChannel.recycle();
                HttpConnection.this._parser.reset();
                HttpConnection.this._generator.reset();
                if (!HttpConnection.this._handling.compareAndSet(true, false)) {
                    this.resume();
                }
                return;
            }
            Object object = HttpConnection.this._httpChannel.getRequest().getAttribute(HttpStream.UPGRADE_CONNECTION_ATTRIBUTE);
            if (object instanceof Connection) {
                Connection upgradeConnection = (Connection)object;
                HttpConnection.this.getEndPoint().upgrade(upgradeConnection);
                HttpConnection.this._httpChannel.recycle();
                HttpConnection.this._parser.close();
                HttpConnection.this._generator.reset();
                if (!HttpConnection.this._handling.compareAndSet(true, false)) {
                    HttpConnection.this.releaseRequestBuffer();
                }
                return;
            }
            HttpConnection.this._httpChannel.recycle();
            if (this._expects100Continue) {
                this._expects100Continue = false;
                HttpConnection.this._parser.close();
            }
            if (!HttpConnection.this._parser.isClosed()) {
                if (HttpConnection.this._generator.isPersistent()) {
                    HttpConnection.this._parser.reset();
                } else {
                    HttpConnection.this._parser.close();
                }
            }
            HttpConnection.this._generator.reset();
            if (HttpConnection.this._handling.compareAndSet(true, false)) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("non-current completion {}", (Object)this);
            }
            this.resume();
        }

        public void failed(Throwable x) {
            HttpStreamOverHTTP1 stream = HttpConnection.this._stream.getAndSet(null);
            if (stream == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("ignored", x);
                }
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("aborting", x);
            }
            this.abort(x);
            HttpConnection.this._httpChannel.setHttpStream(null);
            if (!HttpConnection.this._handling.compareAndSet(true, false)) {
                this.resume();
            }
        }

        private void resume() {
            try {
                Request request;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Resuming onFillable() {}", (Object)HttpConnection.this);
                }
                Executor executor = (request = HttpConnection.this._httpChannel.getRequest()) == null ? HttpConnection.this.getExecutor() : request.getComponents().getExecutor();
                executor.execute(HttpConnection.this);
            }
            catch (RejectedExecutionException x) {
                HttpConnection.this.getEndPoint().close((Throwable)x);
                HttpConnection.this.run();
            }
        }

        private void abort(Throwable failure) {
            HttpConnection.this.getEndPoint().close(failure);
        }
    }

    private static class HttpEofException
    extends EofException
    implements HttpException {
        private HttpEofException() {
            super("Early EOF");
        }

        public int getCode() {
            return 400;
        }

        public String getReason() {
            return this.getMessage();
        }
    }
}

