/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.viewers;

import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.jface.internal.databinding.provisional.viewers.ViewerLabelProvider;

public abstract class ListeningLabelProvider<E>
extends ViewerLabelProvider {
    private ISetChangeListener<E> listener = event -> {
        for (Object element : event.diff.getAdditions()) {
            this.addListenerTo(element);
        }
        for (Object element : event.diff.getRemovals()) {
            this.removeListenerFrom(element);
        }
    };
    private IObservableSet<E> items;

    public ListeningLabelProvider(IObservableSet<E> itemsThatNeedLabels) {
        this.items = itemsThatNeedLabels;
        this.items.addSetChangeListener(this.listener);
        for (Object element : this.items) {
            this.addListenerTo(element);
        }
    }

    protected abstract void removeListenerFrom(E var1);

    protected abstract void addListenerTo(E var1);

    @Override
    public void dispose() {
        for (Object element : this.items) {
            this.removeListenerFrom(element);
        }
        this.items.removeSetChangeListener(this.listener);
        super.dispose();
    }
}

