/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.rap.rwt.client.ClientFile;
import org.eclipse.rap.rwt.dnd.ClientFileTransfer;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class DNDExampleTab
extends ExampleTab {
    private static final int BUTTON_TOGGLE = 0;
    private static final int BUTTON_RADIO = 1;
    private static final int BUTTON_CHECK = 2;
    private static final int CANVAS = 3;
    private static final int LABEL = 4;
    private static final int LIST = 5;
    private static final int TABLE = 6;
    private static final int TREE = 7;
    private static final int TEXT = 8;
    private int dragOperation;
    private Transfer[] dragTypes = new Transfer[0];
    private Control dragControl;
    private int dragControlType;
    private DragSource dragSource;
    private String dragDataText;
    private String dragDataRTF;
    private String dragDataHTML;
    private boolean dragEnabled;
    private int dropOperation;
    private int dropFeedback;
    private int dropDefaultOperation;
    private Transfer[] dropTypes = new Transfer[0];
    private DropTarget dropTarget;
    private Control dropControl;
    private int dropControlType;
    private Composite defaultParent;
    private boolean dropEnabled;
    private Text dragConsole;
    private boolean dragEventDetail;
    private Text dropConsole;
    private boolean dropEventDetail;

    public DNDExampleTab() {
        super("Drag & Drop");
        int[] nArray = new int[2];
        nArray[0] = 100;
        this.setHorizontalSashFormWeights(nArray);
        this.dragEnabled = true;
        this.dropEnabled = true;
        this.addDragTransfer((Transfer)TextTransfer.getInstance());
        this.addDropTransfer((Transfer)TextTransfer.getInstance());
    }

    @Override
    protected void createExampleControls(Composite container) {
        container.setLayout((Layout)new FillLayout());
        ScrolledComposite sc = new ScrolledComposite(container, 768);
        Composite parent = new Composite((Composite)sc, 0);
        sc.setContent((Control)parent);
        parent.setLayout((Layout)new FormLayout());
        Label dragLabel = new Label(parent, 16384);
        dragLabel.setText("Drag Source:");
        Group dragWidgetGroup = new Group(parent, 0);
        dragWidgetGroup.setText("Widget");
        this.createDragWidget((Composite)dragWidgetGroup);
        Composite cLeft = new Composite(parent, 0);
        cLeft.setLayout((Layout)new GridLayout(2, false));
        Group dragOperationsGroup = new Group(cLeft, 0);
        dragOperationsGroup.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        dragOperationsGroup.setText("Allowed Operation(s):");
        this.createDragOperations((Composite)dragOperationsGroup);
        Group dragTypesGroup = new Group(cLeft, 0);
        dragTypesGroup.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        dragTypesGroup.setText("Transfer Type(s):");
        this.createDragTypes((Composite)dragTypesGroup);
        this.dragConsole = new Text(cLeft, 2826);
        this.dragConsole.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Menu menu = new Menu((Decorations)container.getShell(), 8);
        MenuItem item = new MenuItem(menu, 8);
        item.setText("Clear");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DNDExampleTab.this.dragConsole.setText("");
            }
        });
        item = new MenuItem(menu, 32);
        item.setText("Show Event detail");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MenuItem item = (MenuItem)e.widget;
                DNDExampleTab.this.dragEventDetail = item.getSelection();
            }
        });
        this.dragConsole.setMenu(menu);
        Label dropLabel = new Label(parent, 16384);
        dropLabel.setText("Drop Target:");
        Group dropWidgetGroup = new Group(parent, 0);
        dropWidgetGroup.setText("Widget");
        this.createDropWidget((Composite)dropWidgetGroup);
        Composite cRight = new Composite(parent, 0);
        cRight.setLayout((Layout)new GridLayout(2, false));
        Group dropOperationsGroup = new Group(cRight, 0);
        dropOperationsGroup.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 2));
        dropOperationsGroup.setText("Allowed Operation(s):");
        this.createDropOperations((Composite)dropOperationsGroup);
        Group dropTypesGroup = new Group(cRight, 0);
        dropTypesGroup.setText("Transfer Type(s):");
        this.createDropTypes((Composite)dropTypesGroup);
        Group feedbackTypesGroup = new Group(cRight, 0);
        feedbackTypesGroup.setText("Feedback Type(s):");
        this.createFeedbackTypes(feedbackTypesGroup);
        this.dropConsole = new Text(cRight, 2826);
        this.dropConsole.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        menu = new Menu((Decorations)container.getShell(), 8);
        item = new MenuItem(menu, 8);
        item.setText("Clear");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DNDExampleTab.this.dropConsole.setText("");
            }
        });
        item = new MenuItem(menu, 32);
        item.setText("Show Event detail");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MenuItem item = (MenuItem)e.widget;
                DNDExampleTab.this.dropEventDetail = item.getSelection();
            }
        });
        this.dropConsole.setMenu(menu);
        int height = 200;
        FormData data = new FormData();
        data.top = new FormAttachment(0, 10);
        data.left = new FormAttachment(0, 10);
        dragLabel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)dragLabel, 10);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(50, -10);
        data.height = height;
        dragWidgetGroup.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)dragWidgetGroup, 10);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(50, -10);
        data.bottom = new FormAttachment(100, -10);
        cLeft.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 10);
        data.left = new FormAttachment((Control)cLeft, 10);
        dropLabel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)dropLabel, 10);
        data.left = new FormAttachment((Control)cLeft, 10);
        data.right = new FormAttachment(100, -10);
        data.height = height;
        dropWidgetGroup.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)dropWidgetGroup, 10);
        data.left = new FormAttachment((Control)cLeft, 10);
        data.right = new FormAttachment(100, -10);
        data.bottom = new FormAttachment(100, -10);
        cRight.setLayoutData((Object)data);
        sc.setMinSize(parent.computeSize(-1, -1));
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
    }

    @Override
    protected void createStyleControls(Composite parent) {
    }

    private void addDragTransfer(Transfer transfer) {
        Transfer[] newTypes = new Transfer[this.dragTypes.length + 1];
        System.arraycopy(this.dragTypes, 0, newTypes, 0, this.dragTypes.length);
        newTypes[this.dragTypes.length] = transfer;
        this.dragTypes = newTypes;
        if (this.dragSource != null) {
            this.dragSource.setTransfer(this.dragTypes);
        }
    }

    private void addDropTransfer(Transfer transfer) {
        Transfer[] newTypes = new Transfer[this.dropTypes.length + 1];
        System.arraycopy(this.dropTypes, 0, newTypes, 0, this.dropTypes.length);
        newTypes[this.dropTypes.length] = transfer;
        this.dropTypes = newTypes;
        if (this.dropTarget != null) {
            this.dropTarget.setTransfer(this.dropTypes);
        }
    }

    private void createDragOperations(Composite parent) {
        parent.setLayout((Layout)new RowLayout(512));
        final Button moveButton = new Button(parent, 32);
        moveButton.setText("DND.DROP_MOVE");
        moveButton.setSelection(true);
        this.dragOperation = 2;
        moveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    DNDExampleTab.this.dragOperation |= 2;
                } else {
                    DNDExampleTab.this.dragOperation &= 0xFFFFFFFD;
                    if (DNDExampleTab.this.dragOperation == 0) {
                        DNDExampleTab.this.dragOperation = 2;
                        moveButton.setSelection(true);
                    }
                }
                if (DNDExampleTab.this.dragEnabled) {
                    DNDExampleTab.this.createDragSource();
                }
            }
        });
        Button b = new Button(parent, 32);
        b.setText("DND.DROP_COPY");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    DNDExampleTab.this.dragOperation |= 1;
                } else {
                    DNDExampleTab.this.dragOperation &= 0xFFFFFFFE;
                    if (DNDExampleTab.this.dragOperation == 0) {
                        DNDExampleTab.this.dragOperation = 2;
                        moveButton.setSelection(true);
                    }
                }
                if (DNDExampleTab.this.dragEnabled) {
                    DNDExampleTab.this.createDragSource();
                }
            }
        });
        b = new Button(parent, 32);
        b.setText("DND.DROP_LINK");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    DNDExampleTab.this.dragOperation |= 4;
                } else {
                    DNDExampleTab.this.dragOperation &= 0xFFFFFFFB;
                    if (DNDExampleTab.this.dragOperation == 0) {
                        DNDExampleTab.this.dragOperation = 2;
                        moveButton.setSelection(true);
                    }
                }
                if (DNDExampleTab.this.dragEnabled) {
                    DNDExampleTab.this.createDragSource();
                }
            }
        });
    }

    private void createDragSource() {
        if (this.dragSource != null) {
            this.dragSource.dispose();
        }
        this.dragSource = new DragSource(this.dragControl, this.dragOperation);
        this.dragSource.setTransfer(this.dragTypes);
        this.dragSource.addDragListener(new DragSourceListener(){

            public void dragFinished(DragSourceEvent event) {
                DNDExampleTab.this.dragConsole.append(">>dragFinished\n");
                DNDExampleTab.this.printEvent(event);
                DNDExampleTab.this.dragDataHTML = null;
                DNDExampleTab.this.dragDataRTF = null;
                DNDExampleTab.this.dragDataText = null;
                if (event.detail == 2) {
                    switch (DNDExampleTab.this.dragControlType) {
                        case 0: 
                        case 1: 
                        case 2: {
                            Button b = (Button)DNDExampleTab.this.dragControl;
                            b.setText("");
                            break;
                        }
                        case 6: {
                            Table table = (Table)DNDExampleTab.this.dragControl;
                            TableItem[] items = table.getSelection();
                            int i = 0;
                            while (i < items.length) {
                                items[i].dispose();
                                ++i;
                            }
                            break;
                        }
                        case 8: {
                            Text text = (Text)DNDExampleTab.this.dragControl;
                            text.clearSelection();
                            break;
                        }
                        case 7: {
                            Tree tree = (Tree)DNDExampleTab.this.dragControl;
                            TreeItem[] items = tree.getSelection();
                            int i = 0;
                            while (i < items.length) {
                                items[i].dispose();
                                ++i;
                            }
                            break;
                        }
                        case 3: {
                            DNDExampleTab.this.dragControl.setData("STRINGS", null);
                            DNDExampleTab.this.dragControl.redraw();
                            break;
                        }
                        case 4: {
                            Label label = (Label)DNDExampleTab.this.dragControl;
                            label.setText("");
                            break;
                        }
                        case 5: {
                            List list = (List)DNDExampleTab.this.dragControl;
                            int[] indices = list.getSelectionIndices();
                            list.remove(indices);
                        }
                    }
                }
            }

            public void dragSetData(DragSourceEvent event) {
                DNDExampleTab.this.dragConsole.append(">>dragSetData\n");
                DNDExampleTab.this.printEvent(event);
                if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = DNDExampleTab.this.dragDataText;
                }
                if (RTFTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = DNDExampleTab.this.dragDataRTF;
                }
                if (HTMLTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = DNDExampleTab.this.dragDataHTML;
                }
            }

            public void dragStart(DragSourceEvent event) {
                DNDExampleTab.this.dragConsole.append(">>dragStart\n");
                DNDExampleTab.this.printEvent(event);
                switch (DNDExampleTab.this.dragControlType) {
                    case 0: 
                    case 1: 
                    case 2: {
                        Button b = (Button)DNDExampleTab.this.dragControl;
                        DNDExampleTab.this.dragDataText = b.getSelection() ? "true" : "false";
                        break;
                    }
                    case 6: {
                        Table table = (Table)DNDExampleTab.this.dragControl;
                        TableItem[] items = table.getSelection();
                        if (items.length == 0) {
                            event.doit = false;
                            break;
                        }
                        DNDExampleTab.this.dragDataText = DNDExampleTab.join("\n", (Item[])items);
                        break;
                    }
                    case 8: {
                        Text text = (Text)DNDExampleTab.this.dragControl;
                        String s = text.getSelectionText();
                        if (s.length() == 0) {
                            event.doit = false;
                            break;
                        }
                        DNDExampleTab.this.dragDataText = s;
                        break;
                    }
                    case 7: {
                        Tree tree = (Tree)DNDExampleTab.this.dragControl;
                        TableItem[] items = tree.getSelection();
                        if (items.length == 0) {
                            event.doit = false;
                            break;
                        }
                        DNDExampleTab.this.dragDataText = DNDExampleTab.join("\n", (Item[])items);
                        break;
                    }
                    case 3: {
                        String[] strings = (String[])DNDExampleTab.this.dragControl.getData("STRINGS");
                        if (strings == null || strings.length == 0) {
                            event.doit = false;
                            break;
                        }
                        DNDExampleTab.this.dragDataText = DNDExampleTab.join("\n", strings);
                        break;
                    }
                    case 4: {
                        Label label = (Label)DNDExampleTab.this.dragControl;
                        String string = label.getText();
                        if (string.length() == 0) {
                            event.doit = false;
                            break;
                        }
                        DNDExampleTab.this.dragDataText = string;
                        break;
                    }
                    case 5: {
                        List list = (List)DNDExampleTab.this.dragControl;
                        String[] selection = list.getSelection();
                        if (selection.length == 0) {
                            event.doit = false;
                            break;
                        }
                        DNDExampleTab.this.dragDataText = DNDExampleTab.join("\n", selection);
                        break;
                    }
                    default: {
                        throw new SWTError(20);
                    }
                }
                if (DNDExampleTab.this.dragDataText != null) {
                    DNDExampleTab.this.dragDataRTF = "{\\rtf1{\\colortbl;\\red255\\green0\\blue0;}\\cf1\\b " + DNDExampleTab.this.dragDataText + "}";
                    DNDExampleTab.this.dragDataHTML = "<b>" + DNDExampleTab.this.dragDataText + "</b>";
                }
                int i = 0;
                while (i < DNDExampleTab.this.dragTypes.length) {
                    if (DNDExampleTab.this.dragTypes[i] instanceof TextTransfer && DNDExampleTab.this.dragDataText == null) {
                        event.doit = false;
                    }
                    if (DNDExampleTab.this.dragTypes[i] instanceof RTFTransfer && DNDExampleTab.this.dragDataRTF == null) {
                        event.doit = false;
                    }
                    if (DNDExampleTab.this.dragTypes[i] instanceof HTMLTransfer && DNDExampleTab.this.dragDataHTML == null) {
                        event.doit = false;
                    }
                    ++i;
                }
            }
        });
    }

    private void createDragTypes(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        Button b = new Button(parent, 32);
        b.setText("Text Transfer");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    DNDExampleTab.this.addDragTransfer((Transfer)TextTransfer.getInstance());
                } else {
                    DNDExampleTab.this.removeDragTransfer((Transfer)TextTransfer.getInstance());
                }
            }
        });
        b.setSelection(true);
        b = new Button(parent, 32);
        b.setText("RTF Transfer");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    DNDExampleTab.this.addDragTransfer((Transfer)RTFTransfer.getInstance());
                } else {
                    DNDExampleTab.this.removeDragTransfer((Transfer)RTFTransfer.getInstance());
                }
            }
        });
        b = new Button(parent, 32);
        b.setText("HTML Transfer");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    DNDExampleTab.this.addDragTransfer((Transfer)HTMLTransfer.getInstance());
                } else {
                    DNDExampleTab.this.removeDragTransfer((Transfer)HTMLTransfer.getInstance());
                }
            }
        });
    }

    private void createDragWidget(Composite parent) {
        parent.setLayout((Layout)new FormLayout());
        Combo combo = new Combo(parent, 8);
        combo.setItems(new String[]{"Toggle Button", "Radio Button", "Checkbox", "Canvas", "Label", "List", "Table", "Tree"});
        combo.select(4);
        this.dragControlType = combo.getSelectionIndex();
        this.dragControl = this.createWidget(this.dragControlType, parent, "Drag Source");
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object data = DNDExampleTab.this.dragControl.getLayoutData();
                Composite parent = DNDExampleTab.this.dragControl.getParent();
                DNDExampleTab.this.dragControl.dispose();
                Combo c = (Combo)e.widget;
                DNDExampleTab.this.dragControlType = c.getSelectionIndex();
                DNDExampleTab.this.dragControl = DNDExampleTab.this.createWidget(DNDExampleTab.this.dragControlType, parent, "Drag Source");
                DNDExampleTab.this.dragControl.setLayoutData(data);
                DNDExampleTab.this.updateDragSource();
                parent.layout();
            }
        });
        Button b = new Button(parent, 32);
        b.setText("DragSource");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DNDExampleTab.this.dragEnabled = ((Button)e.widget).getSelection();
                DNDExampleTab.this.updateDragSource();
            }
        });
        b.setSelection(this.dragEnabled);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 10);
        data.bottom = new FormAttachment((Control)combo, -10);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(100, -10);
        this.dragControl.setLayoutData((Object)data);
        data = new FormData();
        data.bottom = new FormAttachment(100, -10);
        data.left = new FormAttachment(0, 10);
        combo.setLayoutData((Object)data);
        data = new FormData();
        data.bottom = new FormAttachment(100, -10);
        data.left = new FormAttachment((Control)combo, 10);
        b.setLayoutData((Object)data);
        this.updateDragSource();
    }

    private void updateDragSource() {
        if (this.dragSource != null) {
            this.dragSource.dispose();
        }
        if (this.dragEnabled) {
            this.createDragSource();
        } else {
            if (this.dragSource != null) {
                this.dragSource.dispose();
            }
            this.dragSource = null;
        }
    }

    private void createDropOperations(Composite parent) {
        parent.setLayout((Layout)new RowLayout(512));
        final Button moveButton = new Button(parent, 32);
        moveButton.setText("DND.DROP_MOVE");
        moveButton.setSelection(true);
        this.dropOperation = 2;
        moveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    DNDExampleTab.this.dropOperation |= 2;
                } else {
                    DNDExampleTab.this.dropOperation &= 0xFFFFFFFD;
                    if (DNDExampleTab.this.dropOperation == 0 || (DNDExampleTab.this.dropDefaultOperation & 2) != 0) {
                        DNDExampleTab.this.dropOperation |= 2;
                        moveButton.setSelection(true);
                    }
                }
                if (DNDExampleTab.this.dropEnabled) {
                    DNDExampleTab.this.createDropTarget();
                }
            }
        });
        final Button copyButton = new Button(parent, 32);
        copyButton.setText("DND.DROP_COPY");
        copyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    DNDExampleTab.this.dropOperation |= 1;
                } else {
                    DNDExampleTab.this.dropOperation &= 0xFFFFFFFE;
                    if (DNDExampleTab.this.dropOperation == 0 || (DNDExampleTab.this.dropDefaultOperation & 1) != 0) {
                        DNDExampleTab.this.dropOperation = 1;
                        copyButton.setSelection(true);
                    }
                }
                if (DNDExampleTab.this.dropEnabled) {
                    DNDExampleTab.this.createDropTarget();
                }
            }
        });
        final Button linkButton = new Button(parent, 32);
        linkButton.setText("DND.DROP_LINK");
        linkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    DNDExampleTab.this.dropOperation |= 4;
                } else {
                    DNDExampleTab.this.dropOperation &= 0xFFFFFFFB;
                    if (DNDExampleTab.this.dropOperation == 0 || (DNDExampleTab.this.dropDefaultOperation & 4) != 0) {
                        DNDExampleTab.this.dropOperation = 4;
                        linkButton.setSelection(true);
                    }
                }
                if (DNDExampleTab.this.dropEnabled) {
                    DNDExampleTab.this.createDropTarget();
                }
            }
        });
        Button b = new Button(parent, 32);
        b.setText("DND.DROP_DEFAULT");
        this.defaultParent = new Composite(parent, 0);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    DNDExampleTab.this.dropOperation |= 0x10;
                    DNDExampleTab.this.defaultParent.setVisible(true);
                } else {
                    DNDExampleTab.this.dropOperation &= 0xFFFFFFEF;
                    DNDExampleTab.this.defaultParent.setVisible(false);
                }
                if (DNDExampleTab.this.dropEnabled) {
                    DNDExampleTab.this.createDropTarget();
                }
            }
        });
        this.defaultParent.setVisible(false);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 20;
        this.defaultParent.setLayout((Layout)layout);
        Label label = new Label(this.defaultParent, 0);
        label.setText("Value for default operation is:");
        b = new Button(this.defaultParent, 16);
        b.setText("DND.DROP_MOVE");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    DNDExampleTab.this.dropDefaultOperation = 2;
                    DNDExampleTab.this.dropOperation |= 2;
                    moveButton.setSelection(true);
                    if (DNDExampleTab.this.dropEnabled) {
                        DNDExampleTab.this.createDropTarget();
                    }
                }
            }
        });
        b = new Button(this.defaultParent, 16);
        b.setText("DND.DROP_COPY");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    DNDExampleTab.this.dropDefaultOperation = 1;
                    DNDExampleTab.this.dropOperation |= 1;
                    copyButton.setSelection(true);
                    if (DNDExampleTab.this.dropEnabled) {
                        DNDExampleTab.this.createDropTarget();
                    }
                }
            }
        });
        b = new Button(this.defaultParent, 16);
        b.setText("DND.DROP_LINK");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    DNDExampleTab.this.dropDefaultOperation = 4;
                    DNDExampleTab.this.dropOperation |= 4;
                    linkButton.setSelection(true);
                    if (DNDExampleTab.this.dropEnabled) {
                        DNDExampleTab.this.createDropTarget();
                    }
                }
            }
        });
        b = new Button(this.defaultParent, 16);
        b.setText("DND.DROP_NONE");
        b.setSelection(true);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    DNDExampleTab.this.dropDefaultOperation = 0;
                    DNDExampleTab.this.dropOperation &= 0xFFFFFFEF;
                    if (DNDExampleTab.this.dropEnabled) {
                        DNDExampleTab.this.createDropTarget();
                    }
                }
            }
        });
    }

    private void createDropTarget() {
        if (this.dropTarget != null) {
            this.dropTarget.dispose();
        }
        this.dropTarget = new DropTarget(this.dropControl, this.dropOperation);
        this.dropTarget.setTransfer(this.dropTypes);
        this.dropTarget.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                DNDExampleTab.this.dropConsole.append(">>dragEnter\n");
                DNDExampleTab.this.printEvent(event);
                if (event.detail == 16) {
                    event.detail = DNDExampleTab.this.dropDefaultOperation;
                }
                event.feedback = DNDExampleTab.this.dropFeedback;
            }

            public void dragLeave(DropTargetEvent event) {
                DNDExampleTab.this.dropConsole.append(">>dragLeave\n");
                DNDExampleTab.this.printEvent(event);
            }

            public void dragOperationChanged(DropTargetEvent event) {
                DNDExampleTab.this.dropConsole.append(">>dragOperationChanged\n");
                DNDExampleTab.this.printEvent(event);
                if (event.detail == 16) {
                    event.detail = DNDExampleTab.this.dropDefaultOperation;
                }
                event.feedback = DNDExampleTab.this.dropFeedback;
            }

            public void dragOver(DropTargetEvent event) {
                DNDExampleTab.this.dropConsole.append(">>dragOver\n");
                DNDExampleTab.this.printEvent(event);
                event.feedback = DNDExampleTab.this.dropFeedback;
            }

            public void drop(DropTargetEvent event) {
                int i;
                DNDExampleTab.this.dropConsole.append(">>drop\n");
                DNDExampleTab.this.printEvent(event);
                String[] strings = null;
                if (TextTransfer.getInstance().isSupportedType(event.currentDataType) || RTFTransfer.getInstance().isSupportedType(event.currentDataType) || HTMLTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    strings = new String[]{(String)event.data};
                }
                if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    strings = (String[])event.data;
                }
                if (ClientFileTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    ClientFile[] files = (ClientFile[])event.data;
                    strings = new String[files.length];
                    i = 0;
                    while (i < files.length) {
                        strings[i] = files[i].toString();
                        ++i;
                    }
                }
                if (strings == null || strings.length == 0) {
                    DNDExampleTab.this.dropConsole.append("!!Invalid data dropped");
                    return;
                }
                if (strings.length == 1 && (DNDExampleTab.this.dropControlType == 6 || DNDExampleTab.this.dropControlType == 7 || DNDExampleTab.this.dropControlType == 5)) {
                    String string = strings[0];
                    int count = 0;
                    int offset = string.indexOf("\n", 0);
                    while (offset > 0) {
                        ++count;
                        offset = string.indexOf("\n", offset + 1);
                    }
                    if (count > 0) {
                        strings = new String[count + 1];
                        int start = 0;
                        int end = string.indexOf("\n");
                        int index = 0;
                        while (start < end) {
                            strings[index++] = string.substring(start, end);
                            start = end + 1;
                            if ((end = string.indexOf("\n", start)) != -1) continue;
                            end = string.length();
                        }
                    }
                }
                switch (DNDExampleTab.this.dropControlType) {
                    case 0: 
                    case 1: 
                    case 2: {
                        Button b = (Button)DNDExampleTab.this.dropControl;
                        b.setText(strings[0]);
                        break;
                    }
                    case 6: {
                        Table table = (Table)DNDExampleTab.this.dropControl;
                        Point p = event.display.map(null, (Control)table, event.x, event.y);
                        TableItem dropItem = table.getItem(p);
                        int index = dropItem == null ? table.getItemCount() : table.indexOf(dropItem);
                        int i2 = 0;
                        while (i2 < strings.length) {
                            TableItem item = new TableItem(table, 0, index);
                            item.setText(0, strings[i2]);
                            item.setText(1, "dropped item");
                            ++i2;
                        }
                        TableColumn[] columns = table.getColumns();
                        int i3 = 0;
                        while (i3 < columns.length) {
                            columns[i3].pack();
                            ++i3;
                        }
                        break;
                    }
                    case 8: {
                        Text text = (Text)DNDExampleTab.this.dropControl;
                        i = 0;
                        while (i < strings.length) {
                            text.append(strings[i] + "\n");
                            ++i;
                        }
                        break;
                    }
                    case 7: {
                        Tree tree = (Tree)DNDExampleTab.this.dropControl;
                        Point p = event.display.map(null, (Control)tree, event.x, event.y);
                        TreeItem parentItem = tree.getItem(p);
                        int i4 = 0;
                        while (i4 < strings.length) {
                            TreeItem item = parentItem != null ? new TreeItem(parentItem, 0) : new TreeItem(tree, 0);
                            item.setText(strings[i4]);
                            ++i4;
                        }
                        break;
                    }
                    case 3: {
                        DNDExampleTab.this.dropControl.setData("STRINGS", (Object)strings);
                        DNDExampleTab.this.dropControl.redraw();
                        break;
                    }
                    case 4: {
                        Label label = (Label)DNDExampleTab.this.dropControl;
                        label.setText(DNDExampleTab.join("\n", strings));
                        break;
                    }
                    case 5: {
                        List list = (List)DNDExampleTab.this.dropControl;
                        i = 0;
                        while (i < strings.length) {
                            list.add(strings[i]);
                            ++i;
                        }
                        break;
                    }
                    default: {
                        throw new SWTError(20);
                    }
                }
            }

            public void dropAccept(DropTargetEvent event) {
                DNDExampleTab.this.dropConsole.append(">>dropAccept\n");
                DNDExampleTab.this.printEvent(event);
            }
        });
    }

    private void createFeedbackTypes(Group parent) {
        parent.setLayout((Layout)new RowLayout(512));
        Button b = new Button((Composite)parent, 32);
        b.setText("FEEDBACK_SELECT");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                DNDExampleTab.this.dropFeedback = b.getSelection() ? (DNDExampleTab.this.dropFeedback |= 1) : (DNDExampleTab.this.dropFeedback &= 0xFFFFFFFE);
            }
        });
        b = new Button((Composite)parent, 32);
        b.setText("FEEDBACK_SCROLL");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                DNDExampleTab.this.dropFeedback = b.getSelection() ? (DNDExampleTab.this.dropFeedback |= 8) : (DNDExampleTab.this.dropFeedback &= 0xFFFFFFF7);
            }
        });
        b = new Button((Composite)parent, 32);
        b.setText("FEEDBACK_INSERT_BEFORE");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                DNDExampleTab.this.dropFeedback = b.getSelection() ? (DNDExampleTab.this.dropFeedback |= 2) : (DNDExampleTab.this.dropFeedback &= 0xFFFFFFFD);
            }
        });
        b = new Button((Composite)parent, 32);
        b.setText("FEEDBACK_INSERT_AFTER");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                DNDExampleTab.this.dropFeedback = b.getSelection() ? (DNDExampleTab.this.dropFeedback |= 4) : (DNDExampleTab.this.dropFeedback &= 0xFFFFFFFB);
            }
        });
        b = new Button((Composite)parent, 32);
        b.setText("FEEDBACK_EXPAND");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                DNDExampleTab.this.dropFeedback = b.getSelection() ? (DNDExampleTab.this.dropFeedback |= 0x10) : (DNDExampleTab.this.dropFeedback &= 0xFFFFFFEF);
            }
        });
    }

    private void createDropTypes(Composite parent) {
        parent.setLayout((Layout)new RowLayout(512));
        this.createDropTypeButton(parent, "Text Transfer", (Transfer)TextTransfer.getInstance()).setSelection(true);
        this.createDropTypeButton(parent, "RTF Transfer", (Transfer)RTFTransfer.getInstance());
        this.createDropTypeButton(parent, "HTML Transfer", (Transfer)HTMLTransfer.getInstance());
        this.createDropTypeButton(parent, "ClientFile Transfer", (Transfer)ClientFileTransfer.getInstance());
    }

    private Button createDropTypeButton(Composite parent, String name, final Transfer transfer) {
        final Button button = new Button(parent, 32);
        button.setText(name);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (button.getSelection()) {
                    DNDExampleTab.this.addDropTransfer(transfer);
                } else {
                    DNDExampleTab.this.removeDropTransfer(transfer);
                }
            }
        });
        return button;
    }

    private void createDropWidget(Composite parent) {
        parent.setLayout((Layout)new FormLayout());
        Combo combo = new Combo(parent, 8);
        combo.setItems(new String[]{"Toggle Button", "Radio Button", "Checkbox", "Canvas", "Label", "List", "Table", "Tree", "Text"});
        combo.select(4);
        this.dropControlType = combo.getSelectionIndex();
        this.dropControl = this.createWidget(this.dropControlType, parent, "Drop Target");
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object data = DNDExampleTab.this.dropControl.getLayoutData();
                Composite parent = DNDExampleTab.this.dropControl.getParent();
                DNDExampleTab.this.dropControl.dispose();
                Combo c = (Combo)e.widget;
                DNDExampleTab.this.dropControlType = c.getSelectionIndex();
                DNDExampleTab.this.dropControl = DNDExampleTab.this.createWidget(DNDExampleTab.this.dropControlType, parent, "Drop Target");
                DNDExampleTab.this.dropControl.setLayoutData(data);
                DNDExampleTab.this.updateDropTarget();
                parent.layout();
            }
        });
        Button b = new Button(parent, 32);
        b.setText("DropTarget");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DNDExampleTab.this.dropEnabled = ((Button)e.widget).getSelection();
                DNDExampleTab.this.updateDropTarget();
            }
        });
        b.setSelection(this.dropEnabled);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 10);
        data.bottom = new FormAttachment((Control)combo, -10);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(100, -10);
        this.dropControl.setLayoutData((Object)data);
        data = new FormData();
        data.bottom = new FormAttachment(100, -10);
        data.left = new FormAttachment(0, 10);
        combo.setLayoutData((Object)data);
        data = new FormData();
        data.bottom = new FormAttachment(100, -10);
        data.left = new FormAttachment((Control)combo, 10);
        b.setLayoutData((Object)data);
        this.updateDropTarget();
    }

    private void updateDropTarget() {
        if (this.dropTarget != null) {
            this.dropTarget.dispose();
        }
        if (this.dropEnabled) {
            this.createDropTarget();
        } else {
            if (this.dropTarget != null) {
                this.dropTarget.dispose();
            }
            this.dropTarget = null;
        }
    }

    private Control createWidget(int type, Composite parent, String prefix) {
        switch (type) {
            case 2: {
                Button button = new Button(parent, 32);
                button.setText(prefix + " Check box");
                return button;
            }
            case 0: {
                Button button = new Button(parent, 2);
                button.setText(prefix + " Toggle button");
                return button;
            }
            case 1: {
                Button button = new Button(parent, 16);
                button.setText(prefix + " Radio button");
                return button;
            }
            case 6: {
                Table table = new Table(parent, 2562);
                TableColumn column1 = new TableColumn(table, 0);
                TableColumn column2 = new TableColumn(table, 0);
                int i = 0;
                while (i < 10) {
                    TableItem item = new TableItem(table, 0);
                    item.setText(0, prefix + " name " + i);
                    item.setText(1, prefix + " value " + i);
                    ++i;
                }
                column1.pack();
                column2.pack();
                return table;
            }
            case 8: {
                Text text = new Text(parent, 2818);
                text.setText(prefix + " Text");
                return text;
            }
            case 7: {
                Tree tree = new Tree(parent, 2562);
                int i = 0;
                while (i < 3) {
                    TreeItem item = new TreeItem(tree, 0);
                    item.setText(prefix + " item " + i);
                    int j = 0;
                    while (j < 3) {
                        TreeItem subItem = new TreeItem(item, 0);
                        subItem.setText(prefix + " item " + j);
                        int k = 0;
                        while (k < 3) {
                            TreeItem subsubItem = new TreeItem(subItem, 0);
                            subsubItem.setText(prefix + " item " + k);
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
                return tree;
            }
            case 3: {
                Canvas canvas = new Canvas(parent, 2048);
                canvas.setData("STRINGS", (Object)new String[]{prefix + " Canvas widget"});
                return canvas;
            }
            case 4: {
                Label label = new Label(parent, 2048);
                label.setText(prefix + " Label");
                return label;
            }
            case 5: {
                List list = new List(parent, 2560);
                list.setItems(new String[]{prefix + " Item a", prefix + " Item b", prefix + " Item c", prefix + " Item d"});
                return list;
            }
        }
        throw new SWTError(20);
    }

    private void printEvent(DragSourceEvent e) {
        if (!this.dragEventDetail) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("widget: ");
        sb.append(e.widget);
        sb.append(", time: ");
        sb.append(e.time);
        sb.append(", operation: ");
        sb.append(e.detail);
        sb.append(", type: ");
        sb.append(e.dataType != null ? e.dataType.type : 0);
        sb.append(", doit: ");
        sb.append(e.doit);
        sb.append(", data: ");
        sb.append(e.data);
        sb.append("\n");
        this.dragConsole.append(sb.toString());
    }

    private void printEvent(DropTargetEvent e) {
        if (!this.dropEventDetail) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("widget; ");
        sb.append(e.widget);
        sb.append(", time: ");
        sb.append(e.time);
        sb.append(", x: ");
        sb.append(e.x);
        sb.append(", y: ");
        sb.append(e.y);
        sb.append(", item: ");
        sb.append(e.item);
        sb.append(", operations: ");
        sb.append(e.operations);
        sb.append(", operation: ");
        sb.append(e.detail);
        sb.append(", feedback: ");
        sb.append(e.feedback);
        if (e.dataTypes != null) {
            int i = 0;
            while (i < e.dataTypes.length) {
                sb.append(", dataType ");
                sb.append(i);
                sb.append(": ");
                sb.append(e.dataTypes[i].type);
                ++i;
            }
        } else {
            sb.append(", dataTypes: none");
        }
        sb.append(", currentDataType: ");
        sb.append(e.currentDataType);
        sb.append(", data: ");
        sb.append(e.data);
        sb.append("\n");
        this.dropConsole.append(sb.toString());
    }

    private void removeDragTransfer(Transfer transfer) {
        if (this.dragTypes.length == 1) {
            this.dragTypes = new Transfer[0];
        } else {
            int index = -1;
            int i = 0;
            while (i < this.dragTypes.length) {
                if (this.dragTypes[i] == transfer) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index == -1) {
                return;
            }
            Transfer[] newTypes = new Transfer[this.dragTypes.length - 1];
            System.arraycopy(this.dragTypes, 0, newTypes, 0, index);
            System.arraycopy(this.dragTypes, index + 1, newTypes, index, this.dragTypes.length - index - 1);
            this.dragTypes = newTypes;
        }
        if (this.dragSource != null) {
            this.dragSource.setTransfer(this.dragTypes);
        }
    }

    private void removeDropTransfer(Transfer transfer) {
        if (this.dropTypes.length == 1) {
            this.dropTypes = new Transfer[0];
        } else {
            int index = -1;
            int i = 0;
            while (i < this.dropTypes.length) {
                if (this.dropTypes[i] == transfer) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index == -1) {
                return;
            }
            Transfer[] newTypes = new Transfer[this.dropTypes.length - 1];
            System.arraycopy(this.dropTypes, 0, newTypes, 0, index);
            System.arraycopy(this.dropTypes, index + 1, newTypes, index, this.dropTypes.length - index - 1);
            this.dropTypes = newTypes;
        }
        if (this.dropTarget != null) {
            this.dropTarget.setTransfer(this.dropTypes);
        }
    }

    private static String join(String glue, Item[] items) {
        String[] strings = new String[items.length];
        int i = 0;
        while (i < items.length) {
            strings[i] = items[i].getText();
            ++i;
        }
        return DNDExampleTab.join(glue, strings);
    }

    private static String join(String glue, String[] strings) {
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        while (i < strings.length) {
            stringBuilder.append(strings[i]);
            if (i != strings.length - 1) {
                stringBuilder.append(glue);
            }
            ++i;
        }
        return stringBuilder.toString();
    }
}

