/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.commands;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.lang.reflect.Field;
import java.util.LinkedList;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.commands.internal.CommandServiceImpl;
import org.eclipse.e4.core.commands.internal.HandlerServiceCreationFunction;
import org.eclipse.e4.core.commands.internal.HandlerServiceImpl;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;

public class CommandServiceAddon {
    private IEclipseContext context;

    @Inject
    public CommandServiceAddon(IEclipseContext context) {
        this.context = context;
    }

    @PostConstruct
    void init(IEclipseContext context) {
        CommandManager manager = (CommandManager)context.get(CommandManager.class);
        if (manager == null) {
            manager = new CommandManager();
            context.set(CommandManager.class, (Object)manager);
        }
        CommandServiceImpl service = (CommandServiceImpl)ContextInjectionFactory.make(CommandServiceImpl.class, (IEclipseContext)context);
        context.set(ECommandService.class, (Object)service);
        context.set(EHandlerService.class.getName(), (Object)new HandlerServiceCreationFunction());
        context.set("_handlerExecutionStack", new LinkedList());
        HandlerServiceImpl.push(context, null);
    }

    @PreDestroy
    void cleanup() {
        HandlerServiceImpl.pop(this.context);
    }

    void setCommandFireEvents(CommandManager manager, boolean b) {
        try {
            Field f = CommandManager.class.getDeclaredField("shouldCommandFireEvents");
            f.setAccessible(true);
            f.set(manager, b);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

