/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.nls.editor;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.NativePropertyListener;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.databinding.property.value.SimpleValueProperty;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.s.nls.ITranslation;
import org.eclipse.scout.sdk.core.s.nls.ITranslationManagerListener;
import org.eclipse.scout.sdk.core.s.nls.Language;
import org.eclipse.scout.sdk.core.s.nls.manager.IStackedTranslation;
import org.eclipse.scout.sdk.core.s.nls.manager.TranslationManager;
import org.eclipse.scout.sdk.core.s.nls.manager.TranslationManagerEvent;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.s2e.ui.internal.S2ESdkUiActivator;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.editor.NlsReferenceProvider;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.editor.NlsTable;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.editor.NlsTableCell;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class NlsTableController
extends ViewerComparator {
    public static final int INDEX_COLUMN_REF_COUNT = 0;
    public static final int INDEX_COLUMN_KEYS = 1;
    public static final ViewerFilter EDITABLE_ONLY_FILTER = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return NlsTableController.translationOfRow(element).hasEditableStores();
        }
    };
    private static final AtomicLong ENTRY_ID = new AtomicLong();
    private static final int NUM_NON_LANGUAGE_COLS = 2;
    private static final String COLOR_INACTIVE_FOREGROUND = "scout.nlsRowInactiveForeground";
    private final TranslationManager m_manager;
    private final Color m_colorDisabledForeground;
    private final Image m_image;
    private final ITranslationManagerListener m_managerListener;
    private final DisposeListener m_disposeListener;
    private ObservedColumn[] m_observedColumns;
    private NlsTable m_view;
    private int m_sortIndex = 1;
    private boolean m_ascSorting;
    private NlsReferenceProvider m_referenceProvider;
    private List<Language> m_langIndexCache;
    private WritableList<TranslationTableEntry> m_translationList;
    private List<TranslationTableEntry> m_translations;

    protected NlsTableController(TranslationManager manager) {
        this.m_manager = (TranslationManager)Ensure.notNull((Object)manager);
        this.m_image = S2ESdkUiActivator.getImage("text.png");
        this.m_managerListener = events -> this.m_view.getDisplay().asyncExec(() -> this.handleTranslationManagerEvents(events));
        this.m_disposeListener = e -> this.unbind();
        ColorRegistry colorRegistry = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
        if (!colorRegistry.hasValueFor(COLOR_INACTIVE_FOREGROUND)) {
            colorRegistry.put(COLOR_INACTIVE_FOREGROUND, new RGB(166, 166, 166));
        }
        this.m_colorDisabledForeground = colorRegistry.get(COLOR_INACTIVE_FOREGROUND);
    }

    protected void handleTranslationManagerEvents(Stream<TranslationManagerEvent> events) {
        events.map(this::handleTranslationManagerEvent).max(Comparator.naturalOrder()).ifPresent(this::finishTranslationManagerEvents);
    }

    protected void finishTranslationManagerEvents(boolean requireReSort) {
        if (requireReSort) {
            this.preservingSelectionDo(() -> this.m_view.tableViewer().refresh(false, true));
        } else {
            this.m_view.tableViewer().getTable().requestLayout();
        }
    }

    protected boolean handleTranslationManagerEvent(TranslationManagerEvent event) {
        switch (event.type()) {
            case 2: {
                IStackedTranslation newTranslation = (IStackedTranslation)event.translation().orElseThrow();
                this.m_translationList.add((Object)new TranslationTableEntry(newTranslation));
                this.reveal(newTranslation.key());
                this.updateReferenceCountInTable();
                return true;
            }
            case 4: {
                this.translationToTableEntry((IStackedTranslation)event.translation().orElseThrow()).ifPresent(arg_0 -> this.m_translationList.remove(arg_0));
                this.updateReferenceCountInTable();
                return false;
            }
            case 32: {
                if (!this.allLanguages().contains(event.language().orElseThrow())) {
                    this.m_view.getDisplay().asyncExec(() -> this.preservingSelectionDo(this::rebind));
                }
                return false;
            }
            case 128: {
                this.m_view.getDisplay().asyncExec(() -> this.preservingSelectionDo(this::rebind));
                return false;
            }
            case 16: {
                this.m_translations.stream().filter(t -> t.unwrap().key().equals(event.key().orElse(null))).findAny().ifPresent(arg_0 -> this.m_translationList.remove(arg_0));
                IStackedTranslation translationWitNewKey = (IStackedTranslation)event.translation().orElseThrow();
                this.m_translationList.add((Object)new TranslationTableEntry(translationWitNewKey));
                this.reveal(translationWitNewKey.key());
                this.updateReferenceCountInTable();
                return true;
            }
            case 8: {
                IStackedTranslation changedTranslation = (IStackedTranslation)event.translation().orElseThrow();
                for (int i = 2; i < this.m_observedColumns.length; ++i) {
                    this.m_observedColumns[i].fireChange(changedTranslation);
                }
                return true;
            }
        }
        return false;
    }

    protected List<Language> allLanguages() {
        if (this.m_langIndexCache == null) {
            this.m_langIndexCache = this.m_manager.allLanguages().sorted().collect(Collectors.toList());
        }
        return this.m_langIndexCache;
    }

    protected void bind(NlsTable view) {
        this.m_view = (NlsTable)((Object)Ensure.notNull((Object)((Object)view)));
        this.m_view.createColumns();
        this.m_observedColumns = new ObservedColumn[2 + this.allLanguages().size()];
        this.m_observedColumns[0] = new ObservedColumn(0);
        this.m_observedColumns[1] = new ObservedColumn(1);
        for (int i = 2; i < this.m_observedColumns.length; ++i) {
            this.m_observedColumns[i] = new ObservedColumn(i);
        }
        this.m_translations = this.m_manager.allTranslations().map(TranslationTableEntry::new).collect(Collectors.toList());
        this.m_translationList = new WritableList(this.m_translations, TranslationTableEntry.class);
        TableViewer viewer = this.m_view.tableViewer();
        ObservableListContentProvider contentProvider = new ObservableListContentProvider();
        viewer.setComparator((ViewerComparator)this);
        viewer.setLabelProvider((IBaseLabelProvider)new NlsTableLabelProvider((ObservableListContentProvider<TranslationTableEntry>)contentProvider, this.m_observedColumns));
        viewer.setContentProvider((IContentProvider)contentProvider);
        viewer.setInput(this.m_translationList);
        viewer.getControl().addDisposeListener(this.m_disposeListener);
        this.m_manager.addListener(this.m_managerListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preservingSelectionDo(Runnable task) {
        Table table = this.m_view.tableViewer().getTable();
        table.setRedraw(false);
        try {
            Optional<NlsTableCell> selection = this.m_view.getCursorSelection();
            task.run();
            selection.ifPresent(cell -> this.reveal(cell.translation().key(), cell.column()));
        }
        finally {
            table.setRedraw(true);
        }
    }

    public void reveal(String keyToSelect) {
        this.reveal(keyToSelect, 1);
    }

    public void reveal(String keyToSelect, int columnToSelect) {
        for (TableItem row : this.m_view.tableViewer().getTable().getItems()) {
            IStackedTranslation e = NlsTableController.translationOfRow(row);
            if (!e.key().equals(keyToSelect)) continue;
            this.m_view.tableViewer().reveal(row.getData());
            this.m_view.tableCursor().ensureFocus(row, columnToSelect);
            break;
        }
    }

    protected void unbind() {
        this.m_langIndexCache = null;
        this.m_manager.removeListener(this.m_managerListener);
        this.m_view.tableViewer().getControl().removeDisposeListener(this.m_disposeListener);
    }

    protected void rebind() {
        this.unbind();
        this.bind(this.m_view);
    }

    protected Optional<TranslationTableEntry> translationToTableEntry(IStackedTranslation toSearch) {
        for (TranslationTableEntry candidate : this.m_translations) {
            if (candidate.unwrap() != toSearch) continue;
            return Optional.of(candidate);
        }
        return Optional.empty();
    }

    public List<IStackedTranslation> getSelectedEntries() {
        IStructuredSelection selection = (IStructuredSelection)this.m_view.tableViewer().getSelection();
        ArrayList<IStackedTranslation> result = new ArrayList<IStackedTranslation>(selection.size());
        for (Object o : selection) {
            result.add(NlsTableController.translationOfRow(o));
        }
        return result;
    }

    protected String getColumnText(ITranslation element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                NlsReferenceProvider refProvider = this.getReferenceProvider();
                if (refProvider == null) {
                    return "";
                }
                return Integer.toString(refProvider.getReferencesFor(element).size());
            }
            case 1: {
                return element.key();
            }
        }
        Language lang = this.languageOfColumn(columnIndex);
        String text = element.text(lang).orElse("");
        return Strings.replaceEach((CharSequence)text, (CharSequence[])new String[]{"\n", "\r"}, (CharSequence[])new String[]{" ", ""}).toString();
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        Object second;
        Object first;
        int index = this.m_sortIndex;
        if (this.m_ascSorting) {
            first = e2;
            second = e1;
        } else {
            first = e1;
            second = e2;
        }
        String a = this.getColumnText((ITranslation)NlsTableController.translationOfRow(first), index);
        String b = this.getColumnText((ITranslation)NlsTableController.translationOfRow(second), index);
        if (Objects.equals(a, b)) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (index == 0 && !a.isEmpty() && !b.isEmpty()) {
            try {
                int numA = Integer.parseInt(a);
                int numB = Integer.parseInt(b);
                return Integer.compare(numA, numB);
            }
            catch (NumberFormatException e) {
                SdkLog.info((CharSequence)"no valid number '{}' or '{}'.", (Object[])new Object[]{a, b, e});
            }
        }
        return a.compareToIgnoreCase(b);
    }

    public boolean isAscSorting() {
        return this.m_ascSorting;
    }

    public void setAscSorting(boolean sorting) {
        this.m_ascSorting = sorting;
    }

    public int getSortIndex() {
        return this.m_sortIndex;
    }

    public void setSortIndex(int index) {
        this.m_sortIndex = index;
    }

    public TranslationManager translationManager() {
        return this.m_manager;
    }

    protected static IStackedTranslation translationOfRow(Object row) {
        return ((TranslationTableEntry)row).unwrap();
    }

    protected static IStackedTranslation translationOfRow(TableItem row) {
        return NlsTableController.translationOfRow(row.getData());
    }

    public void setReferenceProvider(NlsReferenceProvider referenceProvider) {
        if (this.m_referenceProvider == referenceProvider) {
            return;
        }
        this.m_referenceProvider = referenceProvider;
        this.updateReferenceCountInTable();
    }

    public void setHideReadOnly(boolean hide) {
        this.preservingSelectionDo(() -> {
            if (hide) {
                this.m_view.tableViewer().addFilter(EDITABLE_ONLY_FILTER);
            } else {
                this.m_view.tableViewer().removeFilter(EDITABLE_ONLY_FILTER);
            }
        });
    }

    protected void updateReferenceCountInTable() {
        NlsReferenceProvider referenceProvider = this.getReferenceProvider();
        if (referenceProvider == null) {
            return;
        }
        ObservedColumn refCountProperty = this.m_observedColumns[0];
        if (refCountProperty != null) {
            this.m_manager.allTranslations().forEach(refCountProperty::fireChange);
        }
    }

    public NlsReferenceProvider getReferenceProvider() {
        return this.m_referenceProvider;
    }

    public Language languageOfColumn(int index) {
        if (index == 0 || index == 1) {
            return null;
        }
        return this.allLanguages().get(index - 2);
    }

    protected static final class TranslationTableEntry {
        private final IStackedTranslation m_entry;
        private final long m_id;

        private TranslationTableEntry(IStackedTranslation entry) {
            this.m_entry = entry;
            this.m_id = ENTRY_ID.getAndIncrement();
        }

        private IStackedTranslation unwrap() {
            return this.m_entry;
        }

        public int hashCode() {
            return Long.hashCode(this.m_id);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            TranslationTableEntry other = (TranslationTableEntry)obj;
            return this.m_id == other.m_id;
        }
    }

    private final class ObservedColumn
    extends SimpleValueProperty<TranslationTableEntry, CharSequence> {
        private NativeListener m_propertyChangeListener;
        private final int m_index;

        private ObservedColumn(int index) {
            this.m_index = index;
        }

        public Object getValueType() {
            return null;
        }

        private void fireChange(IStackedTranslation entry) {
            if (this.m_propertyChangeListener != null) {
                this.m_propertyChangeListener.fireChange(entry);
            }
        }

        protected CharSequence doGetValue(TranslationTableEntry source) {
            return NlsTableController.this.getColumnText((ITranslation)source.unwrap(), this.m_index);
        }

        protected void doSetValue(TranslationTableEntry source, CharSequence value) {
            throw new UnsupportedOperationException();
        }

        public INativePropertyListener<TranslationTableEntry> adaptListener(ISimplePropertyListener<TranslationTableEntry, ValueDiff<? extends CharSequence>> listener) {
            this.m_propertyChangeListener = new NativeListener((IProperty)this, listener);
            return this.m_propertyChangeListener;
        }
    }

    private final class NlsTableLabelProvider
    extends ObservableMapLabelProvider
    implements ITableColorProvider {
        private NlsTableLabelProvider(ObservableListContentProvider<TranslationTableEntry> contentProvider, ObservedColumn ... observedColumns) {
            super(Properties.observeEach((IObservableSet)contentProvider.getKnownElements(), (IValueProperty[])observedColumns));
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return NlsTableController.this.m_image;
            }
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            boolean cellEditable;
            if (0 == columnIndex) {
                return null;
            }
            IStackedTranslation entry = NlsTableController.translationOfRow(element);
            if (1 == columnIndex) {
                if (!entry.hasOnlyEditableStores()) {
                    return NlsTableController.this.m_colorDisabledForeground;
                }
                return null;
            }
            if (columnIndex > 1 && !(cellEditable = entry.hasEditableStores())) {
                return NlsTableController.this.m_colorDisabledForeground;
            }
            return null;
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }
    }

    private final class NativeListener
    extends NativePropertyListener<TranslationTableEntry, ValueDiff<? extends CharSequence>> {
        private NativeListener(IProperty property, ISimplePropertyListener<TranslationTableEntry, ValueDiff<? extends CharSequence>> listener) {
            super(property, listener);
        }

        private void fireChange(IStackedTranslation entry) {
            NlsTableController.this.translationToTableEntry(entry).ifPresent(e -> super.fireChange(e, null));
        }

        protected void doAddTo(TranslationTableEntry source) {
        }

        protected void doRemoveFrom(TranslationTableEntry source) {
        }
    }
}

